/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.emf.ecore.utilities.copy.EtoolsCopyUtility;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.DistributedMapFactory;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.auth.login.Configuration;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SSLConfigValidation;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.wsspi.security.token.TokenHolder;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.ecore.EObject;

public final class SecurityAdmin {
    private static final String LOGIN_CONFIG_CLASS = "com.ibm.ws.security.auth.login.Configuration";
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$core$SecurityAdmin == null ? (class$com$ibm$ws$security$core$SecurityAdmin = SecurityAdmin.class$("com.ibm.ws.security.core.SecurityAdmin")) : class$com$ibm$ws$security$core$SecurityAdmin), null, (String)"com.ibm.ejs.resources.security");
    private LTPAServerObject _ltpaServer = null;
    private UserRegistry _registry = null;
    private boolean initialized = false;
    static /* synthetic */ Class class$com$ibm$ws$security$core$SecurityAdmin;

    public SecurityAdmin() throws Exception {
        this.initialize();
    }

    public synchronized void initialize() throws Exception {
        Boolean bl;
        if (this.initialized) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize ");
        }
        if ((bl = (Boolean)SecurityConfig.getConfig().getValue("security.enabled")).booleanValue()) {
            ContextManager contextManager;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security is enabled, therefore initializing references to user registry and ltpa server.");
            }
            if ((contextManager = ContextManagerFactory.getInstance()) != null) {
                try {
                    this._registry = contextManager.getRegistry(contextManager.getDefaultRealm());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.initialize", (String)"70", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.sambean.urerr", (Object)new Object[]{exception});
                    throw exception;
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"security.sambean.nullsecserver");
                throw new Exception("Unable to get ContextManager");
            }
            try {
                this._ltpaServer = LTPAServerObject.getLTPAServer();
            }
            catch (LTPAConfigException lTPAConfigException) {
                FFDCFilter.processException((Throwable)lTPAConfigException, (String)"com.ibm.ws.security.core.SecurityAdmin.initialize", (String)"89", (Object)this);
                Tr.debug((TraceComponent)tc, (String)"Error initializing LTPA server object.");
            }
            if (tc.isDebugEnabled()) {
                if (this._ltpaServer == null) {
                    Tr.debug((TraceComponent)tc, (String)"ltpa server not initialized.");
                } else {
                    Tr.debug((TraceComponent)tc, (String)"ltpa server initialized.");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Security is not enabled, therefore not initializing references to user registry and ltpa server.");
        }
        this.initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void purgeUserFromAuthCache(String string, String string2) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"purgeUserFromAuthCache");
            }
            AuthCache authCache = AuthCache.getInstance();
            try {
                authCache.removeEntry(string, string2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.purgeUserFromCache", (String)"124", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Exception purging user" + string2 + " from cache."));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"purgeUserFromAuthCache");
        }
    }

    public void clearAuthCache() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"clearAuthCache");
            }
            AuthCache authCache = AuthCache.getInstance();
            try {
                authCache.removeAllEntries();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.purgeUserFromCache", (String)"146", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Exception clearing auth cache.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clearAuthCache");
        }
    }

    public void updateAuthDataCfg(HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateAuthDataCfg ", (Object)new Object[]{hashMap});
        }
        if (hashMap != null) {
            WSDefaultPrincipalMapping.refreshAuthData((HashMap)hashMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateAuthDataCfg ");
        }
    }

    public void updateJAASCfg(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateJAASCfg ");
        }
        javax.security.auth.login.Configuration configuration = Configuration.getConfiguration();
        String string2 = configuration.getClass().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The Login Configuration class is: " + string2));
        }
        if (configuration instanceof Configuration) {
            try {
                Configuration configuration2 = (Configuration)configuration;
                configuration2.updateWCCMConfig(string);
                configuration2.refresh();
                if (tc.isDebugEnabled()) {
                    String string3 = configuration2.toString();
                    System.out.println("The dynamic JAAS login configuration is:\n" + string3);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.updateJAASCfg", (String)"97", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.init.wccmjaas.error", (Object)new Object[]{exception});
            }
        } else {
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.enabled");
            if (bl != null && bl.booleanValue()) {
                Tr.error((TraceComponent)tc, (String)"security.init.wccmjaas.wrongclasserror", (Object)new Object[]{string2, LOGIN_CONFIG_CLASS});
                throw new RuntimeException("JAAS Login provider class com.ibm.ws.security.auth.login.Configuration is not configured as login provider class");
            }
            Tr.warning((TraceComponent)tc, (String)"security.init.wccmjaas.wrongclasswarning", (Object)new Object[]{string2, LOGIN_CONFIG_CLASS});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateJAASCfg ");
        }
    }

    public String getJAASCfg() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getJAASCfg ");
        }
        String string = null;
        javax.security.auth.login.Configuration configuration = Configuration.getConfiguration();
        String string2 = configuration.getClass().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The Login Configuration class is: " + string2));
        }
        if (configuration instanceof Configuration) {
            try {
                Configuration configuration2 = (Configuration)configuration;
                string = configuration2.toString();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getJAASCfg", (String)"147", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.init.wccmjaas.error", (Object)new Object[]{exception});
            }
        } else {
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.enabled");
            if (bl != null && bl.booleanValue()) {
                Tr.error((TraceComponent)tc, (String)"security.init.wccmjaas.wrongclasserror", (Object)new Object[]{string2, LOGIN_CONFIG_CLASS});
                throw new RuntimeException("JAAS Login provider class com.ibm.ws.security.auth.login.Configuration is not configured as login provider class");
            }
            Tr.warning((TraceComponent)tc, (String)"security.init.wccmjaas.wrongclasswarning", (Object)new Object[]{string2, LOGIN_CONFIG_CLASS});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getJAASCfg ");
        }
        return string;
    }

    public Result getUsers(String string, Integer n, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsers ", (Object)(string + " " + n));
        }
        int n2 = n;
        Result result = null;
        UserRegistry userRegistry = this.getRegistry(properties);
        if (userRegistry != null) {
            try {
                result = userRegistry.getUsers(string, n2);
            }
            catch (CustomRegistryException customRegistryException) {
                FFDCFilter.processException((Throwable)customRegistryException, (String)"com.ibm.ws.security.core.SecurityAdmin.getUsers", (String)"193", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sambean.getusrerr", (Object)new Object[]{string, new Integer(n2), customRegistryException});
                throw customRegistryException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getUsers", (String)"198", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sambean.getusrerr", (Object)new Object[]{string, new Integer(n2), exception});
                throw exception;
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"security.sa.no.registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers ");
        }
        return result;
    }

    public Result getGroups(String string, Integer n, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroups ", (Object)(string + " " + n));
        }
        int n2 = n;
        Result result = null;
        UserRegistry userRegistry = this.getRegistry(properties);
        if (userRegistry != null) {
            try {
                result = userRegistry.getGroups(string, n2);
            }
            catch (CustomRegistryException customRegistryException) {
                FFDCFilter.processException((Throwable)customRegistryException, (String)"com.ibm.ws.security.core.SecurityAdmin.getGroups", (String)"225", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sambean.getgrperr", (Object)new Object[]{string, new Integer(n2), customRegistryException});
                throw customRegistryException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getGroups", (String)"230", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sambean.getgrperr", (Object)new Object[]{string, new Integer(n2), exception});
                throw exception;
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"security.sa.no.registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroups ");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Boolean checkRunAsUser(List list, List list2, String string, Properties properties) throws Exception {
        Boolean bl;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkRunAsUser", (Object)string);
        }
        boolean bl2 = false;
        UserRegistry userRegistry = null;
        if (string == null || string.trim().length() <= 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RunAs username is null");
            }
            bl2 = true;
        } else if (list.contains(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("user " + string + " is in the user list"));
            }
            bl2 = true;
        } else {
            userRegistry = this.getRegistry(properties);
            Result result = null;
            object = null;
            if (userRegistry != null) {
                result = userRegistry.getUsers(string, 1);
                if (result != null) {
                    object = (String)result.getList().get(0);
                }
                if (list != null && object != null && ((String)object).length() > 0 && list.contains(object)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("user " + string + " is in the list"));
                    }
                    bl2 = true;
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"security.sa.no.registry");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cannot determine if user " + string + " is in the list since registry is null. Returing false"));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkRunAsUser");
                }
            }
        }
        if (!bl2 && userRegistry != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("user " + string + " is not in the user list. Checking in the group list"));
            }
            boolean bl3 = false;
            object = (Boolean)SecurityConfig.getConfig().getValue("security.registry.IgnoreCase");
            if (object != null && ((Boolean)object).booleanValue()) {
                bl3 = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ignoreCase is set");
                }
            }
            List list3 = userRegistry.getGroupsForUser(string);
            if (list2 != null && list3 != null) {
                block0: for (int i = 0; i < list2.size() && !bl2; ++i) {
                    if (bl3) {
                    } else {
                        if (!list3.contains(list2.get(i))) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("user " + string + " is in the group list"));
                        }
                        bl2 = true;
                        continue;
                    }
                    for (int j = 0; j < list3.size(); ++j) {
                        String string2;
                        String string3 = (String)list3.get(j);
                        if (!string3.equalsIgnoreCase(string2 = (String)list2.get(i))) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("user " + string + " is in the group list"));
                        }
                        bl2 = true;
                        continue block0;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkRunAsUser", (Object)(bl2 ? Boolean.TRUE : Boolean.FALSE));
        }
        if (bl2) {
            bl = Boolean.TRUE;
            return bl;
        }
        bl = Boolean.FALSE;
        return bl;
    }

    public String getAccessIds(boolean bl, String string, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAccessIds", (Object)string);
        }
        String string2 = null;
        UserRegistry userRegistry = this.getRegistry(properties);
        if (userRegistry != null) {
            string2 = bl ? userRegistry.getUniqueUserId(string) : userRegistry.getUniqueGroupId(string);
        } else {
            Tr.error((TraceComponent)tc, (String)"security.sa.no.registry");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"registry is null. Returing null accessId");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAccessIds");
        }
        return string2;
    }

    public String getRealm(Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRealm ");
        }
        UserRegistry userRegistry = this.getRegistry(properties);
        String string = null;
        if (userRegistry != null) {
            try {
                string = userRegistry.getRealm();
            }
            catch (CustomRegistryException customRegistryException) {
                FFDCFilter.processException((Throwable)customRegistryException, (String)"com.ibm.ws.security.core.SecurityAdmin.getRealm", (String)"273", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sa.get.realm", (Object)new Object[]{customRegistryException});
                throw customRegistryException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getRealm", (String)"278", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sa.get.realm", (Object)new Object[]{exception});
                throw exception;
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"security.sa.no.registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRealm ", (Object)string);
        }
        return string;
    }

    public void generateKeys(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"generateKeys ");
        }
        LTPAServerObject lTPAServerObject = this.getLtpaServer();
        try {
            if (lTPAServerObject != null) {
                lTPAServerObject.generateKeys(string.getBytes("UTF8"));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.generateKeys", (String)"253", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ErrorCreatingLTPAKeys", (Object)new Object[]{exception});
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"generateKeys ");
        }
    }

    public Properties genKeys(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"genKeys ");
        }
        LTPAServerObject lTPAServerObject = this.getLtpaServer();
        Properties properties = null;
        try {
            if (lTPAServerObject != null) {
                properties = lTPAServerObject.genKeys(string.getBytes("UTF8"));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.generateKeys", (String)"253", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ErrorCreatingLTPAKeys", (Object)new Object[]{exception});
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"genKeys ");
        }
        return properties;
    }

    public void exportKeys(String string, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("exportKeys filename:" + string));
        }
        LTPAServerObject lTPAServerObject = this.getLtpaServer(properties);
        Properties properties2 = null;
        try {
            if (lTPAServerObject != null) {
                properties2 = lTPAServerObject.exportSSOProperties();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.exportKeys", (String)"273", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.sambean.expltpakeys", (Object)new Object[]{exception});
            throw exception;
        }
        try {
            this.setProps(properties2, string);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.core.SecurityAdmin.exportKeys", (String)"283", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.sa.set.props", (Object)new Object[]{string, iOException});
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"exportKeys ");
        }
    }

    public void importKeys(String string, byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("importKeys " + string));
        }
        Properties properties = new Properties();
        try {
            properties = this.getProps(string);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.core.SecurityAdmin.importKeys", (String)"302", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.sa.set.props", (Object)new Object[]{string, iOException});
            throw iOException;
        }
        try {
            LTPAServerObject lTPAServerObject = this.getLtpaServer(properties);
            lTPAServerObject.importSSOProperties(properties, byArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.importKeys", (String)"312", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.sambean.impltpakeys", (Object)new Object[]{properties, exception});
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"importKeys ");
        }
    }

    public void getApplicationRoles(String string) {
    }

    public void getEjbModuleRoles(String string, String string2) {
    }

    public void getWebModuleRoles(String string, String string2) {
    }

    public void importLTPAKeys(Properties properties, byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"importLTPAKeys");
        }
        try {
            LTPAServerObject lTPAServerObject = this.getLtpaServer(properties);
            if (null != lTPAServerObject) {
                lTPAServerObject.importSSOProperties(properties, byArray);
            }
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.sambean.impltpakeys", (Object)new Object[]{properties, exception});
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.importLTPAKeys", (String)"348", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"importLTPAKeys", (Object)exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"importLTPAKeys");
        }
    }

    public void checkImportLTPAKeys(Properties properties, byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkImportLTPAKeys");
        }
        try {
            LTPAServerObject lTPAServerObject = this.getLtpaServer(properties);
            if (null != lTPAServerObject) {
                lTPAServerObject.checkImportSSOProperties(properties, byArray);
            }
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.sambean.impltpakeys", (Object)new Object[]{properties, exception});
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.checkImportLTPAKeys", (String)"348", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkImportLTPAKeys", (Object)exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkImportLTPAKeys");
        }
    }

    public Properties exportLTPAKeys() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"exportLTPAKeys");
        }
        try {
            Properties properties = null;
            LTPAServerObject lTPAServerObject = this.getLtpaServer();
            if (lTPAServerObject != null) {
                properties = lTPAServerObject.exportSSOProperties();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ltpaServer is null! not good.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("exportLTPAKeys: " + (properties != null ? properties.toString() : "null props")));
            }
            return properties;
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.sambean.expltpakeys", (Object)new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.exportLTPAKeys", (String)"368", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"exportLTPAKeys", (Object)exception);
            }
            throw exception;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Boolean checkPassword(String var1_1, String var2_2, Properties var3_3) throws Exception {
        if (SecurityAdmin.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SecurityAdmin.tc, (String)"checkPassword");
        }
        var4_4 = false;
        var5_5 = this.getRegistry(var3_3);
        if (var5_5 != null) {
            try {
                var6_6 = var5_5.checkPassword(var1_1, var2_2);
                if (var6_6 != null && var6_6.length() > 0) {
                    if (SecurityAdmin.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SecurityAdmin.tc, (String)"password is ok");
                    }
                    var4_4 = true;
                }
                if (!var4_4) ** GOTO lbl30
                var7_10 = var5_5.createCredential(var6_6);
            }
            catch (PasswordCheckFailedException var6_7) {
                FFDCFilter.processException((Throwable)var6_7, (String)"com.ibm.ws.security.core.SecurityAdmin.checkPassword", (String)"392", (Object)this);
                Tr.error((TraceComponent)SecurityAdmin.tc, (String)"security.sa.chk.password", (Object)new Object[]{var1_1, var6_7});
                throw var6_7;
            }
            catch (CustomRegistryException var6_8) {
                FFDCFilter.processException((Throwable)var6_8, (String)"com.ibm.ws.security.core.SecurityAdmin.checkPassword", (String)"397", (Object)this);
                Tr.error((TraceComponent)SecurityAdmin.tc, (String)"security.sa.chk.password.custom", (Object)new Object[]{var1_1, var6_8});
                throw var6_8;
            }
            catch (Exception var6_9) {
                FFDCFilter.processException((Throwable)var6_9, (String)"com.ibm.ws.security.core.SecurityAdmin.checkPassword", (String)"402", (Object)this);
                Tr.error((TraceComponent)SecurityAdmin.tc, (String)"security.sa.chk.password.custom", (Object)new Object[]{var1_1, var6_9});
                throw var6_9;
            }
        } else {
            if (SecurityAdmin.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)SecurityAdmin.tc, (String)"registry is null: checkPassword failed");
            }
            Tr.error((TraceComponent)SecurityAdmin.tc, (String)"security.sa.no.registry");
        }
lbl30:
        // 3 sources

        if (SecurityAdmin.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SecurityAdmin.tc, (String)"checkPassword", (Object)(var4_4 != false ? Boolean.TRUE : Boolean.FALSE));
        }
        return var4_4 != false ? Boolean.TRUE : Boolean.FALSE;
    }

    public Integer checkTokenLibFile(String string, String string2, String string3, String string4, String string5, String string6) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkTokenLibFile");
        }
        int n = SSLConfigValidation.checkTokenLibFile(string, string2, string3, string4, string5, string6);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkTokenLibFile", (Object)("status=" + n));
        }
        return new Integer(n);
    }

    public Integer checkKeyFile(String string, String string2, String string3, String string4, String string5) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkKeyFile");
        }
        int n = SSLConfigValidation.checkKeyFile(string, string2, string3, string4, string5);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkKeyFile", (Object)("status=" + n));
        }
        return new Integer(n);
    }

    public Integer checkTrustFile(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkTrustFile");
        }
        int n = SSLConfigValidation.checkTrustFile(string, string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkTrustFile", (Object)("status=" + n));
        }
        return new Integer(n);
    }

    public TokenHolder getOpaqueToken(ByteArray byteArray) {
        TokenHolder tokenHolder;
        byte[] byArray;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getOpaqueToken");
            }
            byArray = null;
            tokenHolder = null;
            try {
                DistributedMap distributedMap = DistributedMapFactory.getMap("WSSecureMap");
                if (distributedMap != null) {
                    byArray = (byte[])distributedMap.get((Object)byteArray);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getOpaqueToken", (String)"795", (Object)this);
                if (!tc.isEntryEnabled()) break block8;
                Tr.exit((TraceComponent)tc, (String)"Exception occurred getting opaque token from distributed map.", (Object)new Object[]{exception});
            }
        }
        if (byArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getOpaqueToken returns null.");
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getOpaqueToken returns opaque token.");
            }
            tokenHolder = new TokenHolder(byArray, "WS_OPAQUE", 1);
        }
        return tokenHolder;
    }

    private UserRegistry getRegistry(Properties properties) throws Exception {
        Object object;
        EtoolsCopyUtility etoolsCopyUtility;
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            object4 = SecurityConfig.maskPasswords(properties);
            Tr.entry((TraceComponent)tc, (String)("getRegistry " + object4));
        }
        object4 = this._registry;
        if (properties == null && object4 != null) {
            return object4;
        }
        if (properties == null && object4 == null) {
            object3 = (Properties)SecurityConfig.getConfig().getValue("security.activeUserRegistry.props");
            properties = SecurityConfig.expandProps((Properties)object3);
            object2 = (Properties)SecurityConfig.getConfig().getValue("security.registry.ldap.props");
            if (object2 != null) {
                etoolsCopyUtility = ((Properties)object2).keys();
                while (etoolsCopyUtility.hasMoreElements()) {
                    object = (String)etoolsCopyUtility.nextElement();
                    properties.put(object, ((Properties)object2).get(object));
                }
                object = (Boolean)SecurityConfig.getConfig().getValue("security.registry.ldap.SSLEnabled");
                properties.put("sslEnabled", object);
                if (((Boolean)object).booleanValue()) {
                    properties.put("sslConfig", (SecureSocketLayer)SecurityConfig.getConfig().getValue("security.registry.ldap.SSLConfig"));
                }
                properties.put("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
            }
        }
        try {
            Properties properties2 = null;
            if (properties != null) {
                properties2 = new Properties();
                object3 = properties.keys();
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    properties2.put(object2, properties.get(object2));
                }
            }
            if (properties2 != null && (object3 = (Boolean)properties2.get("sslEnabled")) != null && ((Boolean)object3).booleanValue()) {
                object2 = (SecureSocketLayer)properties2.get("sslConfig");
                etoolsCopyUtility = new EtoolsCopyUtility();
                object = (SecureSocketLayer)etoolsCopyUtility.copy((EObject)object2);
                SecurityConfig.expandSSLVars((SecureSocketLayer)object);
                properties2.put("sslConfig", object);
            }
            object3 = new UserRegistryImpl();
            object2 = SecurityConfig.expandProps(properties2);
            ((UserRegistryImpl)((Object)object3)).initialize((Properties)object2);
            object4 = object3;
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.security.core.SecurityAdmin.getRegistry", (String)"452", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.createerror", (Object)new Object[]{remoteException});
            throw remoteException;
        }
        catch (CustomRegistryException customRegistryException) {
            FFDCFilter.processException((Throwable)customRegistryException, (String)"com.ibm.ws.security.core.SecurityAdmin.getRegistry", (String)"457", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.createerror", (Object)new Object[]{customRegistryException});
            throw customRegistryException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getRegistry", (String)"462", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.createerror", (Object)new Object[]{exception});
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRegistry ");
        }
        if (this._registry == null) {
            this._registry = object4;
        }
        return object4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProps(String string) throws IOException {
        URL uRL;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getProps ");
            }
            String string2 = string;
            uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.security.core.SecurityAdmin.getProps", (String)"495", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sa.set.props", (Object)new Object[]{string2, malformedURLException});
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"Malformed url", (Object)string2);
            }
        }
        Properties properties = new Properties();
        InputStream inputStream = uRL.openStream();
        try {
            properties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getProps ");
        }
        return properties;
    }

    private void setProps(Properties properties, String string) throws IOException {
        URL uRL;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"setProps ");
            }
            String string2 = string;
            uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.security.core.SecurityAdmin.setProps", (String)"526", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sa.set.props", (Object)new Object[]{string2, malformedURLException});
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Malformed url", (Object)string2);
            }
        }
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(uRL.getFile());
        properties.save(fileOutputStream, "SSOProperties");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setProps ");
        }
    }

    private LTPAServerObject getLtpaServer(Properties properties) throws Exception {
        return this.getLtpaServer();
    }

    private LTPAServerObject getLtpaServer() throws Exception {
        if (this._ltpaServer == null) {
            this._ltpaServer = new LTPAServerObject();
            if (this._ltpaServer == null) {
                Tr.error((TraceComponent)tc, (String)"security.sambean.noltpaserver");
                throw new Exception("Error creating LTPAServerObject.");
            }
        }
        return this._ltpaServer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

