/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityUtilityImpl.WSSecurityContextFactory;
import com.ibm.crypto.fips.provider.IBMJCEFIPS;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.emf.ecore.utilities.copy.EtoolsCopyUtility;
import com.ibm.fips.jsse.IBMJSSEFIPSProvider;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.models.config.ipc.ssl.CryptoHardwareToken;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.jaaslogin.JAASConfiguration;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.ORB;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.auth.Cache;
import com.ibm.ws.security.auth.login.Configuration;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.JaasWCCMHelper;
import com.ibm.ws.security.core.SASConfig;
import com.ibm.ws.security.core.SecurityAdmin;
import com.ibm.ws.security.core.SecurityCollaborator;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.SecurityConfigException;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.core.SecurityDM;
import com.ibm.ws.security.core.SecurityManager;
import com.ibm.ws.security.policy.NullDynamicPolicy;
import com.ibm.ws.security.policy.WSDynamicPolicy;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorFactory;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.security.server.SecurityServerFactory;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.security.util.SecurityMerge;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.Policy;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public final class SecurityComponentImpl
extends ComponentImpl
implements SecurityService {
    private Repository repository = null;
    private EndPointMgr endPointMgr = null;
    private SecurityDM dm = null;
    private boolean ibmjssefips_might_be_in_demand = false;
    private static RoleBasedConfigurator configurator = null;
    private static final String LOGIN_CONFIG_CLASS = "com.ibm.ws.security.auth.login.Configuration";
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$core$SecurityComponentImpl == null ? (class$com$ibm$ws$security$core$SecurityComponentImpl = SecurityComponentImpl.class$("com.ibm.ws.security.core.SecurityComponentImpl")) : class$com$ibm$ws$security$core$SecurityComponentImpl), null, (String)"com.ibm.ejs.resources.security");
    private com.ibm.websphere.models.config.security.Security security = null;
    private String processType = null;
    private SecurityServer secServer = null;
    private ArrayList listeners = new ArrayList(32);
    static /* synthetic */ Class class$com$ibm$ws$security$service$SecurityService;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$EndPointMgr;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ORB;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Server;
    static /* synthetic */ Class class$com$ibm$ws$security$core$SecurityComponentImpl;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$VariableMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void initialize(Object var1_1) throws ConfigurationWarning, ConfigurationError {
        if (SecurityComponentImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SecurityComponentImpl.tc, (String)"initialize ", (Object)var1_1);
        }
        try {
            block107: {
                block106: {
                    try {
                        javax.security.auth.login.Configuration.setConfiguration((javax.security.auth.login.Configuration)new Configuration());
                    }
                    catch (Exception var2_2) {
                        FFDCFilter.processException((Throwable)var2_2, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"91", (Object)this);
                        Tr.error((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.wccmjaas.setcfgerror", (Object)new Object[]{"com.ibm.ws.security.auth.login.Configuration", var2_2});
                        throw new ConfigurationError("Unable to set com.ibm.ws.security.auth.login.Configuration as the JAAS Login Configuration class.", (Throwable)var2_2);
                    }
                    this.addService(SecurityComponentImpl.class$com$ibm$ws$security$service$SecurityService == null ? (SecurityComponentImpl.class$com$ibm$ws$security$service$SecurityService = SecurityComponentImpl.class$("com.ibm.ws.security.service.SecurityService")) : SecurityComponentImpl.class$com$ibm$ws$security$service$SecurityService);
                    this.repository = (Repository)this.getService(SecurityComponentImpl.class$com$ibm$ws$runtime$service$Repository == null ? (SecurityComponentImpl.class$com$ibm$ws$runtime$service$Repository = SecurityComponentImpl.class$("com.ibm.ws.runtime.service.Repository")) : SecurityComponentImpl.class$com$ibm$ws$runtime$service$Repository);
                    var2_3 = this.repository.getConfigRoot();
                    this.endPointMgr = (EndPointMgr)this.getService(SecurityComponentImpl.class$com$ibm$ws$runtime$service$EndPointMgr == null ? (SecurityComponentImpl.class$com$ibm$ws$runtime$service$EndPointMgr = SecurityComponentImpl.class$("com.ibm.ws.runtime.service.EndPointMgr")) : SecurityComponentImpl.class$com$ibm$ws$runtime$service$EndPointMgr);
                    try {
                        block103: {
                            block101: {
                                this.dm = new SecurityDM();
                                if (this.dm == null) {
                                    if (SecurityComponentImpl.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)"Null SecurityDM after construction");
                                    }
                                } else {
                                    this.dm.registerWithFFDCService();
                                }
                                var3_5 = null;
                                var4_7 = "security.xml";
                                try {
                                    var3_5 = var2_3.getResource(0, (String)var4_7);
                                }
                                catch (Exception var5_8) {
                                    FFDCFilter.processException((Throwable)var5_8, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"114", (Object)this);
                                    Tr.error((TraceComponent)SecurityComponentImpl.tc, (String)"security.loadresource.error", (Object)new Object[]{var4_7, var5_8});
                                    throw var5_8;
                                }
                                var5_9 = (com.ibm.websphere.models.config.security.Security)var3_5.getContents().get(0);
                                var6_10 = new EtoolsCopyUtility();
                                this.security = (com.ibm.websphere.models.config.security.Security)var6_10.copy((EObject)var5_9);
                                if (this.security == null) {
                                    Tr.error((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.nullsecobject");
                                    throw new SecurityConfigException("Cannot get the Security object. security.xml might be corrupt or missing");
                                }
                                SecurityConfig.getConfig().setValue("cell.security.enabled", new Boolean(this.security.isEnabled()));
                                var7_11 /* !! */  = AdminServiceFactory.getAdminService();
                                this.processType = var7_11 /* !! */ .getProcessType();
                                if (this.processType == null || this.processType.length() == 0) {
                                    if (SecurityComponentImpl.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)"Cannot determine process type");
                                    }
                                    Tr.error((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.nullprocesstype");
                                    throw new SecurityConfigException("Cannot get the process type.");
                                }
                                if (SecurityComponentImpl.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)("Process type: " + this.processType));
                                }
                                SecurityConfig.getConfig().setValue("security.processType", this.processType);
                                if (this.processType.equals("NodeAgent")) {
                                    var8_12 = SecurityConfig.getProperties((List)this.security.getProperties());
                                    var9_17 = var8_12.getProperty("WAS_UseRemoteRegistry");
                                    var10_19 = SecurityConfig.getProperties((List)this.security.getActiveUserRegistry().getProperties());
                                    var11_20 = var10_19.getProperty("com.ibm.websphere.registry.UseDataSource");
                                    if (var9_17 != null && var9_17.equalsIgnoreCase("cell") || var11_20 != null && var11_20.equalsIgnoreCase("true")) {
                                        SecurityConfig.getConfig().setValue("WAS_UseRemoteRegistry", "cell");
                                        if (SecurityComponentImpl.tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)"Setting remote registry to: cell");
                                        }
                                    }
                                } else if (this.processType.equals("ManagedProcess")) {
                                    block99: {
                                        var8_12 = null;
                                        try {
                                            var8_12 = var2_3.getResource(4, (String)var4_7);
                                        }
                                        catch (Exception var9_18) {
                                            if (!SecurityComponentImpl.tc.isDebugEnabled()) break block99;
                                            Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)"Cannot get Resource for Server. Security.xml for server is missing. Will use cell's security.xml");
                                        }
                                    }
                                    if (var8_12 != null) {
                                        var9_17 = (com.ibm.websphere.models.config.security.Security)var8_12.getContents().get(0);
                                        var10_19 = (com.ibm.websphere.models.config.security.Security)var6_10.copy((EObject)var9_17);
                                        if (SecurityComponentImpl.tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)"Managed process: Start merging the server's and cell's configuration");
                                        }
                                        this.security = SecurityMerge.merge(this.security, (com.ibm.websphere.models.config.security.Security)var10_19);
                                        if (SecurityComponentImpl.tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)"Managed process: End of merging the server's and cell's configuration");
                                        }
                                    }
                                    if ((var10_19 = (var9_17 = SecurityConfig.getProperties((List)this.security.getProperties())).getProperty("WAS_UseRemoteRegistry")) != null && (var10_19.equalsIgnoreCase("node") || var10_19.equalsIgnoreCase("cell"))) {
                                        SecurityConfig.getConfig().setValue("WAS_UseRemoteRegistry", var10_19);
                                        if (SecurityComponentImpl.tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)("Setting remote registry to: " + (String)var10_19));
                                        }
                                    }
                                }
                                Security.setProperty("DEFAULT_JCE_PROVIDER", (String)SecurityConfig.getConfig().getValue("IBMJCE"));
                                var8_12 = SecurityConfig.getProperties((List)this.security.getProperties());
                                var9_17 = var8_12.getProperty("com.ibm.security.useFIPS");
                                var10_19 = "USEFIPS_ENABLED";
                                var11_21 = false;
                                if (var9_17 != null && !var9_17.equals("")) {
                                    Security.setProperty((String)var10_19, (String)var9_17);
                                } else {
                                    Security.setProperty((String)var10_19, "false");
                                }
                                if (var9_17 != null && var9_17.equalsIgnoreCase("true")) {
                                    var11_21 = true;
                                    SecurityConfig.getConfig().setValue("IBMJCE", "IBMJCEFIPS");
                                    Security.setProperty("DEFAULT_JCE_PROVIDER", (String)SecurityConfig.getConfig().getValue("IBMJCE"));
                                }
                                this.initializeJava2Sec();
                                if (this.security != null) {
                                    SecurityConfig.getConfig().setValue("server.security.enabled", new Boolean(this.security.isEnabled()));
                                    SecurityConfig.getConfig().setValues(this.security);
                                    var12_23 = SecurityConfig.getConfig();
                                    var13_24 = Configuration.getConfiguration();
                                    var14_32 = var13_24.getClass().getName();
                                    if (SecurityComponentImpl.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)("The Login Configuration class is: " + (String)var14_32));
                                    }
                                    if (var13_24 instanceof Configuration) {
                                        try {
                                            var15_33 = (Configuration)Configuration.getConfiguration();
                                            var16_35 /* !! */  = (JAASConfiguration)var12_23.getValue("security.loginconfig.system");
                                            var17_36 = JaasWCCMHelper.convertToConfiguration((JAASConfiguration)var16_35 /* !! */ , (boolean)true);
                                            var16_35 /* !! */  = (JAASConfiguration)var12_23.getValue("security.loginconfig.application");
                                            var18_37 = JaasWCCMHelper.convertToConfiguration((JAASConfiguration)var16_35 /* !! */ , (boolean)false);
                                            var17_36.putAll(var18_37);
                                            var15_33.updateWCCMConfig((HashMap)var17_36);
                                            Tr.info((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.wccmjaas.init");
                                            if (!SecurityComponentImpl.tc.isDebugEnabled()) ** GOTO lbl127
                                            var19_38 = var15_33.toString();
                                            Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)("The dynamic JAAS login configuration is:\n" + var19_38));
                                        }
                                        catch (Exception var15_34) {
                                            FFDCFilter.processException((Throwable)var15_34, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"158", (Object)this);
                                            Tr.error((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.wccmjaas.error", (Object)new Object[]{var15_34});
                                            throw var15_34;
                                        }
                                    } else {
                                        var15_33 = (Boolean)SecurityConfig.getConfig().getValue("cell.security.enabled");
                                        if (var15_33 != null && var15_33.booleanValue()) {
                                            Tr.error((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.wccmjaas.wrongclasserror", (Object)new Object[]{var14_32, "com.ibm.ws.security.auth.login.Configuration"});
                                            throw new RuntimeException("JAAS Login provider class com.ibm.ws.security.auth.login.Configuration is not configured as login provider class");
                                        }
                                        Tr.warning((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.wccmjaas.wrongclasswarning", (Object)new Object[]{var14_32, "com.ibm.ws.security.auth.login.Configuration"});
                                    }
                                }
lbl127:
                                // 5 sources

                                this.initializeDefaultSSLSettings(this.security);
                                if (this.ibmjssefips_might_be_in_demand) {
                                    block100: {
                                        var12_23 = null;
                                        try {
                                            var12_23 = Security.getProvider("IBMJSSEFIPS");
                                        }
                                        catch (Throwable var13_25) {
                                            if (!SecurityComponentImpl.tc.isDebugEnabled()) break block100;
                                            Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)"getProvider(IBMJSSEFIPS) Exception caught", (Object)var13_25);
                                        }
                                    }
                                    try {
                                        if (var12_23 == null) {
                                            var13_26 = 0;
                                            var12_23 = new IBMJSSEFIPSProvider();
                                            if (var13_26 > 0) {
                                                Security.insertProviderAt((Provider)var12_23, var13_26);
                                            } else {
                                                Security.addProvider((Provider)var12_23);
                                            }
                                        }
                                    }
                                    catch (Exception var13_27) {
                                        Tr.warning((TraceComponent)SecurityComponentImpl.tc, (String)"security.addprovider.error", (Object)new Object[]{var13_27});
                                        if (!SecurityComponentImpl.tc.isDebugEnabled()) break block101;
                                        Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)"Exception caught adding IBMJSSEFIPS", (Object)var13_27);
                                    }
                                }
                            }
                            if (var11_21) {
                                block102: {
                                    var12_23 = null;
                                    try {
                                        var12_23 = Security.getProvider("IBMJCEFIPS");
                                    }
                                    catch (Throwable var13_28) {
                                        if (!SecurityComponentImpl.tc.isDebugEnabled()) break block102;
                                        Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)"getProvider(IBMJCEFIPS) Exception caught", (Object)var13_28);
                                    }
                                }
                                try {
                                    if (var12_23 == null) {
                                        var13_29 = 0;
                                        var12_23 = new IBMJCEFIPS();
                                        if (var13_29 > 0) {
                                            Security.insertProviderAt((Provider)var12_23, var13_29);
                                        } else {
                                            Security.addProvider((Provider)var12_23);
                                        }
                                    }
                                }
                                catch (Exception var13_30) {
                                    Tr.warning((TraceComponent)SecurityComponentImpl.tc, (String)"security.addprovider.error", (Object)new Object[]{var13_30});
                                    if (SecurityComponentImpl.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)"Exception caught adding IBMJCEFIPS", (Object)var13_30);
                                    }
                                    if (!var11_21) break block103;
                                    throw var13_30;
                                }
                            }
                        }
                        var12_23 = new Properties();
                        var13_31 = (ORB)this.getService(SecurityComponentImpl.class$com$ibm$ws$runtime$service$ORB == null ? (SecurityComponentImpl.class$com$ibm$ws$runtime$service$ORB = SecurityComponentImpl.class$("com.ibm.ws.runtime.service.ORB")) : SecurityComponentImpl.class$com$ibm$ws$runtime$service$ORB);
                        try {
                            if (var13_31 != null) {
                                var12_23 = var13_31.getOrbProps();
                            }
                        }
                        finally {
                            if (var13_31 != null) {
                                this.releaseService(var13_31);
                            }
                        }
                        this.expandVariables((Properties)var12_23);
                        if (var12_23 != null) {
                            var14_32 = (List)SecurityConfig.getConfig().getValue("security.toplevel.properties");
                            var15_33 = SecurityConfig.getProperties((List)var14_32);
                            var16_35 /* !! */  = (String)var15_33.get("com.ibm.CORBA.keyFileName");
                            if (var16_35 /* !! */  != null) {
                                var12_23.put("com.ibm.CORBA.keyFileName", var16_35 /* !! */ );
                            }
                            if ((var17_36 = (String)var15_33.get("com.ibm.ssl.keyStoreClientAlias")) != null) {
                                var12_23.put("com.ibm.ssl.keyStoreClientAlias", var17_36);
                            }
                            if ((var18_37 = (String)var15_33.get("com.ibm.ssl.keyStoreServerAlias")) != null) {
                                var12_23.put("com.ibm.ssl.keyStoreServerAlias", var18_37);
                            }
                            if ((var19_38 = (String)var15_33.get("com.ibm.ssl.sas.outbound.keyStoreClientAlias")) != null) {
                                var12_23.put("com.ibm.ssl.sas.outbound.keyStoreClientAlias", var19_38);
                            }
                            if ((var20_40 = (String)var15_33.get("com.ibm.ssl.sas.outbound.keyStoreServerAlias")) != null) {
                                var12_23.put("com.ibm.ssl.sas.outbound.keyStoreServerAlias", var20_40);
                            }
                            if ((var21_41 = (String)var15_33.get("com.ibm.ssl.sas.inbound.keyStoreClientAlias")) != null) {
                                var12_23.put("com.ibm.ssl.sas.inbound.keyStoreClientAlias", var21_41);
                            }
                            if ((var22_42 = (String)var15_33.get("com.ibm.ssl.sas.inbound.keyStoreServerAlias")) != null) {
                                var12_23.put("com.ibm.ssl.sas.inbound.keyStoreServerAlias", var22_42);
                            }
                            if ((var23_43 = (String)var15_33.get("com.ibm.ssl.csi.outbound.keyStoreClientAlias")) != null) {
                                var12_23.put("com.ibm.ssl.csi.outbound.keyStoreClientAlias", var23_43);
                            }
                            if ((var24_44 = (String)var15_33.get("com.ibm.ssl.csi.outbound.keyStoreServerAlias")) != null) {
                                var12_23.put("com.ibm.ssl.csi.outbound.keyStoreServerAlias", var24_44);
                            }
                            if ((var25_45 = (String)var15_33.get("com.ibm.ssl.csi.inbound.keyStoreClientAlias")) != null) {
                                var12_23.put("com.ibm.ssl.csi.inbound.keyStoreClientAlias", var25_45);
                            }
                            if ((var26_46 = (String)var15_33.get("com.ibm.ssl.csi.inbound.keyStoreServerAlias")) != null) {
                                var12_23.put("com.ibm.ssl.csi.inbound.keyStoreServerAlias", var26_46);
                            }
                            if ((var27_47 = (String)var15_33.get("com.ibm.ssl.tokenSlot")) != null) {
                                var12_23.put("com.ibm.ssl.tokenSlot", var27_47);
                            }
                            var28_48 = (String)var15_33.get("com.ibm.security.useFIPS");
                            if (SecurityComponentImpl.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)("use_fips_flag = " + var28_48));
                            }
                            if (var28_48 != null) {
                                var12_23.put("com.ibm.security.useFIPS", var28_48);
                            } else {
                                var12_23.put("com.ibm.security.useFIPS", "false");
                            }
                            var29_49 = (String)var15_33.get("security.enablePluggableAuthentication");
                            if (SecurityComponentImpl.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)("enable_pluggable_auth_falg = " + var29_49));
                            }
                            if (var29_49 != null) {
                                var12_23.put("security.enablePluggableAuthentication", var29_49);
                            } else {
                                var12_23.put("security.enablePluggableAuthentication", "false");
                            }
                        }
                        var14_32 = (Server)this.getService(SecurityComponentImpl.class$com$ibm$ws$runtime$service$Server == null ? (SecurityComponentImpl.class$com$ibm$ws$runtime$service$Server = SecurityComponentImpl.class$("com.ibm.ws.runtime.service.Server")) : SecurityComponentImpl.class$com$ibm$ws$runtime$service$Server);
                        try {
                            var15_33 = var14_32.getCellName() + ":" + var14_32.getNodeName() + ":" + var14_32.getName();
                            SecurityConfig.getConfig().setValue("process.serverName", var15_33);
                        }
                        finally {
                            if (var14_32 != null) {
                                this.releaseService(var14_32);
                            }
                        }
                        SASConfig.updateORBConfig(this.security, (Properties)var12_23, this.endPointMgr);
                        var32_51 = null;
                        if (this.repository == null) break block106;
                    }
                    catch (Throwable var31_53) {
                        var32_52 = null;
                        if (this.repository != null) {
                            this.releaseService(this.repository);
                        }
                        if (this.endPointMgr != null) {
                            this.releaseService(this.endPointMgr);
                        }
                        if (SecurityComponentImpl.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)SecurityConfig.getConfig().toString());
                        }
                        throw var31_53;
                    }
                    this.releaseService(this.repository);
                }
                if (this.endPointMgr != null) {
                    this.releaseService(this.endPointMgr);
                }
                if (SecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SecurityComponentImpl.tc, (String)SecurityConfig.getConfig().toString());
                }
                break block107;
                {
                    catch (Exception var3_6) {
                        FFDCFilter.processException((Throwable)var3_6, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"220", (Object)this);
                        Tr.error((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.error", (Object)new Object[]{var3_6});
                        throw new ConfigurationError("Error during Security initialization", (Throwable)var3_6);
                    }
                }
            }
            var3_5 = (Boolean)SecurityConfig.getConfig().getValue("cell.security.enabled");
            var4_7 = (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.enabled");
            if (var3_5 != null && var3_5.booleanValue()) {
                var5_9 = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
                if (var5_9.equalsIgnoreCase("LTPA") && var4_7 != null && !var4_7.booleanValue()) {
                    Tr.warning((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.ltpawithoutsso");
                }
                if ((var6_10 = (String)SecurityConfig.getConfig().getValue("security.enablePluggableAuthentication")).equalsIgnoreCase("true") || var6_10.equalsIgnoreCase("yes")) {
                    var7_11 /* !! */  = "Failed to initialize WSCallbackHandlerFactory";
                    try {
                        TrustAssociationManager.create();
                        var8_12 = (String)SecurityConfig.getConfig().getValue("security.callbackHandlerFactoryClass");
                        var9_17 = Class.forName((String)var8_12);
                        var10_19 = var9_17.getMethod("getInstance", new Class[]{Class.forName("java.lang.String")});
                        var11_22 = (WSCallbackHandlerFactory)var10_19.invoke(null, new Object[]{var8_12});
                    }
                    catch (ClassNotFoundException var8_13) {
                        Tr.error((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.error", (Object)new Object[]{var8_13});
                        throw new ConfigurationError((String)var7_11 /* !! */ , (Throwable)var8_13);
                    }
                    catch (NoSuchMethodException var8_14) {
                        Tr.error((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.error", (Object)new Object[]{var8_14});
                        throw new ConfigurationError((String)var7_11 /* !! */ , (Throwable)var8_14);
                    }
                    catch (IllegalAccessException var8_15) {
                        Tr.error((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.error", (Object)new Object[]{var8_15});
                        throw new ConfigurationError((String)var7_11 /* !! */ , (Throwable)var8_15);
                    }
                    catch (InvocationTargetException var8_16) {
                        Tr.error((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.error", (Object)new Object[]{var8_16});
                        throw new ConfigurationError((String)var7_11 /* !! */ , (Throwable)var8_16);
                    }
                }
            }
            Tr.info((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.startcomplete");
        }
        catch (ConfigurationError var2_4) {
            FFDCFilter.processException((Throwable)var2_4, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"253", (Object)this);
            Tr.audit((TraceComponent)SecurityComponentImpl.tc, (String)"security.init.startfail");
            throw var2_4;
        }
        if (SecurityComponentImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SecurityComponentImpl.tc, (String)"initialize");
        }
    }

    public void destroy() {
    }

    public void start() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start ");
        }
        try {
            if (this.processType.equals("NodeAgent")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processType is NodeAgent. Security server is being started");
                }
                this.initialize();
                this.fireStartedEvent();
                Tr.info((TraceComponent)tc, (String)"security.init.svcstartcomplete");
                Tr.info((TraceComponent)tc, (String)"security.init.secstatus", (Object)new Object[]{new Boolean(this.isServerSecurityEnabled())});
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processType is not NodeAgent.");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.start", (String)"248", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.init.error", (Object)new Object[]{exception});
            Tr.audit((TraceComponent)tc, (String)"security.init.svcstartfail");
            throw new RuntimeException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start ");
        }
    }

    public void startSecurity() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startSecurity ");
        }
        this.initialize();
        this.fireStartedEvent();
        Tr.info((TraceComponent)tc, (String)"security.init.svcstartcomplete");
        Tr.info((TraceComponent)tc, (String)"security.init.secstatus", (Object)new Object[]{new Boolean(this.isServerSecurityEnabled())});
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startSecurity ");
        }
    }

    public void initialize() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("cell.security.enabled");
        try {
            Resource resource;
            String string;
            Object object;
            SecurityContext.setIsServerProcess();
            if (bl != null && bl.booleanValue()) {
                this.secServer = SecurityServerFactory.create();
                this.initializeCache();
                SecurityContext.enable();
                SecurityContext.initialize();
                if (bl.booleanValue()) {
                    try {
                        ContextManagerFactory.getInstance().getServerCredential();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"315", (Object)((Object)this));
                        Tr.error((TraceComponent)tc, (String)"security.init.secidautherror", (Object)new Object[]{exception});
                        throw exception;
                    }
                }
            }
            boolean bl2 = false;
            if (bl != null) {
                bl2 = bl;
            }
            configurator = RoleBasedConfiguratorFactory.getConfigurator((boolean)bl2);
            if (bl2) {
                object = this.repository.getConfigRoot();
                string = "admin-authz.xml";
                resource = null;
                try {
                    resource = object.getResource(0, string);
                    configurator.loadApplication("admin-authz", resource);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"343", (Object)((Object)this));
                    Tr.error((TraceComponent)tc, (String)"security.loadresource.error", (Object)new Object[]{string, exception});
                    throw exception;
                }
                string = "naming-authz.xml";
                try {
                    resource = object.getResource(0, string);
                    configurator.loadApplication("naming-authz", resource);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"356", (Object)((Object)this));
                    Tr.error((TraceComponent)tc, (String)"security.loadresource.error", (Object)new Object[]{string, exception});
                    throw exception;
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"To get RoleBasedAuthorizer");
                    }
                    RoleBasedAuthorizer roleBasedAuthorizer = configurator.loadSecurityPolicy("admin-authz", "/com/ibm/ws/security/server/xml/SecurityServer.xml", "domain");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Initialized RoleBasedAuthorizer");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"371", (Object)((Object)this));
                    Tr.error((TraceComponent)tc, (String)"security.load.secConfig", (Object)new Object[]{exception});
                    throw exception;
                }
            }
            if (bl != null && bl.booleanValue()) {
                SecurityCollaborator.initialize();
            }
            try {
                object = new SecurityAdmin();
                string = AdminServiceFactory.getMBeanFactory();
                resource = new DefaultRuntimeCollaborator(object, "SecurityAdmin");
                string.activateMBean("SecurityAdmin", (RuntimeCollaborator)resource, string.getConfigId((Object)"SecurityAdmin"), "com/ibm/ws/management/descriptor/xml/SecurityAdmin.xml");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"414", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"security.init.mbeanerror", (Object)new Object[]{"SecurityAdmin", exception});
                throw exception;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"426", (Object)((Object)this));
            if (!bl.booleanValue()) {
                Tr.warning((TraceComponent)tc, (String)"security.init.error", (Object)new Object[]{exception});
            }
            Tr.error((TraceComponent)tc, (String)"security.init.error", (Object)new Object[]{exception});
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void stop() {
    }

    private void initializeDefaultSSLSettings(com.ibm.websphere.models.config.security.Security security) {
        block2: for (int i = 0; i < security.getRepertoire().size(); ++i) {
            SecureSocketLayer secureSocketLayer = ((SSLConfig)security.getRepertoire().get(i)).getSetting();
            if (secureSocketLayer == null) continue;
            if (secureSocketLayer.getKeyFileName() != null) {
                secureSocketLayer.setKeyFileName(this.expandVariable(secureSocketLayer.getKeyFileName()));
            }
            if (secureSocketLayer.getTrustFileName() != null) {
                secureSocketLayer.setTrustFileName(this.expandVariable(secureSocketLayer.getTrustFileName()));
            }
            if (this.ibmjssefips_might_be_in_demand) continue;
            try {
                Object var4_4 = null;
                EList eList = secureSocketLayer.getProperties();
                if (eList == null) continue;
                for (int j = 0; j < eList.size(); ++j) {
                    String string;
                    Property property = (Property)eList.get(j);
                    String string2 = property.getName();
                    if (string2 == null || !string2.equals("com.ibm.ssl.contextProvider") || (string = property.getValue()) == null || !string.equals("IBMJSSEFIPS")) continue;
                    this.ibmjssefips_might_be_in_demand = true;
                    continue block2;
                }
                continue;
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Exception caught inspecting contextProvider " + exception.getMessage()));
            }
        }
    }

    public com.ibm.websphere.models.config.security.Security getSecurity() {
        return this.security;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SecurityServiceListener securityServiceListener) {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addListener");
            serializable = new StringBuffer("Listener.hashCode() = ");
            ((StringBuffer)serializable).append(securityServiceListener.hashCode());
            ((StringBuffer)serializable).append("Listener.toString()");
            ((StringBuffer)serializable).append(securityServiceListener.toString());
            Tr.debug((TraceComponent)tc, (String)((StringBuffer)serializable).toString());
        }
        serializable = this.listeners;
        synchronized (serializable) {
            if (!this.listeners.contains(securityServiceListener)) {
                this.listeners.add(securityServiceListener);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SecurityServiceListener securityServiceListener) {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeListener");
            serializable = new StringBuffer("Listener.hashCode() = ");
            ((StringBuffer)serializable).append(securityServiceListener.hashCode());
            ((StringBuffer)serializable).append("Listener.toString()");
            ((StringBuffer)serializable).append(securityServiceListener.toString());
            Tr.debug((TraceComponent)tc, (String)((StringBuffer)serializable).toString());
        }
        serializable = this.listeners;
        synchronized (serializable) {
            this.listeners.remove(securityServiceListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStartedEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fireStartedEvent");
        }
        List list = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = (List)this.listeners.clone();
        }
        if (list != null) {
            int n = list.size();
            SecurityServiceEvent securityServiceEvent = new SecurityServiceEvent(1);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("list size = " + n));
            }
            for (int i = 0; i < n; ++i) {
                if (tc.isEntryEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("Invoking stateChanged(), Listener.hashCode() = ");
                    stringBuffer.append(list.get(i).hashCode());
                    stringBuffer.append("Listener.toString()");
                    stringBuffer.append(list.get(i).toString());
                    Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                }
                ((SecurityServiceListener)list.get(i)).stateChanged(securityServiceEvent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fireStartedEvent");
        }
    }

    public RoleBasedConfigurator getConfigurator() throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConfigurator");
        }
        if (configurator == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RoleBasedConfigurator not initialized");
            }
            throw new RoleBasedAppException("RoleBasedConfigurator not initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConfigurator");
        }
        return configurator;
    }

    public Properties getSecureSocketLayer(String string) throws IllegalArgumentException {
        if (string != null && !string.equals("")) {
            for (int i = 0; i < this.security.getRepertoire().size(); ++i) {
                if (!((SSLConfig)this.security.getRepertoire().get(i)).getAlias().equals(string)) continue;
                SecureSocketLayer secureSocketLayer = ((SSLConfig)this.security.getRepertoire().get(i)).getSetting();
                Properties properties = new Properties();
                if (secureSocketLayer == null) continue;
                properties.put("com.ibm.ssl.keyManager", "IbmX509");
                properties.put("com.ibm.ssl.trustManager", "IbmX509");
                properties.put("com.ibm.ssl.protocol", "SSL");
                if (secureSocketLayer.getKeyFileName() != null) {
                    properties.put("com.ibm.ssl.keyStore", secureSocketLayer.getKeyFileName());
                } else if (!secureSocketLayer.isEnableCryptoHardwareSupport()) {
                    throw new IllegalArgumentException("KeyFileName not set in the SSL configuration");
                }
                if (secureSocketLayer.getTrustFileName() != null) {
                    properties.put("com.ibm.ssl.trustStore", secureSocketLayer.getTrustFileName());
                } else if (!secureSocketLayer.isEnableCryptoHardwareSupport()) {
                    throw new IllegalArgumentException("TrustFileName not set in the SSL configuration");
                }
                if (secureSocketLayer.getTrustFilePassword() != null) {
                    properties.put("com.ibm.ssl.trustStorePassword", secureSocketLayer.getTrustFilePassword());
                } else if (!secureSocketLayer.isEnableCryptoHardwareSupport()) {
                    throw new IllegalArgumentException("TrustFilePassword not set in the SSL configuration");
                }
                if (secureSocketLayer.getKeyFilePassword() != null) {
                    properties.put("com.ibm.ssl.keyStorePassword", secureSocketLayer.getKeyFilePassword());
                } else if (!secureSocketLayer.isEnableCryptoHardwareSupport()) {
                    throw new IllegalArgumentException("KeyFilePassword not set in the SSL configuration");
                }
                if (secureSocketLayer.getKeyFileFormat() != null) {
                    properties.put("com.ibm.ssl.keyStoreType", SASConfig.getKeyStoreType(secureSocketLayer.getKeyFileFormat()));
                } else if (!secureSocketLayer.isEnableCryptoHardwareSupport()) {
                    throw new IllegalArgumentException("KeyFileFormat not set in the SSL configuration");
                }
                if (secureSocketLayer.getTrustFileFormat() != null) {
                    properties.put("com.ibm.ssl.trustStoreType", SASConfig.getKeyStoreType(secureSocketLayer.getTrustFileFormat()));
                } else if (!secureSocketLayer.isEnableCryptoHardwareSupport()) {
                    throw new IllegalArgumentException("TrustFileFormat not set in the SSL configuration");
                }
                properties.put("com.ibm.ssl.clientAuthentication", new Boolean(secureSocketLayer.isClientAuthentication()));
                properties.put("com.ibm.ssl.securityLevel", SASConfig.getSecurityLevel(secureSocketLayer.getSecurityLevel()));
                for (int j = 0; j < secureSocketLayer.getProperties().size(); ++j) {
                    Property property = (Property)secureSocketLayer.getProperties().get(j);
                    if (property == null) continue;
                    properties.put(property.getName(), property.getValue());
                }
                if (secureSocketLayer.isEnableCryptoHardwareSupport()) {
                    CryptoHardwareToken cryptoHardwareToken = secureSocketLayer.getCryptoHardware();
                    properties.put("com.ibm.ssl.tokenType", cryptoHardwareToken.getTokenType());
                    properties.put("com.ibm.ssl.tokenLibraryFile", cryptoHardwareToken.getLibraryFile());
                    properties.put("com.ibm.ssl.tokenPassword", cryptoHardwareToken.getPassword());
                }
                return properties;
            }
            return null;
        }
        throw new IllegalArgumentException("Alias is null or empty string.");
    }

    public boolean isSecurityEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isSecurityEnabled");
        }
        try {
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("cell.security.enabled");
            return bl != null && bl != false;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.core.SecurityComponentImpl.isSecurityEnabled", (String)"645", (Object)((Object)this));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception caught", (Object)throwable);
            }
            return false;
        }
    }

    public boolean isServerSecurityEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isServerSecurityEnabled");
        }
        try {
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.enabled");
            return bl != null && bl != false;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.core.SecurityComponentImpl.isServerSecurityEnabled", (String)"662", (Object)((Object)this));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception caught", (Object)throwable);
            }
            return false;
        }
    }

    public String getRealm() {
        return (String)SecurityConfig.getConfig().getValue("security.activeUserRegistry.realm");
    }

    public WSSecurityContext getWSSecurityContext() {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getWSSecurityContext");
            }
            if (this.isSecurityEnabled()) {
                try {
                    String string = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism.OID");
                    WSSecurityContextFactory wSSecurityContextFactory = WSSecurityContextFactory.getInstance();
                    WSSecurityContext wSSecurityContext = wSSecurityContextFactory.createContext(string);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getWSSecurityContext");
                    }
                    return wSSecurityContext;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.getWSSecurityContext", (String)"708", (Object)((Object)this));
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)"Exception getting WSSecurityContext", (Object)exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWSSecurityContext");
        }
        return null;
    }

    private void initializeJava2Sec() throws SecurityConfigException, ConfigurationError {
        if (this.security != null) {
            Boolean bl = null;
            try {
                bl = new Boolean(this.security.isEnforceJava2Security());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initializeJava2Sec", (String)"728", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"security.j2sec.init.error", (Object)new Object[]{exception});
                throw new ConfigurationError("Failed to get EnforceJava2Security.", (Throwable)exception);
            }
            if (bl == null) {
                throw new SecurityConfigException("EnforceJava2Security is not defined.");
            }
            try {
                boolean bl2 = bl;
                if (!bl2) {
                    Policy.setPolicy(new NullDynamicPolicy(Policy.getPolicy()));
                    System.setSecurityManager(null);
                    Tr.info((TraceComponent)tc, (String)"security.manager.disabled");
                } else {
                    WSDynamicPolicy wSDynamicPolicy = new WSDynamicPolicy(Policy.getPolicy(), this.repository);
                    Policy.setPolicy(wSDynamicPolicy);
                    List list = (List)SecurityConfig.getConfig().getValue("security.toplevel.properties");
                    Properties properties = SecurityConfig.getProperties(list);
                    String string = (String)properties.get("java.security.debug");
                    Server server = (Server)this.getService(class$com$ibm$ws$runtime$service$Server == null ? (class$com$ibm$ws$runtime$service$Server = SecurityComponentImpl.class$("com.ibm.ws.runtime.service.Server")) : class$com$ibm$ws$runtime$service$Server);
                    ExtClassLoader extClassLoader = (ExtClassLoader)server.getRuntimeClassLoader();
                    this.releaseService(server);
                    Boolean bl3 = new Boolean(this.security.isEnableJava2SecRuntimeFiltering());
                    if (bl3 == null) {
                        bl3 = Boolean.TRUE;
                    }
                    System.setSecurityManager(new SecurityManager(string, extClassLoader, wSDynamicPolicy.getRuntimeFilteredPermission(), bl3));
                    Tr.info((TraceComponent)tc, (String)"security.jsecman.installed");
                    Boolean bl4 = Boolean.TRUE;
                    bl4 = new Boolean(this.security.isIssuePermissionWarning());
                    wSDynamicPolicy.initApplicationTemplate(bl4);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initializeJava2Sec", (String)"773", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"security.j2sec.init.error", (Object)new Object[]{exception});
                throw new ConfigurationError("Error during Java 2 Security and Dynamic Policy initialization", (Throwable)exception);
            }
        }
    }

    private void expandVariables(Properties properties) {
        VariableMap variableMap = (VariableMap)this.getService(class$com$ibm$ws$runtime$service$VariableMap == null ? (class$com$ibm$ws$runtime$service$VariableMap = SecurityComponentImpl.class$("com.ibm.ws.runtime.service.VariableMap")) : class$com$ibm$ws$runtime$service$VariableMap);
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        try {
            string = variableMap.expand("${WAS_INSTALL_ROOT}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot expand ${WAS_INSTALL_ROOT}");
            }
            string = System.getProperty("was.install.root");
        }
        try {
            string2 = variableMap.expand("${USER_INSTALL_ROOT}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot expand ${USER_INSTALL_ROOT}");
            }
            string2 = System.getProperty("user.install.root", System.getProperty("was.install.root"));
        }
        try {
            string3 = variableMap.expand("${WAS_TEMP_DIR}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot expand ${WAS_TEMP_DIR}");
            }
            string3 = string + File.separator + "tmp";
        }
        try {
            string5 = variableMap.expand("${WAS_PROPS_DIR}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot expand ${WAS_PROPS_DIR}");
            }
            string5 = string + File.separator + "properties";
        }
        try {
            string6 = variableMap.expand("${APP_INSTALL_ROOT}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot expand ${APP_INSTALL_ROOT}");
            }
            string6 = string + File.separator + "installedApps";
        }
        try {
            string4 = variableMap.expand("${WAS_ETC_DIR}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot expand ${WAS_ETC_DIR}");
            }
            string4 = string + File.separator + "etc";
        }
        SecurityConfig.getConfig().setValue("${WAS_INSTALL_ROOT}", string);
        SecurityConfig.getConfig().setValue("${USER_INSTALL_ROOT}", string2);
        SecurityConfig.getConfig().setValue("${WAS_TEMP_DIR}", string3);
        SecurityConfig.getConfig().setValue("${WAS_PROPS_DIR}", string5);
        SecurityConfig.getConfig().setValue("${WAS_ETC_DIR}", string4);
        SecurityConfig.getConfig().setValue("${APP_INSTALL_ROOT}", string6);
        if (properties != null) {
            properties.put("${WAS_INSTALL_ROOT}", string);
            properties.put("${USER_INSTALL_ROOT}", string2);
            properties.put("${WAS_TEMP_DIR}", string3);
            properties.put("${WAS_PROPS_DIR}", string5);
            properties.put("${WAS_ETC_DIR}", string4);
            properties.put("${APP_INSTALL_ROOT}", string6);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WAS_INSTALL_ROOT = " + string + " USER_INSTALL_ROOT = " + string2 + " WAS_TEMP_DIR + " + string3 + " WAS_ETC_DIR =  " + string4 + " WAS_PROPS_DIR= " + string5 + " APP_INSTALL_ROOT= " + string6));
        }
    }

    private void initializeCache() {
        Long l = (Long)SecurityConfig.getConfig().getValue("security.CacheTimeout");
        long l2 = l;
        if (tc.isDebugEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("security cache timeout is " + l2));
        }
        Cache.setDefaultTimeout(l2 * 1000L);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

