/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.AuthMechanism;
import com.ibm.websphere.models.config.security.CustomAuthMechanism;
import com.ibm.websphere.models.config.security.CustomUserRegistry;
import com.ibm.websphere.models.config.security.Key;
import com.ibm.websphere.models.config.security.LDAPUserRegistry;
import com.ibm.websphere.models.config.security.LTPA;
import com.ibm.websphere.models.config.security.LocalOSUserRegistry;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.SWAMAuthentication;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.ws.security.auth.ContextManagerImpl;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AuthData;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.naming.ConfigurationException;
import org.eclipse.emf.common.util.EList;

public class SecurityConfig {
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$security$core$SecurityConfig == null ? (class$com$ibm$ws$security$core$SecurityConfig = SecurityConfig.class$("com.ibm.ws.security.core.SecurityConfig")) : class$com$ibm$ws$security$core$SecurityConfig).getName(), null, (String)"com.ibm.ejs.resources.security");
    private static final SecurityConfig secCfg = new SecurityConfig();
    private final HashMap myProps = new HashMap();
    public static final String CACHE_TIMEOUT = "security.CacheTimeout";
    public static final String CACHE_CUSHION_MIN = "security.CacheCushionMin";
    public static final String CACHE_CUSHION_MAX = "security.CacheCushionMax";
    public static final String SECURITY_ENABLED = "security.enabled";
    public static final String SERVER_SECURITY_ENABLED = "server.security.enabled";
    public static final String CELL_SECURITY_ENABLED = "cell.security.enabled";
    public static final String QUALIFIED_USER_NAME = "security.FullyQualifiedUserName";
    public static final String USE_LOCAL_SEC_SERVER = "security.useLocalSecurityServer";
    public static final String SECURITY_SERVER_NAME = "security.securityServerName";
    public static final String SERVER_NAME = "process.serverName";
    public static final String ISSUE_PERM_WARNING = "security.issuePermissionWarning";
    public static final String JMX_CONNECTOR_PROPS = "process.jmxConnectorProps";
    public static final String PROCESS_TYPE = "security.processType";
    public static final String PLUGGABLE_AUTHZN_PROPERTY = "com.ibm.websphere.security.authorizationTable";
    public static final String CALLBACK_HANDLER_FACTORY_CLASS = "security.callbackHandlerFactoryClass";
    public static final String CALLBACK_HANDLER_CLASS = "security.callbackHandlerClass";
    public static final String ENABLE_PLUGGABLE_AUTHENTICATION = "security.enablePluggableAuthentication";
    public static final String ENABLE_AUTHORIZATION_ATTRIBUTES = "security.enableAuthorizationAttributes";
    public static final String ACTIVE_AUTH_MECHANISM = "security.activeAuthMechanism";
    public static final String ACTIVE_AUTH_MECHANISM_OID = "security.activeAuthMechanism.OID";
    public static final String AUTH_MECHANISM_OID = "security.authMechOID";
    public static final String AUTH_MECHANISM_AUTHALIAS = "security.authMechAuthAlias";
    public static final String AUTH_MECHANISM_SIMPAUTHALIAS = "security.authMechSimpAuthAlias";
    public static final String AUTH_MECHANISM_VALIDATEALIAS = "security.authMechValidateAlias";
    public static final String AUTH_MECHANISM_FORWARDABLE_CRED = "security.authMechForwardCred";
    public static final String AUTH_MECHANISM_CONTEXTIMPL = "security.authMechContextImpl";
    public static final String TRUST_ASSOCIATION_ENABLED = "security.ltpa.trustAssociationEnabled";
    public static final String TRUST_ASSOCIATIONS = "security.ltpa.trustAssociations";
    public static final String LTPA_PASSWORD = "security.ltpa.password";
    public static final String LTPA_EXPIRATION_TIME = "security.ltpa.expirydate";
    public static final String LTPA_TOKEN_FACTORY_PROPERTY = "com.ibm.wsspi.security.ltpa.tokenFactory";
    public static final String LTPA_TOKEN_FACTORY_DEFAULT_IMPL_CLASS = "com.ibm.ws.security.ltpa.LTPATokenFactory|com.ibm.ws.security.ltpa.AuthzPropTokenFactory";
    public static final String SSO_ENABLED = "security.ltpa.sso.enabled";
    public static final String SSO_DOMAIN = "security.ltpa.sso.domain";
    public static final String SSO_SSL = "security.ltpa.sso.ssl";
    public static final String ACTIVE_USER_REGISTRY = "security.activeUserRegistry";
    public static final String SERVER_ID = "security.serverId";
    public static final String SERVER_PASSWD = "security.serverPasswd";
    public static final String ACTIVE_USER_REGISTRY_PROPS = "security.activeUserRegistry.props";
    public static final String ACTIVE_USER_REGISTRY_REALM = "security.activeUserRegistry.realm";
    public static final String LDAP_PROPS = "security.registry.ldap.props";
    public static final String LDAP_SSL_ENABLED = "security.registry.ldap.SSLEnabled";
    public static final String LDAP_SSL_CONFIG = "security.registry.ldap.SSLConfig";
    public static final String CUSTIMPL_CLASSNAME = "CustUserRegImplClass";
    public static final String CUSTOM_REG_PROPS = "CustomerUserRegistryProps";
    public static final String PROP_EXCEPTION_TO_CLIENT = "com.ibm.websphere.security.registry.propagateExceptionsToClient";
    public static final String REGISTRY_MAX_USERID_SIZE_PROPERTY = "com.ibm.websphere.security.registry.maxUseridSize";
    public static final String REGISTRY_MAX_PASSWORD_SIZE_PROPERTY = "com.ibm.websphere.security.registry.maxPasswordSize";
    public static final String LDAP_REUSE_CONN = "security.registry.ldap.reuseConn";
    public static final String LDAP_SEARCH_TIME_LIMIT = "security.registry.ldap.searchTimeLimit";
    public static final String REGISTRY_IMPL_CLASS = "CustUserRegImplClass";
    public static final String LDAP_REG_IMPL_CLASS = "com.ibm.ws.security.registry.ldap.LdapRegistryImpl";
    public static final String SAF_REG_IMPL_CLASS = "com.ibm.ws.security.registry.zOS.SAFRegistryImpl";
    public static final String USE_LOCALOS_USER_REGISTRY = "security.use.localos.userregistry";
    public static final String VIRTUAL_HOSTS = "host.virtualhosts";
    public static final String WEB_TRANSPORTS = "webcontainer.transports";
    public static final String SYSTEM_CONFIG_LOGIN_JAAS = "security.loginconfig.system";
    public static final String APPL_CONFIG_LOGIN_JAAS = "security.loginconfig.application";
    public static final String ENFORCE_JAVA2SECURITY = "security.java2security";
    public static final String USE_FIPS = "com.ibm.security.useFIPS";
    public static final String IBMJCEFIPS = "com.ibm.crypto.fips.provider.IBMJCEFIPS";
    public static final String IBMJSSEFIPS = "com.ibm.fips.jsse.IBMJSSEFIPSProvider";
    public static final String IBMJSSE = "com.ibm.jsse.IBMJSSEProvider";
    public static final String IBMJCE = "com.ibm.crypto.provider.IBMJCE";
    public static final String PROVIDER = "IBMJCE";
    public static final String DEFAULT_JCE_PROVIDER = "DEFAULT_JCE_PROVIDER";
    public static boolean isLDAP = false;
    public static boolean isTAM = false;
    public static final String RMI_OUTBOUND_PROPAGATION_ENABLED = "com.ibm.CSI.rmiOutboundPropagationEnabled";
    public static final String RMI_OUTBOUND_LOGIN_ENABLED = "com.ibm.CSI.rmiOutboundLoginEnabled";
    public static final String RMI_INBOUND_PROPAGATION_ENABLED = "com.ibm.CSI.rmiInboundPropagationEnabled";
    public static final String WEB_INBOUND_PROPAGATION_ENABLED = "com.ibm.ws.security.webInboundPropagationEnabled";
    public static final String SSO_INTEROP_MODE = "com.ibm.ws.security.ssoInteropModeEnabled";
    public static final String RMI_INBOUND_LOGIN_CONFIG = "com.ibm.CSI.rmiInboundLoginConfig";
    public static final String RMI_OUTBOUND_LOGIN_CONFIG = "com.ibm.CSI.rmiOutboundLoginConfig";
    public static final String WEB_INBOUND_LOGIN_CONFIG = "com.ibm.ws.security.webInboundLoginConfig";
    public static final String DEFAULT_LOGIN_CONFIG = "com.ibm.ws.security.defaultLoginConfig";
    public static final String SUPPORTED_TARGET_REALMS = "com.ibm.CSI.supportedTargetRealms";
    public static final String AUTHENTICATION_TOKEN_FACTORY = "com.ibm.wsspi.security.token.authenticationTokenFactory";
    public static final String AUTHORIZATION_TOKEN_FACTORY = "com.ibm.wsspi.security.token.authorizationTokenFactory";
    public static final String DEFAULT_TOKEN_FACTORY = "com.ibm.wsspi.security.token.defaultTokenFactory";
    public static final String PROPAGATION_TOKEN_FACTORY = "com.ibm.wsspi.security.token.propagationTokenFactory";
    public static final String SINGLESIGNON_TOKEN_FACTORY = "com.ibm.wsspi.security.token.singleSignonTokenFactory";
    public static final String DEFAULT_AUTHORIZATION_TOKEN_FACTORY = "com.ibm.ws.security.ltpa.AuthzPropTokenFactory";
    public static final String DEFAULT_PROPAGATION_TOKEN_FACTORY = "com.ibm.ws.security.ltpa.AuthzPropTokenFactory";
    public static final String DEFAULT_AUTHENTICATION_TOKEN_FACTORY = "com.ibm.ws.security.ltpa.LTPATokenFactory";
    public static final String DEFAULT_DEFAULT_TOKEN_FACTORY = "com.ibm.ws.security.ltpa.LTPATokenFactory";
    public static final String DEFAULT_SINGLESIGNON_TOKEN_FACTORY = "com.ibm.ws.security.ltpa.LTPATokenFactory";
    public static final String DEFAULT_WEB_PROPAGATION_SERVER_TRANSPORT = "JMX";
    public static final String WEB_PROPAGATION_SERVER_TRANSPORT = "com.ibm.ws.security.webPropagationTransport";
    public static final String DEFAULT_PROPAGATION_EXCLUDE_LIST = "";
    public static final String PROPAGATION_EXCLUDE_LIST = "com.ibm.ws.security.propagationExcludeList";
    public static final String DEFAULT_LTPATOKEN2_CIPHER = "AES/CBC/PKCS5Padding";
    public static final String LTPATOKEN2_CIPHER = "com.ibm.wsspi.security.token.ltpaToken2Cipher";
    public static ContextManager ctxMgr = ContextManagerFactory.getInstance();
    public static final String ICSF_KEYLABEL = "was.security.ISCF.cryptoKey";
    public static final String ICSF_EXPIRATION_TIME = "was.security.ISCF.timeout";
    public static final String AUTH_MECHANISM_SWAM = "SWAM";
    public static final String AUTH_MECHANISM_LTPA = "LTPA";
    public static final String AUTH_MECHANISM_KERBEROS = "KERBEROS";
    public static final String AUTH_MECHANISM_CUSTOM = "CUSTOM";
    public static final String AUTH_MECHANISM_ICSF = "ICSF";
    public static final Boolean disabled = new Boolean(false);
    public static final Boolean enabled = new Boolean(true);
    public static final Long cacheTimeout = new Long(30000L);
    static /* synthetic */ Class class$com$ibm$ws$security$core$SecurityConfig;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$applicationserver$ApplicationServer;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$applicationserver$webcontainer$WebContainer;

    public static SecurityConfig getConfig() {
        return secCfg;
    }

    private SecurityConfig() {
        this.init();
    }

    private void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        this.myProps.put(ACTIVE_AUTH_MECHANISM, AUTH_MECHANISM_SWAM);
        Boolean bl = new Boolean(false);
        Long l = new Long(30000L);
        this.myProps.put(TRUST_ASSOCIATION_ENABLED, bl);
        this.myProps.put(CACHE_TIMEOUT, l);
        this.myProps.put(SECURITY_ENABLED, bl);
        this.myProps.put(SSO_ENABLED, bl);
        this.myProps.put(SSO_SSL, bl);
        this.myProps.put(QUALIFIED_USER_NAME, bl);
        this.myProps.put(SECURITY_SERVER_NAME, "SecurityServer");
        this.myProps.put(USE_LOCAL_SEC_SERVER, bl);
        this.myProps.put(USE_FIPS, bl.toString());
        this.myProps.put(PROVIDER, PROVIDER);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public Object getValue(String string) {
        return this.myProps.get(string);
    }

    public void setValue(String string, Object object) throws IllegalArgumentException {
        this.myProps.put(string, object);
    }

    public void setValues(Security security) throws ConfigurationException {
        String string;
        Object object;
        String string2;
        String string3;
        String string4;
        Object object2;
        Object object3;
        Object object4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        String string11;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setValues " + security));
        }
        this.myProps.put("security.toplevel.properties", security.getProperties());
        EList eList = security.getProperties();
        Properties properties = SecurityConfig.getProperties((List)eList);
        String string12 = (String)properties.get(PROP_EXCEPTION_TO_CLIENT);
        if (string12 == null) {
            string12 = System.getProperty(PROP_EXCEPTION_TO_CLIENT);
        }
        if (string12 != null && (string12.equalsIgnoreCase("true") || string12.equalsIgnoreCase("yes"))) {
            this.myProps.put(PROP_EXCEPTION_TO_CLIENT, "true");
        } else {
            this.myProps.put(PROP_EXCEPTION_TO_CLIENT, "false");
        }
        if (security.getActiveAuthMechanism() instanceof SWAMAuthentication) {
            this.myProps.put(RMI_OUTBOUND_PROPAGATION_ENABLED, "false");
            this.myProps.put(RMI_INBOUND_PROPAGATION_ENABLED, "false");
            this.myProps.put(RMI_OUTBOUND_LOGIN_ENABLED, "false");
            this.myProps.put(WEB_INBOUND_PROPAGATION_ENABLED, "false");
            this.myProps.put(SSO_INTEROP_MODE, "true");
        } else {
            string11 = (String)properties.get(RMI_OUTBOUND_PROPAGATION_ENABLED);
            if (string11 == null) {
                string11 = System.getProperty(RMI_OUTBOUND_PROPAGATION_ENABLED);
            }
            if (string11 != null && (string11.equalsIgnoreCase("true") || string11.equalsIgnoreCase("yes"))) {
                this.myProps.put(RMI_OUTBOUND_PROPAGATION_ENABLED, "true");
            } else {
                this.myProps.put(RMI_OUTBOUND_PROPAGATION_ENABLED, "false");
            }
            string10 = (String)properties.get(RMI_INBOUND_PROPAGATION_ENABLED);
            if (string10 == null) {
                string10 = System.getProperty(RMI_INBOUND_PROPAGATION_ENABLED);
            }
            if (string10 != null && (string10.equalsIgnoreCase("true") || string10.equalsIgnoreCase("yes"))) {
                this.myProps.put(RMI_INBOUND_PROPAGATION_ENABLED, "true");
            } else {
                this.myProps.put(RMI_INBOUND_PROPAGATION_ENABLED, "false");
            }
            string9 = (String)properties.get(WEB_INBOUND_PROPAGATION_ENABLED);
            if (string9 == null) {
                string9 = System.getProperty(WEB_INBOUND_PROPAGATION_ENABLED);
            }
            if (string9 != null && (string9.equalsIgnoreCase("true") || string9.equalsIgnoreCase("yes"))) {
                this.myProps.put(WEB_INBOUND_PROPAGATION_ENABLED, "true");
            } else {
                this.myProps.put(WEB_INBOUND_PROPAGATION_ENABLED, "false");
            }
            string8 = (String)properties.get(SSO_INTEROP_MODE);
            if (string8 == null) {
                string8 = System.getProperty(SSO_INTEROP_MODE);
            }
            if (string8 != null && (string8.equalsIgnoreCase("true") || string8.equalsIgnoreCase("yes"))) {
                this.myProps.put(SSO_INTEROP_MODE, "true");
            } else {
                this.myProps.put(SSO_INTEROP_MODE, "false");
            }
            string7 = (String)properties.get(RMI_OUTBOUND_LOGIN_ENABLED);
            if (string7 == null) {
                string7 = System.getProperty(RMI_OUTBOUND_LOGIN_ENABLED);
            }
            if (string7 != null && (string7.equalsIgnoreCase("true") || string7.equalsIgnoreCase("yes"))) {
                this.myProps.put(RMI_OUTBOUND_LOGIN_ENABLED, "true");
            } else {
                this.myProps.put(RMI_OUTBOUND_LOGIN_ENABLED, "false");
            }
        }
        string11 = (String)properties.get(SINGLESIGNON_TOKEN_FACTORY);
        if (string11 == null) {
            string11 = System.getProperty(SINGLESIGNON_TOKEN_FACTORY);
        }
        if (string11 != null) {
            this.myProps.put(SINGLESIGNON_TOKEN_FACTORY, string11);
        } else {
            this.myProps.put(SINGLESIGNON_TOKEN_FACTORY, "com.ibm.ws.security.ltpa.LTPATokenFactory");
        }
        string10 = (String)properties.get(PROPAGATION_TOKEN_FACTORY);
        if (string10 == null) {
            string10 = System.getProperty(PROPAGATION_TOKEN_FACTORY);
        }
        if (string10 != null) {
            this.myProps.put(PROPAGATION_TOKEN_FACTORY, string10);
        } else {
            this.myProps.put(PROPAGATION_TOKEN_FACTORY, "com.ibm.ws.security.ltpa.AuthzPropTokenFactory");
        }
        string9 = (String)properties.get(DEFAULT_TOKEN_FACTORY);
        if (string9 == null) {
            string9 = System.getProperty(DEFAULT_TOKEN_FACTORY);
        }
        if (string9 != null) {
            this.myProps.put(DEFAULT_TOKEN_FACTORY, string9);
        } else {
            this.myProps.put(DEFAULT_TOKEN_FACTORY, "com.ibm.ws.security.ltpa.LTPATokenFactory");
        }
        string8 = (String)properties.get(AUTHORIZATION_TOKEN_FACTORY);
        if (string8 == null) {
            string8 = System.getProperty(AUTHORIZATION_TOKEN_FACTORY);
        }
        if (string8 != null) {
            this.myProps.put(AUTHORIZATION_TOKEN_FACTORY, string8);
        } else {
            this.myProps.put(AUTHORIZATION_TOKEN_FACTORY, "com.ibm.ws.security.ltpa.AuthzPropTokenFactory");
        }
        string7 = (String)properties.get(AUTHENTICATION_TOKEN_FACTORY);
        if (string7 == null) {
            string7 = System.getProperty(AUTHENTICATION_TOKEN_FACTORY);
        }
        if (string7 != null) {
            this.myProps.put(AUTHENTICATION_TOKEN_FACTORY, string7);
        } else {
            this.myProps.put(AUTHENTICATION_TOKEN_FACTORY, "com.ibm.ws.security.ltpa.LTPATokenFactory");
        }
        String string13 = (String)properties.get(LTPATOKEN2_CIPHER);
        if (string13 == null) {
            string13 = System.getProperty(LTPATOKEN2_CIPHER);
        }
        if (string13 != null) {
            this.myProps.put(LTPATOKEN2_CIPHER, string13);
        } else {
            this.myProps.put(LTPATOKEN2_CIPHER, DEFAULT_LTPATOKEN2_CIPHER);
        }
        String string14 = (String)properties.get(WEB_PROPAGATION_SERVER_TRANSPORT);
        if (string14 == null) {
            string14 = System.getProperty(WEB_PROPAGATION_SERVER_TRANSPORT);
        }
        if (string14 != null) {
            this.myProps.put(WEB_PROPAGATION_SERVER_TRANSPORT, string14);
        } else {
            this.myProps.put(WEB_PROPAGATION_SERVER_TRANSPORT, DEFAULT_WEB_PROPAGATION_SERVER_TRANSPORT);
        }
        String string15 = (String)properties.get(PROPAGATION_EXCLUDE_LIST);
        if (string15 == null) {
            string15 = System.getProperty(PROPAGATION_EXCLUDE_LIST);
        }
        if (string15 != null) {
            this.myProps.put(PROPAGATION_EXCLUDE_LIST, string15);
        } else {
            this.myProps.put(PROPAGATION_EXCLUDE_LIST, DEFAULT_PROPAGATION_EXCLUDE_LIST);
        }
        String string16 = (String)properties.get(REGISTRY_MAX_USERID_SIZE_PROPERTY);
        if (string16 == null || string16.equals(DEFAULT_PROPAGATION_EXCLUDE_LIST)) {
            this.myProps.put(REGISTRY_MAX_USERID_SIZE_PROPERTY, "256");
        } else {
            this.myProps.put(REGISTRY_MAX_USERID_SIZE_PROPERTY, string16);
        }
        String string17 = (String)properties.get(REGISTRY_MAX_PASSWORD_SIZE_PROPERTY);
        if (string17 == null || string17.equals(DEFAULT_PROPAGATION_EXCLUDE_LIST)) {
            this.myProps.put(REGISTRY_MAX_PASSWORD_SIZE_PROPERTY, "256");
        } else {
            this.myProps.put(REGISTRY_MAX_PASSWORD_SIZE_PROPERTY, string17);
        }
        Properties properties2 = null;
        Properties properties3 = SecurityConfig.getProperties((List)security.getProperties());
        String string18 = properties3.getProperty(USE_FIPS);
        if (string18 != null) {
            SecurityConfig.getConfig().setValue(USE_FIPS, string18);
        }
        if ((string6 = (String)properties.get(ENABLE_PLUGGABLE_AUTHENTICATION)) != null && (string6.equalsIgnoreCase("true") || string6.equalsIgnoreCase("yes"))) {
            this.myProps.put(ENABLE_PLUGGABLE_AUTHENTICATION, "true");
        } else {
            this.myProps.put(ENABLE_PLUGGABLE_AUTHENTICATION, "false");
        }
        String string19 = (String)properties.get(PLUGGABLE_AUTHZN_PROPERTY);
        if (string19 != null) {
            this.myProps.put(PLUGGABLE_AUTHZN_PROPERTY, string19);
        }
        if ((string5 = (String)properties.get(CALLBACK_HANDLER_FACTORY_CLASS)) != null) {
            this.myProps.put(CALLBACK_HANDLER_FACTORY_CLASS, string5);
        } else {
            this.myProps.put(CALLBACK_HANDLER_FACTORY_CLASS, "com.ibm.ws.security.auth.callback.WSCallbackHandlerFactoryImpl");
        }
        String string20 = (String)properties.get(CALLBACK_HANDLER_CLASS);
        if (string20 != null) {
            this.myProps.put(CALLBACK_HANDLER_CLASS, string20);
        } else {
            this.myProps.put(CALLBACK_HANDLER_CLASS, "com.ibm.ws.security.auth.callback.WSCallbackHandler");
        }
        String string21 = (String)properties.get(ENABLE_AUTHORIZATION_ATTRIBUTES);
        if (string21 != null && (string21.equalsIgnoreCase("true") || string21.equalsIgnoreCase("yes"))) {
            this.myProps.put(ENABLE_AUTHORIZATION_ATTRIBUTES, "true");
        } else {
            this.myProps.put(ENABLE_AUTHORIZATION_ATTRIBUTES, "false");
        }
        if (security.getActiveAuthMechanism() instanceof LTPA) {
            object4 = (LTPA)security.getActiveAuthMechanism();
            this.myProps.put(LTPA_EXPIRATION_TIME, new Long(object4.getTimeout()));
            this.myProps.put(LTPA_PASSWORD, object4.getPassword());
            this.myProps.put(ACTIVE_AUTH_MECHANISM, AUTH_MECHANISM_LTPA);
            object3 = (String)properties.get(LTPA_TOKEN_FACTORY_PROPERTY);
            if (object3 != null && ((String)object3).length() > 0) {
                SecurityConfig.getConfig().setValue(LTPA_TOKEN_FACTORY_PROPERTY, object3);
            } else {
                SecurityConfig.getConfig().setValue(LTPA_TOKEN_FACTORY_PROPERTY, LTPA_TOKEN_FACTORY_DEFAULT_IMPL_CLASS);
            }
            this.myProps.put(AUTH_MECHANISM_OID, object4.getOID());
            this.myProps.put(AUTH_MECHANISM_FORWARDABLE_CRED, enabled);
            this.myProps.put(AUTH_MECHANISM_CONTEXTIMPL, object4.getAuthContextImplClass());
            this.setLTPAKeys((LTPA)object4, this.myProps);
            object2 = object4.getSingleSignon();
            this.myProps.put(SSO_ENABLED, new Boolean(object2.isEnabled()));
            string4 = object2.getDomainName();
            this.myProps.put(SSO_DOMAIN, string4);
            this.myProps.put(SSO_SSL, new Boolean(object2.isRequiresSSL()));
            if (System.getProperty("com.ibm.ejs.security.setSSODomain", "true").equals("false")) {
                this.myProps.put("security.ltpa.setSSODomain", disabled);
            } else {
                this.myProps.put("security.ltpa.setSSODomain", enabled);
            }
            this.myProps.put(TRUST_ASSOCIATION_ENABLED, new Boolean(object4.getTrustAssociation().isEnabled()));
            this.myProps.put(TRUST_ASSOCIATIONS, object4.getTrustAssociation());
            String string22 = (String)properties.get(RMI_INBOUND_LOGIN_CONFIG);
            if (string22 == null || string22.equals(DEFAULT_PROPAGATION_EXCLUDE_LIST)) {
                string22 = System.getProperty(RMI_INBOUND_LOGIN_CONFIG);
            }
            if (string22 != null && !string22.equals(DEFAULT_PROPAGATION_EXCLUDE_LIST)) {
                this.myProps.put(RMI_INBOUND_LOGIN_CONFIG, string22);
            } else {
                this.myProps.put(RMI_INBOUND_LOGIN_CONFIG, "system.LTPA");
            }
            string3 = (String)properties.get(DEFAULT_LOGIN_CONFIG);
            if (string3 == null || string3.equals(DEFAULT_PROPAGATION_EXCLUDE_LIST)) {
                string3 = System.getProperty(DEFAULT_LOGIN_CONFIG);
            }
            if (string3 != null && !string3.equals(DEFAULT_PROPAGATION_EXCLUDE_LIST)) {
                this.myProps.put(DEFAULT_LOGIN_CONFIG, string3);
            } else {
                string3 = "system.LTPA";
                this.myProps.put(DEFAULT_LOGIN_CONFIG, string3);
            }
            this.myProps.put(AUTH_MECHANISM_SIMPAUTHALIAS, string3);
            this.myProps.put(AUTH_MECHANISM_AUTHALIAS, string3);
            this.myProps.put(AUTH_MECHANISM_VALIDATEALIAS, string3);
            string2 = (String)properties.get(RMI_OUTBOUND_LOGIN_CONFIG);
            if (string2 == null || string2.equals(DEFAULT_PROPAGATION_EXCLUDE_LIST)) {
                string2 = System.getProperty(RMI_OUTBOUND_LOGIN_CONFIG);
            }
            if (string2 != null && !string2.equals(DEFAULT_PROPAGATION_EXCLUDE_LIST)) {
                this.myProps.put(RMI_OUTBOUND_LOGIN_CONFIG, string2);
            } else {
                this.myProps.put(DEFAULT_LOGIN_CONFIG, "system.RMI_OUTBOUND");
            }
            object = (String)properties.get(WEB_INBOUND_LOGIN_CONFIG);
            if (object == null || ((String)object).equals(DEFAULT_PROPAGATION_EXCLUDE_LIST)) {
                object = System.getProperty(WEB_INBOUND_LOGIN_CONFIG);
            }
            if (object != null && !((String)object).equals(DEFAULT_PROPAGATION_EXCLUDE_LIST)) {
                this.myProps.put(WEB_INBOUND_LOGIN_CONFIG, object);
            } else {
                this.myProps.put(WEB_INBOUND_LOGIN_CONFIG, "system.LTPA_WEB");
            }
            string = (String)properties.get(SUPPORTED_TARGET_REALMS);
            if (string == null || string.equals(DEFAULT_PROPAGATION_EXCLUDE_LIST)) {
                string = System.getProperty(SUPPORTED_TARGET_REALMS);
            }
            if (string != null && !string.equals(DEFAULT_PROPAGATION_EXCLUDE_LIST)) {
                this.myProps.put(SUPPORTED_TARGET_REALMS, string);
            }
        } else if (security.getActiveAuthMechanism() instanceof SWAMAuthentication) {
            this.myProps.put(ACTIVE_AUTH_MECHANISM, AUTH_MECHANISM_SWAM);
            this.myProps.put(AUTH_MECHANISM_CONTEXTIMPL, DEFAULT_PROPAGATION_EXCLUDE_LIST);
            this.myProps.put(AUTH_MECHANISM_OID, "No OID for this mechanism");
            object4 = (SWAMAuthentication)security.getActiveAuthMechanism();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SWAM props are: " + object4));
            }
            this.myProps.put(AUTH_MECHANISM_FORWARDABLE_CRED, disabled);
            this.myProps.put(AUTH_MECHANISM_AUTHALIAS, object4.getAuthConfig());
            this.myProps.put(RMI_INBOUND_LOGIN_CONFIG, "system.SWAM");
            this.myProps.put(RMI_OUTBOUND_LOGIN_CONFIG, "system.RMI_OUTBOUND");
            this.myProps.put(WEB_INBOUND_LOGIN_CONFIG, "system.SWAM");
            this.myProps.put(DEFAULT_LOGIN_CONFIG, "system.SWAM");
        } else if (security.getActiveAuthMechanism() instanceof CustomAuthMechanism) {
            block137: {
                object4 = (CustomAuthMechanism)security.getActiveAuthMechanism();
                if (ctxMgr.getPlatformHelper().isZOS()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Treating as ICSF =  " + object4.getOID().toString()));
                    }
                    this.myProps.put(ACTIVE_AUTH_MECHANISM, AUTH_MECHANISM_ICSF);
                    object3 = object4.getProperties();
                    object2 = SecurityConfig.getProperties((List)object3);
                    this.myProps.put(ICSF_KEYLABEL, (String)((Properties)object2).get(ICSF_KEYLABEL));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ICSF_KEYLABEL is set to " + (String)((Properties)object2).get(ICSF_KEYLABEL)));
                    }
                    try {
                        this.myProps.put(ICSF_EXPIRATION_TIME, Long.valueOf((String)((Properties)object2).get(ICSF_EXPIRATION_TIME)));
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("was.security.ISCF.timeout " + Long.valueOf((String)((Properties)object2).get(ICSF_EXPIRATION_TIME))));
                        }
                    }
                    catch (Exception exception) {
                        this.myProps.put(ICSF_EXPIRATION_TIME, new Long(120L));
                        if (!tc.isDebugEnabled()) break block137;
                        Tr.debug((TraceComponent)tc, (String)"was.security.ISCF.timeout default of 120");
                    }
                }
            }
            this.myProps.put(AUTH_MECHANISM_OID, object4.getOID());
            this.myProps.put(AUTH_MECHANISM_AUTHALIAS, object4.getAuthConfig());
            this.myProps.put(AUTH_MECHANISM_SIMPAUTHALIAS, object4.getSimpleAuthConfig());
            this.myProps.put(AUTH_MECHANISM_VALIDATEALIAS, object4.getAuthValidationConfig());
            this.myProps.put(AUTH_MECHANISM_FORWARDABLE_CRED, enabled);
            this.myProps.put(AUTH_MECHANISM_CONTEXTIMPL, object4.getAuthContextImplClass());
            this.myProps.put(ACTIVE_AUTH_MECHANISM, AUTH_MECHANISM_CUSTOM);
            if (ctxMgr.getPlatformHelper().isZOS()) {
                this.myProps.put(TRUST_ASSOCIATION_ENABLED, new Boolean(object4.getTrustAssociation().isEnabled()));
                this.myProps.put(TRUST_ASSOCIATIONS, object4.getTrustAssociation());
                object3 = object4.getSingleSignon();
                if (new Boolean(object3.isEnabled()) != null) {
                    this.myProps.put(SSO_ENABLED, new Boolean(object3.isEnabled()));
                }
                object2 = object3.getDomainName();
                this.myProps.put(SSO_DOMAIN, object2);
                this.myProps.put(SSO_SSL, new Boolean(object3.isRequiresSSL()));
                if (System.getProperty("com.ibm.ejs.security.setSSODomain", "true").equals("false")) {
                    this.myProps.put("security.ltpa.setSSODomain", disabled);
                } else {
                    this.myProps.put("security.ltpa.setSSODomain", enabled);
                }
            }
        } else if (security.getActiveAuthMechanism() instanceof AuthMechanism) {
            object4 = security.getActiveAuthMechanism();
            this.myProps.put(AUTH_MECHANISM_OID, object4.getOID());
            this.myProps.put(AUTH_MECHANISM_AUTHALIAS, object4.getAuthConfig());
            this.myProps.put(AUTH_MECHANISM_SIMPAUTHALIAS, object4.getSimpleAuthConfig());
            this.myProps.put(AUTH_MECHANISM_VALIDATEALIAS, object4.getAuthValidationConfig());
            this.myProps.put(AUTH_MECHANISM_FORWARDABLE_CRED, enabled);
            this.myProps.put(AUTH_MECHANISM_CONTEXTIMPL, object4.getAuthContextImplClass());
            this.myProps.put(ACTIVE_AUTH_MECHANISM, AUTH_MECHANISM_KERBEROS);
        }
        if (security.getActiveUserRegistry() instanceof LocalOSUserRegistry) {
            this.myProps.put("security.activeUserRegistryType", "LOCALOS");
        }
        if (security.getActiveUserRegistry() instanceof CustomUserRegistry) {
            this.myProps.put("security.activeUserRegistryType", AUTH_MECHANISM_CUSTOM);
            object4 = new Properties();
            object3 = (CustomUserRegistry)security.getActiveUserRegistry();
            if (object3 != null) {
                ((Properties)object4).put("CustUserRegImplClass", object3.getCustomRegistryClassName());
                this.myProps.put(CUSTOM_REG_PROPS, object4);
                this.myProps.put("security.registry.IgnoreCase", new Boolean(object3.isIgnoreCase()));
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No Active registry");
            }
        }
        if (security.getActiveUserRegistry() instanceof LDAPUserRegistry) {
            String string23;
            this.myProps.put("security.activeUserRegistryType", "LDAP");
            object4 = null;
            object3 = (LDAPUserRegistry)security.getActiveUserRegistry();
            if (object3 != null) {
                object4 = this.setLDAPProperties((UserRegistry)object3);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No Active registry");
            }
            this.myProps.put(LDAP_PROPS, object4);
            this.myProps.put(LDAP_SSL_ENABLED, new Boolean(object3.isSslEnabled()));
            this.myProps.put("security.registry.IgnoreCase", new Boolean(object3.isIgnoreCase()));
            object2 = null;
            string4 = object3.getSslConfig();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Ldap SSL alias is " + string4));
            }
            for (int i = 0; i < security.getRepertoire().size(); ++i) {
                if (!((SSLConfig)security.getRepertoire().get(i)).getAlias().equals(string4)) continue;
                object2 = ((SSLConfig)security.getRepertoire().get(i)).getSetting();
                break;
            }
            if (object3.isSslEnabled() && object2 != null) {
                this.myProps.put(LDAP_SSL_CONFIG, object2);
            }
            isLDAP = true;
            properties2 = SecurityConfig.getProperties((List)security.getActiveUserRegistry().getProperties());
            if (properties2 != null && (string23 = (String)properties2.get("com.ibm.websphere.security.registry.UseTAM")) != null && string23.equalsIgnoreCase("true")) {
                isTAM = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Using Tivoli Access Manager");
                }
            }
        }
        this.myProps.put(ACTIVE_AUTH_MECHANISM_OID, security.getActiveAuthMechanism().getOID());
        object4 = null;
        object3 = null;
        if (!ctxMgr.getPlatformHelper().isZOS()) {
            this.myProps.put(SERVER_ID, security.getActiveUserRegistry().getServerId());
            object4 = security.getActiveUserRegistry().getServerPassword();
        } else {
            this.myProps.put(ACTIVE_USER_REGISTRY, security.getActiveUserRegistry());
            object3 = security.getActiveUserRegistry().getServerId();
            object4 = security.getActiveUserRegistry().getServerPassword();
            object2 = security.getActiveUserRegistry().getRealm();
            if (!(security.getActiveUserRegistry() instanceof LocalOSUserRegistry || object3 != null && object4 != null && object2 != null)) {
                throw new ConfigurationException("Error in the User Registry configuration - Null serverId, serverPassword, or realm was specified in the security.xml");
            }
            this.myProps.put(SERVER_ID, object3);
        }
        this.myProps.put(SERVER_PASSWD, object4);
        if (properties2 != null) {
            this.myProps.put(ACTIVE_USER_REGISTRY_PROPS, properties2);
        } else {
            this.myProps.put(ACTIVE_USER_REGISTRY_PROPS, SecurityConfig.getProperties((List)security.getActiveUserRegistry().getProperties()));
        }
        this.myProps.put(ACTIVE_USER_REGISTRY_REALM, security.getActiveUserRegistry().getRealm());
        this.myProps.put(SECURITY_SERVER_NAME, "SecurityServer");
        object2 = System.getProperty("com.ibm.ws.security.cacheCushionMin");
        if (object2 != null && !((String)object2).equals(DEFAULT_PROPAGATION_EXCLUDE_LIST)) {
            this.myProps.put(CACHE_CUSHION_MIN, new Integer((String)object2));
        } else {
            this.myProps.put(CACHE_CUSHION_MIN, new Integer("3"));
        }
        string4 = System.getProperty("com.ibm.ws.security.cacheCushionMax");
        if (string4 != null && !string4.equals(DEFAULT_PROPAGATION_EXCLUDE_LIST)) {
            this.myProps.put(CACHE_CUSHION_MAX, new Integer(string4));
        } else {
            this.myProps.put(CACHE_CUSHION_MAX, new Integer("10"));
        }
        this.myProps.put(SECURITY_ENABLED, new Boolean(security.isEnabled()));
        if (security.getCacheTimeout() > 0) {
            this.myProps.put(CACHE_TIMEOUT, new Long(security.getCacheTimeout()));
        } else {
            this.myProps.put(CACHE_TIMEOUT, cacheTimeout);
        }
        this.myProps.put(QUALIFIED_USER_NAME, new Boolean(security.isUseDomainQualifiedUserNames()));
        this.myProps.put(USE_LOCAL_SEC_SERVER, new Boolean(security.isUseLocalSecurityServer()));
        this.myProps.put(ISSUE_PERM_WARNING, new Boolean(security.isIssuePermissionWarning()));
        this.myProps.put(SYSTEM_CONFIG_LOGIN_JAAS, security.getSystemLoginConfig());
        this.myProps.put(APPL_CONFIG_LOGIN_JAAS, security.getApplicationLoginConfig());
        if (security.getAuthDataEntries() != null) {
            this.refreshAuthDataEntries(security);
        }
        this.myProps.put(ENFORCE_JAVA2SECURITY, new Boolean(security.isEnforceJava2Security()));
        if (ctxMgr.getPlatformHelper().isZOS()) {
            this.myProps.put(USE_LOCALOS_USER_REGISTRY, disabled);
            this.myProps.put("security.use.localos.authorization", "false");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setting use_localos_authorization = false");
            }
            this.myProps.put("com.ibm.CORBA.delegateCredentials", "methodDefined");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setting com.ibm.CORBA.delegateCredentials", (Object)"methodDefined");
            }
            if (security.getActiveUserRegistry() instanceof LocalOSUserRegistry) {
                String string24;
                String string25;
                if (security.getActiveUserRegistry() instanceof LocalOSUserRegistry) {
                    this.myProps.put("security.activeUserRegistryType", "LOCALOS");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Setting Use LocalOS UserRegistry to TRUE");
                }
                this.myProps.put(USE_LOCALOS_USER_REGISTRY, enabled);
                LocalOSUserRegistry localOSUserRegistry = (LocalOSUserRegistry)security.getActiveUserRegistry();
                string3 = (ContextManagerImpl)ContextManagerFactory.getInstance();
                this.myProps.put(SERVER_ID, string3.getRegionId());
                object3 = security.getActiveUserRegistry().getServerId();
                this.myProps.put(SERVER_ID, object3);
                this.myProps.put(ACTIVE_USER_REGISTRY_REALM, string3.getDefaultSAFRealm());
                this.myProps.put(SERVER_PASSWD, DEFAULT_PROPAGATION_EXCLUDE_LIST);
                string2 = localOSUserRegistry.getProperties();
                object = SecurityConfig.getProperties((List)((Object)string2));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Local OS Properties are" + ((Properties)object).toString()));
                }
                if (null != (string = ((Properties)object).getProperty("com.ibm.security.SAF.authorization")) && string.equals("true")) {
                    this.myProps.put("security.use.localos.authorization", "true");
                    this.myProps.put(PLUGGABLE_AUTHZN_PROPERTY, "com.ibm.ws.security.core.SAFAuthorizationTableImpl");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"setting security_use_localos_authorization = true");
                    }
                } else {
                    this.myProps.put("security.use.localos.authorization", "false");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"setting security_use_localos_authorization = false");
                    }
                }
                if (null != (string25 = ((Properties)object).getProperty("com.ibm.security.SAF.delegation")) && string25.equals("true")) {
                    this.myProps.put("com.ibm.CORBA.delegateCredentials", "saf");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"setting com.ibm.CORBA.delegateCredentials to saf");
                    }
                }
                if (null != (string24 = ((Properties)object).getProperty("com.ibm.security.SAF.unauthenticated"))) {
                    this.myProps.put("com.ibm.security.SAF.unauthenticated", string24);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("setting com.ibm.security.SAF.unauthenticated  to " + string24));
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setValues");
        }
    }

    public static void updateHTTPTransports(Server server) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateHTTPTransports " + server));
        }
        EList eList = server.getComponents();
        ApplicationServer applicationServer = null;
        Class clazz = class$com$ibm$websphere$models$config$applicationserver$ApplicationServer == null ? (class$com$ibm$websphere$models$config$applicationserver$ApplicationServer = SecurityConfig.class$("com.ibm.websphere.models.config.applicationserver.ApplicationServer")) : class$com$ibm$websphere$models$config$applicationserver$ApplicationServer;
        EList eList2 = eList.iterator();
        while (eList2.hasNext()) {
            object = eList2.next();
            if (!clazz.isInstance(object)) continue;
            applicationServer = (ApplicationServer)object;
            break;
        }
        eList2 = applicationServer.getComponents();
        object = null;
        Class clazz2 = class$com$ibm$websphere$models$config$applicationserver$webcontainer$WebContainer == null ? (class$com$ibm$websphere$models$config$applicationserver$webcontainer$WebContainer = SecurityConfig.class$("com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer")) : class$com$ibm$websphere$models$config$applicationserver$webcontainer$WebContainer;
        EList eList3 = eList2.iterator();
        while (eList3.hasNext()) {
            Object e = eList3.next();
            if (!clazz2.isInstance(e)) continue;
            object = (WebContainer)e;
            break;
        }
        eList3 = object.getTransports();
        secCfg.setValue(WEB_TRANSPORTS, eList3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateHTTPTransports ");
        }
    }

    public Properties setLDAPProperties(UserRegistry userRegistry) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setLDAPProperties ");
        }
        LDAPUserRegistry lDAPUserRegistry = (LDAPUserRegistry)userRegistry;
        Properties properties = new Properties();
        properties.put("LDAP.server.id", lDAPUserRegistry.getServerId());
        String string = lDAPUserRegistry.getServerPassword();
        properties.put("LDAP.server.pwd", string);
        properties.put("user.filter", lDAPUserRegistry.getSearchFilter().getUserFilter());
        properties.put("group.filter", lDAPUserRegistry.getSearchFilter().getGroupFilter());
        properties.put("group.idmap", lDAPUserRegistry.getSearchFilter().getGroupIdMap());
        properties.put("user.idmap", lDAPUserRegistry.getSearchFilter().getUserIdMap());
        properties.put("groupmember.idmap", lDAPUserRegistry.getSearchFilter().getGroupMemberIdMap());
        properties.put(LDAP_SEARCH_TIME_LIMIT, Long.toString(lDAPUserRegistry.getSearchTimeout()));
        properties.put(LDAP_REUSE_CONN, new Boolean(lDAPUserRegistry.isReuseConnection()).toString());
        this.myProps.put("security.registry.IgnoreCase", new Boolean(lDAPUserRegistry.isIgnoreCase()));
        if (lDAPUserRegistry.getSearchFilter() != null) {
            switch (lDAPUserRegistry.getSearchFilter().getCertificateMapMode().getValue()) {
                case 0: {
                    properties.put("certificate.map.mode", "exactDNMode");
                    break;
                }
                case 1: {
                    properties.put("certificate.map.mode", "filterDescriptorMode");
                    if (lDAPUserRegistry.getSearchFilter().getCertificateFilter() == null) {
                        Tr.warning((TraceComponent)tc, (String)"security.config.missingAttributeCertFilter");
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)"No CertificateFilter specified. Mandatory for Certificate Mode CERTIFICATE_FILTER");
                        break;
                    }
                    properties.put("certificate.map.filter", lDAPUserRegistry.getSearchFilter().getCertificateFilter());
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LDAP registry search filter info missing");
        }
        EList eList = lDAPUserRegistry.getHosts();
        String string2 = DEFAULT_PROPAGATION_EXCLUDE_LIST;
        String string3 = DEFAULT_PROPAGATION_EXCLUDE_LIST;
        if (eList != null && eList.size() > 0) {
            object2 = eList.iterator();
            object = (EndPoint)object2.next();
            string2 = object.getHost();
            string3 = Integer.toString(object.getPort());
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LDAP server host and port info missing");
        }
        object2 = new StringBuffer(string2);
        if (!((StringBuffer)object2).toString().startsWith("ldap://")) {
            ((StringBuffer)object2).insert(0, "ldap://");
        }
        if (string3 != null && string3.length() > 0) {
            ((StringBuffer)object2).append(":" + string3);
        }
        ((StringBuffer)object2).append("/");
        object = lDAPUserRegistry.getBaseDN();
        if (object != null && ((String)object).length() > 0) {
            properties.put("ldap.basedn", object);
            ((StringBuffer)object2).append((String)object);
        }
        properties.put("java.naming.provider.url", ((StringBuffer)object2).toString());
        if (lDAPUserRegistry.getBindDN() != null && lDAPUserRegistry.getBindDN().length() > 0) {
            properties.put("java.naming.security.principal", lDAPUserRegistry.getBindDN());
        }
        if (lDAPUserRegistry.getBindPassword() != null && lDAPUserRegistry.getBindPassword().length() > 0) {
            properties.put("java.naming.security.credentials", lDAPUserRegistry.getBindPassword());
        }
        if (lDAPUserRegistry.getType() != null) {
            switch (lDAPUserRegistry.getType().getValue()) {
                case 0: {
                    properties.put("dirType", "ibm_dir_server");
                    break;
                }
                case 2: {
                    properties.put("dirType", "iplanet");
                    break;
                }
                case 3: {
                    properties.put("dirType", "netscape");
                    break;
                }
                case 4: {
                    properties.put("dirType", "domino50");
                    break;
                }
                case 1: {
                    properties.put("dirType", "secureway");
                    break;
                }
                case 6: {
                    properties.put("dirType", "actived");
                    break;
                }
                case 5: {
                    properties.put("dirType", "edirectory");
                    break;
                }
                case 7: {
                    properties.put("dirType", "custom");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Unknow LDAP registry type");
        }
        properties.put("CustUserRegImplClass", LDAP_REG_IMPL_CLASS);
        if (tc.isEntryEnabled()) {
            Properties properties2 = SecurityConfig.maskPasswords(properties);
            Tr.exit((TraceComponent)tc, (String)("setLDAPProperties " + properties2));
        }
        return properties;
    }

    public static Properties getTrustProperties(List list) {
        Properties properties = new Properties();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Property property = (Property)list.get(i);
                properties.put(property.getName(), property.getValue());
            }
        }
        return properties;
    }

    public static Properties getProperties(List list) {
        Properties properties = new Properties();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Property property = (Property)list.get(i);
                properties.put(property.getName(), property.getValue());
            }
        }
        return properties;
    }

    public Properties getAuthData(String string) throws SecurityException {
        AuthData authData = WSDefaultPrincipalMapping.getAuthDataInt((String)string);
        if (authData == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.put("username", authData.uid);
        properties.put("password", authData.psw);
        return properties;
    }

    public String toString() {
        String string = "SecurityConfig property values:\n";
        if (this.myProps != null) {
            Properties properties;
            HashMap<String, Object> hashMap = new HashMap<String, Object>(this.myProps);
            hashMap.put(SERVER_PASSWD, "XXXXXX");
            hashMap.put(LTPA_PASSWORD, "XXXXXX");
            Properties properties2 = (Properties)hashMap.get(LDAP_PROPS);
            if (properties2 != null) {
                if (properties2.getProperty("LDAP.server.pwd") != null) {
                    properties2.setProperty("LDAP.server.pwd", "XXXXXX");
                }
                properties = SecurityConfig.maskPasswords(properties2);
                hashMap.put(LDAP_PROPS, properties);
            }
            if ((properties = (Properties)hashMap.get(ACTIVE_USER_REGISTRY_PROPS)) != null) {
                if (properties.getProperty("java.naming.security.credentials") != null) {
                    properties.setProperty("java.naming.security.credentials", "XXXXXX");
                }
                if (properties.getProperty("LDAP.server.pwd") != null) {
                    properties.setProperty("LDAP.server.pwd", "XXXXXX");
                }
            }
            hashMap.remove(ACTIVE_USER_REGISTRY);
            string = string + hashMap.toString();
        } else {
            string = string + "None to report, null property table.\n";
        }
        return string;
    }

    public static boolean isRegLDAP() {
        return isLDAP;
    }

    public static boolean isRegTAM() {
        return isTAM;
    }

    private void setLTPAKeys(LTPA lTPA, HashMap hashMap) {
        String string = null;
        Key key = null;
        if (lTPA.getPrivate() != null) {
            Tr.debug((TraceComponent)tc, (String)"ltpa.isSetPrivate() is true");
            key = lTPA.getPrivate();
            if (key != null) {
                Tr.debug((TraceComponent)tc, (String)"key.isSetByteArray()  is true");
                string = key.getByteArray();
            }
        }
        hashMap.put("com.ibm.websphere.ltpa.PrivateKey", string);
        string = null;
        if (lTPA.getPublic() != null && (key = lTPA.getPublic()) != null) {
            string = key.getByteArray();
        }
        hashMap.put("com.ibm.websphere.ltpa.PublicKey", string);
        string = null;
        if (lTPA.getShared() != null && (key = lTPA.getShared()) != null) {
            string = key.getByteArray();
        }
        hashMap.put("com.ibm.websphere.ltpa.3DESKey", string);
    }

    public static Properties maskPasswords(Properties properties) {
        Properties properties2 = new Properties();
        if (properties == null) {
            return null;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties2.put(string, properties.get(string));
        }
        if (properties.getProperty(LTPA_PASSWORD) != null) {
            properties2.put(LTPA_PASSWORD, "XXXXXX");
        }
        if (properties.getProperty("java.naming.security.credentials") != null) {
            properties2.put("java.naming.security.credentials", "XXXXXX");
        }
        if (properties.getProperty(SERVER_PASSWD) != null) {
            properties2.put(SERVER_PASSWD, "XXXXXX");
        }
        if (properties.getProperty("LDAP.server.pwd") != null) {
            properties2.put("LDAP.server.pwd", "XXXXXX");
        }
        return properties2;
    }

    public static void expandSSLVars(SecureSocketLayer secureSocketLayer) {
        CharSequence charSequence;
        String string = "${USER_INSTALL_ROOT}";
        int n = string.length();
        string = (String)SecurityConfig.getConfig().getValue("${USER_INSTALL_ROOT}");
        if (secureSocketLayer == null) {
            return;
        }
        String string2 = secureSocketLayer.getKeyFileName();
        if (string2.startsWith("${USER_INSTALL_ROOT}")) {
            charSequence = new StringBuffer(string2);
            ((StringBuffer)charSequence).replace(0, n, string);
            secureSocketLayer.setKeyFileName(((StringBuffer)charSequence).toString());
        }
        if (((String)(charSequence = secureSocketLayer.getTrustFileName())).startsWith("${USER_INSTALL_ROOT}")) {
            StringBuffer stringBuffer = new StringBuffer((String)charSequence);
            stringBuffer.replace(0, n, string);
            secureSocketLayer.setTrustFileName(stringBuffer.toString());
        }
    }

    public static Properties expandProps(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"expandProps");
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            StringBuffer stringBuffer;
            int n;
            String string;
            String string2 = (String)enumeration.nextElement();
            String string3 = null;
            if (properties.get(string2) instanceof String) {
                string3 = (String)properties.get(string2);
            }
            if (string3 != null && string3.startsWith("${USER_INSTALL_ROOT}")) {
                string = "${USER_INSTALL_ROOT}";
                n = string.length();
                string = (String)SecurityConfig.getConfig().getValue("${USER_INSTALL_ROOT}");
                stringBuffer = new StringBuffer(string3);
                stringBuffer.replace(0, n, string);
                properties.put(string2, stringBuffer.toString());
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("expanding the property: " + string3 + " to: " + stringBuffer.toString()));
                continue;
            }
            if (string3 == null || !string3.startsWith("${WAS_INSTALL_ROOT}")) continue;
            string = "${WAS_INSTALL_ROOT}";
            n = string.length();
            string = (String)SecurityConfig.getConfig().getValue("${WAS_INSTALL_ROOT}");
            stringBuffer = new StringBuffer(string3);
            stringBuffer.replace(0, n, string);
            properties.put(string2, stringBuffer.toString());
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("expanding the property: " + string3 + " to: " + stringBuffer.toString()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"expandProps");
        }
        return properties;
    }

    public static String expandString(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"expandString");
        }
        if (string != null && string.startsWith("${USER_INSTALL_ROOT}")) {
            String string2 = "${USER_INSTALL_ROOT}";
            int n = string2.length();
            string2 = (String)SecurityConfig.getConfig().getValue("${USER_INSTALL_ROOT}");
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.replace(0, n, string2);
            string = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("expanding the string to: " + string));
            }
        } else if (string != null && string.startsWith("${WAS_INSTALL_ROOT}")) {
            String string3 = "${WAS_INSTALL_ROOT}";
            int n = string3.length();
            string3 = (String)SecurityConfig.getConfig().getValue("${WAS_INSTALL_ROOT}");
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.replace(0, n, string3);
            string = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("expanding the string to : " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"expandString", (Object)string);
        }
        return string;
    }

    void refreshAuthDataEntries(Security security) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"refreshAuthDataEntries");
        }
        HashMap<String, AuthData> hashMap = new HashMap<String, AuthData>();
        Iterator iterator = security.getAuthDataEntries().iterator();
        while (iterator.hasNext()) {
            JAASAuthData jAASAuthData = (JAASAuthData)iterator.next();
            if (jAASAuthData == null) continue;
            hashMap.put(jAASAuthData.getAlias(), new AuthData(jAASAuthData.getUserId(), jAASAuthData.getPassword()));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("AuthData - add " + jAASAuthData.getAlias()));
        }
        WSDefaultPrincipalMapping.refreshAuthData(hashMap);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"refreshAuthDataEntries");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

