/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsMap;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.emf.ecore.utilities.copy.EtoolsCopyUtility;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.RMIConnector;
import com.ibm.websphere.models.config.adminservice.SOAPConnector;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VirtualHostMgr;
import com.ibm.ws.security.auth.DistributedMapFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.SecurityConfigException;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.ejb.BeanPermissionRoleMapTable;
import com.ibm.ws.security.ejb.RunAsMapTable;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.ws.security.web.WebAppCache;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public final class ServerSecurityComponentImpl
extends ComponentImpl
implements DeployedObjectListener {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$core$ServerSecurityComponentImpl == null ? (class$com$ibm$ws$security$core$ServerSecurityComponentImpl = ServerSecurityComponentImpl.class$("com.ibm.ws.security.core.ServerSecurityComponentImpl")) : class$com$ibm$ws$security$core$ServerSecurityComponentImpl), null, (String)"com.ibm.ejs.resources.security");
    private static final String DENYALL_ROLE_NAME = "DenyAllRole";
    private SecurityServer secServer = null;
    Hashtable webModulesMap;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$VirtualHostMgr;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ApplicationMgr;
    static /* synthetic */ Class class$com$ibm$ws$security$service$SecurityService;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$adminservice$AdminService;
    static /* synthetic */ Class class$com$ibm$ws$security$core$ServerSecurityComponentImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)object);
        }
        Repository repository = (Repository)this.getService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = ServerSecurityComponentImpl.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository);
        try {
            this.webModulesMap = new Hashtable();
            Resource resource = null;
            String string = "server.xml";
            try {
                resource = repository.getConfigRoot().getResource(4, string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ServerSecurityComponentImpl.initialize", (String)"90", (Object)((Object)this));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to load resource from process :  ", (Object)string);
                }
                if (repository != null) {
                    this.releaseService(repository);
                }
                return;
            }
            Server server = (Server)resource.getContents().get(0);
            EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
            server = (Server)etoolsCopyUtility.copy((EObject)server);
            SecurityConfig.updateHTTPTransports(server);
            ConfigRoot configRoot = repository.getConfigRoot();
            Properties properties = this.getServerAdminProps(configRoot, server);
            SecurityConfig.getConfig().setValue("process.jmxConnectorProps", properties);
            VirtualHostMgr virtualHostMgr = (VirtualHostMgr)this.getService(class$com$ibm$ws$runtime$service$VirtualHostMgr == null ? (class$com$ibm$ws$runtime$service$VirtualHostMgr = ServerSecurityComponentImpl.class$("com.ibm.ws.runtime.service.VirtualHostMgr")) : class$com$ibm$ws$runtime$service$VirtualHostMgr);
            SecurityConfig.getConfig().setValue("host.virtualhosts", virtualHostMgr.getVirtualHosts());
            if (virtualHostMgr != null) {
                this.releaseService(virtualHostMgr);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ServerSecurityComponentImpl.initialize", (String)"106", (Object)((Object)this));
            Tr.warning((TraceComponent)tc, (String)"security.servcomp.init");
        }
        finally {
            if (repository != null) {
                this.releaseService(repository);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        try {
            ApplicationMgr applicationMgr = (ApplicationMgr)this.getService(class$com$ibm$ws$runtime$service$ApplicationMgr == null ? (class$com$ibm$ws$runtime$service$ApplicationMgr = ServerSecurityComponentImpl.class$("com.ibm.ws.runtime.service.ApplicationMgr")) : class$com$ibm$ws$runtime$service$ApplicationMgr);
            try {
                applicationMgr.addDeployedObjectListener((DeployedObjectListener)this);
            }
            finally {
                if (applicationMgr != null) {
                    this.releaseService(applicationMgr);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Starting Security Server");
            }
            SecurityService securityService = (SecurityService)this.getService(class$com$ibm$ws$security$service$SecurityService == null ? (class$com$ibm$ws$security$service$SecurityService = ServerSecurityComponentImpl.class$("com.ibm.ws.security.service.SecurityService")) : class$com$ibm$ws$security$service$SecurityService);
            securityService.startSecurity();
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.enabled");
            if (bl.booleanValue() && WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Initializing DistributedMap for security attribute propagation.");
                }
                Properties properties = new Properties();
                properties.put("com.ibm.ws.cache.CacheConfig.cacheSize", "100");
                properties.put("com.ibm.ws.cache.CacheConfig.enableDiskOffload", "false");
                properties.put("com.ibm.ws.cache.CacheConfig.diskOffloadLocation", "");
                DistributedMapFactory.getMap("WSSecureMap", properties);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ServerSecurityComponentImpl.start", (String)"153", (Object)((Object)this));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start failed", (Object)new Object[]{exception});
            }
            throw new RuntimeError(exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        TrustAssociationManager trustAssociationManager = TrustAssociationManager.getInstance();
        if (trustAssociationManager != null) {
            trustAssociationManager.cleanTAInterceptors();
        }
    }

    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        DeployedObject deployedObject;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stateChanged");
        }
        if ((deployedObject = (DeployedObject)deployedObjectEvent.getSource()).getModuleFile().isEARFile()) {
            if (deployedObjectEvent.getNewValue() == "STARTING") {
                this.install(deployedObject);
                this.refreshAuthDataEntries();
            } else if (deployedObjectEvent.getNewValue() == "STOPPED") {
                this.uninstall(deployedObject);
            }
        } else if (deployedObject.getModuleFile().isWARFile()) {
            if (deployedObjectEvent.getNewValue() == "STARTING") {
                this.installWeb((DeployedModule)deployedObject);
            } else if (deployedObjectEvent.getNewValue() == "STOPPED") {
                this.uninstallWeb((DeployedModule)deployedObject);
            }
        } else if (deployedObject.getModuleFile().isEJBJarFile()) {
            if (deployedObjectEvent.getNewValue() == "STARTING") {
                this.installEJB((DeployedModule)deployedObject);
            } else if (deployedObjectEvent.getNewValue() == "STOPPED") {
                this.uninstallEJB((DeployedModule)deployedObject);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stateChanged");
        }
    }

    private void installWeb(DeployedModule deployedModule) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"installWeb", (Object)deployedModule.getName());
        }
        ModuleDeployment moduleDeployment = deployedModule.getModuleDeployment();
        WebModule webModule = (WebModule)((EARFile)deployedModule.getDeployedApplication().getModuleFile()).getModule(moduleDeployment.getUri(), moduleDeployment.getAltDD());
        String string = webModule.getContextRoot();
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("_webcontextroot = " + string));
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        String string2 = ((WebAppBinding)deployedModule.getBinding()).getVirtualHostName();
        String string3 = string2 + ":" + string;
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("contextroot = [" + string3 + "]"));
        }
        this.webModulesMap.put(deployedModule, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"installWeb");
        }
    }

    private void uninstallWeb(DeployedModule deployedModule) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"uninstallWeb", (Object)deployedModule.getName());
        }
        try {
            String string = (String)this.webModulesMap.get(deployedModule);
            if (string != null) {
                WebAppCache.removeWebApp(string);
                this.webModulesMap.remove(deployedModule);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ServerSecurityComponentImpl.uninstallWeb", (String)"208", (Object)((Object)this));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"uninstallWeb failed", (Object)new Object[]{exception});
            }
            throw new RuntimeWarning((Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uninstallWeb");
        }
    }

    private void installEJB(DeployedModule deployedModule) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"installEJB", (Object)deployedModule.getName());
        }
        String string = deployedModule.getDeployedApplication().getName();
        String string2 = deployedModule.getName();
        BeanPermissionRoleMapTable.addBeanPermissionRoleMap(string + ":" + string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"installEJB");
        }
    }

    private void uninstallEJB(DeployedModule deployedModule) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"uninstallEJB", (Object)deployedModule.getName());
        }
        try {
            String string = deployedModule.getDeployedApplication().getName();
            String string2 = deployedModule.getName();
            BeanPermissionRoleMapTable.removeBeanPermissionRoleMap(string + ":" + string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ServerSecurityComponentImpl.uninstallEJB", (String)"239", (Object)((Object)this));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"uninstallEJB failed", (Object)new Object[]{exception});
            }
            throw new RuntimeWarning((Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uninstallEJB");
        }
    }

    private void install(DeployedObject deployedObject) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"install", (Object)deployedObject);
        }
        try {
            ApplicationBinding applicationBinding = (ApplicationBinding)deployedObject.getBinding();
            String string = deployedObject.getName();
            AuthorizationTable authorizationTable = applicationBinding.getAuthorizationTable();
            if (authorizationTable != null) {
                this.removeSubjectsFromDenyAllRole(string, authorizationTable);
                WSAccessManager.addAuthorizationTable(string, authorizationTable);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Authorization Table Not defined for Application " + string));
            }
            RunAsMap runAsMap = applicationBinding.getRunAsMap();
            if (authorizationTable != null) {
                if (runAsMap != null) {
                    RunAsMapTable.addRunAsMap(string, runAsMap);
                    EList eList = runAsMap.getRunAsBindings();
                    if (eList.size() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("RunAsMap Not defined properly for Application " + string));
                        }
                    } else if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Authorization Table and RunAsMap processedfor Application " + string));
                    }
                } else if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Authorization Table processed for Application " + string));
                }
            } else if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Application " + string + " installed without Authorization Table"));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ServerSecurityComponentImpl.install", (String)"292", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.servcomp.init");
            Tr.debug((TraceComponent)tc, (String)"Exception occurred in application install.", (Object)new Object[]{exception});
            throw new RuntimeWarning(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"install");
        }
    }

    private void uninstall(DeployedObject deployedObject) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"uninstall", (Object)deployedObject);
        }
        try {
            String string = deployedObject.getName();
            WSAccessManager.removeAuthorizationTable(string);
            RunAsMapTable.removeRunAsMap(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ServerSecurityComponentImpl.uninstall", (String)"335", (Object)((Object)this));
            throw new RuntimeWarning((Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uninstall");
        }
    }

    protected void removeSubjectsFromDenyAllRole(String string, AuthorizationTable authorizationTable) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeUsersFromDenyAllRole", (Object)string);
        }
        boolean bl = false;
        EList eList = authorizationTable.getAuthorizations();
        for (int i = 0; i < eList.size(); ++i) {
            RoleAssignment roleAssignment = (RoleAssignment)eList.get(i);
            String string2 = roleAssignment.getRole().getRoleName();
            if (string2 != null && string2.equals(DENYALL_ROLE_NAME)) {
                EList eList2;
                EList eList3;
                EList eList4 = roleAssignment.getUsers();
                if (eList4 != null && eList4.size() > 0) {
                    roleAssignment.getUsers().clear();
                    bl = true;
                }
                if ((eList3 = roleAssignment.getGroups()) != null && eList3.size() > 0) {
                    roleAssignment.getGroups().clear();
                    bl = true;
                }
                if ((eList2 = roleAssignment.getSpecialSubjects()) != null && eList2.size() > 0) {
                    roleAssignment.getSpecialSubjects().clear();
                    bl = true;
                }
                if (!bl) break;
                Tr.warning((TraceComponent)tc, (String)"security.servcomp.remove.DenyAllRole", (Object)new Object[]{string});
                break;
            }
            if (string2 != null) continue;
            Tr.debug((TraceComponent)tc, (String)"auth.getRole().getRoleName() returns null, there might be a problem in the descriptors.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeUsersFromDenyAllRole");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAuthDataEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"refreshAuthDataEntries");
        }
        Repository repository = (Repository)this.getService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = ServerSecurityComponentImpl.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository);
        ConfigRoot configRoot = repository.getConfigRoot();
        try {
            Resource resource = null;
            String string = "security.xml";
            try {
                resource = configRoot.getResource(0, string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ServerSecurityComponentImpl.refreshAuthDataEntries", (String)"417", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"security.loadresource.error", (Object)new Object[]{string, exception});
                throw exception;
            }
            Security security = (Security)resource.getContents().get(0);
            if (security == null) {
                throw new SecurityConfigException("Cannot get the Security object. Security.xml may not exist");
            }
            SecurityConfig.getConfig().refreshAuthDataEntries(security);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ServerSecurityComponentImpl.refreshAuthDataEntries", (String)"427", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.servcomp.init");
        }
        finally {
            if (repository != null) {
                this.releaseService(repository);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"refreshAuthDataEntries");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getServerAdminProps(ConfigRoot configRoot, Server server) throws Exception {
        Properties properties;
        block34: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getServerAdminProps");
            }
            String string = null;
            String string2 = null;
            String string3 = null;
            properties = new Properties();
            String string4 = null;
            String string5 = null;
            String string6 = null;
            try {
                String string7;
                Object object;
                Object object2;
                ServerIndex serverIndex;
                String string8;
                Property property;
                Object object3;
                Object object4;
                properties.setProperty("password", (String)SecurityConfig.getConfig().getValue("security.serverPasswd"));
                properties.setProperty("username", (String)SecurityConfig.getConfig().getValue("security.serverId"));
                properties.setProperty("isInternal", "true");
                EList eList = server.getServices();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Number of custom services: " + eList.size()));
                }
                AdminService adminService = null;
                Class clazz = class$com$ibm$websphere$models$config$adminservice$AdminService == null ? (class$com$ibm$websphere$models$config$adminservice$AdminService = ServerSecurityComponentImpl.class$("com.ibm.websphere.models.config.adminservice.AdminService")) : class$com$ibm$websphere$models$config$adminservice$AdminService;
                Object object5 = eList.iterator();
                while (object5.hasNext()) {
                    object4 = object5.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Custom service: " + object4));
                    }
                    if (!clazz.isInstance(object4)) continue;
                    adminService = (AdminService)object4;
                    break;
                }
                if (adminService != null) {
                    Object e;
                    object5 = adminService.getPreferredConnector();
                    if (object5 instanceof SOAPConnector || !(object5 instanceof RMIConnector)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Preferred connector type is SOAP.");
                        }
                        properties.setProperty("type", "SOAP");
                        string4 = "SOAP";
                        object4 = object5.getProperties();
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            e = object3.next();
                            property = (Property)e;
                            if (property.getName().equals("sslConfig")) {
                                string8 = property.getValue();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("SSLConfig alias to use: " + string8));
                                }
                                if (string8 == null) continue;
                                serverIndex = null;
                                try {
                                    serverIndex = (SecurityService)this.getService(class$com$ibm$ws$security$service$SecurityService == null ? ServerSecurityComponentImpl.class$("com.ibm.ws.security.service.SecurityService") : class$com$ibm$ws$security$service$SecurityService);
                                    if (serverIndex == null || (object2 = serverIndex.getSecureSocketLayer(string8)) == null) continue;
                                    Enumeration<?> enumeration = ((Properties)object2).propertyNames();
                                    while (enumeration.hasMoreElements()) {
                                        object = (String)enumeration.nextElement();
                                        string7 = ((Properties)object2).getProperty((String)object);
                                        if (object == null || string7 == null) continue;
                                        properties.setProperty((String)object, string7);
                                    }
                                    continue;
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ServerSecurityComponentImpl.getServerAdminProps", (String)"552", (Object)((Object)this));
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug((TraceComponent)tc, (String)"Exception occurred getting SSLProps.", (Object)new Object[]{exception});
                                    continue;
                                }
                                finally {
                                    if (serverIndex != null) {
                                        this.releaseService(serverIndex);
                                    }
                                    continue;
                                }
                            }
                            properties.setProperty(property.getName(), property.getValue());
                        }
                    } else if (object5 instanceof RMIConnector) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Preferred connector type is RMI.");
                        }
                        properties.setProperty("type", "RMI");
                        string4 = "RMI";
                        object4 = object5.getProperties();
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            e = object3.next();
                            property = (Property)e;
                            properties.setProperty(property.getName(), property.getValue());
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Admin service is null.");
                }
                if (((StringTokenizer)(object4 = new StringTokenizer((String)(object5 = (String)SecurityConfig.getConfig().getValue("process.serverName")), ":"))).countTokens() == 3) {
                    string3 = ((StringTokenizer)object4).nextToken();
                    string2 = ((StringTokenizer)object4).nextToken();
                    string = ((StringTokenizer)object4).nextToken();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("cell:node:server = " + string3 + ":" + string2 + ":" + string));
                    }
                }
                object3 = configRoot.list(3, null);
                block11: for (int i = 0; i < ((String[])object3).length; ++i) {
                    if (!((String)object3[i]).equals(string2)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Node name: " + (String)object3[i]));
                    }
                    property = configRoot.getResource(3, "serverindex.xml");
                    string8 = property.getContents();
                    serverIndex = (ServerIndex)property.getContents().get(0);
                    object2 = serverIndex.getServerEntries();
                    for (int j = 0; j < object2.size(); ++j) {
                        object = (ServerEntry)object2.get(j);
                        if (object == null || !(string7 = object.getServerType()).equals("APPLICATION_SERVER") || !object.getServerName().equals(string)) continue;
                        EndPoint endPoint = null;
                        EndPoint endPoint2 = null;
                        EList eList2 = object.getSpecialEndpoints();
                        for (int k = 0; k < eList2.size(); ++k) {
                            NamedEndPoint namedEndPoint = (NamedEndPoint)eList2.get(k);
                            if (namedEndPoint.getEndPointName().equals("SOAP_CONNECTOR_ADDRESS")) {
                                endPoint = namedEndPoint.getEndPoint();
                            }
                            if (!namedEndPoint.getEndPointName().equals("BOOTSTRAP_ADDRESS") || (endPoint2 = namedEndPoint.getEndPoint()) == null) continue;
                            string6 = new Integer(endPoint2.getPort()).toString();
                            string5 = endPoint2.getHost();
                            properties.setProperty("java.naming.provider.url", "corbaloc:iiop:" + string5 + ":" + string6 + "/" + "WsnAdminNameService");
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("PROVIDER_URL: corbaloc:iiop:" + string5 + ":" + string6));
                        }
                        if (endPoint != null && string4.equals("SOAP")) {
                            properties.setProperty("port", new Integer(endPoint.getPort()).toString());
                            properties.setProperty("host", endPoint.getHost());
                            continue block11;
                        }
                        if (endPoint2 == null || !string4.equals("RMI")) continue block11;
                        properties.setProperty("port", new Integer(endPoint2.getPort()).toString());
                        properties.setProperty("host", endPoint2.getHost());
                        continue block11;
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ServerSecurityComponentImpl.getServerAdminProps", (String)"670", (Object)((Object)this));
                if (!tc.isDebugEnabled()) break block34;
                Tr.debug((TraceComponent)tc, (String)"Exception occurred getting SSLProps.", (Object)new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerAdminProps");
        }
        return properties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

