/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.models.base.bindings.applicationbnd.Group;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.SpecialSubject;
import com.ibm.ejs.models.base.bindings.applicationbnd.Subject;
import com.ibm.ejs.models.base.bindings.applicationbnd.User;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.websphere.security.AuthorizationTable;
import com.ibm.websphere.security.SecurityProviderException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WASPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.AccessContext;
import com.ibm.ws.security.core.AccessException;
import com.ibm.ws.security.core.AccessManager;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.PermissionRoleMap;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.WSPrincipal;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfiguratorFactory;
import com.ibm.ws.security.util.Constants;
import com.ibm.ws.security.util.WCCMHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public abstract class WSAccessManager
implements AccessManager {
    private static Hashtable authzTableMap = new Hashtable(10);
    private static com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable adminAppAuthTable = null;
    public static final String USER = "user";
    public static final String GROUP = "group";
    public static final String ADMINAPP = "Server Administration Application";
    public static final String PLUGGABLE_AUTHZN_PROPERTY = "com.ibm.websphere.security.authorizationTable";
    private AuthorizationTable pluggableAuthTable;
    private String pluggableAuthzTableName;
    private String cellName;
    private String serverName;
    private String serverId;
    private User userSub;
    private Group groupSub;
    private static boolean ignoreCase = false;
    private static boolean isLDAPRegistry = false;
    private static UserRegistry registry;
    private static boolean filledAccessIDs;
    private static ContextManager contextManager;
    private static final TraceComponent tc;
    protected RoleBasedAuthorizer adminAuthorizer;
    protected static final String adminapps_list = "/META-INF/adminapps.list";
    protected Vector adminapps;
    static /* synthetic */ Class class$com$ibm$ws$security$core$WSAccessManager;

    public WSAccessManager() {
        block33: {
            Object object;
            block32: {
                block31: {
                    Boolean bl;
                    this.pluggableAuthTable = null;
                    this.pluggableAuthzTableName = null;
                    this.cellName = null;
                    this.serverName = null;
                    this.serverId = null;
                    this.userSub = null;
                    this.groupSub = null;
                    this.adminAuthorizer = null;
                    this.adminapps = new Vector(2);
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"WSAccessManager<> constructor");
                    }
                    contextManager = ContextManagerFactory.getInstance();
                    this.pluggableAuthzTableName = ContextManagerFactory.getInstance().getProperty(PLUGGABLE_AUTHZN_PROPERTY, null);
                    if (this.pluggableAuthzTableName != null && this.pluggableAuthzTableName.length() != 0) {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(" Loaded Pluggable AuthTable: " + this.pluggableAuthzTableName));
                            }
                            this.pluggableAuthTable = (AuthorizationTable)Class.forName(this.pluggableAuthzTableName).newInstance();
                            Tr.audit((TraceComponent)tc, (String)"security.wsaccessmanager.classloaded", (Object)new Object[]{this.pluggableAuthzTableName});
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(" Loaded AuthTable: " + this.pluggableAuthzTableName));
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.security.core.WSAccessManager.WSAccessManager", (String)"134", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.classnotfound", (Object)new Object[]{this.pluggableAuthzTableName});
                        }
                        catch (InstantiationException instantiationException) {
                            FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.security.core.WSAccessManager.WSAccessManager", (String)"137", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.instantiationerror", (Object)new Object[]{this.pluggableAuthzTableName});
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.WSAccessManager", (String)"141", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.classloading", (Object)new Object[]{this.pluggableAuthzTableName});
                        }
                        if (this.pluggableAuthTable == null) {
                            Tr.audit((TraceComponent)tc, (String)"security.wsaccessmanager.classloadingaudit", (Object)new Object[]{this.pluggableAuthzTableName});
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Pluggable AuthTable was not loaded!");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)" Getting server and cell name");
                    }
                    this.cellName = (String)SecurityConfig.getConfig().getValue("security.activeUserRegistry.realm");
                    this.serverName = (String)SecurityConfig.getConfig().getValue("process.serverName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(" cellName: " + this.cellName + " server Name: " + this.serverName));
                    }
                    if ((bl = (Boolean)SecurityConfig.getConfig().getValue("security.registry.IgnoreCase")) != null && bl.booleanValue()) {
                        ignoreCase = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"ignoreCase is set");
                        }
                    }
                    SecurityConfig.getConfig();
                    if (SecurityConfig.isRegLDAP()) {
                        isLDAPRegistry = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"User registry type is LDAP");
                        }
                    }
                    try {
                        object = ContextManagerFactory.getInstance().getServerCredential();
                        if (object != null) {
                            this.serverId = object.getAccessId();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("serverId is set to: " + this.serverId));
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.core.WSAccessManager.WSAccessManager", (String)"173", (Object)this);
                        if (!tc.isDebugEnabled()) break block31;
                        Tr.debug((TraceComponent)tc, (String)"failed to form serverId");
                    }
                }
                this.groupSub = WCCMHelper.createGroup(GROUP, GROUP);
                this.userSub = WCCMHelper.createUser(USER, USER);
                try {
                    object = RoleBasedConfiguratorFactory.getConfigurator();
                    this.adminAuthorizer = object.getRoleBasedAuthorizer("admin-authz", "domain");
                }
                catch (RoleBasedAppException roleBasedAppException) {
                    FFDCFilter.processException((Throwable)roleBasedAppException, (String)"com.ibm.ws.security.core.WSAccessManager.WSAccessManager", (String)"187", (Object)this);
                    if (!tc.isDebugEnabled()) break block32;
                    Tr.debug((TraceComponent)tc, (String)"failed to initialize RoleBasedAuthorizer");
                }
            }
            try {
                object = this.getClass().getResourceAsStream(adminapps_list);
                if (object != null) {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                    while ((string = bufferedReader.readLine()) != null) {
                        this.adminapps.add(string);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"adminapps.list file not found");
                }
                if (tc.isDebugEnabled() && this.adminapps.size() > 0) {
                    Tr.debug((TraceComponent)tc, (String)("Found " + this.adminapps.size() + " admin applications: " + this.adminapps));
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.core.WSAccessmanager", (String)"201", (Object)this);
                if (!tc.isDebugEnabled()) break block33;
                Tr.debug((TraceComponent)tc, (String)"failed to load list of admin applications");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSAccessManager<> constructor");
        }
    }

    public static void setAccessIdsFilled() {
        filledAccessIDs = true;
    }

    public static com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable getAdminAppAuthorizationTable() {
        return adminAppAuthTable;
    }

    public static Enumeration getAuthorizationTables() {
        return authzTableMap.elements();
    }

    public static void removeAuthorizationTable(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeAuthorizationTable " + string));
        }
        authzTableMap.remove(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAuthorizationTable ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAuthorizationTable(String string, com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable authorizationTable) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addAuthorizationTable " + string));
        }
        Hashtable hashtable = authzTableMap;
        synchronized (hashtable) {
            int n = string.lastIndexOf("_");
            String string2 = null;
            string2 = n != -1 ? string.substring(0, n) : string;
            if (authorizationTable != null) {
                if (string2.equals(ADMINAPP)) {
                    adminAppAuthTable = authorizationTable;
                }
                authzTableMap.put(string, authorizationTable);
                WSAccessManager.fillMissingAccessIds(authorizationTable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addAuthorizationTable ");
        }
    }

    public void checkAccess(AccessContext accessContext, Object object, Object object2, Principal principal) throws AccessException {
        SecurityRole[] securityRoleArray;
        String string = (String)object;
        String string2 = (String)object2;
        javax.security.auth.Subject subject = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkAccess with Principal \n" + ((Object)principal).toString() + "\nresource: " + string + "\nmethodName: " + string2));
        }
        boolean bl = false;
        if (principal != null) {
            subject = ((WSPrincipal)principal).getSubject();
        }
        if (accessContext != null && this.adminapps.size() > 0) {
            for (int i = 0; i < this.adminapps.size(); ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("application name = " + accessContext.getEnterpriseAppName()));
                }
                if (!accessContext.getEnterpriseAppName().equals((String)this.adminapps.get(i))) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"isAdminApp is true");
                }
                bl = true;
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Calling getRequiredRoles<>");
        }
        if ((securityRoleArray = this.getRequiredRoles(accessContext, string, string2)) == null) {
            throw new AccessException("Null required roles");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Check excluded list");
        }
        if (this.isExcluded(accessContext, string, string2)) {
            String string3 = string + ":" + string2 + " is excluded";
            throw new AccessException(string3);
        }
        if (securityRoleArray == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Empty required roles list defined in Authorization Constraints for the web applicaiton in the DD");
            }
            throw new AccessException("Empty required roles list defined in Authorization Constraint");
        }
        if (securityRoleArray == PermissionRoleMap.NO_REQUIRED_ROLES) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"no required roles declared in the DD ");
            }
            if (this.allowIfNoRequiredRoles()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"allowIfNoRequiredRoles<> returned TRUE");
                }
                return;
            }
            throw new AccessException("No required roles defined");
        }
        if (bl) {
            String[] stringArray = new String[securityRoleArray.length];
            for (int i = 0; i < securityRoleArray.length; ++i) {
                stringArray[i] = securityRoleArray[i].getRoleName();
            }
            if (this.adminAuthorizer.isGrantedRole(stringArray, subject)) {
                return;
            }
        } else {
            int n;
            int n2;
            StringBuffer stringBuffer;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling isEveryoneGranted<> ");
            }
            if (this.isEveryoneGranted(accessContext, securityRoleArray)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(string + string2 + " is unprotected"));
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isEveryoneGranted returned FALSE ");
            }
            if (this.isGrantedAnyRole(accessContext, securityRoleArray, subject)) {
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer2 = new StringBuffer(128);
                    int n3 = securityRoleArray.length;
                    for (int i = 0; i < n3; ++i) {
                        stringBuffer2.append(" ").append(securityRoleArray[i].getRoleName()).append(" ");
                    }
                    Tr.debug((TraceComponent)tc, (String)(((Object)principal).toString() + " is granted" + stringBuffer2.toString()));
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isGrantedAnyRole returned FALSE ");
                stringBuffer = new StringBuffer(128);
                n2 = securityRoleArray.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(" ").append(securityRoleArray[n].getRoleName()).append(" ");
                }
                Tr.debug((TraceComponent)tc, (String)(((Object)principal).toString() + " WAS NOT granted" + stringBuffer.toString()));
            }
            stringBuffer = new StringBuffer(128);
            stringBuffer.append(((Object)principal).toString());
            stringBuffer.append(" is not granted any of the required roles: ");
            n2 = securityRoleArray.length;
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(securityRoleArray[n].getRoleName()).append(" ");
            }
            String string4 = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)string4);
            }
            throw new AccessException(string4);
        }
    }

    public boolean isGrantedRole(AccessContext accessContext, SecurityRole securityRole, Principal principal) {
        javax.security.auth.Subject subject = null;
        if (principal != null) {
            subject = ((WSPrincipal)principal).getSubject();
        }
        boolean bl = false;
        if (this.adminapps.size() > 0) {
            for (int i = 0; i < this.adminapps.size(); ++i) {
                if (!accessContext.getEnterpriseAppName().equals((String)this.adminapps.get(i))) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"isAdminApp is true");
                }
                bl = true;
                break;
            }
        }
        if (bl) {
            String[] stringArray = new String[]{securityRole.getRoleName()};
            return this.adminAuthorizer.isGrantedRole(stringArray, subject);
        }
        return this.isGrantedRole(accessContext, (com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable)authzTableMap.get(accessContext.getEnterpriseAppName()), securityRole, subject);
    }

    public abstract SecurityRole[] getRequiredRoles(AccessContext var1, String var2, String var3);

    public abstract boolean allowIfNoRequiredRoles();

    public abstract boolean isExcluded(AccessContext var1, String var2, String var3);

    protected boolean isGrantedRole(AccessContext accessContext, com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable authorizationTable, SecurityRole securityRole, javax.security.auth.Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGrantedRole");
        }
        if (this.pluggableAuthTable != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using vendor supplied authorizer");
            }
            HashMap hashMap = this.createAccessContext(accessContext);
            String string = securityRole.getRoleName();
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Calling createPrincipal");
                }
                com.ibm.websphere.security.auth.WSPrincipal wSPrincipal = null;
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((javax.security.auth.Subject)subject);
                wSPrincipal = ContextManagerFactory.getInstance().createPrincipal(wSCredential);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WSPrincipal created");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Calling Vendor Supplied Authorizerrole = " + string + " Principal = " + wSPrincipal.toString()));
                }
                return this.pluggableAuthTable.isGrantedRole(hashMap, string, (Principal)wSPrincipal);
            }
            catch (SecurityProviderException securityProviderException) {
                FFDCFilter.processException((Throwable)securityProviderException, (String)"com.ibm.ws.security.core.WSAccessManager.isGrantedRole", (String)"400", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableError", (Object)new Object[]{securityProviderException});
                Exception exception = securityProviderException.getException();
                if (exception != null) {
                    Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableSpecificError", (Object)new Object[]{exception});
                }
                return false;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.isGrantedRole", (String)"416", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableGenericError");
                return false;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"A pluggable Table was NOT found");
        }
        if (authorizationTable == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isGrantedRole, null authorization table, exit value: false");
            }
            return false;
        }
        SecurityRole[] securityRoleArray = new SecurityRole[]{securityRole};
        if (this.isEveryoneGranted(accessContext, securityRoleArray)) {
            return true;
        }
        if (this.isGrantedAnyRole(accessContext, securityRoleArray, subject)) {
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"No role or group role found, exit value:false");
        }
        return false;
    }

    public boolean isEveryoneGranted(AccessContext accessContext, SecurityRole[] securityRoleArray) {
        com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable authorizationTable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isEveryoneGranted");
        }
        if (securityRoleArray == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Empty required roles list defined in Authorization Constraints for the web applicaiton in the DD");
            }
            return false;
        }
        if (this.pluggableAuthTable != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using vendor supplied authorizer");
            }
            HashMap hashMap = this.createAccessContext(accessContext);
            String[] stringArray = null;
            if (securityRoleArray != null) {
                stringArray = new String[securityRoleArray.length];
                for (int i = 0; i < securityRoleArray.length; ++i) {
                    stringArray[i] = securityRoleArray[i].getRoleName();
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    if (stringArray == null) {
                        Tr.debug((TraceComponent)tc, (String)"roles list is NULL ");
                    }
                    if (stringArray.length == 0) {
                        Tr.debug((TraceComponent)tc, (String)"roles list length is 0 ");
                    }
                    StringBuffer stringBuffer = new StringBuffer(128);
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer.append(" ").append(stringArray[i]);
                    }
                    Tr.debug((TraceComponent)tc, (String)("Calling Vendor Supplied Authorizer roles are = " + stringBuffer));
                }
                return this.pluggableAuthTable.isEveryoneGranted(hashMap, stringArray);
            }
            catch (SecurityProviderException securityProviderException) {
                FFDCFilter.processException((Throwable)securityProviderException, (String)"com.ibm.ws.security.core.WSAccessManager.isEveryoneGranted", (String)"540", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableError", (Object)new Object[]{securityProviderException});
                Exception exception = securityProviderException.getException();
                if (exception != null) {
                    Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableSpecificError", (Object)new Object[]{securityProviderException});
                }
                return false;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.isEveryoneGranted", (String)"557", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableGenericError");
                return false;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"A pluggable Table was NOT found");
        }
        if ((authorizationTable = (com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable)authzTableMap.get(accessContext.getEnterpriseAppName())) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isGrantedRole, null authorization table, exit value: false");
            }
            return false;
        }
        List list = authorizationTable.getRolesForSubject((Subject)Constants.EVERYONE);
        if (list != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"grantedRoles is NOT Null. Checking for matching roles");
            }
            int n = securityRoleArray.length;
            for (int i = 0; i < n; ++i) {
                if (!list.contains(securityRoleArray[i])) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"isGrantedRole, EVERYONE granted access, exit value:true");
                }
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No matching roles were found in grantedRoles");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"NULL grantedRoles List with Everyone");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"No roles granted to the special subject, Everyone");
        }
        return false;
    }

    private boolean isServerId(String string) {
        if (string == null) {
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isServerId? " + string.equalsIgnoreCase(this.serverId)));
        }
        return string.equalsIgnoreCase(this.serverId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGrantedAnyRole(AccessContext accessContext, SecurityRole[] securityRoleArray, javax.security.auth.Subject subject) {
        int n;
        String[] stringArray;
        String string;
        List list;
        com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable authorizationTable;
        block85: {
            int n2;
            javax.security.auth.Subject subject2;
            block84: {
                int n3;
                Object object;
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"isGrantedAnyRole");
                }
                boolean bl = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Required Roles list length: " + securityRoleArray.length));
                    String[] stringArray2 = null;
                    if (securityRoleArray != null) {
                        stringArray2 = new String[securityRoleArray.length];
                        for (int i = 0; i < securityRoleArray.length; ++i) {
                            stringArray2[i] = securityRoleArray[i].getRoleName();
                        }
                    }
                    Tr.debug((TraceComponent)tc, (String)("Roles list length: " + stringArray2.length));
                    object = new StringBuffer(128);
                    for (n3 = 0; n3 < stringArray2.length; ++n3) {
                        ((StringBuffer)object).append(" ").append(stringArray2[n3]);
                    }
                    Tr.debug((TraceComponent)tc, (String)("Required Roles are = " + object));
                }
                if (securityRoleArray == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Empty required roles list defined in Authorization Constraints for the web applicaiton in the DD");
                    }
                    return false;
                }
                if (accessContext != null && this.adminapps.size() > 0) {
                    for (int i = 0; i < this.adminapps.size(); ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("application name = " + accessContext.getEnterpriseAppName()));
                        }
                        if (!accessContext.getEnterpriseAppName().equals((String)this.adminapps.get(i))) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"isAdminApp is true");
                        }
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    String[] stringArray3 = new String[securityRoleArray.length];
                    for (int i = 0; i < securityRoleArray.length; ++i) {
                        stringArray3[i] = securityRoleArray[i].getRoleName();
                    }
                    return this.adminAuthorizer.isGrantedRole(stringArray3, subject);
                }
                if (this.pluggableAuthTable != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Using vendor supplied authorizer");
                    }
                    HashMap hashMap = this.createAccessContext(accessContext);
                    object = null;
                    if (securityRoleArray != null) {
                        object = new String[securityRoleArray.length];
                        for (n3 = 0; n3 < securityRoleArray.length; ++n3) {
                            object[n3] = securityRoleArray[n3].getRoleName();
                        }
                    }
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Calling createPrincipal");
                        }
                        com.ibm.websphere.security.auth.WSPrincipal wSPrincipal = null;
                        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((javax.security.auth.Subject)subject);
                        wSPrincipal = ContextManagerFactory.getInstance().createPrincipal(wSCredential);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"WSPrincipal created");
                            if (object == null) {
                                Tr.debug((TraceComponent)tc, (String)"roles list is NULL ");
                            }
                            if (((Object)object).length == 0) {
                                Tr.debug((TraceComponent)tc, (String)"roles list length is 0 ");
                            }
                            StringBuffer stringBuffer = new StringBuffer(128);
                            for (int i = 0; i < ((Object)object).length; ++i) {
                                stringBuffer.append(" ").append((String)object[i]);
                            }
                            Tr.debug((TraceComponent)tc, (String)("Calling Vendor Supplied Authorizer, roles are = " + stringBuffer + " Principal = " + wSPrincipal.toString()));
                        }
                        return this.pluggableAuthTable.isGrantedAnyRole(hashMap, (String[])object, (Principal)wSPrincipal);
                    }
                    catch (SecurityProviderException securityProviderException) {
                        FFDCFilter.processException((Throwable)securityProviderException, (String)"com.ibm.ws.security.core.WSAccessManager.isGrantedAnyRole", (String)"631", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableError", (Object)new Object[]{securityProviderException});
                        Exception exception = securityProviderException.getException();
                        if (exception != null) {
                            Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableSpecificError", (Object)new Object[]{securityProviderException});
                        }
                        return false;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.isGrantedAnyRole", (String)"647", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableGenericError");
                        return false;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"A pluggable Table was NOT found");
                }
                if ((authorizationTable = (com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable)authzTableMap.get(accessContext.getEnterpriseAppName())) == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"isGrantedAnyRole, null authorization table, exit value: false");
                    }
                    return false;
                }
                object = SubjectHelper.getWSCredentialFromSubject((javax.security.auth.Subject)subject);
                if (subject == null || object.isUnauthenticated()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"isGrantedRole, rSubject is null or rSubject is Unauthenticated, exit value:false");
                    }
                    return false;
                }
                subject2 = null;
                try {
                    subject2 = object.isBasicAuth() ? contextManager.login((WSCredential)object) : subject;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.isGrantedAnyRole", (String)"673", (Object)this);
                    subject2 = null;
                    if (!tc.isDebugEnabled()) break block84;
                    Tr.debug((TraceComponent)tc, (String)("authentication failed:" + exception));
                }
            }
            if (subject2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"isGrantedAnyRole, getActualCredential() thru an exception, exit value:false");
                }
                return false;
            }
            list = authorizationTable.getRolesForSubject((Subject)Constants.ALL_AUTHENTICATED_USERS);
            if (list != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"granted Roles from ALL_AUTHENTICATED_USERS:");
                }
                int n4 = securityRoleArray.length;
                for (int i = 0; i < n4; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Role<" + i + ">: " + securityRoleArray[i]));
                    }
                    if (!list.contains(securityRoleArray[i])) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"isGrantedAnyRole granted access to authenticated user, exit value:true");
                    }
                    return true;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"NULL grantedRoles from ALL_AUTHENTICATED_USERS");
            }
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((javax.security.auth.Subject)subject2);
            string = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting the accessID");
                }
                string = this.getAccessId(wSCredential);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("accessID: " + string));
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.core.WSAccessManager.isGrantedAnyRole", (String)"804", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getAccessId throw an exception:" + generalSecurityException));
                }
                string = "???";
            }
            if (this.isServerId(string)) {
                list = authorizationTable.getRolesForSubject((Subject)Constants.SERVER);
                if (list != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("grantedRoles for Server is " + list));
                    }
                    n2 = securityRoleArray.length;
                    for (int i = 0; i < n2; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Role<" + i + ">: " + securityRoleArray[i]));
                        }
                        if (!list.contains(securityRoleArray[i])) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"isGrantedAnyRole granted access to server, exit value:true");
                        }
                        return true;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"NULL grantedRoles for server");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The accessId is not a ServerId");
            }
            User user = this.userSub;
            synchronized (user) {
                this.userSub.setAccessId(string);
                this.userSub.setName(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Calling getRolesForSubject with: " + this.userSub.toString()));
                }
                list = authorizationTable.getRolesForSubject((Subject)this.userSub);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" grantedRoles: " + list));
                }
            }
            if (list != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"grantedRoles for userSub is NOT null");
                }
                n2 = securityRoleArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Role<" + i + ">: " + securityRoleArray[i]));
                    }
                    if (!list.contains(securityRoleArray[i])) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"isGrantedAnyRole granted access, exit value:true");
                    }
                    return true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No grantedRoles were found in the reqRoles List");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"NULL grantedRoles for userSub");
                Tr.debug((TraceComponent)tc, (String)("Roles found for userSub: " + this.userSub));
                n2 = securityRoleArray.length;
                for (int i = 0; i < n2; ++i) {
                    Tr.debug((TraceComponent)tc, (String)("Role<" + i + ">: " + securityRoleArray[i]));
                }
            }
            list = null;
            stringArray = null;
            try {
                stringArray = this.getGroupIds(wSCredential);
            }
            catch (GeneralSecurityException generalSecurityException) {
                FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.core.WSAccessManager.isGrantedAnyRole", (String)"864", (Object)this);
                if (!tc.isDebugEnabled()) break block85;
                Tr.debug((TraceComponent)tc, (String)("getGroupId throw an exception:" + generalSecurityException));
            }
        }
        int n5 = n = stringArray == null ? 0 : stringArray.length;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Length of groupIds is: " + n));
        }
        for (int i = 0; i < n; ++i) {
            Group group = this.groupSub;
            synchronized (group) {
                this.groupSub.setAccessId(stringArray[i]);
                this.groupSub.setName(stringArray[i]);
                list = authorizationTable.getRolesForSubject((Subject)this.groupSub);
            }
            if (list != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"grantedRoles for groupSub is NOT null");
                }
                int n6 = securityRoleArray.length;
                for (int j = 0; j < n6; ++j) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Role<" + j + ">: " + securityRoleArray[j]));
                    }
                    if (!list.contains(securityRoleArray[j])) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("Group subjects.contains() accessId[" + string + "], exit value:true"));
                    }
                    return true;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"No grantedRoles for groupSub were found in reqRoles List");
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"NULL grantedRoles for groupSub ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isGrantedAnyRole:No role or group role found for accessId[" + string + "], exit value:false"));
        }
        return false;
    }

    protected static synchronized void fillAccessIds() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fillAccessIds");
        }
        Collection collection = authzTableMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable authorizationTable = (com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable)iterator.next();
            WSAccessManager.fillMissingAccessIds(authorizationTable);
        }
        filledAccessIDs = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fillAccessIds");
        }
    }

    protected static void fillMissingAccessIds(com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable authorizationTable) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("fillMissingAccessIds " + authorizationTable));
        }
        try {
            if (registry == null) {
                if (contextManager == null) {
                    return;
                }
                registry = contextManager.getRegistry(contextManager.getDefaultRealm());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.fillMissingAccessIds", (String)"790");
            Tr.error((TraceComponent)tc, (String)"security.wsaccessmanage.get.reg", (Object)new Object[]{exception});
        }
        Iterator iterator = authorizationTable.getAuthorizations().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Object object;
            RoleAssignment roleAssignment = (RoleAssignment)iterator.next();
            EList eList = roleAssignment.getSpecialSubjects();
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                object = (SpecialSubject)eList.get(i);
                string2 = object.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SpecialSubject " + string2));
                }
                if ((string = object.getAccessId()) != null && string.length() != 0) continue;
                object.setAccessId(string2);
            }
            Iterator iterator2 = roleAssignment.getUsers().iterator();
            while (iterator2.hasNext()) {
                object = (User)iterator2.next();
                string2 = object.getAccessId();
                if (string2 != null && isLDAPRegistry) {
                    string2 = RegistryUtil.removeDNSpace(string2, -1);
                }
                if (string2 == null || string2.length() == 0) {
                    try {
                        string2 = registry.getUniqueUserId(object.getName());
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.fillMissingAccessIds", (String)"807");
                    }
                }
                if (string2 != null && ignoreCase) {
                    string2 = string2.toLowerCase();
                }
                if (string2 != null && string2.length() > 0) {
                    object.setAccessId(string2);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("user accessId=" + string2));
            }
            object = roleAssignment.getGroups().iterator();
            while (object.hasNext()) {
                string2 = (Group)object.next();
                string = string2.getAccessId();
                if (string != null && isLDAPRegistry) {
                    string = RegistryUtil.removeDNSpace(string, -1);
                }
                if (string == null || string.length() == 0) {
                    try {
                        string = registry.getUniqueGroupId(string2.getName());
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.fillMissingAccessIds", (String)"825");
                    }
                }
                if (string != null && ignoreCase) {
                    string = string.toLowerCase();
                }
                if (string != null && string.length() > 0) {
                    string2.setAccessId(string);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("group accessId=" + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fillMissingAccessIds");
        }
    }

    private String getAccessId(WSCredential wSCredential) throws GeneralSecurityException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAccessId");
        }
        if ((string = wSCredential.getAccessId()) != null && string.length() > 0 && ignoreCase) {
            string = string.toLowerCase();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAccessId returns ID: " + string));
        }
        return string;
    }

    private String[] getGroupIds(WSCredential wSCredential) throws GeneralSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupsIds");
        }
        ArrayList arrayList = wSCredential.getGroupIds();
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        if (ignoreCase) {
            int n;
            int n2 = n = stringArray == null ? 0 : stringArray.length;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("groupIds length: " + n));
            }
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringArray[i].toLowerCase();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("groupId<" + i + ">: " + stringArray[i]));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupsIds");
        }
        return stringArray;
    }

    private HashMap createAccessContext(AccessContext accessContext) {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createAccessContext");
        }
        hashMap.put("APPLICATION_NAME", accessContext.getEnterpriseAppName());
        hashMap.put("SERVER_NAME", this.serverName);
        hashMap.put("CELL_NAME", this.cellName);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createAccessContext with: \n  AppName: " + accessContext.getEnterpriseAppName() + "\n  ServerName: " + this.serverName + "\n  CellName: " + this.cellName));
        }
        return hashMap;
    }

    private WASPrincipal createWASPrincipal(javax.security.auth.Subject subject) throws GeneralSecurityException {
        WSCredential wSCredential;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"createWASPrincipal");
            }
            if ((wSCredential = SubjectHelper.getWSCredentialFromSubject((javax.security.auth.Subject)subject)) == null || wSCredential.isUnauthenticated()) {
                return new WASPrincipal(ContextManagerFactory.getInstance().getUnauthenticatedString(), null, null);
            }
            try {
                if (wSCredential.isBasicAuth()) {
                    subject = contextManager.login(wSCredential);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.createWASPrincipal", (String)"947", (Object)this);
                subject = null;
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug((TraceComponent)tc, (String)("getActualCredential() threw an exception:" + exception));
            }
        }
        if (subject == null) {
            return new WASPrincipal(ContextManagerFactory.getInstance().getUnauthenticatedString(), null, null);
        }
        wSCredential = SubjectHelper.getWSCredentialFromSubject((javax.security.auth.Subject)subject);
        List<String> list = null;
        String string = wSCredential.getRealmSecurityName();
        String string2 = wSCredential.getAccessId();
        ArrayList arrayList = wSCredential.getGroupIds();
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        String string3 = "user:";
        String string4 = "group:";
        if (string2.startsWith(string3)) {
            string2 = string2.substring(string3.length());
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(string4)) continue;
                stringArray[i] = stringArray[i].substring(string4.length());
            }
            list = Arrays.asList(stringArray);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("creating WASPrincipal for " + string + " userId = " + string2 + " groupIds = " + stringArray));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createWASPrincipal");
        }
        return new WASPrincipal(string, string2, list);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        filledAccessIDs = false;
        contextManager = null;
        tc = Tr.register((Class)(class$com$ibm$ws$security$core$WSAccessManager == null ? (class$com$ibm$ws$security$core$WSAccessManager = WSAccessManager.class$("com.ibm.ws.security.core.WSAccessManager")) : class$com$ibm$ws$security$core$WSAccessManager), null, (String)"com.ibm.ejs.resources.security");
    }
}

