/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistry;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.UserIdCheckFailedException;
import com.ibm.ws.security.registry.UserRegistryLocalCred;
import com.ibm.ws.security.registry.ldap.LdapRegistryImpl;
import com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl;
import com.ibm.ws.security.registry.zOS.SAFRegistryImpl;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.util.AccessController;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;

public class UserRegistryImpl
extends PortableRemoteObject
implements UserRegistry {
    public static ContextManager ctxMgr = ContextManagerFactory.getInstance();
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$registry$UserRegistryImpl == null ? (class$com$ibm$ws$security$registry$UserRegistryImpl = UserRegistryImpl.class$("com.ibm.ws.security.registry.UserRegistryImpl")) : class$com$ibm$ws$security$registry$UserRegistryImpl), null, (String)"com.ibm.ejs.resources.security");
    private static String CUSTOM_PREFIX = "Custom_";
    private static String CUSTOM_REALM = "customRealm";
    private UserRegistry custImpl;
    private static CustomRegistry oldCustImpl;
    private String realm = null;
    public static final String NONE = "";
    public static final String USERTYPE = "user";
    public static final String GROUPTYPE = "group";
    public static final String ROLETYPE = "role";
    protected static final String nullString;
    protected static final String[] nullStringArray;
    protected static final byte[] nullByteArray;
    protected static final String realmSeparator = "/";
    public static final String typeSeparator = ":";
    private static RoleBasedAuthorizer authorizer;
    private static boolean newCustomReg;
    private boolean isLDAP = false;
    private boolean isWindows = false;
    private boolean isLocalOrDomain = false;
    private String useDisplayName = null;
    private Properties supportedRegistries = new Properties();
    static /* synthetic */ Class class$com$ibm$ws$security$registry$UserRegistryImpl;

    public void initialize(Properties properties) throws CustomRegistryException, RemoteException {
        Object object;
        String string;
        block41: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initialize");
            }
            string = null;
            Object var3_3 = null;
            Properties properties2 = new Properties();
            if (properties != null && (string = (String)properties.get("CustUserRegImplClass")) != null && string.equals("com.ibm.ws.security.registry.ldap.LdapRegistryImpl") && (object = (String)properties.get("com.ibm.websphere.security.registry.UseTAM")) != null && ((String)object).equalsIgnoreCase("true")) {
                string = "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"using TAM LDAP implementation");
                }
            }
            if (string == null) {
                try {
                    this.supportedRegistries.load(((Object)((Object)this)).getClass().getResourceAsStream("wsregistries.properties"));
                }
                catch (Exception exception) {
                    Tr.error((TraceComponent)tc, (String)"security.registry.loadproperr", (Object)new Object[]{exception});
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.initialize", (String)"118", (Object)((Object)this));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Cannot load wsregistries.properties");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"initialize", (Object)exception);
                    }
                    throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
                }
                object = System.getProperty("os.name");
                if (((String)object).startsWith("Windows")) {
                    object = "Windows";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("type = " + (String)object));
                }
                string = this.supportedRegistries.getProperty((String)object);
            }
            if (string == null) {
                Tr.error((TraceComponent)tc, (String)"security.registry.noclassname");
                throw new CustomRegistryException("CustomUserRegistryImplementation Class name is null");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CustomUserRegistryImplementation file is = " + string));
            }
            try {
                object = Class.forName(string);
                Object obj = ((Class)object).newInstance();
                if (obj instanceof UserRegistry) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Instantiating new CustomRegistry: " + string));
                    }
                    newCustomReg = true;
                    this.custImpl = (UserRegistry)obj;
                    if (properties != null) {
                        this.useDisplayName = (String)properties.get("WAS_UseDisplayName");
                    }
                    if (obj instanceof LdapRegistryImpl) {
                        this.isLDAP = true;
                    } else if (!ctxMgr.getPlatformHelper().isZOS() && obj instanceof NTLocalDomainRegistryImpl) {
                        this.isWindows = true;
                        String string2 = properties.getProperty("com.ibm.websphere.registry.UseRegistry");
                        if (string2 != null && (string2.equalsIgnoreCase("Domain") || string2.equalsIgnoreCase("Local"))) {
                            this.isLocalOrDomain = true;
                        }
                    }
                    break block41;
                }
                if (obj instanceof CustomRegistry) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Instantiating old CustomRegistry: " + string));
                    }
                    newCustomReg = false;
                    oldCustImpl = (CustomRegistry)obj;
                    if (properties != null) {
                        this.useDisplayName = (String)properties.get("WAS_UseDisplayName");
                    }
                    break block41;
                }
                Tr.error((TraceComponent)tc, (String)"security.registry.unsupportedclass", (Object)new Object[]{string});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initialize");
                }
                throw new CustomRegistryException("The implementation file for the custom registry: " + string + " is not supported");
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.registry.UserRegistryImpl.initialize", (String)"154", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"security.registry.loadclass", (Object)new Object[]{string, throwable});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initialize", (Object)throwable);
                }
                throw new CustomRegistryException(throwable.getMessage(), throwable);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("instance exists " + string));
        }
        try {
            if (newCustomReg) {
                this.custImpl.initialize(properties);
                this.realm = this.custImpl.getRealm();
            } else {
                oldCustImpl.initialize(properties);
                this.realm = oldCustImpl.getRealm();
            }
            if (this.realm == null || this.realm.length() == 0) {
                this.realm = CUSTOM_REALM;
            }
        }
        catch (CustomRegistryException customRegistryException) {
            Tr.error((TraceComponent)tc, (String)"security.registry.initerr", (Object)new Object[]{string, customRegistryException});
            FFDCFilter.processException((Throwable)customRegistryException, (String)"com.ibm.ws.security.registry.UserRegistryImpl.initialize", (String)"173", (Object)((Object)this));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initialize", (Object)((Object)customRegistryException));
            }
            throw customRegistryException;
        }
        if (ctxMgr.getPlatformHelper().isControlJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"initialize: in control region, register with JNDI");
            }
            try {
                object = (Stub)PortableRemoteObject.toStub((Remote)((Object)this));
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)("Exception " + exception.toString() + " occurred creating UserRegistry stub"));
            }
            try {
                object = new InitialContext();
                ((InitialContext)object).rebind("UserRegistry", (Object)this);
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)("Exception " + exception.toString() + " occurred registering the UserRegistry in the Name Space"));
                throw new CustomRegistryException(exception.getMessage());
            }
        }
        Tr.audit((TraceComponent)tc, (String)"security.custom.registry.initialized", (Object)new Object[]{string});
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("realm is " + this.realm));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public String checkPassword(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkPassword");
        }
        String string3 = null;
        string3 = newCustomReg ? this.custImpl.checkPassword(string, string2) : oldCustImpl.checkPassword(string, string2);
        if (string3 == null || string3.trim().length() <= 0) {
            Tr.error((TraceComponent)tc, (String)"security.registry.checkpass.failed", (Object)new Object[]{string});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkPassword");
            }
            throw new PasswordCheckFailedException("checkPassword for: " + string + " failed to return a user: " + string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("user " + string3 + " password checks ok"));
        }
        return string3;
    }

    public UserRegistryLocalCred checkPWGetOSCred(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkPWGetOSCred");
        }
        String string3 = null;
        UserRegistryLocalCred userRegistryLocalCred = null;
        if (newCustomReg) {
            if (this.custImpl instanceof SAFRegistryImpl) {
                userRegistryLocalCred = ((SAFRegistryImpl)this.custImpl).checkPWGetOSCred(string, string2);
                string3 = userRegistryLocalCred.getUserID();
            } else {
                string3 = this.custImpl.checkPassword(string, string2);
                userRegistryLocalCred = new UserRegistryLocalCred(string3, null);
            }
        } else {
            string3 = oldCustImpl.checkPassword(string, string2);
            userRegistryLocalCred = new UserRegistryLocalCred(string3, null);
        }
        if (string3 == null || string3.trim().length() <= 0) {
            Tr.error((TraceComponent)tc, (String)"security.registry.checkpass.failed", (Object)new Object[]{string});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkPWGetOSCred");
            }
            throw new PasswordCheckFailedException("checkPWGetOSCred for: " + string + " failed to return a user: " + string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("user " + string3 + " password checks ok"));
        }
        return userRegistryLocalCred;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UserRegistryLocalCred getOSCred(String string) throws UserIdCheckFailedException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOSCred");
        }
        String string2 = null;
        UserRegistryLocalCred userRegistryLocalCred = null;
        if (!newCustomReg) throw new UserIdCheckFailedException("getOSCred Unable to validate unauthenticated user with old custom registry");
        if (!(this.custImpl instanceof SAFRegistryImpl)) throw new UserIdCheckFailedException("getOSCred Unable to validate unauthenticated user with new custom registry");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getOSCred Validating unauthenticated userId" + string + "with SAF"));
        }
        userRegistryLocalCred = ((SAFRegistryImpl)this.custImpl).getOSCred(string);
        string2 = userRegistryLocalCred.getUserID();
        if (string2 == null || string2.trim().length() <= 0) {
            Tr.error((TraceComponent)tc, (String)"security.registry.check.failed", (Object)new Object[]{string});
            if (!tc.isEntryEnabled()) throw new UserIdCheckFailedException("getOSCred for: " + string + " failed to return a credential for user: " + string2);
            Tr.exit((TraceComponent)tc, (String)"getOSCred");
            throw new UserIdCheckFailedException("getOSCred for: " + string + " failed to return a credential for user: " + string2);
        }
        if (!tc.isDebugEnabled()) return userRegistryLocalCred;
        Tr.debug((TraceComponent)tc, (String)("user " + string2 + " checks ok"));
        return userRegistryLocalCred;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UserRegistryLocalCred getDefaultOSCred(String string) throws UserIdCheckFailedException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultOSCred");
        }
        String string2 = null;
        UserRegistryLocalCred userRegistryLocalCred = null;
        if (!newCustomReg) throw new UserIdCheckFailedException("getDefaultOSCred Unable to validate unauthenticated user with old custom registry");
        if (!(this.custImpl instanceof SAFRegistryImpl)) throw new UserIdCheckFailedException("getDefaultOSCred Unable to validate unauthenticated user with new custom registry");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getDefaultOSCred Validating unauthenticated userId " + string + " with SAF"));
        }
        userRegistryLocalCred = ((SAFRegistryImpl)this.custImpl).getDefaultOSCred(string);
        string2 = userRegistryLocalCred.getUserID();
        if (string2 == null || string2.trim().length() <= 0) {
            Tr.error((TraceComponent)tc, (String)"security.registry.check.failed", (Object)new Object[]{string});
            if (!tc.isEntryEnabled()) throw new UserIdCheckFailedException("getDefaultOSCred for: " + string + " failed to return a credential for user: " + string2);
            Tr.exit((TraceComponent)tc, (String)"getDefaultOSCred");
            throw new UserIdCheckFailedException("getDefaultOSCred for: " + string + " failed to return a credential for user: " + string2);
        }
        if (!tc.isEntryEnabled()) return userRegistryLocalCred;
        Tr.exit((TraceComponent)tc, (String)("getDefaultOSCred - user " + string2 + " checks ok"));
        return userRegistryLocalCred;
    }

    public String mapCertificate(X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapCertificate");
        }
        if (authorizer != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"perform checkAccess");
            }
            if (!authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "mapCertificate")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"checkAccess failed");
                }
                return null;
            }
        }
        String string = null;
        if (newCustomReg) {
            string = this.custImpl.mapCertificate(x509CertificateArray);
        } else {
            X509Certificate x509Certificate = x509CertificateArray[0];
            string = oldCustImpl.mapCertificate(x509Certificate);
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"mapCertificate");
            }
            Tr.error((TraceComponent)tc, (String)"security.registry.mapcertfail");
            throw new CertificateMapFailedException("could not map the certificate to a user");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapCertificate", (Object)string);
        }
        return string;
    }

    public Result getUsers(String string, int n) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsers", (Object)string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUsers")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed");
                try {
                    throw new Exception("debugging RoleBasedAuthorization");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.getUsers", (String)"323", (Object)((Object)this));
                    exception.printStackTrace();
                }
            }
            return null;
        }
        List list = null;
        Result result = null;
        if (newCustomReg) {
            result = this.custImpl.getUsers(string, n);
        } else {
            list = oldCustImpl.getUsers(string);
            result = new Result();
            result.setList(list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)String.valueOf(result.getList().size()));
        }
        return result;
    }

    public String getUserDisplayName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserDisplayName", (Object)string);
        }
        String string2 = null;
        string2 = newCustomReg ? this.custImpl.getUserDisplayName(string) : oldCustImpl.getUserDisplayName(string);
        if (string2 == null) {
            string2 = NONE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserDisplayName", (Object)string2);
        }
        return string2;
    }

    public String getUniqueUserId(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueUserId", (Object)string);
        }
        String string2 = null;
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUniqueUserId")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed");
                try {
                    throw new Exception("debugging RoleBasedAuthorization");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.getUniqueUserId", (String)"454", (Object)((Object)this));
                    exception.printStackTrace();
                }
            }
            return null;
        }
        string2 = newCustomReg ? RegistryUtil.appendRealm(USERTYPE, this.custImpl.getUniqueUserId(string), this.realm) : RegistryUtil.appendRealm(USERTYPE, oldCustImpl.getUniqueUserId(string), this.realm);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueUserId", (Object)string2);
        }
        return string2;
    }

    public String getUserSecurityName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserSecurityName", (Object)string);
        }
        String string2 = NONE;
        string2 = newCustomReg ? this.custImpl.getUserSecurityName(string) : oldCustImpl.getUserSecurityName(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserSecurityName", (Object)string2);
        }
        return string2;
    }

    public boolean isValidUser(String string) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValidUser", (Object)string);
        }
        boolean bl = false;
        bl = newCustomReg ? this.custImpl.isValidUser(string) : oldCustImpl.isValidUser(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isValidUser", (Object)String.valueOf(bl));
        }
        return bl;
    }

    public Result getGroups(String string, int n) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroups", (Object)string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getGroups")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed");
                try {
                    throw new Exception("debugging RoleBasedAuthorization");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.getGroups", (String)"578", (Object)((Object)this));
                    exception.printStackTrace();
                }
            }
            return null;
        }
        List list = null;
        Result result = null;
        if (newCustomReg) {
            result = this.custImpl.getGroups(string, n);
        } else {
            list = oldCustImpl.getGroups(string);
            result = new Result();
            result.setList(list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)String.valueOf(result.getList().size()));
        }
        return result;
    }

    public String getGroupDisplayName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupDisplayName", (Object)string);
        }
        String string2 = null;
        string2 = newCustomReg ? this.custImpl.getGroupDisplayName(string) : oldCustImpl.getGroupDisplayName(string);
        if (string2 == null) {
            string2 = NONE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupDisplayName", (Object)string2);
        }
        return string2;
    }

    public String getUniqueGroupId(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueGroupId", (Object)string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUniqueGroupId")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed");
                try {
                    throw new Exception("debugging RoleBasedAuthorization");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.getUniqueGroupId", (String)"711", (Object)((Object)this));
                    exception.printStackTrace();
                }
            }
            return null;
        }
        String string2 = null;
        string2 = newCustomReg ? RegistryUtil.appendRealm(GROUPTYPE, this.custImpl.getUniqueGroupId(string), this.realm) : RegistryUtil.appendRealm(GROUPTYPE, oldCustImpl.getUniqueGroupId(string), this.realm);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueGroupId", (Object)string2);
        }
        return string2;
    }

    public String getGroupSecurityName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupSecurityName", (Object)string);
        }
        String string2 = NONE;
        string2 = newCustomReg ? this.custImpl.getGroupSecurityName(string) : oldCustImpl.getGroupSecurityName(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupSecurityName", (Object)string2);
        }
        return string2;
    }

    public boolean isValidGroup(String string) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValidGroup", (Object)string);
        }
        boolean bl = false;
        bl = newCustomReg ? this.custImpl.isValidGroup(string) : oldCustImpl.isValidGroup(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isValidGroup", (Object)String.valueOf(bl));
        }
        return bl;
    }

    public List getGroupsForUser(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupsForUser", (Object)string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getGroupsForGroup")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed");
                try {
                    throw new Exception("debugging RoleBasedAuthorization");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.getGroupsForUser", (String)"364", (Object)((Object)this));
                    exception.printStackTrace();
                }
            }
            return null;
        }
        List list = null;
        list = newCustomReg ? this.custImpl.getGroupsForUser(string) : oldCustImpl.getGroupsForUser(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupsForUser", (Object)String.valueOf(list.size()));
        }
        return list;
    }

    private WSCredential createCredentialOld(String string) throws CustomRegistryException, EntryNotFoundException, NotImplementedException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCredentialOld", (Object)string);
        }
        if (string == null || string.length() == 0) {
            Tr.error((TraceComponent)tc, (String)"security.registry.nulluser");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createCredentialOld", (Object)string);
            }
            throw new EntryNotFoundException("SecurityName is null");
        }
        WSCredential wSCredential = null;
        List list = null;
        String string2 = null;
        if (this.useDisplayName != null && this.useDisplayName.equalsIgnoreCase("true")) {
            try {
                string2 = this.getUserDisplayName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string3 = null;
        string3 = string2 != null && string2.length() > 0 ? string2 : string;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using name: " + string3 + " in the credential."));
        }
        try {
            String string4 = oldCustImpl.getUniqueUserId(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            final String string5 = RegistryUtil.appendRealm(USERTYPE, string4, this.realm);
            final String string6 = string4;
            String[] stringArray = null;
            String string7 = null;
            list = oldCustImpl.getUniqueGroupIds(string4);
            if (list != null && list.size() > 0) {
                stringArray = list.toArray(new String[list.size()]);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i == 0) {
                        string7 = RegistryUtil.appendRealm(GROUPTYPE, stringArray[i], this.realm);
                    }
                    arrayList.add(RegistryUtil.appendRealm(GROUPTYPE, stringArray[i], this.realm));
                }
            }
            final String string8 = this.realm;
            final String string9 = string3;
            final String string10 = string7;
            final ArrayList<String> arrayList2 = arrayList;
            try {
                wSCredential = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new WSCredentialImpl(string8, string9, string6, string10 != null ? string10 : nullString, string5, null, arrayList2);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS cred.", (Object)new Object[]{privilegedActionException.getException()});
                }
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.registry.UserRegistryImpl.createCredentialOne", (String)"769", (Object)((Object)this));
                throw privilegedActionException.getException();
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception creating credential.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.createCredentialOne", (String)"751", (Object)((Object)this));
            throw new RemoteException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCredentialOne");
        }
        return wSCredential;
    }

    public WSCredential createCredential(String string) throws CustomRegistryException, EntryNotFoundException, NotImplementedException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createCredential" + string));
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "createCredential")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed");
                try {
                    throw new Exception("debugging RoleBasedAuthorization");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.createCredential", (String)"897", (Object)((Object)this));
                    exception.printStackTrace();
                }
            }
            return null;
        }
        WSCredential wSCredential = null;
        if (!newCustomReg) {
            return this.createCredentialOld(string);
        }
        if (this.isLDAP) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using Specific Registry's createCredential ");
            }
            wSCredential = this.custImpl.createCredential(string);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createCredential");
            }
            return wSCredential;
        }
        List list = null;
        if (string == null || string.length() == 0) {
            throw new EntryNotFoundException("SecurityName is null");
        }
        String string2 = null;
        if (this.useDisplayName != null && this.useDisplayName.equalsIgnoreCase("true")) {
            try {
                string2 = this.getUserDisplayName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string3 = null;
        string3 = string2 != null && string2.length() > 0 ? string2 : string;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using name: " + string3 + " in the credential."));
        }
        try {
            int n;
            String string4 = this.custImpl.getUniqueUserId(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            final String string5 = RegistryUtil.appendRealm(USERTYPE, string4, this.realm);
            final String string6 = string4;
            list = this.custImpl.getUniqueGroupIds(string4);
            String[] stringArray = null;
            String string7 = null;
            if (list != null && list.size() > 0) {
                stringArray = list.toArray(new String[list.size()]);
                for (n = 0; n < stringArray.length; ++n) {
                    if (n == 0) {
                        string7 = RegistryUtil.appendRealm(GROUPTYPE, stringArray[n], this.realm);
                    }
                    arrayList.add(RegistryUtil.appendRealm(GROUPTYPE, stringArray[n], this.realm));
                }
            }
            if (this.isWindows && !this.isLocalOrDomain && (n = string3.indexOf("\\")) != -1) {
                string3 = string3.substring(n + 1);
            }
            final String string8 = this.realm;
            final String string9 = string3;
            final String string10 = string7;
            final ArrayList<String> arrayList2 = arrayList;
            try {
                wSCredential = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new WSCredentialImpl(string8, string9, string6, string10 != null ? string10 : nullString, string5, null, arrayList2);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS cred.", (Object)new Object[]{privilegedActionException.getException()});
                }
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.registry.UserRegistryImpl.createCredential", (String)"906", (Object)((Object)this));
                throw privilegedActionException.getException();
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception creating credential.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.createCredential", (String)"865", (Object)((Object)this));
            throw new RemoteException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCredential");
        }
        return wSCredential;
    }

    public String getRealm() throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRealm");
        }
        String string = null;
        if (this.realm != null && this.realm.length() > 0) {
            string = this.realm;
        } else {
            string = newCustomReg ? this.custImpl.getRealm() : oldCustImpl.getRealm();
            if (string == null || string.length() == 0) {
                string = CUSTOM_REALM;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRealm", (Object)string);
        }
        return string;
    }

    public List getUniqueGroupIds(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueGroupIds");
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUniqueGroupId")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed");
                try {
                    throw new Exception("debugging RoleBasedAuthorization");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.getUniqueGroupIds", (String)"1011", (Object)((Object)this));
                    exception.printStackTrace();
                }
            }
            return null;
        }
        List list = null;
        list = newCustomReg ? this.custImpl.getUniqueGroupIds(string) : oldCustImpl.getUniqueGroupIds(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueGroupIds");
        }
        return list;
    }

    public Result getUsersForGroup(String string, int n) throws NotImplementedException, EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsersForGroup", (Object)string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUsersForGroup")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed");
                try {
                    throw new Exception("debugging RoleBasedAuthorization");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.getUsersForGroup", (String)"364", (Object)((Object)this));
                    exception.printStackTrace();
                }
            }
            return null;
        }
        Result result = new Result();
        List list = null;
        if (newCustomReg) {
            result = this.custImpl.getUsersForGroup(string, n);
        } else {
            list = oldCustImpl.getUsersForGroup(string);
            result.setList(list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsersForGroup");
        }
        return result;
    }

    public void setConfigurator(RoleBasedConfigurator roleBasedConfigurator) {
        if (authorizer == null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"To get RoleBasedConfigurator");
                }
                RoleBasedConfigurator roleBasedConfigurator2 = roleBasedConfigurator;
                authorizer = roleBasedConfigurator.getRoleBasedAuthorizer("admin-authz", "domain");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"got RoleBasedAuthorizer");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.setConfigurator", (String)"1127", (Object)((Object)this));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught retrieving RoleBasedAuthorizer");
                }
                Tr.error((TraceComponent)tc, (String)"security.init.roleauthz.geterr", (Object)new Object[]{exception});
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nullString = RegistryUtil.nullString;
        nullStringArray = RegistryUtil.nullStringArray;
        nullByteArray = RegistryUtil.nullByteArray;
        authorizer = null;
        newCustomReg = false;
    }
}

