/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ws.security.registry.RegistryUtil;
import java.net.URLDecoder;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class EntryEnumeration
implements NamingEnumeration {
    protected String baseDn = null;
    protected NamingEnumeration namingEnum;

    public EntryEnumeration(String string, NamingEnumeration namingEnumeration) {
        if (string != null && string.length() > 0) {
            this.baseDn = string;
        }
        this.namingEnum = namingEnumeration;
    }

    public boolean hasMoreElements() {
        return this.namingEnum.hasMoreElements();
    }

    public Object nextElement() {
        NameClassPair nameClassPair = (NameClassPair)this.namingEnum.nextElement();
        String string = nameClassPair.getName();
        if (string != null && string.length() > 0 && nameClassPair.isRelative() && this.baseDn != null) {
            if (string.charAt(0) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            string = string + "," + this.baseDn;
        }
        if (!nameClassPair.isRelative() && string != null && string.length() > 0) {
            int n = string.indexOf(47, 9);
            if (n > -1 && string.length() > n + 1) {
                try {
                    string = URLDecoder.decode(string, "UTF8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string = string.substring(n + 1);
            } else {
                string = "";
            }
        }
        if (string == null || string.length() == 0) {
            string = this.baseDn;
        }
        string = RegistryUtil.removeDNSpace(string, 0);
        return string;
    }

    public void close() throws NamingException {
        this.namingEnum.close();
    }

    public boolean hasMore() throws NamingException {
        return this.namingEnum.hasMore();
    }

    public Object next() throws NamingException {
        return this.namingEnum.next();
    }
}

