/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.registry.ldap.LdapConfig;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class IdMap {
    public static final String USERIDMAP = "user.idmap";
    public static final String GROUPIDMAP = "group.idmap";
    public static final String GROUPMEMBERIDMAP = "groupmember.idmap";
    private static IdEntry[] defaultIds = new IdEntry[]{new IdEntry("*", "cn")};
    private static IdEntry[] defaultMemberIds = new IdEntry[0];
    private IdEntry[] userIds = null;
    private IdEntry[] groupIds = null;
    private IdEntry[] groupMemberIds = null;
    private String[] attrs = null;

    public IdMap(LdapConfig ldapConfig) {
        this.userIds = this.parseIdMap(ldapConfig.getProperty(USERIDMAP), defaultIds);
        this.groupIds = this.parseIdMap(ldapConfig.getProperty(GROUPIDMAP), defaultIds);
        this.groupMemberIds = this.parseIdMap(ldapConfig.getProperty(GROUPMEMBERIDMAP), defaultMemberIds);
        Vector<String> vector = new Vector<String>();
        vector.addElement("objectclass");
        this.addAttributes(vector, this.userIds);
        this.addAttributes(vector, this.groupIds);
        this.attrs = new String[vector.size()];
        vector.copyInto(this.attrs);
    }

    public String getUserName(Attributes attributes) {
        return this.getName(this.userIds, attributes);
    }

    public String getGroupName(Attributes attributes) {
        return this.getName(this.groupIds, attributes);
    }

    public IdEntry[] getGroupMembers() {
        return this.groupMemberIds;
    }

    private String getName(IdEntry[] idEntryArray, Attributes attributes) {
        String string = null;
        Attribute attribute = attributes.get("objectclass");
        if (attribute != null) {
            int n = Integer.MAX_VALUE;
            try {
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMoreElements()) {
                    String string2 = (String)namingEnumeration.nextElement();
                    for (int i = 0; i < idEntryArray.length; ++i) {
                        Attribute attribute2;
                        if (!idEntryArray[i].equals(string2) || i >= n || (attribute2 = attributes.get(idEntryArray[i].getAttributeName())) == null) continue;
                        n = i;
                        string = (String)attribute2.get();
                    }
                }
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.registry.ldap.IdMap.getName", (String)"96", (Object)this);
            }
        }
        return string;
    }

    public String[] getAttributes() {
        return this.attrs;
    }

    private IdEntry[] parseIdMap(String string, IdEntry[] idEntryArray) {
        Object[] objectArray;
        Vector<IdEntry> vector = new Vector<IdEntry>();
        if (string != null) {
            objectArray = new StringTokenizer(string, ";");
            while (objectArray.hasMoreTokens()) {
                String string2 = objectArray.nextToken();
                int n = string2.indexOf(58);
                if (n == -1) continue;
                String string3 = string2.substring(n + 1).trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(0, n), ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken().trim();
                    vector.addElement(new IdEntry(string4, string3));
                }
            }
        }
        if (vector.size() > 0) {
            objectArray = new IdEntry[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return idEntryArray;
    }

    private void addAttributes(Vector vector, IdEntry[] idEntryArray) {
        for (int i = 0; i < idEntryArray.length; ++i) {
            String string = idEntryArray[i].getAttributeName();
            if (vector.contains(string)) continue;
            vector.addElement(string);
        }
    }

    public static class IdEntry {
        private static final String wildCard = new String("*");
        String objClassName;
        String attrName;

        public IdEntry(String string, String string2) {
            this.objClassName = wildCard.equals(string) ? wildCard : string.toLowerCase();
            this.attrName = string2.toLowerCase();
        }

        public String getObjectClassName() {
            return this.objClassName;
        }

        public String getAttributeName() {
            return this.attrName;
        }

        public boolean equals(Object object) {
            return this.objClassName.equalsIgnoreCase(object.toString()) || this.objClassName == wildCard;
        }
    }
}

