/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.registry.RegistryErrorException;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.ldap.CertificateMapper;
import com.ibm.ws.security.registry.ldap.CertificateMapperException;
import com.ibm.ws.security.registry.ldap.EntryEnumeration;
import com.ibm.ws.security.registry.ldap.IdMap;
import com.ibm.ws.security.registry.ldap.LdapConfig;
import com.ibm.ws.security.util.AccessController;
import java.net.URLDecoder;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.InvalidNameException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapRegistryImpl
implements UserRegistry {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$registry$ldap$LdapRegistryImpl == null ? (class$com$ibm$ws$security$registry$ldap$LdapRegistryImpl = LdapRegistryImpl.class$("com.ibm.ws.security.registry.ldap.LdapRegistryImpl")) : class$com$ibm$ws$security$registry$ldap$LdapRegistryImpl), null, (String)"com.ibm.ejs.resources.security");
    private static final int RETRIES = 3;
    public static final String USER_FILTER = "user.filter";
    public static final String GROUP_FILTER = "group.filter";
    public static final String CERTIFICATE_MAP_MODE = "certificate.map.mode";
    public static final String CERTIFICATE_MAP_FILTER = "certificate.map.filter";
    private static final String[] noAttrs = new String[]{"1.1"};
    public static final String OBJECT_FILTER = "(objectclass=*)";
    private static boolean URLContextImpl = false;
    private static String LdapURL = null;
    private static int searchTimeLimit = 120000;
    private static final String[] dnAttrib = new String[]{"dn"};
    private static final String[] GROUP_ATTRIBUTES = new String[]{"nsroledn", "nsrole", "ibm-allGroups", "memberof"};
    private static final String iPlanet_OBJECT_FILTER = "(|(objectclass=*)(objectclass=ldapsubentry))";
    private static String objectFilter = "(objectclass=*)";
    private static boolean ignoreCaseMatch = false;
    private static boolean useAttributeGroupMethod = false;
    private static boolean registryExist = false;
    private static Vector DirContextPool = new Vector();
    private static int ContextPoolSize = 0;
    private static boolean recursiveSearch = false;
    private String realm = null;
    public static final String NONE = "";
    public static final String USERTYPE = "user";
    public static final String GROUPTYPE = "group";
    public static final String ROLETYPE = "role";
    protected static final String nullString = RegistryUtil.nullString;
    protected static final String[] nullStringArray = RegistryUtil.nullStringArray;
    protected static final byte[] nullByteArray = RegistryUtil.nullByteArray;
    protected static final String realmSeparator = "/";
    public static final String typeSeparator = ":";
    private LdapConfig ldapConfig;
    private IdMap idMap;
    private CertificateMapper certMap;
    static /* synthetic */ Class class$com$ibm$ws$security$registry$ldap$LdapRegistryImpl;

    protected DirContext getRootDSE() throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRootDSE");
        }
        DirContext dirContext = null;
        while (DirContextPool != null && DirContextPool.size() > 30) {
            try {
                dirContext = (DirContext)DirContextPool.lastElement();
                DirContextPool.removeElement(dirContext);
                dirContext.close();
                --ContextPoolSize;
            }
            catch (Exception exception) {}
        }
        try {
            dirContext = (DirContext)DirContextPool.lastElement();
            DirContextPool.removeElement(dirContext);
            Tr.exit((TraceComponent)tc, (String)"getRootDSE");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRootDSE");
            }
            return dirContext;
        }
        catch (Exception exception) {
            DirContext dirContext2 = this.ldapConfig.getRootDSE();
            if (ContextPoolSize == 0) {
                for (int i = 0; i < 10; ++i) {
                    dirContext = (DirContext)dirContext2.lookup(NONE);
                    DirContextPool.addElement(dirContext);
                    ++ContextPoolSize;
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"DirContext pool initialized.");
                }
            }
            dirContext = (DirContext)dirContext2.lookup(NONE);
            if (tc.isDebugEnabled() && ++ContextPoolSize > 30) {
                Tr.debug((TraceComponent)tc, (String)("DirContext pool size = " + ContextPoolSize));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRootDSE");
            }
            return dirContext;
        }
    }

    protected void disconnect() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"disconnect");
        }
        while (!DirContextPool.isEmpty()) {
            try {
                DirContext dirContext = (DirContext)DirContextPool.lastElement();
                DirContextPool.removeElement(dirContext);
                dirContext.close();
            }
            catch (Exception exception) {}
        }
        ContextPoolSize = 0;
        this.ldapConfig.disconnect();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"disconnect");
        }
    }

    public String checkPassword(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkPassword", (Object)string);
        }
        String string3 = null;
        try {
            Result result;
            int n;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Authenticating", (Object)string);
            }
            if (string.length() == 0 || string2.length() == 0) {
                PasswordCheckFailedException passwordCheckFailedException = new PasswordCheckFailedException("The userId and/or password is empty");
                Tr.error((TraceComponent)tc, (String)"security.authn.failed.foruser", (Object)new Object[]{string});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkPassword", (Object)((Object)passwordCheckFailedException));
                }
                throw passwordCheckFailedException;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Searching for users");
            }
            if ((n = (result = this.getUsers(string = LdapRegistryImpl.escapeChar(string, '*'), 2)).getList().size()) > 1) {
                PasswordCheckFailedException passwordCheckFailedException = new PasswordCheckFailedException("Multiple users with the name of " + string);
                Tr.error((TraceComponent)tc, (String)"security.authn.failed.multiusers", (Object)new Object[]{string});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkPassword", (Object)((Object)passwordCheckFailedException));
                }
                throw passwordCheckFailedException;
            }
            if (n == 0) {
                PasswordCheckFailedException passwordCheckFailedException = new PasswordCheckFailedException("No user " + string + " found");
                Tr.error((TraceComponent)tc, (String)"security.authn.failed.nouser", (Object)new Object[]{string, passwordCheckFailedException});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkPassword", (Object)((Object)passwordCheckFailedException));
                }
                throw passwordCheckFailedException;
            }
            string = (String)result.getList().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found user", (Object)string);
            }
            string3 = this.authenticate(string, string2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Authenticated with", (Object)string);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.checkPassword", (String)"194", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.authn.error", (Object)new Object[]{string, exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkPassword", (Object)exception);
            }
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkPassword", (Object)string3);
        }
        return string3;
    }

    protected String authenticate(String string, String string2) throws AuthenticationFailedException, com.ibm.websphere.security.auth.AuthenticationNotSupportedException, RegistryErrorException, CustomRegistryException {
        long l = 0L;
        LdapConfig ldapConfig = new LdapConfig(this.ldapConfig);
        String string3 = LdapRegistryImpl.escapeChar(string, '*');
        ldapConfig.setAuthenticationPrincipal(string3);
        ldapConfig.setAuthenticationCredentials(string2);
        try {
            l = System.currentTimeMillis();
            InitialDirContext initialDirContext = new InitialDirContext(ldapConfig);
            initialDirContext.close();
            if (tc.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Time elapsed to open/close DirContext: ");
                stringBuffer = stringBuffer.append(System.currentTimeMillis() - l);
                Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            }
            return string;
        }
        catch (AuthenticationNotSupportedException authenticationNotSupportedException) {
            FFDCFilter.processException((Throwable)authenticationNotSupportedException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.authenticate", (String)"222", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.authn.error", (Object)new Object[]{string, authenticationNotSupportedException});
            throw new com.ibm.websphere.security.auth.AuthenticationNotSupportedException(authenticationNotSupportedException.getMessage(), (Throwable)authenticationNotSupportedException);
        }
        catch (AuthenticationException authenticationException) {
            FFDCFilter.processException((Throwable)authenticationException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.authenticate", (String)"227", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.authn.error", (Object)new Object[]{string, authenticationException});
            throw new AuthenticationFailedException(authenticationException.getMessage(), (Throwable)authenticationException);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.authenticate", (String)"232", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.authn.error", (Object)new Object[]{string, namingException});
            this.logNamingException(namingException, string);
            throw new RegistryErrorException(namingException.getMessage(), namingException);
        }
    }

    private static String normalizeDN(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = true;
        boolean bl2 = true;
        int n2 = 32;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (c != ' ') {
                    if (bl2) {
                        stringBuffer.append(Character.toLowerCase(c));
                    } else {
                        stringBuffer.append(c);
                        bl = false;
                    }
                    if (c == '=') {
                        bl2 = false;
                    }
                }
            } else {
                if ((c == ',' || c == ';') && n2 != 92) {
                    bl = true;
                    bl2 = true;
                }
                stringBuffer.append(c);
            }
            n2 = c;
        }
        return stringBuffer.toString();
    }

    public String mapCertificate(X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapCertificate");
        }
        X509Certificate x509Certificate = x509CertificateArray[0];
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        try {
            string3 = this.certMap.getLdapSearchFilter(x509Certificate);
            n = this.certMap.getLdapSearchScope();
        }
        catch (CertificateMapperException certificateMapperException) {
            FFDCFilter.processException((Throwable)certificateMapperException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.mapCertificate", (String)"308", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CertificatMapperException caught during LDAP operation while looking for: " + x509Certificate.getSubjectDN().getName()));
            }
            Tr.error((TraceComponent)tc, (String)"security.registry.ldap.mapcredentialBadFilter", (Object)new Object[]{x509Certificate.getSubjectDN().getName(), certificateMapperException});
            throw new CertificateMapFailedException(certificateMapperException.getMessage(), (Throwable)certificateMapperException);
        }
        try {
            if (n == 0) {
                Result result;
                int n2;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Searching for users");
                }
                if ((n2 = (result = this.getUsers(string3, 2)).getList().size()) > 1) {
                    CertificateMapFailedException certificateMapFailedException = new CertificateMapFailedException("Multiple users with the name of " + string2);
                    Tr.error((TraceComponent)tc, (String)"security.authn.failed.multiusers", (Object)new Object[]{string2});
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"mapCertificate", (Object)((Object)certificateMapFailedException));
                    }
                    throw certificateMapFailedException;
                }
                if (n2 == 0) {
                    CertificateMapFailedException certificateMapFailedException = new CertificateMapFailedException("No user " + string2 + " found");
                    Tr.error((TraceComponent)tc, (String)"security.authn.failed.nouser", (Object)new Object[]{string2, certificateMapFailedException});
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"mapCertificate", (Object)((Object)certificateMapFailedException));
                    }
                    throw certificateMapFailedException;
                }
                string = (String)result.getList().get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"certificate dn =", (Object)string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"normalized  dn =", (Object)string);
                }
            } else {
                EntryEnumeration entryEnumeration = this.search(n, string3, 2);
                if (entryEnumeration.hasMoreElements()) {
                    string = (String)entryEnumeration.nextElement();
                    if (entryEnumeration.hasMoreElements()) {
                        entryEnumeration.close();
                        Tr.error((TraceComponent)tc, (String)"security.authn.failed.multiusers", (Object)new Object[]{x509Certificate.getSubjectDN().getName()});
                        throw new CertificateMapFailedException("Multiple users with the name of " + x509Certificate.getSubjectDN().getName());
                    }
                }
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.mapCertificate", (String)"349", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("NamingException caught during LDAP operation while looking for: " + x509Certificate.getSubjectDN().getName()));
            }
            Tr.error((TraceComponent)tc, (String)"security.registry.ldap.mapcredentialNamingEx", (Object)new Object[]{x509Certificate.getSubjectDN().getName(), string3, namingException});
            this.logNamingException(namingException);
            throw new CertificateMapFailedException(namingException.getMessage(), (Throwable)namingException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.mapCertificate", (String)"356", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception caught during LDAP operation while looking for: " + x509Certificate.getSubjectDN().getName()));
            }
            throw new CertificateMapFailedException(exception.getMessage(), (Throwable)exception);
        }
        if (string == null) {
            Tr.error((TraceComponent)tc, (String)"security.registry.ldap.mapcredentialNotFound", (Object)new Object[]{x509Certificate.getSubjectDN().getName(), string3});
            throw new CertificateMapFailedException("The name in the certificate: " + x509Certificate.getSubjectDN().getName() + " cannot be found in the registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapCertificate");
        }
        return string;
    }

    public String getGroupDisplayName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupDisplayName", (Object)string);
        }
        String string2 = null;
        try {
            Attributes attributes = this.getAttributes(string, this.idMap.getAttributes());
            string2 = this.idMap.getGroupName(attributes);
            if (tc.isDebugEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Security name =", (Object)string);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Attributes =", (Object)attributes);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Name =", (Object)attributes);
                }
            }
        }
        catch (NamingException namingException) {
            this.logNamingException(namingException);
        }
        if (string2 == null) {
            string2 = NONE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupDisplayName", (Object)string2);
        }
        return string2;
    }

    public String getUniqueGroupId(String string) throws EntryNotFoundException, CustomRegistryException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueGroupId", (Object)string);
        }
        String string3 = null;
        try {
            string3 = LdapRegistryImpl.escapeChar(string, '*');
            Result result = this.getGroups(string3, 2);
            int n = result.getList().size();
            if (n > 1) {
                CustomRegistryException customRegistryException = new CustomRegistryException("Multiple groups with the name of " + string3);
                Tr.error((TraceComponent)tc, (String)"security.authn.failed.multiusers", (Object)new Object[]{string3});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getUniqueGroupId", (Object)((Object)customRegistryException));
                }
                throw customRegistryException;
            }
            if (n == 0) {
                CustomRegistryException customRegistryException = new CustomRegistryException("No group " + string3 + " found");
                Tr.error((TraceComponent)tc, (String)"security.authn.failed.nouser", (Object)new Object[]{string, customRegistryException});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getUniqueGroupId", (Object)((Object)customRegistryException));
                }
                throw customRegistryException;
            }
            string2 = (String)result.getList().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found group", (Object)string2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getUniqueGroupId", (String)"877", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.uniquegrpid.error", (Object)new Object[]{string3, exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUniqueGroupId");
            }
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueGroupId", (Object)string2);
        }
        return string2;
    }

    public List getUniqueGroupIds(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueGroupIds", (Object)string);
        }
        List list = this.getGroupsForUser(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueGroupIds");
        }
        return list;
    }

    public Result getGroups(String string, int n) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroups", (Object)(string + typeSeparator + n));
        }
        Result result = new Result();
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No groups searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)(string + typeSeparator + n));
            }
            return result;
        }
        EntryEnumeration entryEnumeration = null;
        int n2 = n++;
        int n3 = 0;
        if (n2 == 0 || n2 < Integer.MAX_VALUE) {
            // empty if block
        }
        try {
            ArrayList<Object> arrayList;
            block21: {
                if (this.fullDN(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"pattern is full DN");
                    }
                    entryEnumeration = this.search(string, 0, OBJECT_FILTER, n);
                } else {
                    arrayList = this.ldapConfig.getFilter(GROUP_FILTER).prepare(string);
                    entryEnumeration = this.search(2, (String)((Object)arrayList), n);
                }
                if (entryEnumeration == null) {
                    arrayList = new ArrayList<Object>(0);
                    result.setList(arrayList);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No groups found");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)(string + typeSeparator + n2));
                    }
                    return result;
                }
                arrayList = new ArrayList();
                if (n2 != 0) {
                    arrayList = new ArrayList(n);
                }
                while (entryEnumeration.hasMoreElements()) {
                    arrayList.add(entryEnumeration.nextElement());
                    if (n2 == 0 || ++n3 != n2) continue;
                }
                result.setList(arrayList);
                try {
                    if (entryEnumeration.hasMoreElements()) {
                        result.setHasMore();
                        entryEnumeration.close();
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug((TraceComponent)tc, (String)"no more groups");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Number of groups returned = " + arrayList.size()));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)(string + typeSeparator + n2));
            }
            return result;
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getGroups", (String)"533", (Object)this);
            this.logNamingException(namingException);
            Tr.error((TraceComponent)tc, (String)"security.registry.getgroups.error", (Object)new Object[]{string, namingException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)namingException);
            }
            throw new CustomRegistryException(namingException.getMessage(), (Throwable)namingException);
        }
    }

    private void getAllGroupMembersByGroupObject(String string, ArrayList arrayList, ArrayList arrayList2, IdMap.IdEntry[] idEntryArray, String string2) throws CustomRegistryException {
        if (arrayList2.contains(string)) {
            return;
        }
        arrayList2.add(string);
        StringBuffer stringBuffer = new StringBuffer("(|");
        for (int i = 0; i < idEntryArray.length; ++i) {
            if (idEntryArray[i].getObjectClassName().equalsIgnoreCase("objectCategory")) continue;
            stringBuffer.append("(&(").append(string2).append("=").append(idEntryArray[i].getObjectClassName()).append(")(");
            stringBuffer.append(idEntryArray[i].getAttributeName()).append("=").append(string.toString()).append("))");
        }
        stringBuffer.append(")");
        String string3 = stringBuffer.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"filter =", (Object)string3);
        }
        Vector<Object> vector = new Vector<Object>(5);
        try {
            String string4 = this.ldapConfig.getBaseDn();
            Object object = new EntryEnumeration(this.ldapConfig.getBaseDn(), this.search(this.ldapConfig.getBaseDn(), 2, string3, noAttrs, 0));
            while (((EntryEnumeration)object).hasMoreElements()) {
                vector.addElement(((EntryEnumeration)object).nextElement());
            }
            object = vector.listIterator();
            while (object.hasNext()) {
                String string5 = (String)object.next();
                arrayList.add(string5);
                if (!recursiveSearch) continue;
                this.getAllGroupMembersByGroupObject(string5, arrayList, arrayList2, idEntryArray, string2);
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getGroupsForUser", (String)"736", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.getgrpsforuser.error", (Object)new Object[]{string, namingException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroupsForUser", (Object)namingException);
            }
            throw new CustomRegistryException(namingException.getMessage(), (Throwable)namingException);
        }
    }

    private void getAllGroupMembershipsByUserObject(String string, ArrayList arrayList, ArrayList arrayList2, String string2) throws EntryNotFoundException {
        if (arrayList2.contains(string)) {
            return;
        }
        arrayList2.add(string);
        String[] stringArray = new String[]{string2};
        Vector<String> vector = new Vector<String>(5);
        try {
            Object object;
            NamingEnumeration namingEnumeration;
            if (this.fullDN(string)) {
                namingEnumeration = this.search(string, 0, objectFilter, stringArray, 0);
            } else {
                object = this.ldapConfig.getFilter(USER_FILTER).prepare(string);
                namingEnumeration = this.search(this.ldapConfig.getBaseDn(), 2, (String)object, stringArray, 0);
            }
            if (namingEnumeration.hasMoreElements()) {
                String string3;
                Object object2;
                object = (SearchResult)namingEnumeration.next();
                NamingEnumeration<? extends Attribute> namingEnumeration2 = ((SearchResult)object).getAttributes().getAll();
                while (namingEnumeration2.hasMoreElements()) {
                    object2 = namingEnumeration2.next();
                    string3 = object2.getID();
                    if (!string3.equalsIgnoreCase(stringArray[0])) continue;
                    for (int i = 0; i < object2.size(); ++i) {
                        String string4 = (String)object2.get(i);
                        string4 = RegistryUtil.removeDNSpace(string4, 0);
                        vector.addElement(string4);
                    }
                }
                if (namingEnumeration.hasMoreElements()) {
                    namingEnumeration.close();
                }
                object2 = vector.listIterator();
                while (object2.hasNext()) {
                    string3 = (String)object2.next();
                    arrayList.add(string3);
                    if (!recursiveSearch) continue;
                    this.getAllGroupMembershipsByUserObject(string3, arrayList, arrayList2, string2);
                }
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getGroupsForUser", (String)"643", (Object)this);
            this.logNamingException(namingException);
            Tr.error((TraceComponent)tc, (String)"security.registry.getgrpsforuser.error", (Object)new Object[]{string, namingException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroupsForUser");
            }
            throw new EntryNotFoundException(namingException.getMessage(), (Throwable)namingException);
        }
    }

    public List getGroupsForUser(String string) throws EntryNotFoundException, CustomRegistryException {
        IdMap.IdEntry[] idEntryArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupsForUser", (Object)string);
        }
        if (!this.fullDN(string)) {
            string = this.getUniqueUserId(string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("using DN: " + string));
            }
        }
        if ((idEntryArray = this.idMap.getGroupMembers()).length == 0) {
            return new ArrayList(0);
        }
        ArrayList arrayList = new ArrayList();
        if (useAttributeGroupMethod) {
            string = LdapRegistryImpl.escapeChar(string, '*');
            String string2 = idEntryArray[0].getObjectClassName();
            this.getAllGroupMembershipsByUserObject(string, arrayList, new ArrayList(), string2);
        } else {
            string = LdapRegistryImpl.escapeChar(string, '\\');
            string = LdapRegistryImpl.escapeChar(string, '*');
            String string3 = "objectclass";
            for (int i = 0; i < idEntryArray.length; ++i) {
                if (!idEntryArray[i].getObjectClassName().equalsIgnoreCase("objectCategory")) continue;
                string3 = "objectCategory";
                break;
            }
            this.getAllGroupMembersByGroupObject(string, arrayList, new ArrayList(), idEntryArray, string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Number of groups returned = " + arrayList.size()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupsForUser", (Object)arrayList.toArray());
        }
        return arrayList;
    }

    public Result getUsersForGroup(String string, int n) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsersForGroup");
        }
        Result result = new Result();
        int n2 = 0;
        String string2 = null;
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No groups searched for users as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsersForGroup");
            }
            return result;
        }
        IdMap.IdEntry[] idEntryArray = this.idMap.getGroupMembers();
        if (idEntryArray.length == 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No filter specified for groupmeneber.idmap ");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsersForGroup");
            }
            return result;
        }
        String[] stringArray = new String[idEntryArray.length];
        for (int i = 0; i < idEntryArray.length; ++i) {
            stringArray[i] = idEntryArray[i].getAttributeName();
        }
        ArrayList<String> arrayList = new ArrayList<String>(0);
        if (n != 0 && n < Integer.MAX_VALUE) {
            arrayList = new ArrayList(n + 1);
        } else if (n == Integer.MAX_VALUE) {
            arrayList = new ArrayList(n);
        }
        try {
            NamingEnumeration namingEnumeration = this.search(string, 0, OBJECT_FILTER, stringArray, 1);
            if (namingEnumeration.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)namingEnumeration.next();
                NamingEnumeration<? extends Attribute> namingEnumeration2 = searchResult.getAttributes().getAll();
                block3: while (namingEnumeration2.hasMoreElements()) {
                    Attribute attribute = namingEnumeration2.next();
                    for (int i = 0; i < attribute.size(); ++i) {
                        string2 = (String)attribute.get(i);
                        string2 = RegistryUtil.removeDNSpace(string2, 0);
                        arrayList.add(string2);
                        if (n >= Integer.MAX_VALUE || n == 0 || ++n2 < n + 1) continue;
                        result.setHasMore();
                        arrayList.remove(string2);
                        continue block3;
                    }
                }
                if (namingEnumeration.hasMoreElements()) {
                    namingEnumeration.close();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getUsersForGroup");
                }
                result.setList(arrayList);
            }
        }
        catch (NamingException namingException) {
            this.logNamingException(namingException);
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getUsersForGroup", (String)"871", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.getusrsforgrp.error", (Object)new Object[]{string, namingException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsersForGroup", (Object)namingException);
            }
            throw new CustomRegistryException(namingException.getMessage(), (Throwable)namingException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsersForGroup");
        }
        return result;
    }

    public String getGroupSecurityName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupSecurityName", (Object)string);
        }
        String string2 = this.getUniqueGroupId(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupSecurityName", (Object)string2);
        }
        return string2;
    }

    public String getUserDisplayName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserDisplayName", (Object)string);
        }
        String string2 = null;
        try {
            Attributes attributes = this.getAttributes(string, this.idMap.getAttributes());
            string2 = this.idMap.getUserName(attributes);
            if (tc.isDebugEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"securityName =", (Object)string);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"attributes =", (Object)attributes);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"userName =", (Object)string2);
                }
            }
        }
        catch (NamingException namingException) {
            this.logNamingException(namingException);
        }
        if (string2 == null) {
            string2 = NONE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserDisplayName");
        }
        return string2;
    }

    public String getUniqueUserId(String string) throws EntryNotFoundException, CustomRegistryException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueUserId", (Object)string);
        }
        String string3 = null;
        try {
            string3 = LdapRegistryImpl.escapeChar(string, '*');
            Result result = this.getUsers(string3, 2);
            int n = result.getList().size();
            if (n > 1) {
                CustomRegistryException customRegistryException = new CustomRegistryException("Multiple users with the name of " + string3);
                Tr.error((TraceComponent)tc, (String)"security.authn.failed.multiusers", (Object)new Object[]{string3});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getUniqueUserId", (Object)((Object)customRegistryException));
                }
                throw customRegistryException;
            }
            if (n == 0) {
                Tr.error((TraceComponent)tc, (String)"security.registry.uniqueusrid.notfound", (Object)new Object[]{string3});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getUniqueUserId");
                }
                throw new CustomRegistryException("Cannot find uniqueID for the user " + string3);
            }
            string2 = (String)result.getList().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found user", (Object)string2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getUniqueUserId", (String)"877", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.uniqueusrid.error", (Object)new Object[]{string3, exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUniqueUserId");
            }
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueUserId", (Object)string2);
        }
        return string2;
    }

    public Result getUsers(String string, int n) throws CustomRegistryException {
        ArrayList<Object> arrayList;
        int n2;
        Result result;
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getUsers", (Object)new Object[]{string, new Integer(n)});
            }
            result = new Result();
            if (n < 0) {
                ArrayList arrayList2 = new ArrayList(0);
                result.setList(arrayList2);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No users searched as the limit is a negative number.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)new Object[]{string, new Integer(n)});
                }
                return result;
            }
            EntryEnumeration entryEnumeration = null;
            n2 = n++;
            int n3 = 0;
            if (n2 == 0 || n2 < Integer.MAX_VALUE) {
                // empty if block
            }
            try {
                if (this.fullDN(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"pattern is full DN");
                    }
                    entryEnumeration = this.search(string, 0, OBJECT_FILTER, n);
                } else {
                    arrayList = this.ldapConfig.getFilter(USER_FILTER).prepare(string);
                    entryEnumeration = this.search(2, (String)((Object)arrayList), n);
                }
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getUsers", (String)"910", (Object)this);
                this.logNamingException(namingException);
                Tr.error((TraceComponent)tc, (String)"security.registry.getusers.error", (Object)new Object[]{string, namingException});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)new Object[]{string, new Integer(n2), namingException});
                }
                throw new CustomRegistryException(namingException.getMessage(), (Throwable)namingException);
            }
            if (entryEnumeration == null) {
                arrayList = new ArrayList<Object>(0);
                result.setList(arrayList);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No users found");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)new Object[]{string, new Integer(n2)});
                }
                return result;
            }
            arrayList = new ArrayList();
            if (n2 != 0) {
                arrayList = new ArrayList(n);
            }
            while (entryEnumeration.hasMoreElements()) {
                arrayList.add(entryEnumeration.nextElement());
                if (n2 == 0 || ++n3 != n2) continue;
            }
            result.setList(arrayList);
            try {
                if (entryEnumeration.hasMoreElements()) {
                    result.setHasMore();
                    entryEnumeration.close();
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block21;
                Tr.debug((TraceComponent)tc, (String)"no more users");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Number of users returned = " + arrayList.size()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)new Object[]{string, new Integer(n2)});
        }
        return result;
    }

    public String getUserSecurityName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserSecurityName", (Object)string);
        }
        String string2 = this.getUniqueUserId(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserSecurityName", (Object)string2);
        }
        return string2;
    }

    public void initialize(Properties properties) throws CustomRegistryException {
        block24: {
            IdMap.IdEntry[] idEntryArray;
            Object object;
            String string;
            block23: {
                block22: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"initialize");
                    }
                    String string2 = "LDAP";
                    try {
                        this.ldapConfig = new LdapConfig(properties);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.initialize", (String)"1040", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.registry.ldap.initerror", (Object)new Object[]{exception});
                        throw new CustomRegistryException(exception.toString(), (Throwable)exception);
                    }
                    string = this.ldapConfig.getDirectoryUrl();
                    if (string == null || string.length() == 0) {
                        throw new CustomRegistryException("No Directory URL");
                    }
                    if (this.ldapConfig.getFilter(USER_FILTER) == null) {
                        throw new CustomRegistryException("No User Filter");
                    }
                    if (this.ldapConfig.getFilter(GROUP_FILTER) == null) {
                        throw new CustomRegistryException("No Group Filter");
                    }
                    int n = string.indexOf("://");
                    this.realm = string.endsWith(realmSeparator) ? string.substring(n + 3, string.length() - 1) : string.substring(n + 3, string.length());
                    this.idMap = new IdMap(this.ldapConfig);
                    this.certMap = new CertificateMapper();
                    try {
                        this.certMap.setLdapMapMode(properties.getProperty(CERTIFICATE_MAP_MODE));
                        this.certMap.setLdapFilterDescriptor(properties.getProperty(CERTIFICATE_MAP_FILTER));
                    }
                    catch (CertificateMapperException certificateMapperException) {
                        FFDCFilter.processException((Throwable)certificateMapperException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.initialize", (String)"1082", (Object)this);
                        if (!tc.isDebugEnabled()) break block22;
                        Tr.debug((TraceComponent)tc, (String)"initialize", (Object)certificateMapperException);
                    }
                }
                try {
                    int n = -1;
                    object = properties.getProperty("security.registry.ldap.searchTimeLimit");
                    if (object != null && ((String)object).length() > 0) {
                        n = new Integer((String)object);
                    }
                    if (n > 0) {
                        searchTimeLimit = n * 1000;
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block23;
                    Tr.debug((TraceComponent)tc, (String)"initialize", (Object)"will try for 2 minutes");
                }
            }
            try {
                idEntryArray = properties.getProperty("security.registry.ldap.reuseConn");
                if (idEntryArray.equalsIgnoreCase("false")) {
                    URLContextImpl = true;
                    LdapURL = string;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Use URL Context Implementation.");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            idEntryArray = this.idMap.getGroupMembers();
            if (idEntryArray.length > 0 && !registryExist) {
                recursiveSearch = this.ldapConfig.isRecursiveSearchEnabled();
                if (GROUP_ATTRIBUTES[0].equalsIgnoreCase(idEntryArray[0].getObjectClassName()) || GROUP_ATTRIBUTES[1].equalsIgnoreCase(idEntryArray[0].getObjectClassName())) {
                    objectFilter = iPlanet_OBJECT_FILTER;
                }
                try {
                    object = new InitialDirContext(this.ldapConfig);
                    DirContext dirContext = object.getSchema(NONE);
                    String string3 = "AttributeDefinition/" + idEntryArray[0].getObjectClassName();
                    DirContext dirContext2 = (DirContext)dirContext.lookup(string3);
                    useAttributeGroupMethod = true;
                    object.close();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found attribute of LDAP user object that specifies the distinguished name of those groups to which this user belongs.");
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block24;
                    Tr.debug((TraceComponent)tc, (String)"Will call getGroupsForUser() to get user's group memberships.");
                }
            }
        }
        registryExist = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidGroup(String string) throws CustomRegistryException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValidGroup");
        }
        try {
            try {
                bl = this.getEntry(string) != null;
                Object var4_7 = null;
            }
            catch (InvalidNameException invalidNameException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Invalid Group or Group does not exist : " + string));
                }
                Object var4_8 = null;
                if (!tc.isEntryEnabled()) return false;
                Tr.exit((TraceComponent)tc, (String)"isValidGroup");
                return false;
            }
            catch (NameNotFoundException nameNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Invalid Group or Group does not exist : " + string));
                }
                Object var4_9 = null;
                if (!tc.isEntryEnabled()) return false;
                Tr.exit((TraceComponent)tc, (String)"isValidGroup");
                return false;
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.isValidGroup", (String)"1146", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.registry.isvalidgroup.error", (Object)new Object[]{string, namingException});
                this.logNamingException(namingException, string);
                Object var4_10 = null;
                if (!tc.isEntryEnabled()) return false;
                Tr.exit((TraceComponent)tc, (String)"isValidGroup");
                return false;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.isValidGroup", (String)"1155", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.registry.isvalidgroup.error", (Object)new Object[]{string, exception});
                Object var4_11 = null;
                if (!tc.isEntryEnabled()) return false;
                Tr.exit((TraceComponent)tc, (String)"isValidGroup");
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var4_12 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"isValidGroup");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return bl;
        Tr.exit((TraceComponent)tc, (String)"isValidGroup");
        return bl;
    }

    public boolean isValidUser(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValidUser");
        }
        try {
            return this.getEntry(string) != null;
        }
        catch (InvalidNameException invalidNameException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Invalid User or User does not exist : " + string));
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Invalid User or User does not exist : " + string));
            }
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.isValidUser", (String)"1171", (Object)this);
            this.logNamingException(namingException, string);
            Tr.error((TraceComponent)tc, (String)"security.registry.isvaliduser.error", (Object)new Object[]{string, namingException});
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.isValidUser", (String)"1181", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.isvaliduser.error", (Object)new Object[]{string, exception});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isValidUser");
        }
        return false;
    }

    public String getRealm() throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRealm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRealm", (Object)this.realm);
        }
        return this.realm;
    }

    protected Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        NamingEnumeration namingEnumeration = this.search(string = LdapRegistryImpl.escapeChar(string, '*'), 0, objectFilter, stringArray, 0);
        if (namingEnumeration.hasMoreElements()) {
            Attributes attributes;
            block4: {
                attributes = ((SearchResult)namingEnumeration.nextElement()).getAttributes();
                if (namingEnumeration.hasMoreElements()) {
                    try {
                        namingEnumeration.close();
                    }
                    catch (NamingException namingException) {
                        if (!tc.isDebugEnabled()) break block4;
                        Tr.debug((TraceComponent)tc, (String)"Exception occurs while close NamingException.");
                    }
                }
            }
            return attributes;
        }
        return null;
    }

    protected String getEntry(String string) throws NamingException {
        String string2;
        block4: {
            EntryEnumeration entryEnumeration = this.search(string, 0, objectFilter, 0);
            string2 = null;
            if (entryEnumeration.hasMoreElements()) {
                string2 = (String)entryEnumeration.nextElement();
                if (entryEnumeration.hasMoreElements()) {
                    try {
                        entryEnumeration.close();
                    }
                    catch (NamingException namingException) {
                        if (!tc.isDebugEnabled()) break block4;
                        Tr.debug((TraceComponent)tc, (String)"Exception occurs while close NamingException.");
                    }
                }
            }
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getNormalizedDN(String string) throws NamingException {
        String string2 = null;
        EntryEnumeration entryEnumeration = null;
        int n = string.indexOf(44);
        if (n == -1) {
            n = string.indexOf(59);
        }
        if (n == -1) {
            try {
                string = LdapRegistryImpl.escapeChar(string, '*');
                entryEnumeration = this.search(string, 0, objectFilter, 0);
                if (!entryEnumeration.hasMoreElements()) return string2;
                string2 = (String)entryEnumeration.nextElement();
                if (!entryEnumeration.hasMoreElements()) return string2;
                entryEnumeration.close();
                return string2;
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getNormalizedDN", (String)"1242", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.registry.ldap.invalidID");
                this.logNamingException(namingException, string);
                throw namingException;
            }
        }
        try {
            int n2 = string.length();
            String string3 = string.substring(0, n);
            string3 = LdapRegistryImpl.escapeChar(string3, '*');
            String string4 = LdapRegistryImpl.escapeChar(string, '*');
            entryEnumeration = this.search(string4, 0, objectFilter, 0);
            String string5 = LdapRegistryImpl.normalizeDN(string);
            while (string2 == null && entryEnumeration.hasMoreElements()) {
                String string6 = (String)entryEnumeration.nextElement();
                String string7 = LdapRegistryImpl.normalizeDN(string6);
                if (!string7.equalsIgnoreCase(string5)) continue;
                string2 = string6;
            }
            if (!entryEnumeration.hasMoreElements()) return string2;
            entryEnumeration.close();
            return string2;
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getNormalizedDN", (String)"1278", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.ldap.invalidID");
            this.logNamingException(namingException, string);
            throw namingException;
        }
    }

    private boolean fullDN(String string) {
        return string.indexOf(61) > 0 && string.indexOf(44) > 0 || this.ldapConfig.getBaseDn().length() < 1 && string.indexOf(61) > 0;
    }

    protected EntryEnumeration search(int n, String string, int n2) throws NamingException {
        return this.search(this.ldapConfig.getBaseDn(), n, string, n2);
    }

    protected EntryEnumeration search(String string, int n, String string2, int n2) throws NamingException {
        return new EntryEnumeration(string, this.search(string, n, string2, noAttrs, n2));
    }

    protected NamingEnumeration search(String string, int n, String string2, String[] stringArray, int n2) throws NamingException {
        if (string.indexOf(47) > 0) {
            string = LdapRegistryImpl.escapeChar(string, '/');
        }
        if (string2.indexOf(47) > 0) {
            string2 = LdapRegistryImpl.escapeChar(string2, '/');
        }
        StringBuffer stringBuffer = null;
        long l = 0L;
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"search");
            stringBuffer = new StringBuffer("DN: ");
            stringBuffer.append(string);
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            stringBuffer = new StringBuffer("Search scope: ");
            stringBuffer.append(n);
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            stringBuffer = new StringBuffer("Filter: ");
            stringBuffer.append(string2);
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            stringBuffer = new StringBuffer("Time limit: ");
            stringBuffer.append(n2);
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer = new StringBuffer("Attr[");
                stringBuffer.append(i);
                stringBuffer.append("]: ");
                stringBuffer.append(stringArray[i]);
                Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            }
        }
        NamingException namingException = null;
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(n);
        searchControls.setReturningAttributes(stringArray);
        searchControls.setReturningObjFlag(false);
        if (n2 != 0) {
            searchControls.setCountLimit(n2);
        }
        searchControls.setTimeLimit(searchTimeLimit);
        String string3 = string;
        if (string3.indexOf(35) > -1) {
            string3 = LdapRegistryImpl.escapeFirstChar(string3, '#');
        }
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> namingEnumeration = null;
        for (int i = 0; i < 3; ++i) {
            try {
                l = System.currentTimeMillis();
                if (LdapURL == null) {
                    dirContext = this.getRootDSE();
                    namingEnumeration = dirContext.search(string3, string2, searchControls);
                    DirContextPool.addElement(dirContext);
                } else {
                    dirContext = new InitialDirContext(this.ldapConfig);
                    namingEnumeration = dirContext.search(string3, string2, searchControls);
                    dirContext.close();
                }
                if (tc.isDebugEnabled()) {
                    stringBuffer = new StringBuffer("Time elapsed: ");
                    stringBuffer = stringBuffer.append(System.currentTimeMillis() - l);
                    Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                    Tr.exit((TraceComponent)tc, (String)"search");
                }
                return namingEnumeration;
            }
            catch (NamingException namingException2) {
                if (tc.isDebugEnabled()) {
                    stringBuffer = new StringBuffer("Time elapsed: ");
                    stringBuffer = stringBuffer.append(System.currentTimeMillis() - l);
                    Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                }
                this.logNamingException(namingException2);
                try {
                    dirContext.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.disconnect();
                namingException = namingException2;
                continue;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"search");
        }
        FFDCFilter.processException(namingException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.search", (String)"1467", (Object)this);
        throw namingException;
    }

    public WSCredential createCredential(String string) throws CustomRegistryException, EntryNotFoundException, NotImplementedException, RemoteException {
        Object object;
        String string2;
        Object object2;
        Object[] objectArray;
        String[] stringArray;
        Object object3;
        String[] stringArray2;
        Object object4;
        String string3;
        String string4;
        Cloneable cloneable;
        WSCredential wSCredential;
        block40: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"createCredential", (Object)string);
            }
            wSCredential = null;
            cloneable = null;
            string4 = null;
            string3 = null;
            if (!useAttributeGroupMethod) {
                string4 = this.getUniqueUserId(string);
                if (string4 == null || string4.trim().length() <= 0) {
                    Tr.error((TraceComponent)tc, (String)"security.registry.createcredential.nouser", (Object)new Object[]{string});
                    throw new EntryNotFoundException("Cannot get accessID for user: " + string);
                }
                try {
                    string3 = this.getUserDisplayName(string4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                cloneable = this.getUniqueGroupIds(string4);
            } else {
                object4 = this.idMap.getGroupMembers();
                stringArray2 = new String[2];
                object3 = this.idMap.getAttributes();
                stringArray2[0] = object3[1];
                if (((IdMap.IdEntry[])object4).length > 0) {
                    stringArray2[1] = object4[0].getObjectClassName();
                }
                stringArray = new Vector(5);
                objectArray = null;
                String string5 = null;
                try {
                    string = LdapRegistryImpl.escapeChar(string, '*');
                    if (string.indexOf(61) >= 0 && string.indexOf(44) >= 0) {
                        object2 = this.search(string, 0, OBJECT_FILTER, stringArray2, 0);
                    } else {
                        string2 = this.ldapConfig.getFilter(USER_FILTER).prepare(string);
                        object2 = this.search(this.ldapConfig.getBaseDn(), 2, string2, stringArray2, 0);
                    }
                    if (object2.hasMoreElements()) {
                        Cloneable cloneable2;
                        string2 = object2.next();
                        object = (NameClassPair)((Object)string2);
                        String string6 = ((NameClassPair)object).getName();
                        if (string6 != null && string6.length() > 1 && string6.charAt(0) == '\"') {
                            string6 = string6.substring(1, string6.length() - 1);
                        }
                        if (string6 != null && string6.length() > 0 && ((NameClassPair)object).isRelative()) {
                            string = string6 + "," + this.ldapConfig.getBaseDn();
                        }
                        if (!((NameClassPair)object).isRelative() && string6 != null && string6.length() > 0) {
                            int n = string6.indexOf(47, 9);
                            if (n > -1 && string6.length() > n + 1) {
                                try {
                                    string6 = URLDecoder.decode(string6, "UTF8");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                string = string6.substring(n + 1);
                            } else {
                                string = NONE;
                            }
                        }
                        string4 = RegistryUtil.removeDNSpace(string, 0);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("uniqueUserId = " + string4));
                        }
                        SearchResult searchResult = (SearchResult)((Object)string2);
                        NamingEnumeration<? extends Attribute> namingEnumeration = searchResult.getAttributes().getAll();
                        while (namingEnumeration.hasMoreElements()) {
                            cloneable2 = namingEnumeration.next();
                            String string7 = cloneable2.getID();
                            if (string7.equalsIgnoreCase(stringArray2[0])) {
                                string3 = (String)cloneable2.get(0);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("displayName = " + string3));
                                continue;
                            }
                            if (!string7.equalsIgnoreCase(stringArray2[1])) continue;
                            for (int i = 0; i < cloneable2.size(); ++i) {
                                string5 = (String)cloneable2.get(i);
                                string5 = RegistryUtil.removeDNSpace(string5, 0);
                                stringArray.addElement(string5);
                            }
                        }
                        if (stringArray.size() > 0) {
                            objectArray = new String[stringArray.size()];
                            stringArray.copyInto(objectArray);
                            cloneable = new ArrayList<Object>(objectArray.length);
                            cloneable2 = new ArrayList();
                            if (recursiveSearch) {
                                this.getAllGroupMembershipsByUserObject(string4, (ArrayList)cloneable2, new ArrayList(), stringArray2[1]);
                                cloneable = cloneable2;
                            }
                            for (int i = 0; i < objectArray.length; ++i) {
                                cloneable.add(objectArray[i]);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("groups name = " + (String)objectArray[i]));
                            }
                        }
                        if (object2.hasMoreElements()) {
                            object2.close();
                        }
                        break block40;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"createCredential", (Object)("no users with name: " + string + " found"));
                    }
                    Tr.error((TraceComponent)tc, (String)"security.registry.createcredential.nouser", (Object)new Object[]{string});
                    throw new EntryNotFoundException("Cannot find the user: " + string);
                }
                catch (NamingException namingException) {
                    FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.createCredential", (String)"1366", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.registry.createcredential.error", (Object)new Object[]{string, namingException});
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"createCredential", (Object)namingException);
                    }
                    throw new EntryNotFoundException(namingException.toString(), (Throwable)namingException);
                }
            }
        }
        if (string3 == null || string3.trim().length() <= 0) {
            string3 = string4;
        }
        try {
            object4 = RegistryUtil.appendRealm(USERTYPE, string4, this.realm);
            stringArray2 = string4;
            object3 = new ArrayList();
            stringArray = null;
            objectArray = null;
            if (cloneable != null && cloneable.size() > 0) {
                stringArray = cloneable.toArray(new String[cloneable.size()]);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i == 0) {
                        objectArray = RegistryUtil.appendRealm(GROUPTYPE, stringArray[i], this.realm);
                    }
                    ((ArrayList)object3).add(RegistryUtil.appendRealm(GROUPTYPE, stringArray[i], this.realm));
                }
            }
            final String string8 = this.realm;
            object2 = string3;
            string2 = objectArray;
            object = object3;
            try {
                wSCredential = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((String)object2, (String)stringArray2, string2, (String)object4, (ArrayList)object){
                    private final /* synthetic */ String val$displayNamePriv;
                    private final /* synthetic */ String val$longSecurityName;
                    private final /* synthetic */ String val$primaryGroupIdPriv;
                    private final /* synthetic */ String val$accessId;
                    private final /* synthetic */ ArrayList val$groupListPriv;
                    {
                        this.val$displayNamePriv = string2;
                        this.val$longSecurityName = string3;
                        this.val$primaryGroupIdPriv = string4;
                        this.val$accessId = string5;
                        this.val$groupListPriv = arrayList;
                    }

                    public Object run() throws Exception {
                        return new WSCredentialImpl(string8, this.val$displayNamePriv, this.val$longSecurityName, this.val$primaryGroupIdPriv != null ? this.val$primaryGroupIdPriv : nullString, this.val$accessId, null, this.val$groupListPriv);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS cred.", (Object)new Object[]{privilegedActionException.getException()});
                }
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.createCredential", (String)"1714", (Object)this);
                throw privilegedActionException.getException();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.createCredential", (String)"1396", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.createcredential.error", (Object)new Object[]{string, exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createCredential", (Object)exception);
            }
            throw new EntryNotFoundException(exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCredential", (Object)string);
        }
        return wSCredential;
    }

    protected static String escapeChar(String string, char c) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                stringBuffer.append('\\').append(c2);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private static String escapeFirstChar(String string, char c) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        int n2 = 32;
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (i > 1) {
                n2 = string.charAt(i - 1);
            }
            if (c2 == c && n2 == 61) {
                stringBuffer.append('\\').append(c2);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private void logNamingException(NamingException namingException) {
        this.logNamingException(namingException, null);
    }

    private void logNamingException(NamingException namingException, String string) {
        if (string != null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("name = " + string));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)namingException.getMessage());
        }
        if (namingException.getExplanation() != null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)namingException.getExplanation());
        }
        if (namingException.getRootCause() != null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)namingException.getRootCause().getMessage(), (Object)namingException.getRootCause());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

