/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.AuthorizationTable;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfiguratorImpl;
import com.ibm.ws.security.role.RoleBasedModule;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;

class RoleBasedAuthorizerImpl
implements RoleBasedAuthorizer {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$role$RoleBasedAuthorizerImpl == null ? (class$com$ibm$ws$security$role$RoleBasedAuthorizerImpl = RoleBasedAuthorizerImpl.class$("com.ibm.ws.security.role.RoleBasedAuthorizerImpl")) : class$com$ibm$ws$security$role$RoleBasedAuthorizerImpl), null, (String)"com.ibm.ejs.resources.security");
    private String appName = null;
    private RoleBasedConfiguratorImpl configurator = null;
    public static final String PLUGGABLE_AUTHZN_PROPERTY = "com.ibm.websphere.security.authorizationTable";
    private AuthorizationTable pluggableAuthTable = null;
    private String cellName = null;
    private String serverName = null;
    private String pluggableAuthzTableName = null;
    private HashMap accessContext = new HashMap(3);
    private static final String userPrefix = "user:";
    private static final String groupPrefix = "group:";
    private static final ContextManager contextManager = ContextManagerFactory.getInstance();
    private static boolean ignoreCase = false;
    static /* synthetic */ Class class$com$ibm$ws$security$role$RoleBasedAuthorizerImpl;

    public RoleBasedAuthorizerImpl(String string, RoleBasedConfiguratorImpl roleBasedConfiguratorImpl) {
        this.appName = string;
        this.configurator = roleBasedConfiguratorImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RoleBasedAuthorizerImpl <String, RBC> constructor");
        }
        if (this.cellName == null && this.serverName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" Getting pluggable AuthTable");
            }
            this.pluggableAuthzTableName = contextManager.getProperty(PLUGGABLE_AUTHZN_PROPERTY, null);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Using local Pluggable AuthTable: " + this.pluggableAuthzTableName));
            }
            if (this.pluggableAuthzTableName != null && this.pluggableAuthzTableName.length() != 0) {
                try {
                    this.pluggableAuthTable = (AuthorizationTable)Class.forName(this.pluggableAuthzTableName).newInstance();
                    Tr.audit((TraceComponent)tc, (String)"security.wsaccessmanager.classloaded", (Object)new Object[]{this.pluggableAuthzTableName});
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.RoleBasedAuthorizerImpl", (String)"96", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.classnotfound", (Object)new Object[]{this.pluggableAuthzTableName});
                }
                catch (InstantiationException instantiationException) {
                    FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.security.role.RleBasedAuthorizerImpl.RoleBasedAuthorizerImpl", (String)"99", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.instantiationerror", (Object)new Object[]{this.pluggableAuthzTableName});
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.RoleBasedAuthorizerImpl", (String)"103", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.classloading", (Object)new Object[]{this.pluggableAuthzTableName});
                }
                if (this.pluggableAuthTable == null) {
                    Tr.audit((TraceComponent)tc, (String)"security.wsaccessmanager.classloadingaudit", (Object)new Object[]{this.pluggableAuthzTableName});
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Pluggable AuthTable was not loaded!");
            }
            this.cellName = (String)SecurityConfig.getConfig().getValue("security.activeUserRegistry.realm");
            this.serverName = (String)SecurityConfig.getConfig().getValue("process.serverName");
            this.accessContext.put("APPLICATION_NAME", this.appName);
            this.accessContext.put("SERVER_NAME", this.serverName);
            this.accessContext.put("CELL_NAME", this.cellName);
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.registry.IgnoreCase");
            if (bl != null && bl.booleanValue()) {
                ignoreCase = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ignoreCase is set");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RoleBasedAuthorizerImpl <String, RBC> constructor");
        }
    }

    public boolean checkAccess(String string, String string2, String string3) {
        String string4;
        String string5;
        boolean bl;
        block44: {
            bl = false;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("checkAccess, methodName:" + string3 + " resourceName: " + string2 + " moduleName: " + string));
            }
            string5 = null;
            string4 = null;
            try {
                Subject subject;
                Subject subject2;
                HashSet hashSet;
                block41: {
                    RoleBasedModule roleBasedModule = this.configurator.getRoleBasedModule(this.appName, string);
                    hashSet = roleBasedModule.getRequiredRoles(string2 + ":" + string3);
                    if (this.configurator.getRoleBasedSubjectMap(this.appName).isEveryoneGranted(hashSet)) {
                        return true;
                    }
                    subject2 = null;
                    subject = null;
                    try {
                        subject2 = contextManager.getCallerSubject();
                        subject = contextManager.getInvocationSubject();
                    }
                    catch (WSSecurityException wSSecurityException) {
                        FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", (String)"88", (Object)this);
                        if (!tc.isDebugEnabled()) break block41;
                        Tr.debug((TraceComponent)tc, (String)("Exception getting invocation credential " + (Object)((Object)wSSecurityException)));
                    }
                }
                String[] stringArray = null;
                WSPrincipal wSPrincipal = null;
                WSCredential wSCredential = null;
                WSCredential wSCredential2 = null;
                if (subject != null) {
                    wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                }
                if (subject2 != null) {
                    wSCredential2 = SubjectHelper.getWSCredentialFromSubject((Subject)subject2);
                }
                if (wSCredential != null && wSCredential.isUnauthenticated() && wSCredential2 != null && wSCredential2.isUnauthenticated()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"either invocation or received cred are UNAUTHENTICATED!");
                    }
                    string5 = ContextManagerFactory.getInstance().getUnauthenticatedString();
                } else {
                    ArrayList arrayList;
                    if (wSCredential2 != null && !wSCredential2.isUnauthenticated()) {
                        block42: {
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"getting received subject");
                                    Tr.debug((TraceComponent)tc, (String)("received cred type is: " + wSCredential2.getClass()));
                                }
                                string4 = wSCredential2.getRealmSecurityName();
                                string5 = wSCredential2.getAccessId();
                                arrayList = wSCredential2.getGroupIds();
                                stringArray = arrayList.toArray(new String[arrayList.size()]);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("securityname = " + string4 + " accessId = " + string5));
                                }
                            }
                            catch (GeneralSecurityException generalSecurityException) {
                                FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", (String)"146", (Object)this);
                                if (!tc.isDebugEnabled()) break block42;
                                Tr.debug((TraceComponent)tc, (String)("checkAccess: failed to retrieve credential " + this.dump(generalSecurityException)));
                            }
                        }
                        if (this.pluggableAuthTable != null) {
                            wSPrincipal = this.createPrincipal(subject2);
                        }
                    }
                    if ((wSCredential2 == null || string5 == null || string5.equals("")) && wSCredential != null && !wSCredential.isUnauthenticated()) {
                        block43: {
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"getting invocation credential");
                                }
                                string4 = wSCredential.getRealmSecurityName();
                                string5 = wSCredential.getAccessId();
                                arrayList = wSCredential.getGroupIds();
                                stringArray = arrayList.toArray(new String[arrayList.size()]);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("securityname = " + string4 + " accessId = " + string5));
                                }
                            }
                            catch (GeneralSecurityException generalSecurityException) {
                                FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", (String)"111", (Object)this);
                                if (!tc.isDebugEnabled()) break block43;
                                Tr.debug((TraceComponent)tc, (String)("bad invocation credential " + this.dump(generalSecurityException)));
                            }
                        }
                        if (this.pluggableAuthTable != null) {
                            wSPrincipal = this.createPrincipal(subject);
                        }
                    }
                    if (wSCredential == null && wSCredential2 == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"invocation and received cred are both null!");
                        }
                        try {
                            throw new Exception("dump thread stack for debugging");
                        }
                        catch (Exception exception) {
                            Tr.error((TraceComponent)tc, (String)"security.rolebauthz.nocred", (Object)new Object[]{string3, string2, string, exception});
                            string5 = "NO_CRED_NO_ACCESS_ID";
                        }
                    } else if (string5 == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"invocation or received creds exist but the accessId is null!");
                        }
                        string5 = "NULL_ACCESS_ID";
                    }
                }
                if (ignoreCase) {
                    string5 = string5.toLowerCase();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("accessId: " + string5));
                }
                if (this.pluggableAuthTable != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"pluggable table is NOT Null ... Calling checkAccess with 4 parms");
                    }
                    if (this.checkAccess(string, string2, string3, (Principal)wSPrincipal)) {
                        bl = true;
                    }
                    break block44;
                }
                if (this.configurator.getRoleBasedSubjectMap(this.appName).isGrantedAnyRole(string5, hashSet)) {
                    bl = true;
                    break block44;
                }
                if (stringArray == null) break block44;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (ignoreCase) {
                        stringArray[i] = stringArray[i].toLowerCase();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("groupId: " + stringArray[i]));
                    }
                    if (!this.configurator.getRoleBasedSubjectMap(this.appName).isGroupGrantedAnyRole(stringArray[i], hashSet)) continue;
                    bl = true;
                    break;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", (String)"231", (Object)this);
                if (!tc.isDebugEnabled()) break block44;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception caught: ", (Object)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkAccess, result:" + bl));
        }
        if (!bl) {
            Tr.audit((TraceComponent)tc, (String)"security.rolebauthz.authzfail", (Object)new Object[]{string4, string5, string3, string2, string});
        }
        return bl;
    }

    private boolean checkAccess(String string, String string2, String string3, Principal principal) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkAccess " + string + " " + string2 + ":" + string3 + " by " + principal));
        }
        try {
            RoleBasedModule roleBasedModule = this.configurator.getRoleBasedModule(this.appName, string);
            HashSet hashSet = roleBasedModule.getRequiredRoles(string2 + ":" + string3);
            int n = hashSet.size();
            String[] stringArray = hashSet.toArray(new String[n]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set size is: " + n));
                for (int i = 0; i < n; ++i) {
                    Tr.debug((TraceComponent)tc, (String)("Required Role<" + i + ">: " + stringArray[i]));
                }
                Tr.debug((TraceComponent)tc, (String)"Calling PlugAuthTable.isEveryoneGranted");
            }
            if (this.pluggableAuthTable.isEveryoneGranted(this.accessContext, stringArray)) {
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling PlugAuthTable.isGrantedAnyRole");
            }
            return this.pluggableAuthTable.isGrantedAnyRole(this.accessContext, stringArray, principal);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", (String)"369", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception caught within checkAccess, access denied");
                exception.printStackTrace();
            }
            return false;
        }
    }

    public boolean isCallerInRole(String string) {
        boolean bl;
        block46: {
            bl = false;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("isCallerInRole(" + string + ")"));
            }
            if (string == null) {
                Tr.error((TraceComponent)tc, (String)"security.roleref.configerror", (Object)new Object[]{string});
                return false;
            }
            String string2 = null;
            String string3 = null;
            try {
                AbstractCollection abstractCollection;
                Subject subject;
                Subject subject2;
                block43: {
                    subject2 = null;
                    subject = null;
                    try {
                        subject2 = contextManager.getCallerSubject();
                        subject = contextManager.getInvocationSubject();
                    }
                    catch (WSSecurityException wSSecurityException) {
                        FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", (String)"415", (Object)this);
                        if (!tc.isDebugEnabled()) break block43;
                        Tr.debug((TraceComponent)tc, (String)("Exception getting invocation credential " + (Object)((Object)wSSecurityException)));
                    }
                }
                String[] stringArray = null;
                WSPrincipal wSPrincipal = null;
                WSCredential wSCredential = null;
                WSCredential wSCredential2 = null;
                if (subject != null) {
                    wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                }
                if (subject2 != null) {
                    wSCredential2 = SubjectHelper.getWSCredentialFromSubject((Subject)subject2);
                }
                if (wSCredential2 != null) {
                    block44: {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"getting received credential");
                                Tr.debug((TraceComponent)tc, (String)("received Credential type is: " + wSCredential2.getClass()));
                            }
                            if (wSCredential2.isBasicAuth()) {
                                wSCredential2 = contextManager.authenticate(wSCredential2);
                            }
                            string3 = wSCredential2.getRealmSecurityName();
                            string2 = wSCredential2.getAccessId();
                            abstractCollection = wSCredential2.getGroupIds();
                            stringArray = abstractCollection.toArray(new String[abstractCollection.size()]);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("securityname = " + string3 + " accessId = " + string2));
                            }
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", (String)"146", (Object)this);
                            if (!tc.isDebugEnabled()) break block44;
                            Tr.debug((TraceComponent)tc, (String)("checkAccess: failed to retrieve credential " + this.dump(generalSecurityException)));
                        }
                    }
                    if (this.pluggableAuthTable != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"pluggable table is NOT null. \n  Calling createPrincipal with receivedCred");
                        }
                        wSPrincipal = this.createPrincipal(subject2);
                    }
                }
                if ((wSCredential2 == null || string2 == null || string2.equals("")) && wSCredential != null) {
                    block45: {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"getting invocation credential");
                            }
                            if (wSCredential.isBasicAuth()) {
                                wSCredential = contextManager.authenticate(wSCredential);
                            }
                            string3 = wSCredential.getRealmSecurityName();
                            string2 = wSCredential.getAccessId();
                            abstractCollection = wSCredential.getGroupIds();
                            stringArray = abstractCollection.toArray(new String[abstractCollection.size()]);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("securityname = " + string3 + " accessId = " + string2));
                            }
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", (String)"111", (Object)this);
                            if (!tc.isDebugEnabled()) break block45;
                            Tr.debug((TraceComponent)tc, (String)("bad invocation credential " + this.dump(generalSecurityException)));
                        }
                    }
                    if (this.pluggableAuthTable != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"pluggable table is NOT null. \n  Calling createPrincipal with invocationCred");
                        }
                        wSPrincipal = this.createPrincipal(subject);
                    }
                }
                if (wSCredential == null && wSCredential2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"invocation and received cred are both null!");
                    }
                    try {
                        throw new Exception("dump thread stack for debugging");
                    }
                    catch (Exception exception) {
                        Tr.error((TraceComponent)tc, (String)"security.rolebauthz.nocred2", (Object)new Object[]{string, exception});
                        string2 = "NO_CRED_NO_ACCESS_ID";
                    }
                } else if (wSCredential != null && wSCredential.isUnauthenticated() || wSCredential2 != null && wSCredential2.isUnauthenticated()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"either invocation or received cred are UNAUTHENTICATED!");
                    }
                    string2 = ContextManagerFactory.getInstance().getUnauthenticatedString();
                } else if (string2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"invocation or received creds exist but the accessId is null!");
                    }
                    string2 = "NULL_ACCESS_ID";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("accessId: " + string2));
                }
                if (this.pluggableAuthTable != null) {
                    if (this.pluggableAuthTable.isGrantedRole(this.accessContext, string, (Principal)wSPrincipal)) {
                        bl = true;
                    }
                    break block46;
                }
                abstractCollection = new HashSet(1);
                ((HashSet)abstractCollection).add(string);
                if (ignoreCase) {
                    string2 = string2.toLowerCase();
                }
                if (this.configurator.getRoleBasedSubjectMap(this.appName).isGrantedAnyRole(string2, (Set)((Object)abstractCollection))) {
                    bl = true;
                    break block46;
                }
                if (stringArray == null) break block46;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("groupId: " + stringArray[i]));
                    }
                    if (ignoreCase) {
                        stringArray[i] = stringArray[i].toLowerCase();
                    }
                    if (!this.configurator.getRoleBasedSubjectMap(this.appName).isGroupGrantedAnyRole(stringArray[i], (Set)((Object)abstractCollection))) continue;
                    bl = true;
                    break;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.isCallerInRole", (String)"495", (Object)this);
                if (!tc.isDebugEnabled()) break block46;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception caught: ", (Object)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isCallerInRole, result:" + bl));
        }
        return bl;
    }

    public boolean isGrantedRole(String[] stringArray, Subject subject) {
        String string;
        String string2;
        boolean bl;
        block20: {
            bl = false;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"isGrantedRole()");
            }
            if (stringArray == null) {
                Tr.error((TraceComponent)tc, (String)"security.roleref.configerror", (Object)new Object[]{stringArray});
                return false;
            }
            if (tc.isDebugEnabled()) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Tr.debug((TraceComponent)tc, (String)("isGrantedRole(roleName[" + i + "] = " + stringArray[i] + ")"));
                }
            }
            if (subject == null) {
                Tr.error((TraceComponent)tc, (String)"security.roleref.configerror", (Object)new Object[]{"subject is null"});
                return false;
            }
            string2 = null;
            string = null;
            String[] stringArray2 = null;
            WSPrincipal wSPrincipal = null;
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
            try {
                int n;
                string2 = wSCredential.getAccessId();
                string = wSCredential.getRealmSecurityName();
                ArrayList arrayList = wSCredential.getGroupIds();
                stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                if (this.pluggableAuthTable != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"pluggable table is NOT null. \n  Calling createPrincipal with authCreds");
                    }
                    wSPrincipal = this.createPrincipal(subject);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("accessId: " + string2));
                }
                if (this.pluggableAuthTable != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!this.pluggableAuthTable.isGrantedRole(this.accessContext, stringArray[i], (Principal)wSPrincipal)) continue;
                        bl = true;
                    }
                    break block20;
                }
                HashSet<String> hashSet = new HashSet<String>(stringArray.length);
                for (n = 0; n < stringArray.length; ++n) {
                    hashSet.add(stringArray[n]);
                }
                if (ignoreCase) {
                    string2 = string2.toLowerCase();
                }
                if (this.configurator.getRoleBasedSubjectMap(this.appName).isGrantedAnyRole(string2, hashSet)) {
                    bl = true;
                    break block20;
                }
                if (stringArray2 == null) break block20;
                n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("groupId: " + stringArray2[i]));
                    }
                    if (ignoreCase) {
                        stringArray2[i] = stringArray2[i].toLowerCase();
                    }
                    if (!this.configurator.getRoleBasedSubjectMap(this.appName).isGroupGrantedAnyRole(stringArray2[i], hashSet)) continue;
                    bl = true;
                    break;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.isGrantedRole", (String)"579", (Object)this);
                if (!tc.isDebugEnabled()) break block20;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception caught: ", (Object)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isGrantedRole, result:" + bl));
        }
        if (!bl) {
            Tr.audit((TraceComponent)tc, (String)"security.rolebauthz.iscallerinrolefail", (Object)new Object[]{string, string2, stringArray});
        }
        return bl;
    }

    private String dump(Throwable throwable) {
        if (throwable instanceof WSSecurityException) {
            return throwable.toString();
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private WSPrincipal createPrincipal(Subject subject) throws GeneralSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createWASPrincipal");
        }
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
        WSPrincipal wSPrincipal = ContextManagerFactory.getInstance().createPrincipal(wSCredential);
        return wSPrincipal;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

