/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.rolebasedauthz.AuthorizationTableExt;
import com.ibm.websphere.models.config.rolebasedauthz.GroupExt;
import com.ibm.websphere.models.config.rolebasedauthz.RoleAssignmentExt;
import com.ibm.websphere.models.config.rolebasedauthz.RolebasedauthzFactory;
import com.ibm.websphere.models.config.rolebasedauthz.SecurityRoleExt;
import com.ibm.websphere.models.config.rolebasedauthz.UserExt;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.role.DescriptorConversionException;
import com.ibm.ws.security.role.DescriptorParseException;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedAuthorizerImpl;
import com.ibm.ws.security.role.RoleBasedAuthorizerNullImpl;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedModule;
import com.ibm.ws.security.role.RoleBasedSubjectMap;
import com.ibm.ws.security.role.RolePermissionDescriptorLoader;
import com.ibm.ws.security.role.RolePermissionFromMBean;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.modelmbean.ModelMBeanInfo;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.xml.sax.InputSource;

public class RoleBasedConfiguratorImpl
implements RoleBasedConfigurator {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$role$RoleBasedConfiguratorImpl == null ? (class$com$ibm$ws$security$role$RoleBasedConfiguratorImpl = RoleBasedConfiguratorImpl.class$("com.ibm.ws.security.role.RoleBasedConfiguratorImpl")) : class$com$ibm$ws$security$role$RoleBasedConfiguratorImpl), null, (String)"com.ibm.ejs.resources.security");
    private static final String CONTACT_INFO = "WebSphere Security";
    private static final String userPrefix = "user:";
    private static final String groupPrefix = "group:";
    private boolean securityEnabled = true;
    private RoleBasedAuthorizerNullImpl nullAuthorizer = null;
    private UserRegistry registry = null;
    private RolebasedauthzFactory rbaFact = null;
    private WorkSpace workspace = null;
    private String serverId = null;
    private String longServerId = null;
    private static boolean ignoreCase = false;
    private static boolean isLDAPRegistry = false;
    private HashMap applications = new HashMap(4);
    static /* synthetic */ Class class$com$ibm$ws$security$role$RoleBasedConfiguratorImpl;

    public RoleBasedConfiguratorImpl() {
        this.InitializeFactories();
        this.InitializeServerId();
    }

    private void InitializeServerId() {
        block21: {
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.enabled");
            Boolean bl2 = (Boolean)SecurityConfig.getConfig().getValue("security.registry.IgnoreCase");
            if (bl2 != null && bl2.booleanValue()) {
                ignoreCase = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ignoreCase is set");
                }
            }
            SecurityConfig.getConfig();
            if (SecurityConfig.isRegLDAP()) {
                isLDAPRegistry = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"User registry type is LDAP");
                }
            }
            try {
                if (bl != null && bl.booleanValue()) {
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    if (contextManager != null) {
                        try {
                            this.registry = contextManager.getRegistry(contextManager.getDefaultRealm());
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.role.RoleBasedConfiguratorImpl.InitializeServerid", (String)"155", (Object)this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Failed to get registry from ContextManager");
                            }
                            Tr.error((TraceComponent)tc, (String)"security.sambean.urerr", (Object)new Object[]{exception});
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Failed to get ContextManager");
                        }
                        Tr.error((TraceComponent)tc, (String)"security.sambean.nullsecserver");
                    }
                    WSCredential wSCredential = contextManager.getServerCredential();
                    if (wSCredential != null) {
                        this.serverId = wSCredential.getRealmSecurityName();
                        if (this.serverId != null && ignoreCase) {
                            this.serverId = this.serverId.toLowerCase();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("serverId =  " + this.serverId));
                        }
                        this.longServerId = wSCredential.getAccessId();
                        if (this.longServerId != null && ignoreCase) {
                            this.longServerId = this.longServerId.toLowerCase();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("longServerId =  " + this.longServerId));
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Failed to get serverCreds");
                        }
                        Tr.error((TraceComponent)tc, (String)"security.sambean.nullsecserver");
                    }
                } else {
                    this.securityEnabled = false;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.role.RoleBasedConfiguratorImpl.setSecurityServer", (String)"182", (Object)this);
                if (!tc.isDebugEnabled()) break block21;
                Tr.debug((TraceComponent)tc, (String)("failed to form serverId" + throwable.getMessage()));
            }
        }
    }

    private void InitializeFactories() {
        this.rbaFact = (RolebasedauthzFactory)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi").getEFactoryInstance();
    }

    public void loadApplication(String string, Resource resource) throws RoleBasedAppException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadApplication", (Object)string);
        }
        if (!this.securityEnabled) {
            if (this.nullAuthorizer == null) {
                this.nullAuthorizer = new RoleBasedAuthorizerNullImpl();
            }
            return;
        }
        if (this.applications.containsKey(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Warning: " + string + " already loaded"));
            }
            return;
        }
        EList eList = resource.getContents();
        Iterator iterator = eList.iterator();
        AuthorizationTableExt authorizationTableExt = null;
        while (iterator.hasNext()) {
            authorizationTableExt = (AuthorizationTableExt)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("AuthorizationTableExt context " + authorizationTableExt.getContext()));
            }
            if (!authorizationTableExt.getContext().equals("domain")) continue;
        }
        if (authorizationTableExt == null || !authorizationTableExt.getContext().equals("domain")) {
            throw new RoleBasedAppException("cell level AuthorizationTable not found");
        }
        this.fillMissingAccessIds(authorizationTableExt, string);
        EList eList2 = authorizationTableExt.getRoles();
        RoleBasedSubjectMap roleBasedSubjectMap = new RoleBasedSubjectMap(string, (List)authorizationTableExt.getRoles(), this.serverId, this.longServerId);
        EList eList3 = authorizationTableExt.getAuthorizations();
        iterator = eList3.iterator();
        while (iterator.hasNext()) {
            object = (RoleAssignmentExt)iterator.next();
            roleBasedSubjectMap.addSpecialSubjects(object.getRole().getRoleName(), (List)object.getSpecialSubjects());
            roleBasedSubjectMap.addSubjects(object.getRole().getRoleName(), (List)object.getUsers());
            roleBasedSubjectMap.addSubjectGroups(object.getRole().getRoleName(), (List)object.getGroups());
        }
        roleBasedSubjectMap.pack();
        object = new RoleBasedAuthorizerImpl(string, this);
        RoleBasedApplication roleBasedApplication = new RoleBasedApplication(roleBasedSubjectMap, (RoleBasedAuthorizerImpl)object);
        this.applications.put(string, roleBasedApplication);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadApplication", (Object)string);
        }
    }

    public Set getApplications() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getApplications");
        }
        if (this.applications.isEmpty()) {
            return null;
        }
        HashSet hashSet = new HashSet(this.applications.keySet());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getApplications");
        }
        return hashSet;
    }

    public RoleBasedAuthorizer getRoleBasedAuthorizer(String string, String string2) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRoleBasedAuthorizer", (Object)new Object[]{string, string2});
        }
        if (!this.securityEnabled) {
            return this.nullAuthorizer;
        }
        if (!this.applications.containsKey(string)) {
            Tr.error((TraceComponent)tc, (String)"security.roleauthz.appnoload", (Object)new Object[]{string});
            throw new RoleBasedAppException(string + " not loaded yet");
        }
        return ((RoleBasedApplication)this.applications.get(string)).rbAuthzer;
    }

    public RoleBasedAuthorizer loadSecurityPolicy(String string, ModelMBeanInfo modelMBeanInfo, InputSource inputSource, String string2) throws RoleBasedAppException, DescriptorConversionException, DescriptorParseException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("loadSecurityPolicy - MBean " + string));
        }
        if (!this.securityEnabled) {
            return this.nullAuthorizer;
        }
        if (!this.applications.containsKey(string)) {
            Tr.error((TraceComponent)tc, (String)"security.roleauthz.appnoload", (Object)new Object[]{string});
            throw new RoleBasedAppException(string + " not loaded yet");
        }
        RoleBasedModule roleBasedModule = null;
        String string3 = null;
        try {
            string3 = (String)modelMBeanInfo.getMBeanDescriptor().getFieldValue("type");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.role.RoleBasedConfiguratorImpl.loadSecurityPolicy", (String)"246", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"loadSecurityPolicy: cannot get module name ");
            }
            throw new RoleBasedAppException("cannot get module name");
        }
        if (inputSource != null) {
            try {
                object = new RolePermissionDescriptorLoader();
                roleBasedModule = ((RolePermissionDescriptorLoader)object).loadDescriptor(inputSource, string3, (Object)this);
            }
            catch (DescriptorParseException descriptorParseException) {
                FFDCFilter.processException((Throwable)descriptorParseException, (String)"com.ibm.ws.security.role.RoleBasedConfiguratorImpl.loadSecurityPolicy", (String)"240", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("loadSecurityPolicy: cannot load " + string3));
                }
                throw descriptorParseException;
            }
        }
        if (roleBasedModule == null && modelMBeanInfo != null) {
            object = new RolePermissionFromMBean();
            roleBasedModule = ((RolePermissionFromMBean)object).convert(modelMBeanInfo);
        }
        if (!((RoleBasedApplication)this.applications.get(string)).modules.containsKey(roleBasedModule.getModuleName())) {
            ((RoleBasedApplication)this.applications.get(string)).modules.put(roleBasedModule.getModuleName(), roleBasedModule);
        } else {
            Tr.warning((TraceComponent)tc, (String)"security.roleauthz.appalreadyload", (Object)new Object[]{roleBasedModule.getModuleName()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadSecurityPolicy - MBean", (Object)string);
        }
        return ((RoleBasedApplication)this.applications.get(string)).rbAuthzer;
    }

    public RoleBasedAuthorizer loadSecurityPolicy(String string, String string2, String string3) throws RoleBasedAppException, DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadSecurityPolicy", (Object)string);
        }
        if (!this.securityEnabled) {
            return this.nullAuthorizer;
        }
        if (!this.applications.containsKey(string)) {
            Tr.error((TraceComponent)tc, (String)"security.roleauthz.appnoload", (Object)new Object[]{string});
            throw new RoleBasedAppException(string + " not loaded yet");
        }
        RoleBasedModule roleBasedModule = null;
        if (string2 != null) {
            try {
                RolePermissionDescriptorLoader rolePermissionDescriptorLoader = new RolePermissionDescriptorLoader();
                roleBasedModule = rolePermissionDescriptorLoader.loadDescriptor(string2, null, (Object)this);
            }
            catch (DescriptorParseException descriptorParseException) {
                FFDCFilter.processException((Throwable)descriptorParseException, (String)"com.ibm.ws.security.role.RoleBasedConfiguratorImpl.loadSecurityPolicy", (String)"281", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("loadSecurityPolicy: cannot load " + string2));
                }
                throw descriptorParseException;
            }
        }
        if (!((RoleBasedApplication)this.applications.get(string)).modules.containsKey(roleBasedModule.getModuleName())) {
            ((RoleBasedApplication)this.applications.get(string)).modules.put(roleBasedModule.getModuleName(), roleBasedModule);
        } else {
            Tr.warning((TraceComponent)tc, (String)"security.roleauthz.appalreadyload", (Object)new Object[]{roleBasedModule.getModuleName()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadSecurityPolicy", (Object)string);
        }
        return ((RoleBasedApplication)this.applications.get(string)).rbAuthzer;
    }

    public AuthorizationTableExt getAuthorizationTable(String string, String string2) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAuthorizationTable", (Object)(string + " : " + string2));
        }
        return this.getReadWriteAuthorizationTable(string, string2);
    }

    public AuthorizationTableExt getReadOnlyAuthorizationTable(String string, String string2) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getReadOnlyAuthorizationTable", (Object)(string + " : " + string2));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationTableExt getReadWriteAuthorizationTable(String string, String string2) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getReadWriteAuthorizationTable", (Object)(string + " : " + string2));
        }
        try {
            if (this.workspace == null) {
                this.workspace = WorkSpaceManagerFactory.getManager().getWorkSpace("cyc");
                if (this.workspace == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"workspace is null");
                    }
                    return null;
                }
            }
            WorkSpace workSpace = this.workspace;
            synchronized (workSpace) {
                String string3 = AdminServiceFactory.getAdminService().getCellName();
                RepositoryContext repositoryContext = this.workspace.findContext("cells/" + string3);
                if (repositoryContext == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"cellContext is null");
                    }
                    return null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Adding cell ResourceSet: " + repositoryContext.getName()));
                }
                repositoryContext.extract(string + ".xml", true);
                Resource resource = repositoryContext.getResourceSet().getResource(URI.createURI((String)(string + ".xml")), true);
                if (resource == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"resource is null");
                    }
                    return null;
                }
                EList eList = resource.getContents();
                Iterator iterator = eList.iterator();
                AuthorizationTableExt authorizationTableExt = null;
                while (iterator.hasNext()) {
                    authorizationTableExt = (AuthorizationTableExt)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("AuthorizationTableExt context = " + authorizationTableExt.getContext()));
                    }
                    if (!authorizationTableExt.getContext().equals("domain")) continue;
                }
                if (authorizationTableExt == null || !authorizationTableExt.getContext().equals("domain")) {
                    throw new RoleBasedAppException("cell level AuthorizationTable not found");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"AuthorizationTableExt = ", (Object)new Object[]{authorizationTableExt});
                }
                return authorizationTableExt;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.role.RoleBasedConfiguratorImpl.getReadWriteAuthorizationTable", (String)"361", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception caught");
                throwable.printStackTrace();
            }
            throw new RoleBasedAppException("loading cell level AuthorizationTable failed");
        }
    }

    public RoleBasedModule getRoleBasedModule(String string, String string2) throws RoleBasedAppException {
        if (!this.applications.containsKey(string)) {
            throw new RoleBasedAppException(string + " not found");
        }
        return (RoleBasedModule)((RoleBasedApplication)this.applications.get(string)).modules.get(string2);
    }

    public RoleBasedSubjectMap getRoleBasedSubjectMap(String string) throws RoleBasedAppException {
        if (!this.applications.containsKey(string)) {
            throw new RoleBasedAppException(string + " not found");
        }
        return ((RoleBasedApplication)this.applications.get(string)).subjectMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthorizationTable(String string, AuthorizationTableExt authorizationTableExt, String string2) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addAuthorizationTable", (Object)(string + " : " + string2));
        }
        if (authorizationTableExt == null || string2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Either AuthorizationTableExt = " + authorizationTableExt + " or scope is not specified, scope = " + string2));
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("AuthorizationTableExt context = " + authorizationTableExt.getContext()));
            Tr.debug((TraceComponent)tc, (String)("adding to scope = " + string2));
        }
        if (!string2.equals("domain")) {
            throw new RoleBasedAppException("Invalid scope: " + string2);
        }
        authorizationTableExt.setContext(string2);
        try {
            if (this.workspace == null) {
                this.workspace = WorkSpaceManagerFactory.getManager().getWorkSpace("cyc");
                if (this.workspace == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"workspace is null");
                    }
                    return;
                }
            }
            WorkSpace workSpace = this.workspace;
            synchronized (workSpace) {
                String string3 = AdminServiceFactory.getAdminService().getCellName();
                RepositoryContext repositoryContext = this.workspace.findContext("cells/" + string3);
                if (repositoryContext == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"cellContext is null");
                    }
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Adding cell ResourceSet: " + repositoryContext.getName()));
                }
                repositoryContext.extract(string + ".xml", true);
                Resource resource = repositoryContext.getResourceSet().getResource(URI.createURI((String)(string + ".xml")), true);
                if (resource == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"resource is null");
                    }
                    return;
                }
                EList eList = resource.getContents();
                Iterator iterator = eList.iterator();
                AuthorizationTableExt authorizationTableExt2 = null;
                while (iterator.hasNext()) {
                    authorizationTableExt2 = (AuthorizationTableExt)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("AuthorizationTableExt context = " + authorizationTableExt2.getContext()));
                    }
                    if (!authorizationTableExt2.getContext().equals(authorizationTableExt.getContext())) continue;
                    iterator.remove();
                    break;
                }
                ((BasicEList)eList).add((Object)authorizationTableExt);
                HashMap hashMap = new HashMap();
                this.workspace.synch(repositoryContext, hashMap);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.role.RoleBasedConfiguratorImpl.addAuthorizationTable", (String)"446", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception caught");
                throwable.printStackTrace();
            }
            throw new RoleBasedAppException("modifying cell level AuthorizationTable failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addAuthorizationTable", (Object)(string + " : " + string2));
        }
    }

    public void deleteAuthorizationTable(String string, String string2) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteAuthorizationTable", (Object)(string + " : " + string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteAuthorizationTable", (Object)(string + " : " + string2));
        }
    }

    private void AddAdminSecurityRoleExt(AuthorizationTableExt authorizationTableExt) {
        RolebasedauthzFactory rolebasedauthzFactory = (RolebasedauthzFactory)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi").getEFactoryInstance();
        SecurityRoleExt securityRoleExt = rolebasedauthzFactory.createSecurityRoleExt();
        securityRoleExt.setRoleName("administrator");
        authorizationTableExt.getRoles().add((Object)securityRoleExt);
        SecurityRoleExt securityRoleExt2 = rolebasedauthzFactory.createSecurityRoleExt();
        securityRoleExt2.setRoleName("operator");
        authorizationTableExt.getRoles().add((Object)securityRoleExt2);
        SecurityRoleExt securityRoleExt3 = rolebasedauthzFactory.createSecurityRoleExt();
        securityRoleExt3.setRoleName("configurator");
        authorizationTableExt.getRoles().add((Object)securityRoleExt3);
        SecurityRoleExt securityRoleExt4 = rolebasedauthzFactory.createSecurityRoleExt();
        securityRoleExt4.setRoleName("monitor");
        authorizationTableExt.getRoles().add((Object)securityRoleExt4);
    }

    private void AddNamingSecurityRoleExt(AuthorizationTableExt authorizationTableExt) {
        RolebasedauthzFactory rolebasedauthzFactory = (RolebasedauthzFactory)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi").getEFactoryInstance();
        SecurityRoleExt securityRoleExt = rolebasedauthzFactory.createSecurityRoleExt();
        securityRoleExt.setRoleName("CosNamingRead");
        authorizationTableExt.getRoles().add((Object)securityRoleExt);
        SecurityRoleExt securityRoleExt2 = rolebasedauthzFactory.createSecurityRoleExt();
        securityRoleExt2.setRoleName("CosNamingWrite");
        authorizationTableExt.getRoles().add((Object)securityRoleExt2);
        SecurityRoleExt securityRoleExt3 = rolebasedauthzFactory.createSecurityRoleExt();
        securityRoleExt3.setRoleName("CosNamingCreate");
        authorizationTableExt.getRoles().add((Object)securityRoleExt3);
        SecurityRoleExt securityRoleExt4 = rolebasedauthzFactory.createSecurityRoleExt();
        securityRoleExt4.setRoleName("CosNamingDelete");
        authorizationTableExt.getRoles().add((Object)securityRoleExt4);
    }

    private AuthorizationTableExt CreateAuthorizationTableExt(String string) {
        RolebasedauthzFactory rolebasedauthzFactory = (RolebasedauthzFactory)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi").getEFactoryInstance();
        AuthorizationTableExt authorizationTableExt = rolebasedauthzFactory.createAuthorizationTableExt();
        authorizationTableExt.setContext("domain");
        if (string.equals("admin-authz")) {
            this.AddAdminSecurityRoleExt(authorizationTableExt);
        } else if (string.equals("naming-authz")) {
            this.AddNamingSecurityRoleExt(authorizationTableExt);
        }
        EList eList = authorizationTableExt.getRoles();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            SecurityRoleExt securityRoleExt = (SecurityRoleExt)iterator.next();
            RoleAssignmentExt roleAssignmentExt = rolebasedauthzFactory.createRoleAssignmentExt();
            roleAssignmentExt.setRole(securityRoleExt);
            authorizationTableExt.getAuthorizations().add((Object)roleAssignmentExt);
        }
        return authorizationTableExt;
    }

    private void fillMissingAccessIds(AuthorizationTableExt authorizationTableExt, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("fillMissingAccessIds " + authorizationTableExt + " authz name " + string));
        }
        Iterator iterator = authorizationTableExt.getAuthorizations().iterator();
        while (iterator.hasNext()) {
            String string2;
            Object object;
            RoleAssignmentExt roleAssignmentExt = (RoleAssignmentExt)iterator.next();
            Iterator iterator2 = roleAssignmentExt.getUsers().iterator();
            while (iterator2.hasNext()) {
                block23: {
                    object = (UserExt)iterator2.next();
                    string2 = object.getAccessId();
                    if (string2 != null && string2.length() > 0 && isLDAPRegistry) {
                        string2 = RegistryUtil.removeDNSpace(string2, -1);
                    }
                    if (string2 == null || string2.length() == 0) {
                        try {
                            if (this.registry != null) {
                                string2 = this.registry.getUniqueUserId(object.getName());
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"cannot get accessID as the registry is null");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("set user " + object.getName() + " accessId to " + object.getAccessId()));
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.role.RoleBasedConfiguratorImpl.fillMissingAccessIds", (String)"542", (Object)this);
                            if (!tc.isDebugEnabled()) break block23;
                            exception.printStackTrace();
                        }
                    }
                }
                if (string2 != null && ignoreCase) {
                    string2 = string2.toLowerCase();
                }
                if (string2 == null || string2.length() <= 0) continue;
                object.setAccessId(string2);
            }
            object = roleAssignmentExt.getGroups().iterator();
            while (object.hasNext()) {
                String string3;
                block24: {
                    string2 = (GroupExt)object.next();
                    string3 = string2.getAccessId();
                    if (string3 != null && string3.length() > 0 && isLDAPRegistry) {
                        string3 = RegistryUtil.removeDNSpace(string3, -1);
                    }
                    if (string3 == null || string3.length() == 0) {
                        try {
                            if (this.registry != null) {
                                string3 = this.registry.getUniqueGroupId(string2.getName());
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"cannot get accessID as the registry is null");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("set group " + string2.getName() + " accessId to " + string2.getAccessId()));
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.role.RoleBasedConfiguratorImpl.fillMissingAccessIds", (String)"565", (Object)this);
                            if (!tc.isDebugEnabled()) break block24;
                            exception.printStackTrace();
                        }
                    }
                }
                if (string3 != null && ignoreCase) {
                    string3 = string3.toLowerCase();
                }
                if (string3 == null || string3.length() <= 0) continue;
                string2.setAccessId(string3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fillMissingAccessIds");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RoleBasedApplication {
        private RoleBasedSubjectMap subjectMap = null;
        private HashMap modules = new HashMap(1);
        private RoleBasedAuthorizerImpl rbAuthzer = null;

        private RoleBasedApplication(RoleBasedSubjectMap roleBasedSubjectMap, RoleBasedAuthorizerImpl roleBasedAuthorizerImpl) {
            this.subjectMap = roleBasedSubjectMap;
            this.rbAuthzer = roleBasedAuthorizerImpl;
        }
    }
}

