/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.rolebasedauthz.AllAuthenticatedUsersExt;
import com.ibm.websphere.models.config.rolebasedauthz.EveryoneExt;
import com.ibm.websphere.models.config.rolebasedauthz.SecurityRoleExt;
import com.ibm.websphere.models.config.rolebasedauthz.ServerExt;
import com.ibm.websphere.models.config.rolebasedauthz.SpecialSubjectExt;
import com.ibm.websphere.models.config.rolebasedauthz.SubjectExt;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class RoleBasedSubjectMap {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$role$RoleBasedSubjectMap == null ? (class$com$ibm$ws$security$role$RoleBasedSubjectMap = RoleBasedSubjectMap.class$("com.ibm.ws.security.role.RoleBasedSubjectMap")) : class$com$ibm$ws$security$role$RoleBasedSubjectMap));
    public static final String NO_CRED = "NO_CRED_NO_ACCESS_ID";
    public static final String NULL_ACCESS_ID = "NULL_ACCESS_ID";
    private HashSet[] roles = null;
    private HashMap subjects = new HashMap();
    private HashMap subjectGroups = new HashMap();
    private String name = null;
    private static boolean defaultAccess = true;
    private String serverId = null;
    private String longServerId = null;
    private static boolean ignoreCase = false;
    private HashMap roleMap = null;
    static /* synthetic */ Class class$com$ibm$ws$security$role$RoleBasedSubjectMap;

    RoleBasedSubjectMap(String string, List list, String string2, String string3) {
        this.name = string;
        this.serverId = string2;
        this.longServerId = string3;
        int n = list.size();
        this.roleMap = new HashMap(n);
        if (n == 0) {
            return;
        }
        int n2 = (1 << n) - 1;
        this.roles = new HashSet[n2];
        String[] stringArray = new String[n];
        int[] nArray = new int[n - 1];
        Iterator iterator = list.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            stringArray[n3++] = new String(((SecurityRoleExt)iterator.next()).getRoleName());
            Role role = new Role();
            this.roleMap.put(stringArray[n3 - 1], role);
        }
        for (n3 = 0; n3 < n - 1; ++n3) {
            nArray[n3] = 2 << n3;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            this.roles[n3] = new HashSet(1);
            int n4 = n3 + 1;
            for (int i = n - 2; i >= 0; --i) {
                if (n4 < nArray[i]) continue;
                this.roles[n3].add(stringArray[i + 1]);
                n4 -= nArray[i];
            }
            if (n4 <= 0) continue;
            this.roles[n3].add(stringArray[0]);
        }
    }

    public void addSpecialSubjects(String string, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addSpecialSubjects: " + string));
        }
        if (list == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"list null");
            }
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SpecialSubjectExt specialSubjectExt = (SpecialSubjectExt)iterator.next();
            if (specialSubjectExt instanceof EveryoneExt) {
                ((Role)this.roleMap.get(string)).everyoneAllowed = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"added EveryoneExt");
                continue;
            }
            if (specialSubjectExt instanceof AllAuthenticatedUsersExt) {
                ((Role)this.roleMap.get(string)).allAuthenAllowed = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"added AllAuthenticatedUsersExt");
                continue;
            }
            if (!(specialSubjectExt instanceof ServerExt)) continue;
            ((Role)this.roleMap.get(string)).serverAllowed = true;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"added ServerExt");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addSpecialSubjects: " + string));
        }
    }

    public boolean isEveryoneGranted(Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isEveryoneGranted");
        }
        if (set == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("requiredRoles null, access allowed ? " + defaultAccess));
            }
            return defaultAccess;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!((Role)this.roleMap.get(iterator.next())).everyoneAllowed) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"everyone allowed");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isEveryoneGranted");
        }
        return false;
    }

    public boolean isAllAuthenticatedUsersGranted(Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isAllAuthenticatedUsersGanted");
        }
        if (set == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("requiredRoles null, access allowed? " + defaultAccess));
            }
            return defaultAccess;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!((Role)this.roleMap.get(iterator.next())).allAuthenAllowed) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"all authenticated users allowed");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isAllAuthenticatedUsersGanted");
        }
        return false;
    }

    public boolean isServerGranted(Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isServerGanted");
        }
        if (set == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("requiredRoles null, access allowed? " + defaultAccess));
            }
            return defaultAccess;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!((Role)this.roleMap.get(iterator.next())).serverAllowed) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"server allowed");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isServerGanted");
        }
        return false;
    }

    public void addSubjects(String string, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addSubjects: " + string));
        }
        if (list == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"list null");
            }
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HashSet hashSet;
            SubjectExt subjectExt = (SubjectExt)iterator.next();
            String string2 = subjectExt.getAccessId();
            if (string2 != null && ignoreCase) {
                string2 = string2.toLowerCase();
            }
            if (!this.subjects.containsKey(string2)) {
                hashSet = new HashSet(1);
                hashSet.add(string);
                this.subjects.put(string2, hashSet);
                continue;
            }
            hashSet = (HashSet)this.subjects.get(string2);
            hashSet.add(string);
            this.subjects.put(string2, hashSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addSubjects: " + string));
        }
    }

    public void addSubjectGroups(String string, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addSubjectGroups: " + string));
        }
        if (list == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"list null");
            }
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HashSet hashSet;
            SubjectExt subjectExt = (SubjectExt)iterator.next();
            String string2 = subjectExt.getAccessId();
            if (string2 != null && ignoreCase) {
                string2 = string2.toLowerCase();
            }
            if (!this.subjectGroups.containsKey(string2)) {
                hashSet = new HashSet(1);
                hashSet.add(string);
                this.subjectGroups.put(string2, hashSet);
                continue;
            }
            hashSet = (HashSet)this.subjectGroups.get(string2);
            hashSet.add(string);
            this.subjectGroups.put(string2, hashSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addSubjectGroups: " + string));
        }
    }

    public void pack() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"pack");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"pack subjects");
        }
        this.packMap(this.subjects);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"pack subjectGroups");
        }
        this.packMap(this.subjectGroups);
        this.roles = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pack");
        }
    }

    private void packMap(HashMap hashMap) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"packMap");
        }
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            HashSet hashSet = (HashSet)hashMap.get(string);
            boolean bl = false;
            for (int i = 0; !bl && i < this.roles.length; ++i) {
                if (!hashSet.equals(this.roles[i])) continue;
                bl = true;
                hashMap.put(string, this.roles[i]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"dump hm");
            set = hashMap.keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                Tr.debug((TraceComponent)tc, (String)("subjectName: " + string + " roles: " + hashMap.get(string)));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"packMap");
        }
    }

    private boolean isServerId(String string) {
        if (string == null) {
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isServerId? " + (string.equals(this.serverId) || string.equals(this.longServerId))));
        }
        return string.equals(this.serverId) || string.equals(this.longServerId);
    }

    public boolean isGrantedAnyRole(String string, Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGrantedAnyRole");
        }
        if (set == null || set.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isGrantedAnyRole: requiredRoles null, access allowed? " + defaultAccess));
            }
            return defaultAccess;
        }
        if (string != null && !string.equalsIgnoreCase(ContextManagerFactory.getInstance().getUnauthenticatedString()) && !string.equalsIgnoreCase(NO_CRED) && !string.equalsIgnoreCase(NULL_ACCESS_ID) && (this.isAllAuthenticatedUsersGranted(set) || this.isServerGranted(set) && this.isServerId(string))) {
            return true;
        }
        Set set2 = (Set)this.subjects.get(string);
        if (set2 == null || set2.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isGrantedAnyRole: grantedRoles null, access denied");
            }
            return false;
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = set.iterator();
            String string2 = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isGrantedAnyRole: grantedRolesName = " + string2));
            }
            while (iterator2.hasNext()) {
                if (!string2.equals((String)iterator2.next())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"isGrantedAnyRole: access granted");
                }
                return true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isGrantedAnyRole: access denied");
        }
        return false;
    }

    public boolean isGroupGrantedAnyRole(String string, Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGroupGrantedAnyRole");
        }
        if (set == null || set.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isGroupGrantedAnyRole: requiredRoles null, access allowed? " + defaultAccess));
            }
            return defaultAccess;
        }
        Set set2 = (Set)this.subjectGroups.get(string);
        if (set2 == null || set2.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isGroupGrantedAnyRole: grantedRoles null, access denied");
            }
            return false;
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = set.iterator();
            String string2 = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isiGroupGrantedAnyRole: grantedRolesName = " + string2));
            }
            while (iterator2.hasNext()) {
                if (!string2.equals((String)iterator2.next())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"isGroupGrantedAnyRole: access granted");
                }
                return true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isGroupGrantedAnyRole: access denied");
        }
        return false;
    }

    protected String getSubjectMapName() {
        return this.name;
    }

    protected HashMap getSubjectMap() {
        return this.subjects;
    }

    protected HashSet[] getSecurityRoles() {
        return this.roles;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.registry.IgnoreCase");
        if (bl != null && bl.booleanValue()) {
            ignoreCase = true;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ignoreCase is set");
            }
        }
    }

    class Role {
        private boolean everyoneAllowed = false;
        private boolean allAuthenAllowed = false;
        private boolean serverAllowed = false;

        Role() {
        }
    }
}

