/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server.lm;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class swamLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private UserRegistry registry = null;
    private ContextManager contextManager = null;
    private WSPrincipal principal;
    private WSCredential credential;
    private WSCredentialTokenMapperInterface wsCredMapper = null;
    protected boolean debug = false;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$server$lm$swamLoginModule == null ? (class$com$ibm$ws$security$server$lm$swamLoginModule = swamLoginModule.class$("com.ibm.ws.security.server.lm.swamLoginModule")) : class$com$ibm$ws$security$server$lm$swamLoginModule), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$ws$security$server$lm$swamLoginModule;

    public swamLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"swamLoginModule()");
            Tr.exit((TraceComponent)tc, (String)"swamLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + map.toString() + "\", options = \"" + map2.toString() + "\")"));
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.contextManager = ContextManagerFactory.getInstance();
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WSLoginModuleImpl initialized");
        }
        try {
            this.wsCredMapper = WSCredentialTokenMapper.getInstance();
            this.registry = SecurityServerImpl.getRegistryImpl(ContextManagerFactory.getInstance().getDefaultRealm());
            this.contextManager.clearRootException();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.swamLoginModule.initialize", (String)"144", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.swam.find.registry", (Object)new Object[]{exception});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws LoginException {
        Object object;
        block56: {
            Object object2;
            Object object3;
            Hashtable hashtable;
            if (this.debug || tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"login()");
            }
            this.succeeded = false;
            if (this.commitSucceeded) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The login module is in funny state, cleanup before starting a new login process.");
                }
                this.cleanup();
            }
            if ((hashtable = (Hashtable)this.sharedState.get("com.ibm.wsspi.security.cred.propertiesObject")) == null) {
                try {
                    object3 = this.subject;
                    hashtable = (Hashtable)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Subject)object3){
                        private final /* synthetic */ Subject val$subjectPriv;
                        {
                            this.val$subjectPriv = subject;
                        }

                        public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                            Object[] objectArray = this.val$subjectPriv.getPublicCredentials().toArray();
                            if (swamLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Looking for custom properties in public cred list.");
                            }
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (swamLoginModule.this.debug || tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Object[" + i + "] in public list: " + objectArray[i]));
                                }
                                if (!(objectArray[i] instanceof Hashtable) || ((Hashtable)objectArray[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null) continue;
                                return objectArray[i];
                            }
                            Object[] objectArray2 = this.val$subjectPriv.getPrivateCredentials().toArray();
                            if (swamLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Looking for custom properties in private cred list.");
                            }
                            for (int i = 0; i < objectArray2.length; ++i) {
                                if (swamLoginModule.this.debug || tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Object[" + i + "] in private list: " + objectArray2[i]));
                                }
                                if (!(objectArray2[i] instanceof Hashtable) || ((Hashtable)objectArray2[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null) continue;
                                return objectArray2[i];
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"320", (Object)this);
                    this.contextManager.setRootException((Throwable)privilegedActionException.getException());
                    throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), (Throwable)privilegedActionException.getException());
                }
            }
            if (hashtable != null) {
                object3 = System.getSecurityManager();
                if (object3 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                        Tr.debug((TraceComponent)tc, (String)("Expecting : " + MAP_CREDENTIAL.toString()));
                    }
                    object3.checkPermission((Permission)MAP_CREDENTIAL);
                }
                try {
                    try {
                        final Hashtable hashtable2 = hashtable;
                        this.credential = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws WSLoginFailedException {
                                return swamLoginModule.this.wsCredMapper.createWSCredentialFromProperties(hashtable2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", (String)"287", (Object)this);
                        this.contextManager.setRootException((Throwable)privilegedActionException.getException());
                        if (this.debug || tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception occurred during properties login: ", (Object)new Object[]{privilegedActionException.getException()});
                        }
                        throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), (Throwable)privilegedActionException.getException());
                    }
                    if (this.credential != null) {
                        this.sharedState.put("WSCredential", this.credential);
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("WSCredential contains: " + this.credential));
                    }
                    this.principal = this.contextManager.createPrincipal(this.credential);
                    if (this.principal != null) {
                        this.sharedState.put("WSPrincipal", this.principal);
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("WSPrincipal contains: " + this.principal));
                    }
                }
                catch (WSLoginFailedException wSLoginFailedException) {
                    this.contextManager.setRootException((Throwable)wSLoginFailedException);
                    FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", (String)"418", (Object)this);
                    if (this.debug || tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"Exception creating SAP tokens.", (Object)new Object[]{wSLoginFailedException});
                    }
                    throw wSLoginFailedException;
                }
                catch (Exception exception) {
                    this.contextManager.setRootException((Throwable)exception);
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", (String)"425", (Object)this);
                    if (this.debug || tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"Exception creating SAP tokens.", (Object)new Object[]{exception});
                    }
                    throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
                }
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Custom login module passing in credential properties.");
                    Tr.exit((TraceComponent)tc, (String)"login()");
                }
                this.succeeded = true;
                return this.succeeded;
            }
            if (this.callbackHandler == null) {
                object3 = new WSLoginFailedException("swamLoginModule: No CallbackHandler available to gather authentication information from the user.");
                this.contextManager.setRootException((Throwable)object3);
                throw object3;
            }
            object3 = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
            String string = null;
            String string2 = null;
            char[] cArray = null;
            try {
                this.callbackHandler.handle((Callback[])object3);
                string = ((NameCallback)object3[0]).getName();
                object2 = ((PasswordCallback)object3[1]).getPassword();
                if (object2 != null) {
                    cArray = new char[((char[])object2).length];
                    System.arraycopy(object2, 0, cArray, 0, ((char[])object2).length);
                    ((PasswordCallback)object3[1]).clearPassword();
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.server.lm.swamLoginModule.login", (String)"359", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.swam.callback.ex", (Object)new Object[]{iOException});
                this.contextManager.setRootException((Throwable)iOException);
                throw new WSLoginFailedException("swamLoginModule IOException: " + iOException.getMessage(), (Throwable)iOException);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                FFDCFilter.processException((Throwable)unsupportedCallbackException, (String)"com.ibm.ws.security.server.lm.swamLoginModule.login", (String)"365", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.swam.unsupport.callback", (Object)new Object[]{unsupportedCallbackException.getCallback().toString(), unsupportedCallbackException});
                this.contextManager.setRootException((Throwable)unsupportedCallbackException);
                throw new WSLoginFailedException(unsupportedCallbackException.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user", (Throwable)unsupportedCallbackException);
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("uid = " + string));
                Tr.debug((TraceComponent)tc, (String)("realm = " + string2));
                Tr.debug((TraceComponent)tc, (String)("password = " + (cArray == null ? "<null>" : "XXXXXXXX")));
            }
            if (string == null && cArray == null) {
                object2 = (Object)new WSLoginFailedException("swamLoginModule: No authentication data.");
                this.contextManager.setRootException((Throwable)object2);
                throw object2;
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Successfully gathered authentication information");
            }
            object2 = null;
            if (string != null && cArray != null) {
                if (string2 == null || string2.length() == 0) {
                    string2 = this.contextManager.getDefaultRealm();
                }
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Using uid and password for authentication");
                    object = new StringBuffer("Authenticating \"");
                    ((StringBuffer)object).append(string2).append('/').append(string).append("\"");
                    Tr.debug((TraceComponent)tc, (String)((StringBuffer)object).toString());
                }
                try {
                    object = new String(cArray);
                    object2 = this.registry.checkPassword(string, (String)object);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.swamLoginModule.login", (String)"421", (Object)this);
                    this.contextManager.setRootException((Throwable)exception);
                    throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
                }
                try {
                    object = this.registry.createCredential((String)object2);
                    try {
                        this.credential = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((WSCredential)object){
                            private final /* synthetic */ WSCredential val$wsRegistryCred;
                            {
                                this.val$wsRegistryCred = wSCredential;
                            }

                            public Object run() throws Exception {
                                return new WSCredentialImpl(this.val$wsRegistryCred, "No OID for this mechanism", RegistryUtil.nullByteArray, false, -1L);
                            }
                        });
                        break block56;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS cred.", (Object)new Object[]{privilegedActionException.getException()});
                        }
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.server.SecurityServerImpl.mapCredential", (String)"449", (Object)this);
                        this.contextManager.setRootException((Throwable)privilegedActionException.getException());
                        throw privilegedActionException.getException();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.swamLoginModule.login", (String)"455", (Object)this);
                    this.contextManager.setRootException((Throwable)exception);
                    throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
                }
            }
            if (string != null) {
                StringBuffer stringBuffer;
                object = System.getSecurityManager();
                if (object != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                        Tr.debug((TraceComponent)tc, (String)("Expecting : " + MAP_CREDENTIAL.toString()));
                    }
                    ((SecurityManager)object).checkPermission((Permission)MAP_CREDENTIAL);
                }
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Using uid to mapCredential.");
                    stringBuffer = new StringBuffer("Authenticating \"");
                    stringBuffer.append(string2).append('/').append(string).append("\"");
                    Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                }
                try {
                    if (SecurityConfig.isRegTAM() && !RegistryUtil.checkValidUserifTAM(string, this.registry)) {
                        throw new WSLoginFailedException("User is not valid in Access Manager");
                    }
                    stringBuffer = this.registry.createCredential(string);
                    try {
                        this.credential = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((WSCredential)stringBuffer){
                            private final /* synthetic */ WSCredential val$wsRegistryCred;
                            {
                                this.val$wsRegistryCred = wSCredential;
                            }

                            public Object run() throws Exception {
                                return new WSCredentialImpl(this.val$wsRegistryCred, "No OID for this mechanism", RegistryUtil.nullByteArray, false, -1L);
                            }
                        });
                        break block56;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS cred.", (Object)new Object[]{privilegedActionException.getException()});
                        }
                        FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.server.lm.swamLoginModule.login", (String)"516", (Object)this);
                        this.contextManager.setRootException((Throwable)privilegedActionException.getException());
                        throw privilegedActionException.getException();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.swamLoginModule.login", (String)"523", (Object)this);
                    this.contextManager.setRootException((Throwable)exception);
                    if (exception instanceof WSLoginFailedException) {
                        throw (WSLoginFailedException)((Object)exception);
                    }
                    throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
                }
            }
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("swamLoginModule: No authentication data");
            this.contextManager.setRootException((Throwable)wSLoginFailedException);
            throw wSLoginFailedException;
        }
        if (this.credential == null) {
            object = new WSLoginFailedException("swamLoginModule: Credential returned from SAS authentication is null");
            this.contextManager.setRootException((Throwable)object);
            throw object;
        }
        try {
            this.principal = this.contextManager.createPrincipal(this.credential);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS Principal.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.swamLoginModule.login", (String)"553", (Object)this);
            this.contextManager.setRootException((Throwable)exception);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        this.succeeded = true;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login()");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit()");
        }
        boolean bl = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Do not commit because of authentication failed.");
            }
            bl = false;
        } else {
            if (!this.commitSucceeded) {
                if (this.principal == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("swamLoginModule: WSPrincipal is null in commit (phase 2) stage");
                    this.contextManager.setRootException((Throwable)wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                if (this.credential == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("swamLoginModule: WSCredential is null in commit (phase 2) stage");
                    this.contextManager.setRootException((Throwable)wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                                if (!swamLoginModule.this.subject.getPrincipals().contains(swamLoginModule.this.principal)) {
                                    swamLoginModule.this.subject.getPrincipals().add((Principal)swamLoginModule.this.principal);
                                }
                                if (!swamLoginModule.this.subject.getPublicCredentials().contains(swamLoginModule.this.credential)) {
                                    swamLoginModule.this.credential.set("wssecurity.identity_name", (Object)"ClientAuthenticationToken");
                                    swamLoginModule.this.credential.set("wssecurity.identity_value", (Object)StringBytesConversion.getConvertedBytes((String)swamLoginModule.this.credential.getRealmSecurityName()));
                                    swamLoginModule.this.subject.getPublicCredentials().add(swamLoginModule.this.credential);
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.server.lm.swamLoginModule.commit", (String)"660", (Object)this);
                        this.contextManager.setRootException((Throwable)privilegedActionException.getException());
                        throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), (Throwable)privilegedActionException.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.swamLoginModule.commit", (String)"674", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.swam.commit.ex", (Object)new Object[]{exception});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"It has been committed prior this call, nothing is done.");
            }
            bl = this.commitSucceeded;
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit()");
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"abort()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug((TraceComponent)tc, (String)"Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logout()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug((TraceComponent)tc, (String)"Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug((TraceComponent)tc, (String)"Start removing ...");
        }
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    if (swamLoginModule.this.principal != null && swamLoginModule.this.subject.getPrincipals().contains(swamLoginModule.this.principal)) {
                        swamLoginModule.this.subject.getPrincipals().remove(swamLoginModule.this.principal);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.swamLoginModule.run", (String)"807", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.swam.remove.prin.ex", (Object)new Object[]{swamLoginModule.this.principal.getName(), exception});
                }
                try {
                    if (swamLoginModule.this.credential != null && swamLoginModule.this.subject.getPublicCredentials().contains(swamLoginModule.this.credential)) {
                        swamLoginModule.this.subject.getPublicCredentials().remove(swamLoginModule.this.credential);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.swamLoginModule.run", (String)"818", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.swam.remove.cred.ex", (Object)new Object[]{exception});
                }
                if (swamLoginModule.this.credential != null) {
                    // empty if block
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Removed.");
        }
        this.principal = null;
        this.credential = null;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanup()");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

