/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server.lm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSProtocolPolicyCallback;
import com.ibm.wsspi.security.csiv2.CSIv2PerformPolicy;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class wsMapCSIv2OutboundLoginModule
implements LoginModule {
    private Subject subject;
    private Subject invocation_subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private TokenHolder opaqueTokenHolder = null;
    private ContextManager contextManager;
    private AuthorizationToken authzToken = null;
    private SingleSignonToken ssoToken = null;
    private AuthenticationToken authToken = null;
    private CSIv2PerformPolicy csiv2PerformPolicy = null;
    protected boolean debug = false;
    protected boolean ssoEnabled = false;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$server$lm$wsMapCSIv2OutboundLoginModule == null ? (class$com$ibm$ws$security$server$lm$wsMapCSIv2OutboundLoginModule = wsMapCSIv2OutboundLoginModule.class$("com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule")) : class$com$ibm$ws$security$server$lm$wsMapCSIv2OutboundLoginModule), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$ws$security$server$lm$wsMapCSIv2OutboundLoginModule;

    public wsMapCSIv2OutboundLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"wsMapCSIv2OutboundLoginModule()");
            Tr.exit((TraceComponent)tc, (String)"wsMapCSIv2OutboundLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + map.toString() + "\", options = \"" + map2.toString() + "\")"));
            }
            this.subject = subject;
            this.callbackHandler = callbackHandler;
            this.sharedState = map;
            this.options = map2;
            try {
                Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.enabled");
                this.ssoEnabled = bl != null ? bl : false;
                this.contextManager = ContextManagerFactory.getInstance();
                if (this.contextManager != null) {
                    this.contextManager.clearRootException();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.initialize", (String)"150", (Object)this);
                if (!this.debug && !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"Exception initializing wsMapCSIv2OutboundLoginModule.", (Object)new Object[]{exception});
            }
        }
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WSLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws LoginException {
        block30: {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"login()");
            }
            if (!WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled()) {
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"Attribute propagation disabled locally.");
                }
                this.succeeded = true;
                return this.succeeded;
            }
            this.succeeded = false;
            if (this.commitSucceeded) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The login module is in funny state, cleanup before starting a new login process.");
                }
                this.cleanup();
            }
            Callback[] callbackArray = null;
            if (!this.sharedState.containsKey("Callback")) {
                if (this.callbackHandler == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                    this.contextManager.setRootException((Throwable)wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                callbackArray = new Callback[]{new WSProtocolPolicyCallback("Protocol Policy Callback: ")};
                try {
                    this.callbackHandler.handle(callbackArray);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"221", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.jaas.callBackHandlerIOException", (Object)new Object[]{this.getClass().getName(), iOException});
                    this.contextManager.setRootException((Throwable)iOException);
                    this.succeeded = false;
                    throw new WSLoginFailedException("IOException: " + iOException.getMessage(), (Throwable)iOException);
                }
                catch (UnsupportedCallbackException unsupportedCallbackException) {
                    FFDCFilter.processException((Throwable)unsupportedCallbackException, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"229", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.jaas.callBackHandlerException", (Object)new Object[]{this.getClass().getName(), unsupportedCallbackException.getCallback().toString(), unsupportedCallbackException});
                    this.contextManager.setRootException((Throwable)unsupportedCallbackException);
                    this.succeeded = false;
                    throw new WSLoginFailedException(unsupportedCallbackException.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + unsupportedCallbackException.getMessage(), (Throwable)unsupportedCallbackException);
                }
                this.sharedState.put("Callback", callbackArray);
            } else {
                callbackArray = (Callback[])this.sharedState.get("Callback");
            }
            this.csiv2PerformPolicy = (CSIv2PerformPolicy)((WSProtocolPolicyCallback)callbackArray[0]).getProtocolPolicy();
            try {
                if (this.csiv2PerformPolicy.performAuthorizationToken()) {
                    String string = this.csiv2PerformPolicy.getServiceCfgList();
                    WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)this.subject);
                    if (string != null && wSCredential != null) {
                        Object object;
                        block29: {
                            if (this.debug || tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("The following ServiceConfiguration list was received: " + string));
                            }
                            if (!wSCredential.isBasicAuth()) {
                                try {
                                    object = wSCredential;
                                    boolean bl = this.ssoEnabled;
                                    AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((WSCredential)object, bl){
                                        private final /* synthetic */ WSCredential val$wsCredPriv;
                                        private final /* synthetic */ boolean val$ssoEnabledPriv;
                                        {
                                            this.val$wsCredPriv = wSCredential;
                                            this.val$ssoEnabledPriv = bl;
                                        }

                                        public Object run() throws WSSecurityException, WSLoginFailedException {
                                            AuthorizationToken authorizationToken = SubjectHelper.getDefaultAuthzTokenFromSubject((Subject)wsMapCSIv2OutboundLoginModule.this.subject);
                                            AuthenticationToken authenticationToken = SubjectHelper.getDefaultAuthTokenFromSubject((Subject)wsMapCSIv2OutboundLoginModule.this.subject);
                                            SingleSignonToken singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject((Subject)wsMapCSIv2OutboundLoginModule.this.subject);
                                            if (authorizationToken == null) {
                                                if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)tc, (String)"Creating AuthorizationToken for outbound request.");
                                                }
                                                wsMapCSIv2OutboundLoginModule.this.authzToken = wsMapCSIv2OutboundLoginModule.this.contextManager.getWSCredTokenMapper().createAuthzTokenFromWSCredential(this.val$wsCredPriv);
                                            }
                                            if (authenticationToken == null) {
                                                if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)tc, (String)"Creating AuthenticationToken for outbound request.");
                                                }
                                                wsMapCSIv2OutboundLoginModule.this.authToken = wsMapCSIv2OutboundLoginModule.this.contextManager.getWSCredTokenMapper().createAuthTokenFromWSCredential(this.val$wsCredPriv);
                                            }
                                            if (singleSignonToken == null && this.val$ssoEnabledPriv) {
                                                if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)tc, (String)"Creating SingleSignonToken for outbound request.");
                                                }
                                                wsMapCSIv2OutboundLoginModule.this.ssoToken = wsMapCSIv2OutboundLoginModule.this.contextManager.getWSCredTokenMapper().createSSOTokenFromWSCredential(this.val$wsCredPriv);
                                                String string = (String)SecurityConfig.getConfig().getValue("security.processType");
                                                if (string != null && (string.equals("ManagedProcess") || string.equals("UnManagedProcess"))) {
                                                    String string2 = (String)SecurityConfig.getConfig().getValue("process.serverName");
                                                    if (string2 != null) {
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("process.serverName", string2);
                                                    } else if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                        Tr.debug((TraceComponent)tc, (String)"Cannot add serverName to SSO token, config property is null.");
                                                    }
                                                    Properties properties = (Properties)SecurityConfig.getConfig().getValue("process.jmxConnectorProps");
                                                    if (properties != null) {
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("type", (String)properties.get("type"));
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("host", (String)properties.get("host"));
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("port", (String)properties.get("port"));
                                                    } else if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                        Tr.debug((TraceComponent)tc, (String)"Cannot add connectorProps to SSO token, config property is null.");
                                                    }
                                                    if (wsMapCSIv2OutboundLoginModule.this.authzToken != null) {
                                                        String[] stringArray = wsMapCSIv2OutboundLoginModule.this.authzToken.getAttributes("com.ibm.wsspi.security.cred.expiration");
                                                        if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                            Tr.debug((TraceComponent)tc, (String)("Setting SSO token expiration: " + new Date(new Long(stringArray[0]))));
                                                        }
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("expire", stringArray[0]);
                                                    }
                                                } else if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)tc, (String)("Not adding connector properties to SSO token, process type: " + string));
                                                }
                                            }
                                            if (wsMapCSIv2OutboundLoginModule.this.authzToken != null && !wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.authzToken)) {
                                                wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().add(wsMapCSIv2OutboundLoginModule.this.authzToken);
                                            }
                                            if (wsMapCSIv2OutboundLoginModule.this.authToken != null && !wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.authToken)) {
                                                wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().add(wsMapCSIv2OutboundLoginModule.this.authToken);
                                            }
                                            if (wsMapCSIv2OutboundLoginModule.this.ssoToken != null && !wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.ssoToken)) {
                                                wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().add(wsMapCSIv2OutboundLoginModule.this.ssoToken);
                                            }
                                            return null;
                                        }
                                    });
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule", (String)"361");
                                    if (!tc.isDebugEnabled()) break block29;
                                    Tr.debug((TraceComponent)tc, (String)"Error creating default authz and auth tokens.", (Object)new Object[]{privilegedActionException.getException()});
                                }
                            }
                        }
                        if ((object = (Object)WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromSubject(this.subject)) != null) {
                            this.opaqueTokenHolder = new TokenHolder((byte[])object, WSOpaqueTokenHelper.getInstance().getOpaqueTokenName(), WSOpaqueTokenHelper.getInstance().getOpaqueTokenVersion());
                            this.sharedState.put("WSOPAQUE", this.opaqueTokenHolder);
                            if (this.debug || tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"Opaque token generated, propagating security attributes.");
                            }
                        } else if (this.debug || tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"Opaque token is null, not propagating security attributes.");
                        }
                        break block30;
                    }
                    if (this.debug || tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"Not processing the authz token.", (Object)new Object[]{string, wSCredential});
                    }
                    break block30;
                }
                if (WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() && !this.csiv2PerformPolicy.performAuthorizationToken() && (this.debug || tc.isDebugEnabled())) {
                    Tr.debug((TraceComponent)tc, (String)"Target server does not support authorization token.");
                }
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.login", (String)"394", (Object)this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"WSLoginFailedException creating SAP tokens from WSCredential.", (Object)new Object[]{wSLoginFailedException});
                }
                this.succeeded = false;
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.login", (String)"401", (Object)this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"Exception creating SAP tokens from WSCredential.", (Object)new Object[]{exception});
                }
                this.succeeded = false;
                throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
            }
        }
        this.succeeded = true;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login() succeeded.");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit()");
        }
        if (!WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled()) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attribute propagation is disabled locally.");
            }
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit()");
            }
            this.commitSucceeded = true;
            return this.commitSucceeded;
        }
        if (WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() && !this.csiv2PerformPolicy.performAuthorizationToken()) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attribute propagation is disabled remotely.");
            }
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit()");
            }
            this.commitSucceeded = true;
            return this.commitSucceeded;
        }
        boolean bl = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Do not commit because of authentication failed.");
            }
            bl = false;
        } else {
            if (!this.commitSucceeded) {
                if (this.opaqueTokenHolder == null) {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Authorization token is null, returning from commit.");
                    }
                    this.commitSucceeded = true;
                    return this.commitSucceeded;
                }
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws WSLoginFailedException, CredentialDestroyedException, CredentialExpiredException {
                                if (wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder != null && !wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder)) {
                                    wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().add(wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder);
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.commit", (String)"502", (Object)this);
                        this.contextManager.setRootException((Throwable)privilegedActionException.getException());
                        throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), (Throwable)privilegedActionException.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.commit", (String)"517", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.jaas.LoginModuleCommitError", (Object)new Object[]{this.getClass().getName(), exception});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"It has been committed prior this call, nothing is done.");
            }
            bl = this.commitSucceeded;
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit()");
        }
        this.authToken = null;
        this.authzToken = null;
        this.ssoToken = null;
        return bl;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"abort()");
        }
        if (!WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled()) {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"abort()");
            }
            return true;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug((TraceComponent)tc, (String)"Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logout()");
        }
        if (!WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled()) {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"abort()");
            }
            return true;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug((TraceComponent)tc, (String)"Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Start removing AuthorizationToken from the Subject.");
            Tr.debug((TraceComponent)tc, (String)"Start removing ...");
        }
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    if (wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder != null && wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder)) {
                        wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().remove(wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder);
                    }
                    if (wsMapCSIv2OutboundLoginModule.this.authToken != null && wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.authToken)) {
                        wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().remove(wsMapCSIv2OutboundLoginModule.this.authToken);
                    }
                    if (wsMapCSIv2OutboundLoginModule.this.authzToken != null && wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.authzToken)) {
                        wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().remove(wsMapCSIv2OutboundLoginModule.this.authzToken);
                    }
                    if (wsMapCSIv2OutboundLoginModule.this.ssoToken != null && wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.ssoToken)) {
                        wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().remove(wsMapCSIv2OutboundLoginModule.this.ssoToken);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.cleanup", (String)"682", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.jaas.removeCredException", (Object)new Object[]{this.getClass().getName(), exception});
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Removed.");
        }
        this.opaqueTokenHolder = null;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanup()");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

