/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.AuthenticationToken;
import java.security.Permission;

public class AuthenticationTokenImpl
extends AbstractTokenImpl
implements AuthenticationToken {
    private Token token = null;
    private LTPAServerObject ltpaServer = null;
    private ContextManager contextManager = null;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$token$AuthenticationTokenImpl == null ? (class$com$ibm$ws$security$token$AuthenticationTokenImpl = AuthenticationTokenImpl.class$("com.ibm.ws.security.token.AuthenticationTokenImpl")) : class$com$ibm$ws$security$token$AuthenticationTokenImpl), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$ws$security$token$AuthenticationTokenImpl;

    public void initializeToken(String string, byte[] byArray) throws WSLoginFailedException {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Initializing authentication token.");
            }
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", (String)"311", (Object)((Object)this));
            Tr.debug((TraceComponent)tc, (String)"Exception validating LTPA token.", (Object)new Object[]{exception});
            this.contextManager.setRootException((Throwable)exception);
            if (exception instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)((Object)exception);
            }
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        if (byArray != null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Using byte[] to create token.");
                }
                this.token = this.ltpaServer.validateToken(byArray);
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", (String)"311", (Object)((Object)this));
                Tr.debug((TraceComponent)tc, (String)"Exception validating LTPA token.", (Object)new Object[]{wSLoginFailedException});
                this.contextManager.setRootException((Throwable)wSLoginFailedException);
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", (String)"317", (Object)((Object)this));
                Tr.debug((TraceComponent)tc, (String)"Exception validating LTPA token.", (Object)new Object[]{exception});
                this.contextManager.setRootException((Throwable)exception);
                throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
            }
        } else if (string != null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                    Tr.debug((TraceComponent)tc, (String)("Expecting : " + MAP_CREDENTIAL.toString()));
                }
                securityManager.checkPermission((Permission)MAP_CREDENTIAL);
            }
            try {
                String string2 = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.authenticationTokenFactory");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Using uid to create token using factroy: " + string2));
                }
                this.token = this.ltpaServer.createLTPAToken(string, string2);
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", (String)"311", (Object)((Object)this));
                Tr.debug((TraceComponent)tc, (String)"Exception validating LTPA token.", (Object)new Object[]{wSLoginFailedException});
                this.contextManager.setRootException((Throwable)wSLoginFailedException);
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", (String)"317", (Object)((Object)this));
                Tr.debug((TraceComponent)tc, (String)"Exception validating LTPA token.", (Object)new Object[]{exception});
                this.contextManager.setRootException((Throwable)exception);
                throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
            }
        } else {
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("wsSAPInboundLoginModule: Invalid authentication data");
            this.contextManager.setRootException((Throwable)wSLoginFailedException);
            throw wSLoginFailedException;
        }
        this.setToken(this.token);
    }

    public void initializeToken(Token token) throws WSLoginFailedException {
        this.token = token;
        this.setToken(this.token);
    }

    public Object clone() {
        try {
            AuthenticationTokenImpl authenticationTokenImpl = new AuthenticationTokenImpl();
            authenticationTokenImpl.initializeToken((Token)this.token.clone());
            return authenticationTokenImpl;
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)tc, (String)"Exception creating clone of authentication token.", (Object)new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAToken.clone", (String)"155");
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

