/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.AuthorizationToken;

public class AuthorizationTokenImpl
extends AbstractTokenImpl
implements AuthorizationToken {
    private Token token = null;
    private LTPAServerObject ltpaServer = null;
    private ContextManager contextManager = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$token$AuthorizationTokenImpl == null ? (class$com$ibm$ws$security$token$AuthorizationTokenImpl = AuthorizationTokenImpl.class$("com.ibm.ws.security.token.AuthorizationTokenImpl")) : class$com$ibm$ws$security$token$AuthorizationTokenImpl), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$ws$security$token$AuthorizationTokenImpl;

    public void initializeToken(byte[] byArray) throws WSLoginFailedException {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Initializing authorization token.");
            }
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
            this.token = this.ltpaServer.validateToken(byArray);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.token.AuthorizationTokenImpl.initializeToken", (String)"50", (Object)((Object)this));
            Tr.debug((TraceComponent)tc, (String)"Exception validating LTPA token.", (Object)new Object[]{wSLoginFailedException});
            this.contextManager.setRootException((Throwable)wSLoginFailedException);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.AuthorizationTokenImpl.initializeToken", (String)"57", (Object)((Object)this));
            Tr.debug((TraceComponent)tc, (String)"Exception validating LTPA token.", (Object)new Object[]{exception});
            this.contextManager.setRootException((Throwable)exception);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        this.setToken(this.token);
    }

    public void initializeToken(Token token) throws WSLoginFailedException {
        this.token = token;
        this.setToken(this.token);
    }

    public Object clone() {
        try {
            AuthorizationTokenImpl authorizationTokenImpl = new AuthorizationTokenImpl();
            authorizationTokenImpl.initializeToken((Token)this.token.clone());
            return authorizationTokenImpl;
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)tc, (String)"Exception creating clone of authorization token.", (Object)new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAToken.clone", (String)"88");
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

