/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.PropagationToken;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class PropagationTokenImpl
extends AbstractTokenImpl
implements PropagationToken {
    private Token token = null;
    private LTPAServerObject ltpaServer = null;
    private ContextManager contextManager = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$token$PropagationTokenImpl == null ? (class$com$ibm$ws$security$token$PropagationTokenImpl = PropagationTokenImpl.class$("com.ibm.ws.security.token.PropagationTokenImpl")) : class$com$ibm$ws$security$token$PropagationTokenImpl), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$ws$security$token$PropagationTokenImpl;

    public void initializeToken(byte[] byArray) throws WSLoginFailedException {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Initializing propagation token.");
            }
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
            this.token = this.ltpaServer.validateToken(byArray);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.token.PropagationTokenImpl.initializeToken", (String)"53", (Object)((Object)this));
            Tr.debug((TraceComponent)tc, (String)"Exception validating LTPA token.", (Object)new Object[]{wSLoginFailedException});
            this.contextManager.setRootException((Throwable)wSLoginFailedException);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.PropagationTokenImpl.initializeToken", (String)"60", (Object)((Object)this));
            Tr.debug((TraceComponent)tc, (String)"Exception validating LTPA token.", (Object)new Object[]{exception});
            this.contextManager.setRootException((Throwable)exception);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        try {
            final Token token = this.token;
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    PropagationTokenImpl.this.setToken(token);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.PropagationTokenImpl.initializeToken", (String)"81", (Object)((Object)this));
        }
    }

    public void initializeToken(final Token token) throws WSLoginFailedException {
        this.token = token;
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    PropagationTokenImpl.this.setToken(token);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.PropagationTokenImpl.initializeToken", (String)"102", (Object)((Object)this));
        }
    }

    public String getUniqueID() {
        String string = ((Object)((Object)this)).hashCode() + ":" + this.getChangeCounter();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Returning uniqueID of propagation token: " + string));
        }
        return string;
    }

    public byte[] getBytes() {
        if (this.token != null) {
            try {
                return this.token.getBytes();
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)tc, (String)"Exception creating byte[] of propagation token.", (Object)new Object[]{exception});
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.PropagationTokenImpl.getUniqueID", (String)"137");
                return null;
            }
        }
        return null;
    }

    public Object clone() {
        try {
            PropagationTokenImpl propagationTokenImpl = new PropagationTokenImpl();
            propagationTokenImpl.initializeToken((Token)this.token.clone());
            return propagationTokenImpl;
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)tc, (String)"Exception creating clone of propagation token.", (Object)new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAToken.clone", (String)"161");
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

