/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.SingleSignonToken;

public class SingleSignonTokenImpl
extends AbstractTokenImpl
implements SingleSignonToken {
    private Token token = null;
    private Token interopToken = null;
    private byte[] interopTokenBytes = null;
    private LTPAServerObject ltpaServer = null;
    private ContextManager contextManager = null;
    private String name = "LtpaToken";
    private short version = (short)2;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$token$SingleSignonTokenImpl == null ? (class$com$ibm$ws$security$token$SingleSignonTokenImpl = SingleSignonTokenImpl.class$("com.ibm.ws.security.token.SingleSignonTokenImpl")) : class$com$ibm$ws$security$token$SingleSignonTokenImpl), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$ws$security$token$SingleSignonTokenImpl;

    public void initializeToken(byte[] byArray) throws WSLoginFailedException {
        try {
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
            this.token = this.ltpaServer.validateToken(byArray);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.token.SingleSignonTokenImpl.initializeToken", (String)"53", (Object)((Object)this));
            Tr.debug((TraceComponent)tc, (String)"Exception validating LTPA token.", (Object)new Object[]{wSLoginFailedException});
            this.contextManager.setRootException((Throwable)wSLoginFailedException);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.SingleSignonTokenImpl.initializeToken", (String)"60", (Object)((Object)this));
            Tr.debug((TraceComponent)tc, (String)"Exception validating LTPA token.", (Object)new Object[]{exception});
            this.contextManager.setRootException((Throwable)exception);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        if (SecurityConfig.getConfig().getValue("com.ibm.ws.security.ssoInteropModeEnabled").equals("true")) {
            this.interopToken = (Token)this.token.clone();
        }
        this.setToken(this.token);
    }

    public void initializeToken(Token token) throws WSLoginFailedException {
        this.token = token;
        if (SecurityConfig.getConfig().getValue("com.ibm.ws.security.ssoInteropModeEnabled").equals("true")) {
            this.interopToken = (Token)token.clone();
        }
        this.setToken(this.token);
    }

    public String getName() {
        return this.name;
    }

    public short getVersion() {
        return this.version;
    }

    public Object clone() {
        try {
            SingleSignonTokenImpl singleSignonTokenImpl = new SingleSignonTokenImpl();
            singleSignonTokenImpl.initializeToken((Token)this.token.clone());
            return singleSignonTokenImpl;
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)tc, (String)"Exception creating clone of single signon token.", (Object)new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.SingleSignonToken.clone", (String)"117");
            return null;
        }
    }

    public byte[] getInteropTokenBytes() {
        if (this.interopTokenBytes == null) {
            try {
                this.interopTokenBytes = this.interopToken.getBytes();
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting byte[] from single signon token.", (Object)new Object[]{exception});
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.SingleSignonToken.getInteropTokenBytes", (String)"137");
                return null;
            }
        }
        return this.interopTokenBytes;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

