/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.DistributedMapFactory;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.token.AuthenticationTokenImpl;
import com.ibm.ws.security.token.AuthorizationTokenImpl;
import com.ibm.ws.security.token.PropagationTokenImpl;
import com.ibm.ws.security.token.SingleSignonTokenImpl;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.Token;
import com.ibm.wsspi.security.token.TokenHolder;
import java.math.BigInteger;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class WSCredentialTokenMapper
implements WSCredentialTokenMapperInterface {
    private LTPAServerObject ltpaServer = null;
    private ContextManager contextManager = null;
    private WSPrincipal wsPrincipal = null;
    private static WSCredentialTokenMapperInterface wsCredTokenMapper = null;
    private DistributedMap dm = null;
    private String activeAuthMech = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$token$WSCredentialTokenMapper == null ? (class$com$ibm$ws$security$token$WSCredentialTokenMapper = WSCredentialTokenMapper.class$("com.ibm.ws.security.token.WSCredentialTokenMapper")) : class$com$ibm$ws$security$token$WSCredentialTokenMapper), null, (String)"com.ibm.ejs.resources.security");
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final WebSphereRuntimePermission GET_OPAQUE_TOKEN_FROM_MBEAN = new WebSphereRuntimePermission("wssecurity.getOpaqueTokenFromMBean");
    static /* synthetic */ Class class$com$ibm$wsspi$security$token$Token;
    static /* synthetic */ Class class$com$ibm$wsspi$security$token$AuthorizationToken;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$com$ibm$ws$security$token$WSCredentialTokenMapper;

    public static WSCredentialTokenMapperInterface getInstance() {
        if (wsCredTokenMapper == null) {
            wsCredTokenMapper = new WSCredentialTokenMapper();
        }
        return wsCredTokenMapper;
    }

    public WSCredentialTokenMapper() {
        try {
            try {
                this.activeAuthMech = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
                if (!this.activeAuthMech.equals("SWAM")) {
                    this.ltpaServer = (LTPAServerObject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return LTPAServerObject.getLTPAServer();
                        }
                    });
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.init", (String)"104", (Object)this);
                throw privilegedActionException.getException();
            }
            this.contextManager = ContextManagerFactory.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.constructor", (String)"112", (Object)this);
            Tr.debug((TraceComponent)tc, (String)"Exception validating LTPA token.", (Object)new Object[]{exception});
            this.contextManager.setRootException((Throwable)exception);
        }
    }

    private DistributedMap getDM() {
        if (this.dm == null) {
            this.dm = DistributedMapFactory.getMap("WSSecureMap");
        }
        return this.dm;
    }

    public WSCredential createWSCredentialFromProperties(Hashtable hashtable) throws WSLoginFailedException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createWSCredentialFromProperties");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + MAP_CREDENTIAL.toString()));
            }
            securityManager.checkPermission((Permission)MAP_CREDENTIAL);
        }
        try {
            Object object;
            Object object2;
            String string;
            String string2;
            Object object3;
            Object object4;
            Object object5;
            String string3;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            ArrayList<String> arrayList = null;
            Hashtable hashtable2 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            Enumeration enumeration = hashtable.keys();
            while (enumeration != null && enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                if (string3 == null || (object5 = hashtable.get(string3)) == null) continue;
                if (!bl && string3.equals("com.ibm.wsspi.security.cred.uniqueId")) {
                    string4 = (String)object5;
                    if (!string4.startsWith("user")) {
                        string4 = "user:" + string4;
                    }
                    bl = true;
                    continue;
                }
                if (!bl2 && string3.equals("com.ibm.wsspi.security.cred.realm")) {
                    string5 = (String)object5;
                    if (!string5.equalsIgnoreCase(ContextManagerFactory.getInstance().getDefaultRealm())) {
                        Tr.warning((TraceComponent)tc, (String)"security.sap.warning.realm.does.not.match.current.realm", (Object)new Object[]{string5, ContextManagerFactory.getInstance().getDefaultRealm()});
                    }
                    bl2 = true;
                    continue;
                }
                if (!bl3 && string3.equals("com.ibm.wsspi.security.cred.securityName")) {
                    string6 = (String)object5;
                    bl3 = true;
                    continue;
                }
                if (!bl4 && string3.equals("com.ibm.wsspi.security.cred.longSecurityName")) {
                    string7 = (String)object5;
                    bl4 = true;
                    continue;
                }
                if (!bl5 && string3.equals("com.ibm.wsspi.security.cred.groups")) {
                    object4 = (ArrayList)object5;
                    arrayList = new ArrayList<String>();
                    arrayList.addAll((Collection<String>)object4);
                    object3 = arrayList.iterator();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Prepending \"group:\" to group list entries.");
                    }
                    while (object3.hasNext()) {
                        string2 = (String)object3.next();
                        string = null;
                        if (string2.startsWith("group")) continue;
                        string = "group:" + this.contextManager.getDefaultRealm() + "/" + string2;
                        arrayList.remove(string2);
                        arrayList.add(string);
                    }
                    bl5 = true;
                    continue;
                }
                if (hashtable2 == null) {
                    hashtable2 = new Hashtable();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Setting key in hashtable: " + string3));
                }
                hashtable2.put(string3, object5);
            }
            if (string7 == null || string7.length() == 0) {
                string3 = string4;
                if (string4.startsWith("user:")) {
                    string3 = string4.substring("user:".length());
                }
                string7 = RealmSecurityName.getSecurityName((String)string3);
            }
            if (string5 == null || string5.length() == 0) {
                string5 = ContextManagerFactory.getInstance().getDefaultRealm();
            }
            if (string7 == null || string7.length() == 0) {
                Tr.error((TraceComponent)tc, (String)"security.sap.error.longsecurityname.not.found.in.hashtable");
                throw new WSLoginFailedException("Did not find value for com.ibm.wsspi.security.cred.longSecurityName property.");
            }
            if (!bl) {
                Tr.error((TraceComponent)tc, (String)"security.sap.error.uniqueid.not.found.in.hashtable");
                throw new WSLoginFailedException("Did not find value for com.ibm.wsspi.security.cred.uniqueId property.");
            }
            if (!bl3) {
                Tr.error((TraceComponent)tc, (String)"security.sap.error.securityname.not.found.in.hashtable");
                throw new WSLoginFailedException("Did not find value for com.ibm.wsspi.security.cred.securityName property.");
            }
            string3 = null;
            object5 = null;
            object4 = string4;
            object3 = string5;
            string2 = string6;
            string = string7;
            ArrayList<String> arrayList2 = arrayList;
            try {
                string3 = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((String)object3, string2, string, (String)object4, arrayList2){
                    private final /* synthetic */ String val$realmPriv;
                    private final /* synthetic */ String val$securityNamePriv;
                    private final /* synthetic */ String val$longSecurityNamePriv;
                    private final /* synthetic */ String val$accessIdPriv;
                    private final /* synthetic */ ArrayList val$groupListPriv;
                    {
                        this.val$realmPriv = string;
                        this.val$securityNamePriv = string2;
                        this.val$longSecurityNamePriv = string3;
                        this.val$accessIdPriv = string4;
                        this.val$groupListPriv = arrayList;
                    }

                    public Object run() throws Exception {
                        return new WSCredentialImpl(this.val$realmPriv, this.val$securityNamePriv, this.val$longSecurityNamePriv, "", this.val$accessIdPriv, null, this.val$groupListPriv);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", (String)"320", (Object)this);
                throw privilegedActionException.getException();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Creating auth mech cred.");
            }
            if (!this.activeAuthMech.equals("SWAM")) {
                object2 = string3;
                object = this.ltpaServer;
                try {
                    object5 = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((LTPAServerObject)object, (WSCredential)object2){
                        private final /* synthetic */ LTPAServerObject val$ltpaServerPriv;
                        private final /* synthetic */ WSCredential val$regCredPriv;
                        {
                            this.val$ltpaServerPriv = lTPAServerObject;
                            this.val$regCredPriv = wSCredential;
                        }

                        public Object run() throws Exception {
                            return this.val$ltpaServerPriv.createLTPAToken(this.val$regCredPriv);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS cred.", (Object)new Object[]{privilegedActionException.getException()});
                    }
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", (String)"346", (Object)this);
                    this.contextManager.setRootException((Throwable)privilegedActionException.getException());
                    throw privilegedActionException.getException();
                }
            }
            object2 = string3;
            try {
                object5 = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((WSCredential)object2){
                    private final /* synthetic */ WSCredential val$regCredPriv;
                    {
                        this.val$regCredPriv = wSCredential;
                    }

                    public Object run() throws Exception {
                        return new WSCredentialImpl(this.val$regCredPriv, "No OID for this mechanism", RegistryUtil.nullByteArray, false, -1L);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS cred.", (Object)new Object[]{privilegedActionException.getException()});
                }
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", (String)"372", (Object)this);
                this.contextManager.setRootException((Throwable)privilegedActionException.getException());
                throw privilegedActionException.getException();
            }
            if (object5 != null && hashtable2 != null) {
                object2 = hashtable2.keys();
                while (object2 != null && object2.hasMoreElements()) {
                    Object v;
                    object = (String)object2.nextElement();
                    if (object == null || (v = hashtable2.get(object)) == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Setting key/value in hashtable of WSCred: " + (String)object + ", " + v));
                    }
                    object5.set((String)object, v);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createWSCredentialFromProperties");
            }
            return object5;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Tr.error((TraceComponent)tc, (String)"security.sap.error.credential.not.mapped", (Object)new Object[]{wSLoginFailedException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createWSCredentialFromProperties");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", (String)"410", (Object)this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.sap.error.credential.not.mapped", (Object)new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createWSCredentialFromProperties");
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", (String)"417", (Object)this);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
    }

    public WSCredential createWSCredentialFromTokens(AuthenticationToken authenticationToken, AuthorizationToken authorizationToken) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createWSCredentialFromTokens");
        }
        if (authenticationToken == null || authorizationToken == null) {
            throw new WSLoginFailedException("Passed in null parameters.");
        }
        String string = null;
        long l = 0L;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        ArrayList<String> arrayList = null;
        Object var11_10 = null;
        String string6 = null;
        boolean bl = true;
        WSCredential wSCredential = null;
        try {
            Object object;
            String string7;
            Enumeration enumeration = authorizationToken.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                string7 = (String)enumeration.nextElement();
                if ((string == null || string.length() == 0) && string7.equals("com.ibm.wsspi.security.cred.uniqueId") && (object = authorizationToken.getAttributes(string7)) != null && ((String[])object).length > 0) {
                    string = object[0];
                }
                if (l == 0L && string7.equals("com.ibm.wsspi.security.cred.expiration") && (object = authorizationToken.getAttributes(string7)) != null && ((String[])object).length > 0) {
                    l = Long.parseLong(object[0]);
                }
                if ((string2 == null || string2.length() == 0) && string7.equals("com.ibm.wsspi.security.cred.realm") && (object = authorizationToken.getAttributes(string7)) != null && ((String[])object).length > 0) {
                    string2 = object[0];
                }
                if ((string3 == null || string3.length() == 0) && string7.equals("com.ibm.wsspi.security.cred.securityName") && (object = authorizationToken.getAttributes(string7)) != null && ((String[])object).length > 0) {
                    string3 = object[0];
                }
                if ((string4 == null || string4.length() == 0) && string7.equals("com.ibm.wsspi.security.cred.longSecurityName") && (object = authorizationToken.getAttributes(string7)) != null && ((String[])object).length > 0) {
                    string4 = object[0];
                }
                if ((string5 == null || string5.length() == 0) && string7.equals("com.ibm.wsspi.security.cred.primaryGroupId") && (object = authorizationToken.getAttributes(string7)) != null && ((String[])object).length > 0) {
                    string5 = object[0];
                }
                if (arrayList == null && string7.equals("com.ibm.wsspi.security.cred.groups") && (object = authorizationToken.getAttributes(string7)) != null && ((String[])object).length > 0) {
                    arrayList = new ArrayList<String>(((String[])object).length);
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        if (object[i] == null) continue;
                        arrayList.add(object[i]);
                    }
                }
                if ((string6 == null || string6.length() == 0) && string7.equals("com.ibm.wsspi.security.cred.oid") && (object = authorizationToken.getAttributes(string7)) != null && ((String[])object).length > 0) {
                    string6 = object[0];
                }
                if (!string7.equals("com.ibm.wsspi.security.cred.forwardable")) continue;
                object = authorizationToken.getAttributes(string7);
                if (object != null && ((String[])object).length > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Forwardable string = " + object[0]));
                    }
                    bl = Boolean.valueOf(object[0]);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Forwardable attribute null: com.ibm.wsspi.security.cred.forwardable");
            }
            boolean bl2 = true;
            if (string == null || string.length() == 0) {
                throw new WSLoginFailedException("Missing the ACCESSID attribute: com.ibm.wsspi.security.cred.uniqueId");
            }
            if (l == 0L) {
                throw new WSLoginFailedException("Missing the EXPIRATION attribute: com.ibm.wsspi.security.cred.expiration");
            }
            if (string2 == null || string2.length() == 0) {
                throw new WSLoginFailedException("Missing the REALM attribute: com.ibm.wsspi.security.cred.realm");
            }
            if (string3 == null || string3.length() == 0) {
                throw new WSLoginFailedException("Missing the SECURITYNAME attribute: com.ibm.wsspi.security.cred.securityName");
            }
            if (string4 == null || string4.length() == 0) {
                throw new WSLoginFailedException("Missing the LONGSECURITYNAME attribute: com.ibm.wsspi.security.cred.longSecurityName");
            }
            if (arrayList == null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("There are no groups defined for user: " + string3));
            }
            if ((string5 == null || string5.length() == 0) && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("There is no primary group defined for user: " + string3));
            }
            if (string6 == null || string6.length() == 0) {
                throw new WSLoginFailedException("Missing the OID attribute: com.ibm.wsspi.security.cred.oid");
            }
            string7 = string2;
            object = string3;
            String string8 = string4;
            String string9 = string5;
            String string10 = string;
            ArrayList<String> arrayList2 = arrayList;
            final String string11 = string6;
            final long l2 = l;
            final boolean bl3 = bl;
            final AuthenticationToken authenticationToken2 = authenticationToken;
            WSCredential wSCredential2 = null;
            try {
                wSCredential2 = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((String)object, string8, string9, string10, arrayList2){
                    private final /* synthetic */ String val$securityNamePriv;
                    private final /* synthetic */ String val$longSecurityNamePriv;
                    private final /* synthetic */ String val$primaryGroupIdPriv;
                    private final /* synthetic */ String val$accessIdPriv;
                    private final /* synthetic */ ArrayList val$groupsPriv;
                    {
                        this.val$securityNamePriv = string2;
                        this.val$longSecurityNamePriv = string3;
                        this.val$primaryGroupIdPriv = string4;
                        this.val$accessIdPriv = string5;
                        this.val$groupsPriv = arrayList;
                    }

                    public Object run() throws Exception {
                        return new WSCredentialImpl(string7, this.val$securityNamePriv, this.val$longSecurityNamePriv, this.val$primaryGroupIdPriv != null ? this.val$primaryGroupIdPriv : RegistryUtil.nullString, this.val$accessIdPriv, null, this.val$groupsPriv);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS cred.", (Object)new Object[]{privilegedActionException.getException()});
                }
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromTokens", (String)"614", (Object)this);
                throw privilegedActionException.getException();
            }
            final WSCredential wSCredential3 = wSCredential2;
            try {
                wSCredential = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new WSCredentialImpl(wSCredential3, string11, ((AbstractTokenImpl)authenticationToken2).getToken(), bl3, l2);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS cred.", (Object)new Object[]{privilegedActionException.getException()});
                }
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromTokens", (String)"637", (Object)this);
                throw privilegedActionException.getException();
            }
            if (wSCredential == null) {
                throw new WSLoginFailedException("WSCredential is null.");
            }
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Tr.error((TraceComponent)tc, (String)"security.sap.error.credential.not.mapped", (Object)new Object[]{wSLoginFailedException});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WSLoginFailedException occurred creating new WS cred from SAP tokens.");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromTokens", (String)"651", (Object)this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.sap.error.credential.not.mapped", (Object)new Object[]{exception});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS cred from SAP tokens.");
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromTokens", (String)"658", (Object)this);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("WSCredential created with the following values: \n");
        stringBuffer.append("\trealm = ");
        stringBuffer.append(string2);
        stringBuffer.append("\n\tsecurityName = ");
        stringBuffer.append(string3);
        stringBuffer.append("\n\tlongSecurityName = ");
        stringBuffer.append(string4);
        stringBuffer.append("\n\taccessId = ");
        stringBuffer.append(string);
        stringBuffer.append("\n\tGroup count = ");
        stringBuffer.append(arrayList != null ? String.valueOf(arrayList.size()) : "0");
        stringBuffer.append("\n\toid = ");
        stringBuffer.append(string6);
        stringBuffer.append("\n\texpiration = ");
        stringBuffer.append(l);
        stringBuffer.append("\n\tforwardable = ");
        stringBuffer.append(bl);
        stringBuffer.append("\n");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createWSCredentialFromTokens");
        }
        return wSCredential;
    }

    public AuthenticationToken createAuthTokenFromWSCredential(WSCredential wSCredential) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createAuthTokenFromWSCredential");
        }
        byte[] byArray = null;
        try {
            byArray = wSCredential.getCredentialToken();
            AuthenticationTokenImpl authenticationTokenImpl = new AuthenticationTokenImpl();
            authenticationTokenImpl.initializeToken(null, byArray);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createAuthTokenFromWSCredential");
            }
            return authenticationTokenImpl;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Tr.error((TraceComponent)tc, (String)"security.sap.error.authentication.token.not.mapped", (Object)new Object[]{wSLoginFailedException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createAuthTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthTokenFromWSCredential", (String)"717", (Object)this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.sap.error.authentication.token.not.mapped", (Object)new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createAuthTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthTokenFromWSCredential", (String)"724", (Object)this);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
    }

    public SingleSignonToken createSSOTokenFromWSCredential(WSCredential wSCredential) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSSOTokenFromWSCredential");
        }
        com.ibm.wsspi.security.ltpa.Token token = null;
        try {
            Object object;
            String string = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.singleSignonTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating sso token using factory " + string + " for caller: " + wSCredential.getSecurityName()));
            }
            try {
                object = this.ltpaServer;
                token = (com.ibm.wsspi.security.ltpa.Token)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((LTPAServerObject)object, wSCredential, string){
                    private final /* synthetic */ LTPAServerObject val$ltpaServerPriv;
                    private final /* synthetic */ WSCredential val$wsCred;
                    private final /* synthetic */ String val$factory;
                    {
                        this.val$ltpaServerPriv = lTPAServerObject;
                        this.val$wsCred = wSCredential;
                        this.val$factory = string;
                    }

                    public Object run() throws Exception {
                        return this.val$ltpaServerPriv.createLTPAToken(this.val$wsCred.getAccessId(), this.val$factory);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthzTokenFromWSCredential", (String)"767", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createSSOTokenFromWSCredential", (Object)new Object[]{privilegedActionException.getException()});
                }
                throw privilegedActionException.getException();
            }
            object = new SingleSignonTokenImpl();
            ((SingleSignonTokenImpl)((Object)object)).initializeToken(token);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSSOTokenFromWSCredential");
            }
            return object;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Tr.error((TraceComponent)tc, (String)"security.sap.error.single.signon.token.not.mapped", (Object)new Object[]{wSLoginFailedException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSSOTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createSSOTokenFromWSCredential", (String)"781", (Object)this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.sap.error.single.signon.token.not.mapped", (Object)new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSSOTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createSSOTokenFromWSCredential", (String)"788", (Object)this);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
    }

    public AuthorizationToken createAuthzTokenFromWSCredential(WSCredential wSCredential) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createAuthzTokenFromWSCredential");
        }
        com.ibm.wsspi.security.ltpa.Token token = null;
        try {
            ArrayList arrayList;
            Object object;
            String string = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.authorizationTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating authorization token using factory " + string + " for caller: " + wSCredential.getSecurityName()));
            }
            try {
                object = this.ltpaServer;
                token = (com.ibm.wsspi.security.ltpa.Token)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((LTPAServerObject)object, wSCredential, string){
                    private final /* synthetic */ LTPAServerObject val$ltpaServerPriv;
                    private final /* synthetic */ WSCredential val$wsCred;
                    private final /* synthetic */ String val$factory;
                    {
                        this.val$ltpaServerPriv = lTPAServerObject;
                        this.val$wsCred = wSCredential;
                        this.val$factory = string;
                    }

                    public Object run() throws Exception {
                        return this.val$ltpaServerPriv.createLTPAToken(this.val$wsCred.getAccessId(), this.val$factory);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthzTokenFromWSCredential", (String)"830", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createAuthzTokenFromWSCredential", (Object)new Object[]{privilegedActionException.getException()});
                }
                throw privilegedActionException.getException();
            }
            token.addAttribute("com.ibm.wsspi.security.cred.uniqueId", wSCredential.getAccessId());
            token.addAttribute("com.ibm.wsspi.security.cred.expiration", String.valueOf(wSCredential.getExpiration()));
            token.addAttribute("com.ibm.wsspi.security.cred.realm", wSCredential.getRealmName());
            token.addAttribute("com.ibm.wsspi.security.cred.securityName", wSCredential.getSecurityName());
            token.addAttribute("com.ibm.wsspi.security.cred.longSecurityName", wSCredential.getUniqueSecurityName());
            token.addAttribute("com.ibm.wsspi.security.cred.primaryGroupId", wSCredential.getPrimaryGroupId());
            object = wSCredential.get("com.ibm.wsspi.security.cred.cacheKey");
            if (object != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Setting cache key in Authz token: " + object.toString()));
                }
                token.addAttribute("com.ibm.wsspi.security.cred.cacheKey", object.toString());
            }
            if ((arrayList = wSCredential.getGroupIds()) != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2 = (String)arrayList.get(i);
                    token.addAttribute("com.ibm.wsspi.security.cred.groups", string2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Setting group list: " + arrayList));
                }
            }
            token.addAttribute("com.ibm.wsspi.security.cred.oid", wSCredential.getOID());
            boolean bl = wSCredential.isForwardable();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Forwardable string set as: " + bl));
            }
            token.addAttribute("com.ibm.wsspi.security.cred.forwardable", String.valueOf(bl));
            AuthorizationTokenImpl authorizationTokenImpl = new AuthorizationTokenImpl();
            authorizationTokenImpl.initializeToken(token);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createAuthzTokenFromWSCredential");
            }
            return authorizationTokenImpl;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Tr.error((TraceComponent)tc, (String)"security.sap.error.authorization.token.not.mapped", (Object)new Object[]{wSLoginFailedException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createAuthzTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthzTokenFromWSCredential", (String)"889", (Object)this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.sap.error.authorization.token.not.mapped", (Object)new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createAuthzTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthzTokenFromWSCredential", (String)"896", (Object)this);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
    }

    public PropagationToken createPropagationTokenFromWSCredential(WSCredential wSCredential) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createPropagationTokenFromWSCredential");
        }
        try {
            Object object;
            String string = this.contextManager.getProperty("com.ibm.CSI.CellNodeServer");
            String string2 = string + ":" + wSCredential.getRealmSecurityName();
            String string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.propagationTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating propagation token using factory " + string3 + " for caller: " + string2 + ", host: " + string));
            }
            com.ibm.wsspi.security.ltpa.Token token = null;
            try {
                object = this.ltpaServer;
                token = (com.ibm.wsspi.security.ltpa.Token)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((LTPAServerObject)object, wSCredential, string3){
                    private final /* synthetic */ LTPAServerObject val$ltpaServerPriv;
                    private final /* synthetic */ WSCredential val$wsCred;
                    private final /* synthetic */ String val$factory;
                    {
                        this.val$ltpaServerPriv = lTPAServerObject;
                        this.val$wsCred = wSCredential;
                        this.val$factory = string;
                    }

                    public Object run() throws Exception {
                        return this.val$ltpaServerPriv.createLTPAToken(this.val$wsCred.getAccessId(), this.val$factory);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenFromWSCredential", (String)"941", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createPropagationTokenFromWSCredential", (Object)new Object[]{privilegedActionException.getException()});
                }
                throw privilegedActionException.getException();
            }
            token.addAttribute("com.ibm.wsspi.security.propagation.callers", string2);
            token.addAttribute("com.ibm.wsspi.security.propagation.hosts", string);
            object = new PropagationTokenImpl();
            ((PropagationTokenImpl)((Object)object)).initializeToken(token);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createPropagationTokenFromWSCredential");
            }
            return object;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Tr.error((TraceComponent)tc, (String)"security.sap.error.propagation.token.not.mapped", (Object)new Object[]{wSLoginFailedException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createPropagationTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenFromWSCredential", (String)"961", (Object)this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.sap.error.propagation.token.not.mapped", (Object)new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createPropagationTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenFromWSCredential", (String)"968", (Object)this);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
    }

    public PropagationToken createPropagationTokenBeforeAuthenticatedCallerSet() throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createPropagationTokenBeforeAuthenticatedCallerSet");
        }
        try {
            Object object;
            String string = this.contextManager.getProperty("com.ibm.CSI.CellNodeServer");
            String string2 = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.propagationTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating propagation token using factory " + string2 + " for host: " + string));
            }
            com.ibm.wsspi.security.ltpa.Token token = null;
            try {
                object = this.ltpaServer;
                token = (com.ibm.wsspi.security.ltpa.Token)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((LTPAServerObject)object, string2){
                    private final /* synthetic */ LTPAServerObject val$ltpaServerPriv;
                    private final /* synthetic */ String val$factory;
                    {
                        this.val$ltpaServerPriv = lTPAServerObject;
                        this.val$factory = string;
                    }

                    public Object run() throws Exception {
                        return this.val$ltpaServerPriv.createLTPAToken("user:" + ContextManagerFactory.getInstance().getUnauthenticatedString(), this.val$factory);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", (String)"999", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createPropagationTokenFromWSCredential", (Object)new Object[]{privilegedActionException.getException()});
                }
                throw privilegedActionException.getException();
            }
            if (token != null) {
                token.addAttribute("com.ibm.wsspi.security.propagation.hosts", string);
                object = new PropagationTokenImpl();
                ((PropagationTokenImpl)((Object)object)).initializeToken(token);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createPropagationTokenBeforeAuthenticatedCallerSet");
                }
                return object;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createPropagationTokenBeforeAuthenticatedCallerSet returns null.");
            }
            return null;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            Tr.error((TraceComponent)tc, (String)"security.sap.error.propagation.token.not.mapped", (Object)new Object[]{wSLoginFailedException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createPropagationTokenBeforeAuthenticatedCallerSet");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", (String)"1025", (Object)this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.sap.error.propagation.token.not.mapped", (Object)new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createPropagationTokenBeforeAuthenticatedCallerSet");
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", (String)"1032", (Object)this);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
    }

    public com.ibm.wsspi.security.ltpa.Token validateLTPAToken(byte[] byArray) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateLTPAToken");
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validateLTPAToken");
            }
            return this.ltpaServer.validateToken(byArray);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred validating LTPA token.", (Object)new Object[]{wSLoginFailedException});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validateLTPAToken");
            }
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", (String)"1051", (Object)this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred validating LTPA token.", (Object)new Object[]{exception});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validateLTPAToken");
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", (String)"1058", (Object)this);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
    }

    public byte[] getOpaqueTokenFromMBean(ByteArray byteArray, String string, Properties properties) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOpaqueTokenFromMBean", (Object)new Object[]{string, properties});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + GET_OPAQUE_TOKEN_FROM_MBEAN.toString()));
            }
            securityManager.checkPermission((Permission)GET_OPAQUE_TOKEN_FROM_MBEAN);
        }
        AdminClient adminClient = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        ObjectName objectName = null;
        try {
            Set set;
            Object object;
            Object object2;
            Properties properties2 = (Properties)SecurityConfig.getConfig().getValue("process.jmxConnectorProps");
            Enumeration<?> enumeration = properties2.propertyNames();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = (String)properties2.get(object2);
                if (object2 == null || object == null || ((String)object).length() <= 0 || ((String)object2).equals("type") || ((String)object2).equals("host") || ((String)object2).equals("port")) continue;
                properties.setProperty((String)object2, (String)object);
            }
            adminClient = AdminClientFactory.createAdminClient((Properties)properties);
            object2 = new StringTokenizer(string, ":");
            if (object2 != null) {
                string2 = ((StringTokenizer)object2).nextToken();
                string3 = ((StringTokenizer)object2).nextToken();
                string4 = ((StringTokenizer)object2).nextToken();
            }
            if ((set = adminClient.queryNames((ObjectName)(object = new ObjectName("WebSphere:type=SecurityAdmin,cell=" + string2 + ",node=" + string3 + ",process=" + string4 + ",*")), null)).isEmpty()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getOpaqueTokenFromMBean: SecurityAdmin MBean was not found using queryString " + object));
                }
                return null;
            }
            objectName = (ObjectName)set.iterator().next();
            TokenHolder tokenHolder = (TokenHolder)adminClient.invoke(objectName, "getOpaqueToken", new Object[]{byteArray}, new String[]{"com.ibm.ws.security.util.ByteArray"});
            if (tokenHolder != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Returning opaque token from MBean.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getOpaqueTokenFromMBean");
                }
                return tokenHolder.getBytes();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning null opaque token.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getOpaqueTokenFromMBean");
            }
            return null;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred getting admin client connection.", (Object)new Object[]{malformedObjectNameException});
            }
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.getOpaqueTokenFromMBean", (String)"1149", (Object)this);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred getting admin client connection.", (Object)new Object[]{instanceNotFoundException});
            }
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.getOpaqueTokenFromMBean", (String)"1154", (Object)this);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred getting admin client connection.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.getOpaqueTokenFromMBean", (String)"1159", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOpaqueTokenFromMBean");
        }
        return null;
    }

    public Object getDistributedObject(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDistributedObject: " + object));
        }
        try {
            DistributedMap distributedMap = this.getDM();
            if (distributedMap != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getDistributedObject");
                }
                return distributedMap.get(object);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getDistributedObject returns null.");
            }
            return null;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred getting distributed object.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.getDistributedObject", (String)"1187", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getDistributedObject (null)");
            }
            return null;
        }
    }

    public Object putDistributedObject(Object object, Object object2, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("putDistributedObject: " + object));
        }
        try {
            DistributedMap distributedMap = this.getDM();
            if (distributedMap != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"putDistributedObject");
                }
                return distributedMap.put(object, object2, 1, n, 2, null);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"putDistributedObject returns null.");
            }
            return null;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred putting distributed object.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.putDistributedObject", (String)"1234", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"putDistributedObject (null)");
            }
            return null;
        }
    }

    public Object putDistributedObject(Object object, Object object2, int n, int n2, int n3, Object[] objectArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"putDistributedObject: ", (Object)new Object[]{object, new Integer(n), new Integer(n2), new Integer(n3), objectArray});
        }
        try {
            DistributedMap distributedMap = this.getDM();
            if (distributedMap != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"putDistributedObject");
                }
                return distributedMap.put(object, object2, n, n2, n3, objectArray);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"putDistributedObject returns null.");
            }
            return null;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred putting distributed object.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.putDistributedObject", (String)"1289", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"putDistributedObject (null)");
            }
            return null;
        }
    }

    public void invalidateDistributedObject(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"invalidateDistributedObject: ", (Object)new Object[]{object});
        }
        try {
            DistributedMap distributedMap = this.getDM();
            if (distributedMap != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"invalidateDistributedObject");
                }
                distributedMap.invalidate(object);
                return;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"invalidateDistributedObject returns null.");
            }
            return;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred invalidating distributed object.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.invalidateDistributedObject", (String)"1320", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"invalidateDistributedObject");
            }
            return;
        }
    }

    public String createSubjectUniqueID(final Subject subject) {
        String string;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"createSubjectUniqueID");
            }
            if (subject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Subject is null.");
                }
                return null;
            }
            string = null;
            try {
                string = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        String string;
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        Set set;
                        Object object5 = null;
                        Object object6 = WSCredentialTokenMapper.this.getCacheKeyFromHashtable(subject);
                        if (object6 != null) {
                            object5 = object6 instanceof String ? (String)object6 : object6.toString();
                        }
                        if ((set = subject.getPrivateCredentials(class$com$ibm$wsspi$security$token$Token == null ? (class$com$ibm$wsspi$security$token$Token = WSCredentialTokenMapper.class$("com.ibm.wsspi.security.token.Token")) : class$com$ibm$wsspi$security$token$Token)) != null && set.size() > 0) {
                            object4 = set.iterator();
                            while (object4.hasNext()) {
                                object3 = object4.next();
                                if (object3 == null || !(object3 instanceof Token)) continue;
                                object2 = ((Token)object3).getUniqueID();
                                object = ((Token)object3).getPrincipal();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Token found, ID/Principal: ", (Object)new Object[]{object2, object});
                                }
                                if (object2 == null || ((String)object2).length() <= 0) continue;
                                if (object != null && ((String)object).length() > 0) {
                                    object5 = object5 == null ? object : (String)object5 + ":" + (String)object;
                                }
                                if (object5 == null) {
                                    object5 = object2;
                                    continue;
                                }
                                object5 = (String)object5 + ":" + (String)object2;
                            }
                        }
                        if ((object4 = subject.getPublicCredentials(class$com$ibm$wsspi$security$token$Token == null ? (class$com$ibm$wsspi$security$token$Token = WSCredentialTokenMapper.class$("com.ibm.wsspi.security.token.Token")) : class$com$ibm$wsspi$security$token$Token)) != null && object4.size() > 0) {
                            object3 = object4.iterator();
                            while (object3.hasNext()) {
                                object2 = object3.next();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"token found, looking for uniqueID.", (Object)new Object[]{object2});
                                }
                                if (object2 == null || !(object2 instanceof Token)) continue;
                                object = ((Token)object2).getUniqueID();
                                string = ((Token)object2).getPrincipal();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"ID/Principal: ", (Object)new Object[]{object, string});
                                }
                                if (object == null || ((String)object).length() <= 0) continue;
                                if (string != null && string.length() > 0) {
                                    object5 = object5 == null ? string : (String)object5 + ":" + string;
                                }
                                if (object5 == null) {
                                    object5 = object;
                                    continue;
                                }
                                object5 = (String)object5 + ":" + (String)object;
                            }
                        }
                        if (object5 != null && ((String)object5).length() > 0) {
                            object3 = ServerCredSigner.getInstance();
                            object2 = object3.getOneWayHash((String)object5);
                            object = new BigInteger((byte[])object2);
                            string = ((BigInteger)object).toString();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("createSubjectUniqueID returns uniqueID (" + (String)object5 + ") as one-way hash: " + string));
                            }
                            return string;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"createSubjectUniqueID returns null for uniqueID.");
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createSubjectUniqueID", (String)"1466", (Object)this);
                if (!tc.isEntryEnabled()) break block6;
                Tr.exit((TraceComponent)tc, (String)"createSubjectUniqueID throwing exception.", (Object)new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSubjectUniqueID");
        }
        return string;
    }

    public String createUniqueIDFromAllTokens(final Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createUniqueIDFromAllTokens");
        }
        String string = null;
        try {
            string = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Object object;
                    String string = WSCredentialTokenMapper.this.createSubjectUniqueID(subject);
                    if (string == null) {
                        try {
                            object = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                            string = object.getRealmUniqueSecurityName();
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createUniqueIDFromAllTokens", (String)"1498", (Object)this);
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"createUniqueIDFromAllTokens catching exception accessing WSCredential and returning null.", (Object)new Object[]{exception});
                            }
                            return null;
                        }
                    }
                    if ((object = WSCredentialTokenMapper.this.contextManager.getPropagationTokens()) != null) {
                        String string2 = null;
                        Iterator iterator = object.values().iterator();
                        while (iterator.hasNext()) {
                            PropagationToken propagationToken = (PropagationToken)iterator.next();
                            if (propagationToken == null || propagationToken.getUniqueID() == null) continue;
                            if (string2 != null) {
                                string2 = string2 + ":" + propagationToken.getUniqueID();
                                continue;
                            }
                            string2 = propagationToken.getUniqueID();
                        }
                        if (string2 != null) {
                            string = string + ":" + string2;
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)("createUniqueIDFromAllTokens: " + string));
                        }
                        return string;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("createUniqueIDFromAllTokens: no PropTokens set on thread: " + string));
                    }
                    return string;
                }
            });
            return string;
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createUniqueIDFromAllTokens", (String)"1550", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createUniqueIDFromAllTokens throwing exception.", (Object)new Object[]{privilegedActionException.getException()});
            }
            return null;
        }
    }

    public String getUniqueIDFromAuthzToken(final Subject subject) {
        String string;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getUniqueIDFromAuthzToken");
            }
            string = null;
            if (subject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Subject is null.");
                }
                return null;
            }
            try {
                string = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Set set = subject.getPrivateCredentials(class$com$ibm$wsspi$security$token$AuthorizationToken == null ? (class$com$ibm$wsspi$security$token$AuthorizationToken = WSCredentialTokenMapper.class$("com.ibm.wsspi.security.token.AuthorizationToken")) : class$com$ibm$wsspi$security$token$AuthorizationToken);
                        if (set != null && set.size() > 0) {
                            Iterator iterator = set.iterator();
                            while (iterator.hasNext()) {
                                String[] stringArray;
                                AuthorizationToken authorizationToken = (AuthorizationToken)iterator.next();
                                if (authorizationToken == null || !authorizationToken.getName().equals("com.ibm.ws.security.token.AuthorizationTokenImpl") || (stringArray = authorizationToken.getAttributes("hashed_uid")) == null || stringArray[0] == null) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("getUniqueIDFromAuthzToken returning uniqueID: " + stringArray[0]));
                                }
                                return stringArray[0];
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.createSubjectUniqueID", (String)"1603", (Object)this);
                if (!tc.isEntryEnabled()) break block6;
                Tr.exit((TraceComponent)tc, (String)"getUniqueIDFromAuthzToken throwing exception.", (Object)new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueIDFromAuthzToken");
        }
        return string;
    }

    public Object getCacheKeyFromHashtable(final Subject subject) {
        Object object;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getCacheKeyFromHashtable");
            }
            if (subject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Subject is null.");
                }
                return null;
            }
            object = null;
            try {
                object = AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        HashSet hashSet = new HashSet();
                        Set set = subject.getPrivateCredentials(class$java$util$Hashtable == null ? (class$java$util$Hashtable = WSCredentialTokenMapper.class$("java.util.Hashtable")) : class$java$util$Hashtable);
                        Set set2 = subject.getPublicCredentials(class$java$util$Hashtable == null ? (class$java$util$Hashtable = WSCredentialTokenMapper.class$("java.util.Hashtable")) : class$java$util$Hashtable);
                        if (set2.size() > 0) {
                            hashSet.addAll(set2);
                        }
                        if (set.size() > 0) {
                            hashSet.addAll(set);
                        }
                        if (hashSet != null && hashSet.size() > 0) {
                            Iterator iterator = hashSet.iterator();
                            while (iterator.hasNext()) {
                                Hashtable hashtable = (Hashtable)iterator.next();
                                if (hashtable == null) continue;
                                Object v = hashtable.get("com.ibm.wsspi.security.cred.cacheKey");
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Returning cache key for lookup: " + v));
                                }
                                return v;
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.getCacheKeyFromHashtable", (String)"1667", (Object)this);
                if (!tc.isEntryEnabled()) break block6;
                Tr.exit((TraceComponent)tc, (String)"getCacheKeyFromHashtable throwing exception.", (Object)new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCacheKeyFromHashtable");
        }
        return object;
    }

    public boolean subjectContainsLoginHashtable(final Subject subject) {
        Boolean bl;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"subjectContainsLoginHashtable");
            }
            bl = Boolean.valueOf("false");
            if (subject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Subject is null.");
                }
                return bl;
            }
            try {
                bl = (Boolean)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        HashSet hashSet = new HashSet();
                        Set set = subject.getPrivateCredentials(class$java$util$Hashtable == null ? (class$java$util$Hashtable = WSCredentialTokenMapper.class$("java.util.Hashtable")) : class$java$util$Hashtable);
                        Set set2 = subject.getPublicCredentials(class$java$util$Hashtable == null ? (class$java$util$Hashtable = WSCredentialTokenMapper.class$("java.util.Hashtable")) : class$java$util$Hashtable);
                        if (set2.size() > 0) {
                            hashSet.addAll(set2);
                        }
                        if (set.size() > 0) {
                            hashSet.addAll(set);
                        }
                        if (hashSet != null && hashSet.size() > 0) {
                            Iterator iterator = hashSet.iterator();
                            while (iterator.hasNext()) {
                                Hashtable hashtable = (Hashtable)iterator.next();
                                if (hashtable == null || hashtable.get("com.ibm.wsspi.security.cred.securityName") == null || hashtable.get("com.ibm.wsspi.security.cred.uniqueId") == null) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Subject contains valid login Hashtable.");
                                }
                                return Boolean.valueOf("true");
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Subject does not contain valid login Hashtable.");
                        }
                        return Boolean.valueOf("false");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.token.WSCredentialTokenMapper.subjectContainsLoginHashtable", (String)"1734", (Object)this);
                if (!tc.isEntryEnabled()) break block6;
                Tr.exit((TraceComponent)tc, (String)"subjectContainsLoginHashtable throwing exception.", (Object)new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("subjectContainsLoginHashtable -> " + bl));
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

