/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;

public class AuthenticationResult {
    public static final int UNKNOWN = 0;
    public static final int SUCCESS = 1;
    public static final int FAILURE = 2;
    public static final int SEND_401 = 3;
    public static final int REDIRECT = 4;
    public static final int TAI_CHALLENGE = 5;
    public static final int CONTINUE = 6;
    int status;
    private int taiChallengeCode = 401;
    String realm = null;
    String userName = null;
    String passWord = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$web$AuthenticationResult == null ? (class$com$ibm$ws$security$web$AuthenticationResult = AuthenticationResult.class$("com.ibm.ws.security.web.AuthenticationResult")) : class$com$ibm$ws$security$web$AuthenticationResult), null, (String)"com.ibm.ejs.resources.security");
    Subject subject = null;
    WSCredential credentials = null;
    ArrayList cookieList = new ArrayList();
    Cookie refererCookie;
    String reason;
    String redirectURL;
    static /* synthetic */ Class class$com$ibm$ws$security$web$AuthenticationResult;

    public AuthenticationResult(int n, Subject subject) {
        this.status = n;
        this.subject = subject;
        if (n != 0) {
            try {
                this.credentials = SubjectHelper.getWSCredentialFromSubject((Subject)this.subject);
            }
            catch (Exception exception) {
                this.credentials = null;
            }
        } else {
            this.credentials = null;
        }
    }

    public AuthenticationResult(int n, String string) {
        this(n, string, null);
    }

    public AuthenticationResult(int n, String string, int n2) {
        this(n, string, null);
        this.taiChallengeCode = n2;
    }

    public AuthenticationResult(int n, String string, Cookie cookie) {
        this.status = n;
        this.subject = null;
        if (n == 2) {
            this.reason = string;
        } else if (n == 3) {
            this.realm = string;
        } else if (n == 4) {
            this.redirectURL = string;
            this.refererCookie = cookie;
        }
        this.cookieList.add(cookie);
    }

    public int getStatus() {
        return this.status;
    }

    public int getTAIChallengeCode() {
        return this.taiChallengeCode;
    }

    public String getReason() {
        return this.reason;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getRealm() {
        if (this.credentials == null && this.realm != null) {
            return this.realm;
        }
        if (this.credentials != null) {
            try {
                return this.credentials.getRealmName();
            }
            catch (GeneralSecurityException generalSecurityException) {
                FFDCFilter.processException((Throwable)generalSecurityException, (String)(this.getClass().getName() + ".getRealm"), (String)"150", (Object)this);
                return null;
            }
        }
        return ContextManagerFactory.getInstance().getDefaultRealm();
    }

    public String getUserName() {
        if (this.credentials == null && this.userName != null) {
            return this.userName;
        }
        try {
            return this.credentials == null ? null : this.credentials.getSecurityName();
        }
        catch (GeneralSecurityException generalSecurityException) {
            FFDCFilter.processException((Throwable)generalSecurityException, (String)(this.getClass().getName() + ".getRealm"), (String)"171", (Object)this);
            return null;
        }
    }

    public String getPublicName() {
        try {
            return this.credentials == null ? null : this.credentials.getRealmSecurityName();
        }
        catch (GeneralSecurityException generalSecurityException) {
            FFDCFilter.processException((Throwable)generalSecurityException, (String)(this.getClass().getName() + ".getRealm"), (String)"184", (Object)this);
            return null;
        }
    }

    public String getAccessId() {
        try {
            return this.credentials == null ? null : this.credentials.getAccessId();
        }
        catch (GeneralSecurityException generalSecurityException) {
            FFDCFilter.processException((Throwable)generalSecurityException, (String)(this.getClass().getName() + ".getRealm"), (String)"196", (Object)this);
            return null;
        }
    }

    public byte[] getCredentialToken() {
        try {
            return this.credentials == null ? null : this.credentials.getCredentialToken();
        }
        catch (GeneralSecurityException generalSecurityException) {
            FFDCFilter.processException((Throwable)generalSecurityException, (String)(this.getClass().getName() + ".getRealm"), (String)"203", (Object)this);
            return null;
        }
    }

    public void clearCookieList() {
        this.cookieList.clear();
    }

    public void setCookieList(ArrayList arrayList) {
        this.cookieList.addAll(arrayList);
    }

    public void setCookie(Cookie cookie) {
        this.cookieList.add(cookie);
    }

    public ArrayList getCookies() {
        return this.cookieList;
    }

    public Cookie getRefererCookie() {
        return this.refererCookie;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

