/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.web.FormLoginInfo;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebAuthenticator;
import com.ibm.ws.security.web.WebCollaborator;
import com.ibm.ws.webcontainer.session.IHttpSession;
import com.ibm.ws.webcontainer.webapp.WebApp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class FormLoginServlet
extends HttpServlet {
    private String loginPage = null;
    private String loginErrorPage = null;
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$web$FormLoginServlet == null ? (class$com$ibm$ws$security$web$FormLoginServlet = FormLoginServlet.class$("com.ibm.ws.security.web.FormLoginServlet")) : class$com$ibm$ws$security$web$FormLoginServlet), null, (String)"com.ibm.ejs.resources.security");
    private WebAttributes webAttrs = null;
    static /* synthetic */ Class class$com$ibm$ws$security$web$FormLoginServlet;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            com.ibm.etools.webapplication.WebApp webApp = (com.ibm.etools.webapplication.WebApp)((WebApp)this.getServletContext()).getWebAppContext().getConfiguration().getDeploymentDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Create WebAttributes for this webApp.");
            }
            this.webAttrs = new WebAttributes(webApp);
            this.loginPage = this.webAttrs.getLoginURL();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("login page is: " + this.loginPage));
            }
            this.loginErrorPage = this.webAttrs.getReloginURL();
            if (this.loginErrorPage != null && !this.loginErrorPage.startsWith("/")) {
                this.loginErrorPage = "/" + this.loginErrorPage;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("login error page is: " + this.loginErrorPage));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.FormLoginServlet.init", (String)"124", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.web.form.noWebAppInfo", (Object)new Object[]{exception});
        }
    }

    public void destroy() {
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.formLogin(httpServletRequest, httpServletResponse);
    }

    private void formLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        String string2;
        String string3;
        CharSequence charSequence;
        boolean bl = false;
        WSCredential wSCredential = null;
        Subject subject = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("formLogin, WebAttributes: \n" + this.webAttrs.toString()));
        }
        String string4 = null;
        if (this.loginErrorPage != null) {
            charSequence = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
            string3 = ((StringBuffer)charSequence).toString();
            String string5 = httpServletRequest.getContextPath();
            if (string5.equals("/")) {
                string5 = "";
            }
            int n = string3.indexOf("//");
            n = string3.indexOf("/", n + 2);
            int n2 = string3.length();
            string4 = string5 + this.loginErrorPage;
            ((StringBuffer)charSequence).replace(n, n2, string4);
            string4 = ((StringBuffer)charSequence).toString();
        }
        charSequence = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
        string3 = null;
        string3 = ((String)charSequence).equals("LTPA") ? (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundLoginConfig") : "system." + (String)charSequence;
        boolean bl2 = false;
        Boolean bl3 = (Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred");
        if (bl3.booleanValue() && !((Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.enabled")).booleanValue()) {
            Tr.error((TraceComponent)tc, (String)"security.formlogin.badconfig", (Object)new Object[]{this.webAttrs.getWebAppName()});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Configuration error.  SSO Not enabled when using FormLogin. Redirecting to error page: " + string4));
            }
            httpServletResponse.setStatus(401);
            httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string4));
            return;
        }
        String string6 = httpServletRequest.getParameter("j_username");
        String string7 = httpServletRequest.getParameter("j_password");
        if (string6 == null || string7 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"username and/or password are not present");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Redirecting to error page: " + string4));
            }
            httpServletResponse.setStatus(401);
            httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string4));
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Form based login: userid/password present in the form. User is: " + string6));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        try {
            hashMap.put("WebAppName", this.webAttrs.getWebAppName());
            hashMap.put("RedirectURL", string4);
            subject = ContextManagerFactory.getInstance().login(ContextManagerFactory.getInstance().getDefaultRealm(), string6, string7, string3, httpServletRequest, httpServletResponse, hashMap);
            string2 = null;
            try {
                string2 = (String)hashMap.get("RedirectURL");
            }
            catch (Throwable throwable) {
                string2 = null;
                Tr.error((TraceComponent)tc, (String)"incorrect customized error page: ", (Object)new Object[]{throwable});
            }
            if (string2 != null && string2.length() > 0) {
                string4 = string2;
            }
            wSCredential = (WSCredential)subject.getPublicCredentials(Class.forName("com.ibm.websphere.security.cred.WSCredential")).iterator().next();
            if (subject == null || wSCredential == null) {
                Tr.audit((TraceComponent)tc, (String)"security.authn.failed.foruser", (Object)new Object[]{string6});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Redirecting to error page: " + string4));
                }
                httpServletResponse.setStatus(401);
                httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string4));
                return;
            }
            ContextManagerFactory.getInstance().setInvocationSubject(subject);
            ContextManagerFactory.getInstance().setCallerSubject(subject);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.FormLoginServlet.formLogin", (String)"218", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.authn.error.foruser", (Object)new Object[]{string6});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Redirecting to error page: " + string4));
            }
            httpServletResponse.setStatus(401);
            httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string4));
            return;
        }
        WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", "FORM");
        string2 = null;
        FormLoginInfo formLoginInfo = null;
        if (((String)charSequence).equals("SWAM")) {
            string2 = httpServletRequest.getSession(true);
            if (string2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Form based login: Store auth data in the HTTP Session");
                }
                if ((formLoginInfo = (FormLoginInfo)((IHttpSession)string2).getSecurityInfo()) == null) {
                    formLoginInfo = new FormLoginInfo(string6, string7);
                } else {
                    formLoginInfo.setUsername(string6);
                    formLoginInfo.setPassword(string7);
                }
                ((IHttpSession)string2).putSecurityInfo((Object)formLoginInfo);
            }
            bl2 = false;
        } else {
            string = null;
            boolean bl4 = false;
            bl2 = false;
            boolean bl5 = false;
            if (this.webAttrs.isSSOEnabled()) {
                bl5 = true;
                if (this.webAttrs.isSecureSSO()) {
                    bl2 = httpServletRequest.getScheme().equalsIgnoreCase("https");
                    bl4 = true;
                } else {
                    bl2 = true;
                }
            }
            if (bl2) {
                try {
                    ArrayList arrayList = WebAttributes.createCookies(httpServletRequest, subject);
                    this.clearCookie(httpServletRequest, httpServletResponse);
                    if (arrayList != null) {
                        ListIterator listIterator = arrayList.listIterator();
                        while (listIterator.hasNext()) {
                            Cookie cookie = (Cookie)listIterator.next();
                            httpServletResponse.addCookie(cookie);
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.FormLoginServlet.formLogin", (String)"309", (Object)((Object)this));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Redirecting to error page: " + string4));
                    }
                    httpServletResponse.setStatus(401);
                    httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string4));
                    return;
                }
            }
        }
        string = "";
        if (((String)charSequence).equals("SWAM")) {
            string = formLoginInfo.getRefererURL();
        } else {
            Cookie[] cookieArray = httpServletRequest.getCookies();
            string = WebAuthenticator.getCookieValue(cookieArray, "WASReqURL");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Successful auth - redirecting to the original URL" + string));
        }
        if (string != null) {
            if (string.equals("/")) {
                string = "";
            } else if (string.startsWith("/")) {
                string = string.substring(1);
            }
        }
        if (string == null) {
            string = "";
        }
        httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string));
    }

    private void clearCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Cookie[] cookieArray;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clearCookie");
        }
        if ((string = WebAuthenticator.getCookieValue(cookieArray = httpServletRequest.getCookies(), "WASReqURL")) != null && string.length() > 0) {
            Cookie cookie = new Cookie("WASReqURL", "");
            cookie.setPath("/");
            cookie.setMaxAge(0);
            httpServletResponse.addCookie(cookie);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cleared REFERER_URL cookie. Original value was " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clearCookie");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

