/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class PreAuthenLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    protected boolean debug = false;
    private ContextManager contextManager;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$web$PreAuthenLoginModule == null ? (class$com$ibm$ws$security$web$PreAuthenLoginModule = PreAuthenLoginModule.class$("com.ibm.ws.security.web.PreAuthenLoginModule")) : class$com$ibm$ws$security$web$PreAuthenLoginModule), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$ws$security$web$PreAuthenLoginModule;

    public PreAuthenLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"PreAuthenLoginModule()");
            Tr.exit((TraceComponent)tc, (String)"PreAuthenLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + map.toString() + "\", options = \"" + map2.toString() + "\")"));
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.contextManager = ContextManagerFactory.getInstance();
        if (this.contextManager != null) {
            this.contextManager.clearRootException();
        }
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WSLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login()");
        }
        this.succeeded = false;
        if (this.commitSucceeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The login module is in funny state, cleanup before starting a new login process.");
            }
            this.cleanup();
        }
        Callback[] callbackArray = null;
        if (!this.sharedState.containsKey("Callback")) {
            if (this.callbackHandler == null) {
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                this.contextManager.setRootException((Throwable)wSLoginFailedException);
                throw wSLoginFailedException;
            }
            callbackArray = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: "), new WSServletRequestCallback("HttpServletRequest: "), new WSServletResponseCallback("HttpServletResponse: "), new WSAppContextCallback("ApplicationContextCallback: ")};
            try {
                this.callbackHandler.handle(callbackArray);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.server.lm.PreAuthenLoginModule.login", (String)"180", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.jaas.callBackHandlerIOException", (Object)new Object[]{this.getClass().getName(), iOException});
                this.contextManager.setRootException((Throwable)iOException);
                throw new WSLoginFailedException("IOException: " + iOException.getMessage(), (Throwable)iOException);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                FFDCFilter.processException((Throwable)unsupportedCallbackException, (String)"com.ibm.ws.security.server.lm.PreAuthenLoginModule.login", (String)"184", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.jaas.callBackHandlerException", (Object)new Object[]{this.getClass().getName(), unsupportedCallbackException.getCallback().toString(), unsupportedCallbackException});
                this.contextManager.setRootException((Throwable)unsupportedCallbackException);
                throw new WSLoginFailedException(unsupportedCallbackException.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + unsupportedCallbackException.getMessage(), (Throwable)unsupportedCallbackException);
            }
            this.sharedState.put("Callback", callbackArray);
        }
        this.succeeded = true;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login()");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit()");
        }
        boolean bl = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Do not commit because of authentication failed.");
            }
            bl = false;
        } else {
            if (!this.commitSucceeded) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Change committed!");
                }
                this.commitSucceeded = true;
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"It has been committed prior this call, nothing is done.");
            }
            bl = this.commitSucceeded;
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit()");
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"abort()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug((TraceComponent)tc, (String)"Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logout()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug((TraceComponent)tc, (String)"Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug((TraceComponent)tc, (String)"Start removing ...");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Removed.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanup()");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

