/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.PermissionRoleMap;
import com.ibm.ws.security.util.Constants;
import com.ibm.ws.security.web.WebAccessContext;
import com.ibm.ws.security.web.WebAppCacheEntry;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebConstraintsTable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Properties;

public class WebAppCache
implements AlarmListener {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$web$WebAppCache == null ? (class$com$ibm$ws$security$web$WebAppCache = WebAppCache.class$("com.ibm.ws.security.web.WebAppCache")) : class$com$ibm$ws$security$web$WebAppCache));
    private static Properties httpMethods = new Properties();
    private static final String VHOST_HOME = "VirtualHostHome";
    private static final String TYPE_HOME = "TypeHome";
    private static WebAttributes UNPROTECTED_WEBATTRS = new WebAttributes();
    private static Hashtable cache = new Hashtable();
    private boolean reload;
    private ContextManager contextManager = ContextManagerFactory.getInstance();
    static /* synthetic */ Class class$com$ibm$ws$security$web$WebAppCache;

    public WebAppCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WebAppCache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WebAppCache");
        }
    }

    public void addWebApp(String string, String string2, WebApp webApp) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Adding webapp with context root =[" + string2 + "]"));
        }
        if (cache.get(string2) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Create a WebConstraintsTable for this webApp");
            }
            WebConstraintsTable webConstraintsTable = new WebConstraintsTable(webApp);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Create WebAttributes for this webApp.");
            }
            WebAttributes webAttributes = new WebAttributes(webApp);
            WebAppCacheEntry webAppCacheEntry = new WebAppCacheEntry(string, string2, webAttributes, webConstraintsTable, webApp);
            cache.put(string2, webAppCacheEntry);
        }
    }

    public static void removeWebApp(String string) {
        cache.remove(string);
    }

    public boolean isContained(String string) {
        return cache.containsKey(string);
    }

    public WebAccessContext getWebAccessContext(String string) {
        WebAppCacheEntry webAppCacheEntry = (WebAppCacheEntry)cache.get(string);
        WebConstraintsTable webConstraintsTable = null;
        String string2 = null;
        if (webAppCacheEntry != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Okay, I found the entry for [" + string + "]"));
            }
            string2 = webAppCacheEntry.getEnterpriseName();
            webConstraintsTable = webAppCacheEntry.getConstraints();
            if (webConstraintsTable == null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WebConstraintsTable is NULL though.");
            }
            WebAttributes webAttributes = webAppCacheEntry.getSecurityAttributes();
            return new WebAccessContext(string2, string, webConstraintsTable, webAttributes, webAppCacheEntry.getWebApp());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("NO WEB SECURITY CONTEXT INFO FOUND FOR " + string));
        }
        return new WebAccessContext(string2, string, null, null, null);
    }

    public WebAttributes getWebSecurityAttributes(final String string) throws Exception {
        WebAttributes webAttributes;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getWebAttributes");
            }
            webAttributes = UNPROTECTED_WEBATTRS;
            try {
                webAttributes = (WebAttributes)this.contextManager.runAsSystem(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        WebAppCacheEntry webAppCacheEntry = (WebAppCacheEntry)cache.get(string);
                        if (webAppCacheEntry != null) {
                            return webAppCacheEntry.getSecurityAttributes();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAppCache.getWebSecurityAttributes", (String)"155", (Object)this);
                if (!tc.isDebugEnabled()) break block5;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                Tr.debug((TraceComponent)tc, (String)"Exception of getting SecurityAttributes of WebApp", (Object)stringWriter.toString());
            }
        }
        if (webAttributes == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Returning a NULL web attributes object.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWebAttributes");
        }
        return webAttributes;
    }

    public void alarm(Object object) {
        this.mark();
    }

    private void mark() {
    }

    public PermissionRoleMap getPermissionRoleMap(String string) {
        WebAppCacheEntry webAppCacheEntry = (WebAppCacheEntry)cache.get(string);
        WebConstraintsTable webConstraintsTable = null;
        if (webAppCacheEntry != null) {
            webConstraintsTable = webAppCacheEntry.getConstraints();
        }
        return webConstraintsTable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        for (int i = 0; i < Constants.HTTP_METHODS.length; ++i) {
            String string = Constants.HTTP_METHODS[i];
            httpMethods.put(string, "HTTP_" + string);
        }
    }
}

