/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webapplication.FormLoginConfig;
import com.ibm.etools.webapplication.LoginConfig;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebAttributes {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$web$WebAttributes == null ? (class$com$ibm$ws$security$web$WebAttributes = WebAttributes.class$("com.ibm.ws.security.web.WebAttributes")) : class$com$ibm$ws$security$web$WebAttributes), null, (String)"com.ibm.ejs.resources.security");
    public static final String LOCALOS = "LOCALOS";
    public static final String LTPA = "LTPA";
    public static final String UNSUPPORTED = "UNSUPPORTED";
    private static Object lockObject = new Object();
    private static Cookie cookieAttrs;
    private static boolean secureSSO;
    private static boolean setSSODomain;
    private static String loginCookieName;
    private static String cookieSuffix;
    private static final String SSO_COOKIE_SUFFIX = "Token";
    private static String[] ltpaCookieNames;
    private static boolean isSecurityEnabled;
    private static String authMechanism;
    private static final char CERTIFICATE_FLAG = 'C';
    private static final char COOKIE_FLAG = 'K';
    private static final char AUTHORIZATION_FLAG = 'A';
    private static String[] ssoDomainList;
    private static boolean useURLDomain;
    private boolean isProtected = true;
    private String realm = null;
    private String challengeType;
    private boolean useSSL = false;
    private boolean defaultToBasic = false;
    private String pluginCfg;
    private String loginURL = null;
    private String reloginURL = null;
    private String webAppName = null;
    static /* synthetic */ Class class$com$ibm$ws$security$web$WebAttributes;
    static /* synthetic */ Class class$com$ibm$wsspi$security$token$SingleSignonToken;

    public WebAttributes() {
        this.isProtected = false;
    }

    public WebAttributes(WebApp webApp) throws RuntimeException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WebAttributes");
        }
        WebAttributes.initializeConfig();
        try {
            LoginConfig loginConfig;
            this.webAppName = webApp.getDisplayName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Webattrs for webApp =  " + this.webAppName));
            }
            if ((loginConfig = webApp.getLoginConfig()) != null) {
                this.realm = loginConfig.getRealmName();
                int n = loginConfig.getAuthMethod().getValue();
                if (n == 1) {
                    this.challengeType = "BASIC";
                } else if (n == 4) {
                    this.challengeType = "CLIENT_CERT";
                } else if (n == 3) {
                    this.challengeType = "FORM";
                    FormLoginConfig formLoginConfig = loginConfig.getFormLoginConfig();
                    if (formLoginConfig != null) {
                        this.loginURL = formLoginConfig.getFormLoginPage();
                        this.reloginURL = formLoginConfig.getFormErrorPage();
                    }
                } else {
                    this.challengeType = n == 2 ? "DIGEST" : "BASIC";
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Login Config is not available for webApp " + this.webAppName + " Assuming Basic Authentication"));
                }
                this.challengeType = "BASIC";
                this.realm = "Default Realm";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("realm is " + this.realm));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("use SSL is " + new Boolean(this.useSSL)));
            }
            boolean bl = this.isProtected = !this.challengeType.equals("none");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("challenge type is " + this.challengeType));
            }
            StringBuffer stringBuffer = new StringBuffer(3);
            if (this.challengeType.equals("CLIENT_CERT")) {
                stringBuffer.append('C');
            }
            if (this.isSSOEnabled()) {
                stringBuffer.append('K');
            }
            if (this.defaultToBasic || this.challengeType.equals("BASIC")) {
                stringBuffer.append('A');
            }
            this.pluginCfg = stringBuffer.toString();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAttributes.WebAttributes", (String)"167", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"WebAttributes", (Object)exception);
            }
            Tr.error((TraceComponent)tc, (String)"security.webatts.exception", (Object)new Object[]{this.webAppName, exception});
            throw new RuntimeException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WebAttributes");
        }
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getChallengeType() {
        return this.challengeType;
    }

    public String getAuthMechanism() {
        return (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
    }

    public boolean isSSLEnabled() {
        return this.useSSL;
    }

    public boolean isSSOEnabled() {
        return (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.enabled");
    }

    private static Iterator getSingleSignonTokensFromSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSingleSignonTokensFromSubject");
        }
        try {
            ArrayList arrayList = new ArrayList();
            if (subject != null) {
                Set set = null;
                Set set2 = null;
                HashSet hashSet = new HashSet();
                try {
                    set = subject.getPrivateCredentials(class$com$ibm$wsspi$security$token$SingleSignonToken == null ? (class$com$ibm$wsspi$security$token$SingleSignonToken = WebAttributes.class$("com.ibm.wsspi.security.token.SingleSignonToken")) : class$com$ibm$wsspi$security$token$SingleSignonToken);
                    if (set != null && set.size() > 0) {
                        hashSet.addAll(set);
                    }
                    if ((set2 = subject.getPublicCredentials(class$com$ibm$wsspi$security$token$SingleSignonToken == null ? (class$com$ibm$wsspi$security$token$SingleSignonToken = WebAttributes.class$("com.ibm.wsspi.security.token.SingleSignonToken")) : class$com$ibm$wsspi$security$token$SingleSignonToken)) != null && set2.size() > 0) {
                        hashSet.addAll(set2);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getSingleSignonTokensFromSubject");
                    }
                    return hashSet.iterator();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.WebAttributes.getSingleSignonToken", (String)"250");
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getSingleSignonTokensFromSubject", (Object)new Object[]{exception});
                    }
                    return null;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSingleSignonTokensFromSubject: (null)");
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.WebAttributes.getDefaultSingleSignonToken", (String)"261");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSingleSignonTokensFromSubject", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    private static void addCookieToList(HttpServletRequest httpServletRequest, String string, byte[] byArray, ArrayList arrayList, boolean bl) {
        if (byArray != null || bl) {
            Cookie cookie;
            String string2 = "";
            if (!bl) {
                string2 = Base64Coder.base64Encode((String)StringUtil.toString((byte[])byArray));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting SSO cookie with name: " + string + " logout " + bl + ", value: " + string2));
            }
            if ((cookie = new Cookie(string, string2)) != null) {
                WebAttributes.copyIntoStatic(cookie, httpServletRequest);
                if (bl) {
                    cookie.setMaxAge(0);
                }
                arrayList.add(cookie);
            }
        }
    }

    public void createLogoutCookies(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        WebAttributes.createLogoutCookiesStatic(httpServletRequest, httpServletResponse);
    }

    public static void createLogoutCookiesStatic(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createLogoutCookiesStatic");
        }
        Cookie[] cookieArray = httpServletRequest.getCookies();
        String[] stringArray = WebAttributes.getAllLTPACookieNamesStatic();
        ArrayList arrayList = new ArrayList();
        for (n = 0; n < cookieArray.length; ++n) {
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!cookieArray[n].getName().equals(stringArray[i])) continue;
                    WebAttributes.addCookieToList(httpServletRequest, stringArray[i], null, arrayList, true);
                }
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.web.WebAttributes.createLogoutCookiesStatic", (String)"319");
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Exception creating logout cookie.", (Object)new Object[]{throwable});
            }
        }
        cookieArray = arrayList.toArray(new Cookie[0]);
        for (n = 0; n < cookieArray.length; ++n) {
            try {
                httpServletResponse.addCookie(cookieArray[n]);
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.web.WebAttributes.createLogoutCookiesStatic", (String)"332");
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Exception adding logout cookie to response.", (Object)new Object[]{throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createLogoutCookiesStatic");
        }
    }

    public static ArrayList createCookies(HttpServletRequest httpServletRequest, Subject subject) {
        return WebAttributes.createCookiesStatic(httpServletRequest, subject);
    }

    public static ArrayList createCookiesStatic(HttpServletRequest httpServletRequest, Subject subject) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCookiesStatic");
        }
        ArrayList arrayList = new ArrayList();
        Object object3 = null;
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
        if (SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundPropagationEnabled").equals("true")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Propagation enabled, adding new cookie.");
            }
            object2 = WebAttributes.getSingleSignonTokensFromSubject(subject);
            while (object2.hasNext()) {
                object = (SingleSignonToken)object2.next();
                if (object == null) continue;
                byte[] byArray = object.getBytes();
                String string = object.getName();
                if (string.equals("LtpaToken")) {
                    object3 = object;
                }
                short s = object.getVersion();
                String string2 = string + new Short(s).toString();
                WebAttributes.addCookieToList(httpServletRequest, string2, byArray, arrayList, false);
            }
        }
        if (SecurityConfig.getConfig().getValue("com.ibm.ws.security.ssoInteropModeEnabled").equals("true") || SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundPropagationEnabled").equals("false") || arrayList.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding old cookie.");
            }
            object2 = null;
            object = WebAttributes.getLTPACookieNameStatic();
            if (wSCredential != null) {
                block12: {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Getting interop token from default SSO token previously found.");
                        }
                        object2 = wSCredential.getCredentialToken();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAttributes.createCookiesStatic", (String)"338");
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug((TraceComponent)tc, (String)"Exception getting WSCredential token.", (Object)new Object[]{exception});
                    }
                }
                WebAttributes.addCookieToList(httpServletRequest, (String)object, (byte[])object2, arrayList, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createCookiesStatic: returning " + arrayList.size() + " cookie(s) to add to response."));
        }
        return arrayList;
    }

    public boolean isSecureSSO() {
        return secureSSO;
    }

    public boolean isDefaultToBasic() {
        return this.defaultToBasic;
    }

    public String getLTPACookieName() {
        return "LtpaToken";
    }

    public static String getLTPACookieNameStatic() {
        return "LtpaToken";
    }

    public String getPreferredLTPACookieName() {
        if (SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundPropagationEnabled").equals("true")) {
            return "LtpaToken2";
        }
        return "LtpaToken";
    }

    public String[] getAllLTPACookieNames() {
        return ltpaCookieNames;
    }

    public static String[] getAllLTPACookieNamesStatic() {
        return ltpaCookieNames;
    }

    public String getLoginCookieName() {
        return loginCookieName;
    }

    public String getCookieSuffix() {
        return cookieSuffix;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("webAppName[" + this.webAppName + "]");
        stringBuffer.append("\nisProtected[" + this.isProtected() + "]");
        stringBuffer.append("\nrealm[" + this.getRealm() + "]");
        stringBuffer.append("\nchallengeType[" + this.getChallengeType() + "]");
        stringBuffer.append("\nauthMechanism[" + this.getAuthMechanism() + "]");
        stringBuffer.append("\nSSLEnabled[" + this.isSSLEnabled() + "]");
        stringBuffer.append("\nSSOEnabled[" + this.isSSOEnabled() + "]");
        stringBuffer.append("\nsecureSSO[" + this.isSecureSSO() + "]");
        stringBuffer.append("\ndefaultToBasic[" + this.isDefaultToBasic() + "]");
        stringBuffer.append("\nLTPACookieName[" + this.getLTPACookieName() + "]");
        stringBuffer.append("\nloginCookieName[" + this.getLoginCookieName() + "]");
        stringBuffer.append("\nCookieSuffix[" + this.getCookieSuffix() + "]");
        return stringBuffer.toString();
    }

    public String getLoginURL() {
        return this.loginURL;
    }

    public String getReloginURL() {
        return this.reloginURL;
    }

    public String getWebAppName() {
        return this.webAppName;
    }

    public void copyInto(Cookie cookie, HttpServletRequest httpServletRequest) {
        WebAttributes.copyIntoStatic(cookie, httpServletRequest);
    }

    public static void copyIntoStatic(Cookie cookie, HttpServletRequest httpServletRequest) {
        if (setSSODomain) {
            String string = WebAttributes.getSSODomain(httpServletRequest);
            if (string.length() > 0) {
                cookie.setDomain(WebAttributes.getSSODomain(httpServletRequest));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SSO domain setting is disabled ");
        }
        cookie.setMaxAge(cookieAttrs.getMaxAge());
        cookie.setPath(cookieAttrs.getPath());
        cookie.setSecure(cookieAttrs.getSecure());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeConfig() throws RuntimeException {
        Object object = lockObject;
        synchronized (object) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initializeConfig");
            }
            try {
                Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.enabled");
                isSecurityEnabled = bl != null ? bl : false;
                Boolean bl2 = (Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred");
                if (bl2.booleanValue()) {
                    boolean bl3;
                    Boolean bl4 = (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.enabled");
                    boolean bl5 = bl3 = bl4 != null ? bl4 : false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SSO is " + bl3));
                    }
                    if (bl3) {
                        String string = (String)SecurityConfig.getConfig().getValue("security.ltpa.sso.domain");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("SSO Domain is " + string));
                        }
                        cookieAttrs = new Cookie("LtpaToken", null);
                        WebAttributes.setSSODomainList(string);
                        Boolean bl6 = (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.ssl");
                        secureSSO = bl6 != null ? bl6 : false;
                        cookieAttrs.setSecure(secureSSO);
                        Boolean bl7 = (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.setSSODomain");
                        if (bl7 != null) {
                            setSSODomain = bl7;
                        }
                        if (string.length() < 1) {
                            setSSODomain = false;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("SSO is secure " + secureSSO));
                        }
                        cookieAttrs.setPath("/");
                        cookieAttrs.setMaxAge(-1);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAttributes.initializeConfig", (String)"345");
                Tr.warning((TraceComponent)tc, (String)"security.web.config.initerror", (Object)new Object[]{exception});
                throw new RuntimeException(exception.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initializeConfig");
            }
        }
    }

    private static void setSSODomainList(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setSSODomainList");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("Raw List: '" + string + "'"));
        }
        if (string != null && ssoDomainList == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ;,|");
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equalsIgnoreCase("UseDomainFromURL")) {
                    useURLDomain = true;
                    continue;
                }
                if (string2.length() <= 0) continue;
                if (string2.charAt(0) != '.') {
                    string2 = "." + string2;
                }
                vector.add(string2);
                if (!tc.isEntryEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Adding domain '" + string2 + "'"));
            }
            ssoDomainList = vector.toArray(new String[0]);
        }
        if (tc.isEntryEnabled()) {
            WebAttributes.traceSSODomainParameters();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setSSODomainList");
        }
    }

    public static String getSSODomain(HttpServletRequest httpServletRequest) {
        String string;
        boolean bl;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getSSODomain");
            }
            if (tc.isEntryEnabled()) {
                WebAttributes.traceSSODomainParameters();
            }
            bl = false;
            String string2 = httpServletRequest.getRequestURL().toString();
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("URL: " + string2));
            }
            string = "";
            try {
                URL uRL = new URL(string2);
                String string3 = uRL.getHost().trim();
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Request host: " + string3));
                }
                if (string3.indexOf(".") == -1) break block11;
                string = string3.substring(string3.indexOf("."));
                for (int i = 0; i < ssoDomainList.length; ++i) {
                    if (!string.endsWith(ssoDomainList[i])) continue;
                    string = ssoDomainList[i];
                    bl = true;
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Domain match found: '" + string + "'"));
                    }
                    break;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAttributes.WebAttributes", (String)"438");
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception getting request host/SSO domain", (Object)new Object[]{exception});
            }
        }
        if (!bl && !useURLDomain) {
            string = "";
        }
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SSO Domain is: '" + string + "'"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSSODomain");
        }
        return string;
    }

    private static void traceSSODomainParameters() {
        if (ssoDomainList.length == 0) {
            Tr.debug((TraceComponent)tc, (String)"SSO Domain List is empty");
        } else {
            StringBuffer stringBuffer = new StringBuffer("SSO Domain List: ");
            for (int i = 0; i < ssoDomainList.length; ++i) {
                stringBuffer.append(ssoDomainList[i]);
                if (i >= ssoDomainList.length - 1) continue;
                stringBuffer.append(":");
            }
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
        }
        if (useURLDomain) {
            Tr.debug((TraceComponent)tc, (String)"Domain of host in URL will be used for SSO if a parent domain is not found in the list above.");
        } else {
            Tr.debug((TraceComponent)tc, (String)"SSO Domain will be set to an empty string if a parent domain is not found in the list above.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        setSSODomain = true;
        loginCookieName = null;
        cookieSuffix = null;
        ltpaCookieNames = new String[]{"LtpaToken", "LtpaToken2"};
        ssoDomainList = null;
        useURLDomain = false;
    }
}

