/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.WebTrustAssociationUserException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.Cache;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.ws.security.web.AuthenticationResult;
import com.ibm.ws.security.web.FormLoginInfo;
import com.ibm.ws.security.web.TAIWrapper;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebCollaborator;
import com.ibm.ws.webcontainer.session.IHttpSession;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.srt.SRTServletResponse;
import com.ibm.wsspi.security.tai.TAIResult;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

public class WebAuthenticator {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$web$WebAuthenticator == null ? (class$com$ibm$ws$security$web$WebAuthenticator = WebAuthenticator.class$("com.ibm.ws.security.web.WebAuthenticator")) : class$com$ibm$ws$security$web$WebAuthenticator), null, (String)"com.ibm.ejs.resources.security");
    private static WebAuthenticator webAuthInstance = null;
    private ContextManager contextManager = ContextManagerFactory.getInstance();
    private static final String nullString = "";
    private static final String[] nullStringArray = new String[0];
    private long cushion;
    private static AuthenticationResult AUTHN_FAILED_RESULT = new AuthenticationResult(2, "Authentication Failed");
    private static AuthenticationResult CRED_FAILED_RESULT = new AuthenticationResult(2, "credential validation failure");
    protected static TrustAssociationManager taManager = null;
    public static final String FormUserName = "__WAS_FORM_USERNAME";
    public static final String FormPassword = "__WAS_FORM_PASSWORD";
    private static String authMech = null;
    static /* synthetic */ Class class$com$ibm$ws$security$web$WebAuthenticator;
    static /* synthetic */ Class class$com$ibm$websphere$security$cred$WSCredential;

    public static WebAuthenticator create(String string) {
        if (webAuthInstance == null) {
            webAuthInstance = new WebAuthenticator();
            authMech = string;
        }
        return webAuthInstance;
    }

    public static WebAuthenticator getInstance() {
        return webAuthInstance;
    }

    private WebAuthenticator() {
        this.initialize();
        TrustAssociationManager.create();
        taManager = TrustAssociationManager.getInstance();
    }

    private AuthenticationResult handleTrustAssociation(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string;
        AuthenticationResult authenticationResult;
        Subject subject;
        String string2;
        block19: {
            TAIWrapper tAIWrapper;
            string2 = null;
            subject = null;
            authenticationResult = null;
            string = this.contextManager.getDefaultRealm();
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"handleTrustAssociation");
            }
            if ((tAIWrapper = taManager.getInterceptor(httpServletRequest)) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("TAI [" + tAIWrapper.getName() + "] is available for this request."));
                }
                try {
                    object = tAIWrapper.negotiateAndValidateEstablishedTrust(httpServletRequest, httpServletResponse);
                    int n = object.getStatus();
                    if (n == 200) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("TAI [" + tAIWrapper.getName() + "] has been validated successfully."));
                        }
                        subject = object.getSubject();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Subject retrieved is [" + subject + "]"));
                        }
                        string2 = object.getAuthenticatedPrincipal();
                        if (tc.isEntryEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Username retrieved from TAI is [" + string2 + "]"));
                        }
                        break block19;
                    }
                    return new AuthenticationResult(5, "Challenge from TrustAssociation Interception: " + tAIWrapper.getName(), n);
                }
                catch (WebTrustAssociationFailedException webTrustAssociationFailedException) {
                    FFDCFilter.processException((Throwable)webTrustAssociationFailedException, (String)"com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", (String)"208", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.web.ta.validationfailed", (Object)new Object[]{webTrustAssociationFailedException});
                    return new AuthenticationResult(2, webTrustAssociationFailedException.getMessage());
                }
                catch (WebTrustAssociationUserException webTrustAssociationUserException) {
                    FFDCFilter.processException((Throwable)webTrustAssociationUserException, (String)"com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", (String)"212", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.web.ta.userex");
                    return new AuthenticationResult(2, webTrustAssociationUserException.getMessage());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", (String)"225", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.web.ta.genexc", (Object)new Object[]{exception});
                    return new AuthenticationResult(2, exception.getMessage());
                }
            }
        }
        if (string2 != null) {
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Map credentials for " + string2 + "."));
            }
            try {
                object = webAttributes.getWebAppName();
                HashMap<String, TAIResult> hashMap = new HashMap<String, TAIResult>(2);
                hashMap.put("WebAppName", (TAIResult)object);
                hashMap.put("RedirectURL", null);
                Subject subject2 = this.contextManager.login(string, string2, authMech, httpServletRequest, httpServletResponse, hashMap, subject);
                authenticationResult = new AuthenticationResult(1, subject2);
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Mapped credential for TrustAssociation was validated successfully.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"handleTrustAssociation: OK");
                }
                return authenticationResult;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", (String)"259", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error in mapping credential for Trust Association:" + string2));
                }
                authenticationResult = AUTHN_FAILED_RESULT;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleTrustAssociation: (null user)");
        }
        return null;
    }

    private AuthenticationResult handleSSO(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = webAttributes.getPreferredLTPACookieName();
        Cookie[] cookieArray = httpServletRequest.getCookies();
        AuthenticationResult authenticationResult = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleSSO");
        }
        if (cookieArray != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Looking for cookie name " + string));
            }
            if ((authenticationResult = this.validateCookie(cookieArray, string, webAttributes, httpServletRequest, httpServletResponse)) == null) {
                String string2 = webAttributes.getLTPACookieName();
                if (!string2.equals(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Looking for cookie name " + string));
                    }
                    if ((authenticationResult = this.validateCookie(cookieArray, string2, webAttributes, httpServletRequest, httpServletResponse)) != null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"handleSSO: found cookie");
                        }
                        return authenticationResult;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"handleSSO: (null)");
                    }
                    return null;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"handleSSO: (null)");
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleSSO: found cookie");
            }
            return authenticationResult;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleSSO: no cookies present in the request.");
        }
        return null;
    }

    private AuthenticationResult validateCookie(Cookie[] cookieArray, String string, WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        AuthenticationResult authenticationResult = null;
        String[] stringArray = WebAuthenticator.getCookieValues(cookieArray, string);
        if (stringArray != null) {
            String string2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                if (string2.length() <= 0) continue;
                byte[] byArray = StringUtil.getBytes((String)Base64Coder.base64Decode((String)string2));
                try {
                    authenticationResult = this.validate(this.contextManager.getDefaultRealm(), byArray, webAttributes, httpServletRequest, httpServletResponse);
                    if (authenticationResult.getStatus() != 1) continue;
                    break;
                }
                catch (Exception exception) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception validating SSO token: ", (Object)new Object[]{exception});
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.handleSSO", (String)"358", (Object)this);
                    authenticationResult = AUTHN_FAILED_RESULT;
                }
            }
            if (authenticationResult != null && authenticationResult.getStatus() == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The LTPA token was valid.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"handleSSO", (Object)("successful ltpa token validation of " + string2));
                }
                WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", webAttributes.getChallengeType());
                return authenticationResult;
            }
            return null;
        }
        return null;
    }

    private AuthenticationResult handleCustomLogin(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string;
        CharSequence charSequence;
        AuthenticationResult authenticationResult = null;
        String string2 = this.contextManager.getDefaultRealm();
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleCustomLogin");
        }
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Form based login is configured for the resource");
        }
        StringBuffer stringBuffer = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
        String string3 = stringBuffer.toString();
        String string4 = httpServletRequest.getContextPath();
        if (string4.equals("/")) {
            string4 = nullString;
        }
        int n = string3.indexOf("//");
        n = string3.indexOf("/", n + 2);
        int n2 = string3.length();
        String string5 = webAttributes.getLoginURL();
        if (!string5.startsWith("/")) {
            string5 = "/" + string5;
        }
        string5 = string4 + string5;
        stringBuffer.replace(n, n2, string5);
        string5 = stringBuffer.toString();
        String string6 = webAttributes.getReloginURL();
        n2 = string5.length();
        if (!string6.startsWith("/")) {
            string6 = "/" + string6;
        }
        string6 = string4 + string6;
        stringBuffer.replace(n, n2, string6);
        string6 = stringBuffer.toString();
        Object object = SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
        HttpSession httpSession = null;
        FormLoginInfo formLoginInfo = null;
        if (object.equals("SWAM")) {
            httpSession = httpServletRequest.getSession(true);
            formLoginInfo = (FormLoginInfo)((IHttpSession)httpSession).getSecurityInfo();
            if (formLoginInfo != null) {
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Form based login: Using HTTP Sessions");
                }
                charSequence = formLoginInfo.getUsername();
                string = formLoginInfo.getPassword();
                if (charSequence != null && string != null) {
                    int n3;
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Form based login: Userid/password present in the session");
                    }
                    if ((n3 = (authenticationResult = this.basicAuthenticate(string2, (String)charSequence, string, webAttributes, httpServletRequest, httpServletResponse)).getStatus()) == 2) {
                        authenticationResult = new AuthenticationResult(4, string6);
                    } else {
                        httpSession.removeAttribute("WASReqURL");
                    }
                    WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", "FORM");
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"handleCustomLogin");
                    }
                    return authenticationResult;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Form based login: No HTTP Session");
            }
        } else {
            authenticationResult = this.handleSSO(webAttributes, httpServletRequest, httpServletResponse);
            if (authenticationResult != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"handleCustomLogin");
                }
                return authenticationResult;
            }
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Form based login: No or Bad ltpa cookie ");
            }
        }
        charSequence = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
        if (httpServletRequest.getQueryString() != null) {
            ((StringBuffer)charSequence).append("?");
            ((StringBuffer)charSequence).append(httpServletRequest.getQueryString());
        }
        string = ((StringBuffer)charSequence).toString();
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Form based login: Stored original request : " + string));
        }
        authenticationResult = new AuthenticationResult(4, string5);
        if (object.equals("SWAM")) {
            if (formLoginInfo == null) {
                formLoginInfo = new FormLoginInfo();
            }
            formLoginInfo.setRefererURL(string);
            ((IHttpSession)httpSession).putSecurityInfo((Object)formLoginInfo);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Form based login: Referer URL set  in session " + string));
            }
        } else {
            Cookie cookie = new Cookie("WASReqURL", string);
            cookie.setPath("/");
            cookie.setMaxAge(-1);
            authenticationResult.setCookie(cookie);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Form based login: Referer URL cookie set " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleCustomLogin", (Object)("Redirecting to a login form" + string5));
        }
        return authenticationResult;
    }

    private AuthenticationResult handleCertificates(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        AuthenticationResult authenticationResult;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"handleCertificates");
            }
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Challenge type used is CERT.");
            }
            String string = "CLIENT_CERT";
            authenticationResult = null;
            String string2 = this.contextManager.getDefaultRealm();
            X509Certificate[] x509CertificateArray = null;
            Object var8_8 = null;
            try {
                Object object;
                Object object2;
                Object object3;
                x509CertificateArray = (X509Certificate[])httpServletRequest.getAttribute("javax.net.ssl.peer_certificates");
                if (x509CertificateArray == null) {
                    if (!webAttributes.isDefaultToBasic()) {
                        if (tc.isEntryEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"No certificate provided and default to basic is false.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"handleCertificates");
                        }
                        return new AuthenticationResult(2, "No Client Certificate Available", null);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No certificate was provided but defaulting to BASIC.");
                    }
                    string = "BASIC";
                }
                if (string.equalsIgnoreCase("BASIC")) break block18;
                byte[] byArray = x509CertificateArray[0].getEncoded();
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Map credential for this certificate.");
                }
                try {
                    object3 = string2;
                    object2 = x509CertificateArray;
                    String string3 = webAttributes.getWebAppName();
                    object = new PrivilegedExceptionAction((X509Certificate[])object2, string3, (String)object3, httpServletRequest, httpServletResponse){
                        private final /* synthetic */ X509Certificate[] val$certs_final;
                        private final /* synthetic */ String val$web_app_name;
                        private final /* synthetic */ String val$realm_final;
                        private final /* synthetic */ HttpServletRequest val$req;
                        private final /* synthetic */ HttpServletResponse val$res;
                        {
                            this.val$certs_final = x509CertificateArray;
                            this.val$web_app_name = string;
                            this.val$realm_final = string2;
                            this.val$req = httpServletRequest;
                            this.val$res = httpServletResponse;
                        }

                        public Object run() throws Exception {
                            AuthenticationResult authenticationResult = null;
                            try {
                                Subject subject = null;
                                UserRegistry userRegistry = WebAuthenticator.this.contextManager.getRegistry(WebAuthenticator.this.contextManager.getDefaultRealm());
                                if (userRegistry != null) {
                                    String string = userRegistry.mapCertificate(this.val$certs_final);
                                    HashMap<String, String> hashMap = new HashMap<String, String>(2);
                                    hashMap.put("WebAppName", this.val$web_app_name);
                                    hashMap.put("RedirectURL", null);
                                    subject = WebAuthenticator.this.contextManager.login(this.val$realm_final, string, authMech, this.val$req, this.val$res, hashMap);
                                    authenticationResult = subject != null ? new AuthenticationResult(1, subject) : AUTHN_FAILED_RESULT;
                                } else {
                                    authenticationResult = AUTHN_FAILED_RESULT;
                                }
                                return authenticationResult;
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.handleCertificates", (String)"598", (Object)this);
                                if (tc.isEntryEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Credential Mapping for Certificate failed.");
                                }
                                authenticationResult = AUTHN_FAILED_RESULT;
                                throw exception;
                            }
                        }
                    };
                    authenticationResult = (AuthenticationResult)this.contextManager.runAsSystem((PrivilegedExceptionAction)object);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    authenticationResult = AUTHN_FAILED_RESULT;
                    throw privilegedActionException.getException();
                }
                object3 = (Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred");
                authenticationResult.clearCookieList();
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Storing certificates in the credential");
                }
                object2 = new ArrayList(x509CertificateArray.length);
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    object2.add(x509CertificateArray[i]);
                }
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                object = certificateFactory.generateCertPath((List<? extends Certificate>)object2);
                Subject subject = authenticationResult.getSubject();
                WSCredential wSCredential = (WSCredential)subject.getPublicCredentials(class$com$ibm$websphere$security$cred$WSCredential == null ? (class$com$ibm$websphere$security$cred$WSCredential = WebAuthenticator.class$("com.ibm.websphere.security.cred.WSCredential")) : class$com$ibm$websphere$security$cred$WSCredential).iterator().next();
                if (wSCredential != null) {
                    wSCredential.set("wssecurity.setAttributForIdentityAssertion", object);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.handleCertificates", (String)"640", (Object)this);
                if (webAttributes.isDefaultToBasic()) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception occurred while processing certificate: " + exception.getMessage()));
                        Tr.debug((TraceComponent)tc, (String)"Defaulting to Basic");
                    }
                    string = "BASIC";
                }
                throw exception;
            }
        }
        WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", "CLIENT_CERT");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleCertificates");
        }
        return authenticationResult;
    }

    static final String getHeader(HttpServletRequest httpServletRequest, String string) {
        if (httpServletRequest instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)httpServletRequest;
            ServletRequest servletRequest = httpServletRequestWrapper.getRequest();
            while (servletRequest != null && servletRequest instanceof HttpServletRequestWrapper) {
                servletRequest = ((HttpServletRequestWrapper)servletRequest).getRequest();
            }
            if (servletRequest != null && servletRequest instanceof SRTServletResponse) {
                String string2 = ((SRTServletRequest)servletRequest).getHeaderDirect(string);
                return string2;
            }
        }
        return httpServletRequest.getHeader(string);
    }

    private AuthenticationResult handleBasicAuth(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleBasicAuth");
        }
        AuthenticationResult authenticationResult = null;
        Cookie cookie = null;
        String string2 = this.contextManager.getDefaultRealm();
        String string3 = httpServletRequest.getHeader("Authorization");
        if (string3 == null || !string3.startsWith("Basic ")) {
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"basic 401");
            }
            authenticationResult = new AuthenticationResult(3, webAttributes.getRealm(), cookie);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleBasicAuth");
            }
            return authenticationResult;
        }
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Authorization: " + string3));
        }
        if ((n = (string3 = Base64Coder.base64DecodeNew((String)string3.substring(6))).indexOf(58)) < 0) {
            authenticationResult = new AuthenticationResult(3, webAttributes.getRealm(), cookie);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to find username/password info -- Sending 401.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleBasicAuth");
            }
            return authenticationResult;
        }
        String string4 = string3.substring(0, n);
        authenticationResult = this.basicAuthenticate(string2, string4, string = string3.substring(n + 1), webAttributes, httpServletRequest, httpServletResponse);
        int n2 = authenticationResult.getStatus();
        if ((n2 == 3 || n2 == 2) && n2 == 2) {
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Authentication failed after calling basicAuthenticate");
            }
            authenticationResult = new AuthenticationResult(3, webAttributes.getRealm(), cookie);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleBasicAuth");
        }
        return authenticationResult;
    }

    public AuthenticationResult authenticate(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"authenticate");
        }
        AuthenticationResult authenticationResult = null;
        try {
            boolean bl = false;
            Object var6_7 = null;
            String string = webAttributes.getChallengeType();
            authenticationResult = null;
            Boolean bl2 = (Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred");
            if (bl2.booleanValue() && webAttributes.isSSOEnabled()) {
                bl = webAttributes.isSecureSSO() ? httpServletRequest.getScheme().equalsIgnoreCase("https") : true;
                authenticationResult = this.handleSSO(webAttributes, httpServletRequest, httpServletResponse);
                if (taManager.isTrustAssociationEnabled() && authenticationResult != null && authenticationResult.getStatus() == 2) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"SSO login failed, trying the TAI instead since it is configured.");
                    }
                    authenticationResult = this.handleTrustAssociation(webAttributes, httpServletRequest, httpServletResponse);
                }
                if (authenticationResult != null) {
                    return authenticationResult;
                }
            }
            if (taManager.isTrustAssociationEnabled()) {
                authenticationResult = this.handleTrustAssociation(webAttributes, httpServletRequest, httpServletResponse);
            }
            if (authenticationResult == null) {
                if (string.equalsIgnoreCase("FORM")) {
                    authenticationResult = this.handleCustomLogin(webAttributes, httpServletRequest, httpServletResponse);
                    return authenticationResult;
                }
                if (string.equalsIgnoreCase("CLIENT_CERT") && (authenticationResult = this.handleCertificates(webAttributes, httpServletRequest, httpServletResponse)) != null) {
                    if (bl) {
                        ArrayList arrayList = WebAttributes.createCookies(httpServletRequest, authenticationResult.getSubject());
                        if (arrayList != null) {
                            authenticationResult.setCookieList(arrayList);
                        }
                    }
                    return authenticationResult;
                }
                authenticationResult = this.handleBasicAuth(webAttributes, httpServletRequest, httpServletResponse);
            }
            if (authenticationResult.getStatus() == 1) {
                WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", "BASIC");
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Successful authentication");
                }
                if (bl) {
                    ArrayList arrayList = WebAttributes.createCookies(httpServletRequest, authenticationResult.getSubject());
                    if (arrayList != null) {
                        authenticationResult.setCookieList(arrayList);
                    }
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.authenticate", (String)"865", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception occurred: " + exception.getMessage()));
                Tr.debug((TraceComponent)tc, (String)"Authentication failed.");
            }
            authenticationResult = new AuthenticationResult(2, exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"authenticate");
        }
        return authenticationResult;
    }

    public static String getCookieValue(Cookie[] cookieArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCookieValue", (Object)string);
        }
        String string2 = null;
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!string.equals(cookieArray[i].getName())) continue;
                string2 = cookieArray[i].getValue();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCookieValue", string2);
        }
        return string2;
    }

    public static String[] getCookieValues(Cookie[] cookieArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCookieValues", (Object)string);
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!string.equals(cookieArray[i].getName())) continue;
                vector.add(cookieArray[i].getValue());
                ++n;
                if (!tc.isEntryEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)cookieArray[i].getValue());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCookieValues");
        }
        if (vector.size() > 0) {
            return vector.toArray(new String[n]);
        }
        return null;
    }

    public AuthenticationResult validate(String string, byte[] byArray, WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate");
        }
        AuthenticationResult authenticationResult = null;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>(2);
            hashMap.put("WebAppName", webAttributes.getWebAppName());
            hashMap.put("RedirectURL", null);
            Subject subject = this.contextManager.login(string, byArray, authMech, httpServletRequest, httpServletResponse, hashMap);
            WSCredential wSCredential = (WSCredential)subject.getPublicCredentials(class$com$ibm$websphere$security$cred$WSCredential == null ? (class$com$ibm$websphere$security$cred$WSCredential = WebAuthenticator.class$("com.ibm.websphere.security.cred.WSCredential")) : class$com$ibm$websphere$security$cred$WSCredential).iterator().next();
            if (wSCredential != null) {
                long l = wSCredential.getExpiration() - System.currentTimeMillis() - this.cushion;
                if (l <= 0L) {
                    wSCredential = null;
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"validate: LTPA token validation failed");
                    }
                    return AUTHN_FAILED_RESULT;
                }
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"validate: LTPA token validation failed");
                }
                return AUTHN_FAILED_RESULT;
            }
            authenticationResult = new AuthenticationResult(1, subject);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.validate", (String)"973", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validate", (Object)exception);
            }
            authenticationResult = new AuthenticationResult(2, exception.getMessage());
        }
        authenticationResult.realm = string;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validate");
        }
        return authenticationResult;
    }

    private void initialize() {
        this.cushion = Cache.cushion();
    }

    public AuthenticationResult basicAuthenticate(String string, String string2, String string3) {
        return this.basicAuthenticate(string, string2, string3, null, null, null);
    }

    public AuthenticationResult basicAuthenticate(String string, String string2, String string3, WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"basicAuthenticate");
        }
        AuthenticationResult authenticationResult = null;
        try {
            Subject subject = null;
            if (webAttributes != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>(2);
                hashMap.put("WebAppName", webAttributes.getWebAppName());
                hashMap.put("RedirectURL", null);
                subject = this.contextManager.login(this.contextManager.getDefaultRealm(), string2, string3, authMech, httpServletRequest, httpServletResponse, hashMap);
            } else {
                subject = this.contextManager.login(this.contextManager.getDefaultRealm(), string2, string3, authMech, null, null, null);
            }
            if (subject == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"basicAuthenticate: authentication failed");
                }
                return AUTHN_FAILED_RESULT;
            }
            authenticationResult = new AuthenticationResult(1, subject);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.basicAuthenticate", (String)"1046", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"basicAuthenticate", (Object)exception);
            }
            authenticationResult = new AuthenticationResult(2, exception.getMessage());
        }
        authenticationResult.realm = string;
        authenticationResult.userName = string2;
        authenticationResult.passWord = string3;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"basicAuthenticate");
        }
        return authenticationResult;
    }

    protected WSCredential setSasBasicAuth(String string, String string2, String string3) throws Exception {
        throw new RuntimeException("Not Implemented");
    }

    public Subject getPreferredSubject(Subject subject, Subject subject2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPreferredSubject");
        }
        return subject != null ? subject : subject2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

