/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.etools.j2ee.common.SecurityRoleRef;
import com.ibm.etools.webapplication.Servlet;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.Alias;
import com.ibm.ws.http.VirtualHost;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.Cache;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.AccessException;
import com.ibm.ws.security.core.AccessManager;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.PermissionRoleMap;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.core.WSPrincipal;
import com.ibm.ws.security.util.WCCMHelper;
import com.ibm.ws.security.web.AuthenticationResult;
import com.ibm.ws.security.web.ChallengeReply;
import com.ibm.ws.security.web.DenyReply;
import com.ibm.ws.security.web.PermitReply;
import com.ibm.ws.security.web.RedirectReply;
import com.ibm.ws.security.web.TAIChallengeReply;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.ws.security.web.WebAccessContext;
import com.ibm.ws.security.web.WebAccessManager;
import com.ibm.ws.security.web.WebAccessPermission;
import com.ibm.ws.security.web.WebAppCache;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebAuthenticator;
import com.ibm.ws.security.web.WebReply;
import com.ibm.ws.security.web.WebResourceCollectionConstraints;
import com.ibm.ws.security.web.WebSecurityConfigException;
import com.ibm.ws.security.web.WebSecurityException;
import com.ibm.ws.util.WSUtil;
import com.ibm.ws.webcontainer.srt.IPrivateRequestAttributes;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import java.io.Serializable;
import java.security.Identity;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.eclipse.emf.common.util.EList;

public abstract class WebCollaborator {
    private static final String nullString = "";
    private static final String[] nullStringArray = new String[0];
    public static final String pnWebServer = "$webServer";
    public static final String pnVirtualHost = "$virtualHost";
    public static final String pnRemoteHost = "$remoteHost";
    public static final String pnUri = "$uri";
    public static final String pnMethod = "$method";
    public static final String pnIsSSL = "$isSSL";
    public static final String pnCertificate = "$certificate";
    public static final String pnCipher = "$cipher";
    public static final String pnAuthorization = "Authorization";
    public static final String pnCookie = "Cookie";
    protected static WebReply PERMIT_REPLY = new PermitReply();
    protected static WebReply DENY_AUTHZ_FAILED = new DenyReply("AuthorizationFailed");
    protected static WebReply DENY_AUTHN_FAILED = new DenyReply("AuthenticationFailed");
    protected static WebReply DENY_CONFIG_ERROR = new DenyReply("Configuration error");
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$web$WebCollaborator == null ? (class$com$ibm$ws$security$web$WebCollaborator = WebCollaborator.class$("com.ibm.ws.security.web.WebCollaborator")) : class$com$ibm$ws$security$web$WebCollaborator), null, (String)"com.ibm.ejs.resources.security");
    protected boolean securityEnabled;
    protected WebAuthenticator authenticator = null;
    protected AccessManager authorizer = null;
    protected static ContextManager contextManager;
    protected static final int PUBLIC = 0;
    protected static final int ACCESSID = 1;
    protected static final int GROUPID = 2;
    protected boolean authDone = false;
    private static Object _lockObject;
    private WebAppCache webCache = null;
    private static boolean custom_auth_mech;
    private static String custom_jaas_config;
    private static TrustAssociationManager taManager;
    private static AuthCache cache;
    private static WSCallbackHandlerFactory cbkFactory;
    static /* synthetic */ Class class$com$ibm$ws$security$web$WebCollaborator;

    protected abstract WebAppCache getWebCache();

    public WebCollaborator() throws Exception {
        this.initialize();
    }

    public void createAuthorizationManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createAuthorizationManager");
        }
        this.authorizer = new WebAccessManager();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createAuthorizationManager");
        }
    }

    public void initialize() throws Exception {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initialize");
            }
            this.securityEnabled = false;
            try {
                Cache.setDefaultTimeout(10000L);
                this.securityEnabled = SecurityContext.isSecurityEnabled();
                if (this.securityEnabled) {
                    contextManager = ContextManagerFactory.getInstance();
                    String string = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
                    if (!string.equals("SWAM")) {
                        taManager = TrustAssociationManager.getInstance();
                        cache = AuthCache.getInstance();
                        String string2 = (String)SecurityConfig.getConfig().getValue("security.enablePluggableAuthentication");
                        if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes")) {
                            custom_auth_mech = true;
                            custom_jaas_config = string.equals("LTPA") ? (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundLoginConfig") : "system." + string;
                        } else if (string.equals("LTPA")) {
                            custom_jaas_config = "system." + string;
                        }
                    } else {
                        custom_jaas_config = "system." + string;
                    }
                    this.authenticator = WebAuthenticator.create(custom_jaas_config);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.initialize", (String)"211", (Object)this);
                if (this.securityEnabled) {
                    Tr.error((TraceComponent)tc, (String)"security.web.initerror");
                }
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug((TraceComponent)tc, (String)"initialize", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void addWebApp(String string, String string2, WebApp webApp) throws WebSecurityConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addWebApp");
        }
        if (this.webCache == null) {
            this.webCache = this.getWebCache();
        }
        try {
            this.webCache.addWebApp(string, string2, webApp);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.web.WebCollaborator.addWebApp", (String)"244", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addWebApp");
            }
            throw new WebSecurityConfigException(throwable.getMessage(), null);
        }
    }

    protected WebReply authorize(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) throws WebSecurityException {
        String string2;
        ArrayList arrayList;
        Serializable serializable;
        SecurityRole[] securityRoleArray;
        WebAccessContext webAccessContext;
        String string3;
        String string4;
        WebReply webReply;
        block61: {
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"authorize");
            }
            webReply = null;
            string4 = httpServletRequest.getServletPath();
            String string5 = httpServletRequest.getPathInfo();
            if (string5 != null) {
                string4 = string4.concat(string5);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("URI requested: " + string4));
            }
            if (string4 == null || string4.length() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"authorize: throw WebSecurityException");
                }
                return new DenyReply("Invalid URI passed to Security Collaborator.");
            }
            string4 = WSUtil.resolveURI((String)string4);
            string3 = httpServletRequest.getMethod();
            webAccessContext = this.webCache.getWebAccessContext(string);
            if (webAccessContext == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No Web App config found.");
                }
                StringBuffer stringBuffer = new StringBuffer("Cannot create a web security context for this request.");
                webReply = new DenyReply(stringBuffer.toString());
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"authorize", (Object)webReply);
                }
                return webReply;
            }
            WebAttributes webAttributes = webAccessContext.getWebAttributes();
            if (webAttributes == null) {
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("No WebAttributes for context root = ");
                    stringBuffer.append(string);
                    Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"authorize: ", (Object)PERMIT_REPLY);
                }
                return PERMIT_REPLY;
            }
            WebResourceCollectionConstraints webResourceCollectionConstraints = webAccessContext.getConstraints().getConstraints(webAccessContext, string4, string3);
            if (webResourceCollectionConstraints == null) {
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("No WebConstraints for URI = ");
                    stringBuffer.append(string4);
                    stringBuffer.append(", method = ");
                    stringBuffer.append(string3);
                    Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"authorize: ", (Object)PERMIT_REPLY);
                }
                return PERMIT_REPLY;
            }
            webReply = this.checkDataConstraints(webAccessContext, string4, string3, httpServletRequest);
            if (webReply != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"authorize: ", (Object)webReply);
                }
                return webReply;
            }
            if (this.unsupportedAuthMech(webAttributes)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Digest Authentication Mechanism is used and is not supported : sending DenyReply response");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"authorize: ");
                }
                return new DenyReply("Authentication Failed : DIGEST not supported");
            }
            String string6 = null;
            String string7 = null;
            if (webAttributes.getChallengeType().equals("FORM") && (string6 = webAttributes.getLoginURL()) != null && (string7 = webAttributes.getReloginURL()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" We have a custom login or error page request, web app login URL:[" + string6 + "], errorPage URL:[" + string7 + "], and the requested URI:[" + string4 + "]"));
                }
                if (string6.equals(string4) || string7.equals(string4)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("authorize, login or error page[" + string4 + "]  requested, permit: "), (Object)PERMIT_REPLY);
                    }
                    return PERMIT_REPLY;
                }
                if (string4 != null && string4.equals("/j_security_check") && string3 != null && string3.equals("POST")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("authorize, login or error page[" + string4 + "]  requested, permit: "), (Object)PERMIT_REPLY);
                    }
                    return PERMIT_REPLY;
                }
            }
            if ((securityRoleArray = this.getRequiredRoles(webAccessContext, string4, string3)) == PermissionRoleMap.NO_REQUIRED_ROLES) {
                webReply = PERMIT_REPLY;
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("No required roles for ");
                    stringBuffer.append(string4).append(".").append(string3);
                    Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"authorize", (Object)webReply);
                }
                return webReply;
            }
            boolean bl2 = false;
            bl2 = this.authorizer.isEveryoneGranted(webAccessContext, securityRoleArray);
            if (bl2) {
                webReply = PERMIT_REPLY;
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("Unprotected URI is ");
                    stringBuffer.append(string4).append(".").append(string3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"authorize", (Object)webReply);
                }
                return webReply;
            }
            if (tc.isDebugEnabled()) {
                serializable = new StringBuffer("URI -  ");
                ((StringBuffer)serializable).append(string4).append(".").append(string3).append(" is protected");
                Tr.debug((TraceComponent)tc, (String)((StringBuffer)serializable).toString());
            }
            serializable = null;
            arrayList = null;
            string2 = "???";
            if (bl) {
                object = null;
                object = this.authenticator.authenticate(webAttributes, httpServletRequest, httpServletResponse);
                if (object == null) {
                    Tr.error((TraceComponent)tc, (String)"authResult is null");
                    return DENY_AUTHN_FAILED;
                }
                switch (((AuthenticationResult)object).getStatus()) {
                    case 2: {
                        webReply = DENY_AUTHN_FAILED;
                        Tr.audit((TraceComponent)tc, (String)"security.authn.failed", (Object)new Object[]{((AuthenticationResult)object).getReason()});
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"authorize", (Object)webReply);
                        }
                        return webReply;
                    }
                    case 3: {
                        webReply = new ChallengeReply(webAttributes.getRealm());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"authentication failed - sending a 401");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"authorize", (Object)webReply);
                        }
                        return webReply;
                    }
                    case 5: {
                        webReply = new TAIChallengeReply(((AuthenticationResult)object).getTAIChallengeCode());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("TAI authentication challenge - sending " + ((AuthenticationResult)object).getTAIChallengeCode()));
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"authorize", (Object)webReply);
                        }
                        return webReply;
                    }
                    case 4: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"redirecting to another url");
                        }
                        webReply = ((AuthenticationResult)object).getCookies() != null ? new RedirectReply(((AuthenticationResult)object).getRedirectURL(), ((AuthenticationResult)object).getCookies()) : new RedirectReply(((AuthenticationResult)object).getRedirectURL());
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"authorize", (Object)webReply);
                        }
                        return webReply;
                    }
                    case 0: 
                    case 6: {
                        Tr.error((TraceComponent)tc, (String)("Unexpected result = " + ((AuthenticationResult)object).getStatus()));
                        Tr.audit((TraceComponent)tc, (String)"security.authn.failed", (Object)new Object[]{new Integer(((AuthenticationResult)object).getStatus())});
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Authentication failed. Status: " + ((AuthenticationResult)object).getStatus()));
                        }
                        webReply = DENY_AUTHN_FAILED;
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"authorize", (Object)webReply);
                        }
                        return webReply;
                    }
                }
                serializable = ((AuthenticationResult)object).getSubject();
                arrayList = ((AuthenticationResult)object).getCookies();
                string2 = ((AuthenticationResult)object).getUserName();
                try {
                    contextManager.setCallerSubject((Subject)serializable);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"532", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception occurred when setting credentials for 'current'. ");
                    }
                    break block61;
                }
            }
            try {
                object = contextManager.getCallerSubject();
                if (object != null) {
                    serializable = object;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"543", (Object)this);
                if (!tc.isDebugEnabled()) break block61;
                Tr.debug((TraceComponent)tc, (String)"Invalid credentials retrieved from security  'current'.");
            }
        }
        boolean bl3 = false;
        try {
            this.checkAuthorization(webAccessContext, securityRoleArray, (Subject)serializable);
            bl3 = true;
        }
        catch (AccessException accessException) {
            FFDCFilter.processException((Throwable)accessException, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"560", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkAuthorization() failed, here is the message in the exception: " + accessException.getMessage()));
            }
            Tr.audit((TraceComponent)tc, (String)"security.web.authz.failed.foruser", (Object)new Object[]{string2, string3, string + string4, accessException.getMessage()});
        }
        webReply = bl3 ? new PermitReply(arrayList) : DENY_AUTHZ_FAILED;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"authorize", (Object)webReply);
        }
        return webReply;
    }

    protected boolean unsupportedAuthMech(WebAttributes webAttributes) {
        String string = webAttributes.getChallengeType();
        return string.equalsIgnoreCase("DIGEST");
    }

    protected WebReply checkDataConstraints(WebAccessContext webAccessContext, String string, String string2, HttpServletRequest httpServletRequest) throws WebSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkConstraints");
        }
        WebReply webReply = null;
        if (this.isSSLRequired(webAccessContext, string, string2) && !httpServletRequest.isSecure()) {
            int n;
            String string3;
            int n2;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Request should be over SSL to access the resource. Redirecting to HTTPS...");
            }
            StringBuffer stringBuffer = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
            String string4 = stringBuffer.toString();
            int n3 = string4.indexOf(47);
            if ((n2 = (string3 = string4.substring(n3 += 2, n = string4.indexOf(47, n3))).indexOf(58)) != -1) {
                String string5 = string3.substring(n2 + 1);
                int n4 = Integer.parseInt(string5);
                int n5 = this.getHTTPSPort(n4);
                String string6 = Integer.toString(n5);
                stringBuffer.replace(n3 + n2 + 1, n, string6);
            }
            stringBuffer.replace(0, 4, "https");
            if (httpServletRequest.getQueryString() != null) {
                stringBuffer.append("?");
                stringBuffer.append(httpServletRequest.getQueryString());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Redirected to " + stringBuffer.toString()));
            }
            return new RedirectReply(stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkConstraints", webReply);
        }
        return webReply;
    }

    private boolean isSSLRequired(WebAccessContext webAccessContext, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isSSLRequired");
        }
        WebAccessPermission webAccessPermission = new WebAccessPermission(string, string2);
        return webAccessContext.getConstraints().isSSLRequired(webAccessContext, webAccessPermission);
    }

    protected SecurityRole[] getRequiredRoles(WebAccessContext webAccessContext, String string, String string2) {
        WebAccessPermission webAccessPermission = new WebAccessPermission(string, string2);
        return webAccessContext.getConstraints().getRequiredRoles(webAccessContext, webAccessPermission);
    }

    protected void checkAuthorization(WebAccessContext webAccessContext, String string, String string2, Subject subject) throws AccessException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkAuthorization");
        }
        if (!this.securityEnabled) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkAuthorization");
            }
            return;
        }
        Object var5_5 = null;
        try {
            this.authorizer.checkAccess(webAccessContext, string, string2, new WSPrincipal(subject));
        }
        catch (AccessException accessException) {
            FFDCFilter.processException((Throwable)accessException, (String)"com.ibm.ws.security.web.WebCollaborator.checkAuthorization", (String)"745", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkAuthorization: throw AccessException");
            }
            throw accessException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkAuthorization");
        }
    }

    protected void checkAuthorization(WebAccessContext webAccessContext, SecurityRole[] securityRoleArray, Subject subject) throws AccessException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkAuthorization");
        }
        if (!this.securityEnabled) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkAuthorization");
            }
            return;
        }
        boolean bl = this.authorizer.isGrantedAnyRole(webAccessContext, securityRoleArray, subject);
        if (!bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkAuthorization: throw AccessException");
            }
            int n = securityRoleArray.length;
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("Authorization failed, Not granted any of the required roles: ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(securityRoleArray[i].getRoleName()).append(" ");
            }
            throw new AccessException(stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkAuthorization");
        }
    }

    protected String getCookieValue(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCookieValue", (Object)string2);
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCookieValue", (Object)"no cookie");
            }
            return null;
        }
        int n = 0;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        while (stringTokenizer.hasMoreElements()) {
            String string5 = stringTokenizer.nextToken();
            String string6 = null;
            String string7 = null;
            int n2 = string5.indexOf("=");
            if (n2 == 0 || n2 == string5.length()) break;
            string6 = string5.substring(0, n2).trim();
            if (!string6.equals(string2) && string6.charAt(0) == '$') continue;
            string7 = string5.substring(n2 + 1);
            if (string7.startsWith("\"") && string7.endsWith("\"")) {
                string7 = string7.substring(1, string7.length() - 1);
            }
            if (string6.charAt(0) == '$') {
                if (string6.equalsIgnoreCase("$Version")) {
                    n = Integer.parseInt(string7);
                    continue;
                }
                if (string6.equalsIgnoreCase("$Domain")) {
                    string3 = string7;
                    continue;
                }
                if (!string6.equalsIgnoreCase("$Path")) continue;
                string4 = string7;
                continue;
            }
            if (!string6.equalsIgnoreCase(string2)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCookieValue", (Object)string7);
            }
            return string7;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCookieValue: null");
        }
        return null;
    }

    private String getCookieValue(Cookie[] cookieArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCookieValue", (Object)string);
        }
        String string2 = null;
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!string.equals(cookieArray[i].getName())) continue;
                string2 = cookieArray[i].getValue();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCookieValue", string2);
        }
        return string2;
    }

    public boolean isUserInRole(Servlet servlet, String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isUserInRole");
        }
        Subject subject = null;
        WebAccessContext webAccessContext = null;
        if (this.securityEnabled) {
            Subject subject2;
            block13: {
                try {
                    String string4;
                    subject2 = contextManager.getCallerSubject();
                    if (subject2 != null) {
                        subject = subject2;
                    }
                    if ((webAccessContext = this.webCache.getWebAccessContext(string4 = string3 + ":" + string2)) == null) {
                        return false;
                    }
                    if (servlet != null) {
                        WebApp webApp = servlet.getWebApp();
                        EList eList = servlet.getSecurityRoleRefs();
                        Iterator iterator = eList.iterator();
                        while (iterator.hasNext()) {
                            SecurityRoleRef securityRoleRef = (SecurityRoleRef)iterator.next();
                            String string5 = securityRoleRef.getName();
                            if (!string5.equals(string)) continue;
                            String string6 = securityRoleRef.getLink();
                            SecurityRole securityRole = WCCMHelper.createSecurityRole(string6, string6);
                            return this.authorizer.isGrantedRole(webAccessContext, securityRole, new WSPrincipal(subject));
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.isUserInRole", (String)"934", (Object)this);
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug((TraceComponent)tc, (String)"Exception: ", (Object)exception);
                }
            }
            if ((subject2 = WCCMHelper.createSecurityRole(string, string)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found security role named " + string));
                }
                if (webAccessContext != null && subject != null) {
                    return this.authorizer.isGrantedRole(webAccessContext, (SecurityRole)subject2, new WSPrincipal(subject));
                }
                return false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Did not find security role named " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isUserInRole");
        }
        return false;
    }

    protected static IPrivateRequestAttributes getPrivateAttributes(HttpServletRequest httpServletRequest) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPrivateAttributes");
        }
        IPrivateRequestAttributes iPrivateRequestAttributes = null;
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        if (httpServletRequest2 instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)httpServletRequest2;
            httpServletRequest2 = (HttpServletRequest)httpServletRequestWrapper.getRequest();
            while (httpServletRequest2 != null && httpServletRequest2 instanceof HttpServletRequestWrapper) {
                httpServletRequest2 = (HttpServletRequest)((HttpServletRequestWrapper)httpServletRequest2).getRequest();
            }
        }
        if (httpServletRequest2 != null && httpServletRequest2 instanceof SRTServletRequest) {
            iPrivateRequestAttributes = (IPrivateRequestAttributes)httpServletRequest2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPrivateAttributes", (Object)new Object[]{iPrivateRequestAttributes});
        }
        return iPrivateRequestAttributes;
    }

    protected static void setPrivateAttributes(HttpServletRequest httpServletRequest, String string, Object object) {
        HttpServletRequest httpServletRequest2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setPrivateAttributes", (Object)new Object[]{string, object});
        }
        if ((httpServletRequest2 = httpServletRequest) instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)httpServletRequest2;
            httpServletRequest2 = (HttpServletRequest)httpServletRequestWrapper.getRequest();
            while (httpServletRequest2 != null && httpServletRequest2 instanceof HttpServletRequestWrapper) {
                httpServletRequest2 = (HttpServletRequest)((HttpServletRequestWrapper)httpServletRequest2).getRequest();
            }
        }
        if (httpServletRequest2 != null && httpServletRequest2 instanceof SRTServletRequest) {
            ((IPrivateRequestAttributes)httpServletRequest2).setPrivateAttribute(string, object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setPrivateAttributes");
        }
    }

    public Principal getUserPrincipal() {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getUserPrincipal");
            }
            if (this.securityEnabled) {
                try {
                    Subject subject = null;
                    Subject subject2 = contextManager.getCallerSubject();
                    if (subject2 != null) {
                        subject = subject2;
                    }
                    WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                    if (subject != null && !wSCredential.isUnauthenticated()) {
                        String string = null;
                        boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.FullyQualifiedUserName");
                        if (bl) {
                            String string2 = wSCredential.getRealmName();
                            if (string2 == null || string2.length() == 0) {
                                string2 = (String)SecurityConfig.getConfig().getValue("security.activeUserRegistry.realm");
                            }
                            string = string2 + "/" + wSCredential.getSecurityName();
                        } else {
                            string = wSCredential.getSecurityName();
                        }
                        return new Identity(new String(string)){};
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator", (String)"1025");
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)tc, (String)"Exception", (Object)exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserPrincipal");
        }
        return null;
    }

    protected boolean SetUnauthenticatedSubjectIfNeeded(Subject subject, Subject subject2) {
        boolean bl;
        block6: {
            bl = false;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"SetUnauthenticatedSubjectIfNeeded");
            }
            if (subject == null && subject2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Invoked and received Subject are null, setting it anonymous/unauthenticated.");
                }
                try {
                    contextManager.setInvocationSubject(SubjectHelper.createUnauthenticatedSubject());
                    bl = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.SetUnauthenticatedSubjectIfNeeded", (String)"1058", (Object)this);
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)("setUnauthenticated Subject threw an unexpected exception" + exception));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SetUnauthenticatedSubjectIfNeeded:" + bl));
        }
        return bl;
    }

    private int getHTTPSPort(int n) {
        int n2;
        Object object;
        Alias alias;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getHTTPSPort" + n));
        }
        boolean bl = false;
        VirtualHost virtualHost = null;
        VirtualHost[] virtualHostArray = (VirtualHost[])SecurityConfig.getConfig().getValue("host.virtualhosts");
        block4: for (int i = 0; !bl && i < virtualHostArray.length; ++i) {
            virtualHost = virtualHostArray[i];
            Alias[] aliasArray = virtualHost.getAliases();
            for (int j = 0; j < aliasArray.length; ++j) {
                alias = aliasArray[j];
                object = alias.getPort();
                n2 = -1;
                try {
                    n2 = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n2 != n) continue;
                bl = true;
                continue block4;
            }
        }
        if (virtualHost == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getHTTPSPort: SSL port not found");
            }
            return -1;
        }
        List list = (List)SecurityConfig.getConfig().getValue("webcontainer.transports");
        for (int i = 0; i < list.size(); ++i) {
            Transport transport = (Transport)list.get(i);
            alias = (HTTPTransport)transport;
            if (!alias.isSslEnabled() || (object = new Integer(alias.getAddress().getPort())) == null) continue;
            n2 = (Integer)object;
            Alias[] aliasArray = virtualHost.getAliases();
            for (int j = 0; j < aliasArray.length; ++j) {
                Alias alias2 = aliasArray[j];
                String string = alias2.getPort();
                int n3 = -1;
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n3 != n2) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found HTTPS port " + n2));
                }
                return n2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getHTTPSPort: SSL port not found");
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _lockObject = new Object();
        custom_auth_mech = false;
        custom_jaas_config = null;
        taManager = null;
        cache = null;
        cbkFactory = null;
    }
}

