/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public final class FastHttpDateFormat {
    protected static SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    protected static long currentDateGenerated;
    protected static String currentDate;
    protected static HashMap dateCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentDate() {
        long now = System.currentTimeMillis();
        if (now - currentDateGenerated > 1000L) {
            SimpleDateFormat simpleDateFormat = format;
            synchronized (simpleDateFormat) {
                if (now - currentDateGenerated > 1000L) {
                    currentDateGenerated = now;
                    currentDate = format.format(new Date(now));
                }
            }
        }
        return currentDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDate(Date date) {
        String cachedDate = (String)dateCache.get(date);
        if (cachedDate != null) {
            return cachedDate;
        }
        String newDate = null;
        SimpleDateFormat simpleDateFormat = format;
        synchronized (simpleDateFormat) {
            newDate = format.format(date);
            dateCache.put(date, newDate);
        }
        return newDate;
    }

    static {
        format.setTimeZone(gmtZone);
        currentDateGenerated = 0L;
        currentDate = null;
        dateCache = new HashMap();
    }
}

