/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.collections.MultiMap;
import org.apache.tomcat.util.http.MimeHeaders;

public final class Parameters
extends MultiMap {
    private Hashtable paramHashStringArray = new Hashtable();
    private boolean didQueryParameters = false;
    private boolean didMerge = false;
    MessageBytes queryMB;
    MimeHeaders headers;
    UDecoder urlDec;
    MessageBytes decodedQuery = MessageBytes.newInstance();
    public static final int INITIAL_SIZE = 4;
    private Parameters child = null;
    private Parameters parent = null;
    private Parameters currentChild = null;
    String encoding = null;
    ByteChunk tmpName = new ByteChunk();
    ByteChunk tmpValue = new ByteChunk();
    CharChunk tmpNameC = new CharChunk(1024);
    CharChunk tmpValueC = new CharChunk(1024);
    private static int debug = 0;

    public Parameters() {
        super(4);
    }

    public void setQuery(MessageBytes queryMB) {
        this.queryMB = queryMB;
    }

    public void setHeaders(MimeHeaders headers) {
        this.headers = headers;
    }

    public void setEncoding(String s) {
        this.encoding = s;
        if (debug > 0) {
            this.log("Set encoding to " + s);
        }
    }

    public void recycle() {
        super.recycle();
        this.paramHashStringArray.clear();
        this.didQueryParameters = false;
        this.currentChild = null;
        this.didMerge = false;
        this.encoding = null;
        this.decodedQuery.recycle();
    }

    public Parameters getCurrentSet() {
        if (this.currentChild == null) {
            return this;
        }
        return this.currentChild;
    }

    public void push() {
        if (this.currentChild == null) {
            this.currentChild = new Parameters();
            this.currentChild.setURLDecoder(this.urlDec);
            this.currentChild.parent = this;
            return;
        }
        if (this.currentChild.child == null) {
            this.currentChild.child = new Parameters();
            this.currentChild.setURLDecoder(this.urlDec);
            this.currentChild.child.parent = this.currentChild;
        }
        this.currentChild = this.currentChild.child;
        this.currentChild.setEncoding(this.encoding);
    }

    public void pop() {
        if (this.currentChild == null) {
            throw new RuntimeException("Attempt to pop without a push");
        }
        this.currentChild.recycle();
        this.currentChild = this.currentChild.parent;
    }

    public String[] getParameterValues(String name) {
        this.handleQueryParameters();
        if (this.currentChild != null) {
            this.currentChild.merge();
            return (String[])this.currentChild.paramHashStringArray.get(name);
        }
        String[] values = (String[])this.paramHashStringArray.get(name);
        return values;
    }

    public Enumeration getParameterNames() {
        this.handleQueryParameters();
        if (this.currentChild != null) {
            this.currentChild.merge();
            return this.currentChild.paramHashStringArray.keys();
        }
        return this.paramHashStringArray.keys();
    }

    private void merge() {
        if (debug > 0) {
            this.log("Before merging " + this + " " + this.parent + " " + this.didMerge);
            this.log(this.paramsAsString());
        }
        this.handleQueryParameters();
        if (this.didMerge) {
            return;
        }
        if (this.parent == null) {
            return;
        }
        this.parent.merge();
        Hashtable parentProps = this.parent.paramHashStringArray;
        Parameters.merge2(this.paramHashStringArray, parentProps);
        this.didMerge = true;
        if (debug > 0) {
            this.log("After " + this.paramsAsString());
        }
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null) {
            if (values.length == 0) {
                return "";
            }
            return values[0];
        }
        return null;
    }

    public void handleQueryParameters() {
        if (this.didQueryParameters) {
            return;
        }
        if (this.queryMB != null) {
            this.queryMB.setEncoding(this.encoding);
        }
        this.didQueryParameters = true;
        if (debug > 0) {
            this.log("Decoding query " + this.queryMB + " " + this.encoding);
        }
        if (this.queryMB == null || this.queryMB.isNull()) {
            return;
        }
        try {
            this.decodedQuery.duplicate(this.queryMB);
            this.decodedQuery.setEncoding(this.encoding);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (debug > 0) {
            this.log("Decoding query " + this.decodedQuery + " " + this.encoding);
        }
        this.processParameters(this.decodedQuery);
    }

    private static void merge2(Hashtable one, Hashtable two) {
        Enumeration e = two.keys();
        while (e.hasMoreElements()) {
            String[] combinedValue;
            String name = (String)e.nextElement();
            String[] oneValue = (String[])one.get(name);
            String[] twoValue = (String[])two.get(name);
            if (twoValue == null) continue;
            if (oneValue == null) {
                combinedValue = new String[twoValue.length];
                System.arraycopy(twoValue, 0, combinedValue, 0, twoValue.length);
            } else {
                combinedValue = new String[oneValue.length + twoValue.length];
                System.arraycopy(oneValue, 0, combinedValue, 0, oneValue.length);
                System.arraycopy(twoValue, 0, combinedValue, oneValue.length, twoValue.length);
            }
            one.put(name, combinedValue);
        }
    }

    private void addParam(String key, String value) {
        String[] values;
        if (key == null) {
            return;
        }
        if (this.paramHashStringArray.containsKey(key)) {
            String[] oldValues = (String[])this.paramHashStringArray.get(key);
            values = new String[oldValues.length + 1];
            int i = 0;
            while (i < oldValues.length) {
                values[i] = oldValues[i];
                ++i;
            }
            values[oldValues.length] = value;
        } else {
            values = new String[]{value};
        }
        this.paramHashStringArray.put(key, values);
    }

    public void setURLDecoder(UDecoder u) {
        this.urlDec = u;
    }

    public void processParameters(byte[] bytes, int start, int len) {
        int end = start + len;
        int pos = start;
        if (debug > 0) {
            this.log("Bytes: " + new String(bytes, start, len));
        }
        do {
            boolean noEq = false;
            int valStart = -1;
            int valEnd = -1;
            int nameStart = pos;
            int nameEnd = ByteChunk.indexOf(bytes, nameStart, end, '=');
            int nameEnd2 = ByteChunk.indexOf(bytes, nameStart, end, '&');
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
                if (debug > 0) {
                    this.log("no equal " + nameStart + " " + nameEnd + " " + new String(bytes, nameStart, nameEnd - nameStart));
                }
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = ByteChunk.indexOf(bytes, valStart = nameEnd < end ? nameEnd + 1 : end, end, '&')) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            this.tmpName.setBytes(bytes, nameStart, nameEnd - nameStart);
            this.tmpValue.setBytes(bytes, valStart, valEnd - valStart);
            this.tmpName.setEncoding(this.encoding);
            this.tmpValue.setEncoding(this.encoding);
            try {
                if (debug > 0) {
                    this.log("Found " + this.tmpName + "= " + this.tmpValue);
                }
                if (this.urlDec == null) {
                    this.urlDec = new UDecoder();
                }
                this.urlDec.convert(this.tmpName);
                this.urlDec.convert(this.tmpValue);
                if (debug > 0) {
                    this.log("After url decoding " + this.tmpName + "= " + this.tmpValue);
                }
                this.addParam(this.tmpName.toString(), this.tmpValue.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.tmpName.recycle();
            this.tmpValue.recycle();
        } while (pos < end);
    }

    public void processParameters(char[] chars, int start, int len) {
        int end = start + len;
        int pos = start;
        if (debug > 0) {
            this.log("Chars: " + new String(chars, start, len));
        }
        do {
            boolean noEq = false;
            int nameStart = pos;
            int valStart = -1;
            int valEnd = -1;
            int nameEnd = CharChunk.indexOf(chars, nameStart, end, '=');
            int nameEnd2 = CharChunk.indexOf(chars, nameStart, end, '&');
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
                if (debug > 0) {
                    this.log("no equal " + nameStart + " " + nameEnd + " " + new String(chars, nameStart, nameEnd - nameStart));
                }
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = CharChunk.indexOf(chars, valStart = nameEnd < end ? nameEnd + 1 : end, end, '&')) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            try {
                this.tmpNameC.append(chars, nameStart, nameEnd - nameStart);
                this.tmpValueC.append(chars, valStart, valEnd - valStart);
                if (debug > 0) {
                    this.log(this.tmpNameC + "= " + this.tmpValueC);
                }
                if (this.urlDec == null) {
                    this.urlDec = new UDecoder();
                }
                this.urlDec.convert(this.tmpNameC);
                this.urlDec.convert(this.tmpValueC);
                if (debug > 0) {
                    this.log(this.tmpNameC + "= " + this.tmpValueC);
                }
                this.addParam(this.tmpNameC.toString(), this.tmpValueC.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.tmpNameC.recycle();
            this.tmpValueC.recycle();
        } while (pos < end);
    }

    public void processParameters(MessageBytes data) {
        if (data == null || data.isNull() || data.getLength() <= 0) {
            return;
        }
        if (data.getType() == 2) {
            ByteChunk bc = data.getByteChunk();
            this.processParameters(bc.getBytes(), bc.getOffset(), bc.getLength());
        } else {
            if (data.getType() != 3) {
                data.toChars();
            }
            CharChunk cc = data.getCharChunk();
            this.processParameters(cc.getChars(), cc.getOffset(), cc.getLength());
        }
    }

    public String paramsAsString() {
        StringBuffer sb = new StringBuffer();
        Enumeration en = this.paramHashStringArray.keys();
        while (en.hasMoreElements()) {
            String k = (String)en.nextElement();
            sb.append(k).append("=");
            String[] v = (String[])this.paramHashStringArray.get(k);
            int i = 0;
            while (i < v.length) {
                sb.append(v[i]).append(",");
                ++i;
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void log(String s) {
        System.out.println("Parameters: " + s);
    }

    public void processParameters(String str) {
        int end = str.length();
        int pos = 0;
        if (debug > 0) {
            this.log("String: " + str);
        }
        do {
            boolean noEq = false;
            int valStart = -1;
            int valEnd = -1;
            int nameStart = pos;
            int nameEnd = str.indexOf(61, nameStart);
            int nameEnd2 = str.indexOf(38, nameStart);
            if (nameEnd2 == -1) {
                nameEnd2 = end;
            }
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
                if (debug > 0) {
                    this.log("no equal " + nameStart + " " + nameEnd + " " + str.substring(nameStart, nameEnd));
                }
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = str.indexOf(38, valStart = nameEnd + 1)) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            if (debug > 0) {
                this.log("XXX " + nameStart + " " + nameEnd + " " + valStart + " " + valEnd);
            }
            try {
                this.tmpNameC.append(str, nameStart, nameEnd - nameStart);
                this.tmpValueC.append(str, valStart, valEnd - valStart);
                if (debug > 0) {
                    this.log(this.tmpNameC + "= " + this.tmpValueC);
                }
                if (this.urlDec == null) {
                    this.urlDec = new UDecoder();
                }
                this.urlDec.convert(this.tmpNameC);
                this.urlDec.convert(this.tmpValueC);
                if (debug > 0) {
                    this.log(this.tmpNameC + "= " + this.tmpValueC);
                }
                this.addParam(this.tmpNameC.toString(), this.tmpValueC.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.tmpNameC.recycle();
            this.tmpValueC.recycle();
        } while (pos < end);
    }
}

