/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import java.util.Vector;
import org.apache.tomcat.util.log.Log;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

public class ThreadPool {
    public static final int MAX_THREADS = 200;
    public static final int MAX_SPARE_THREADS = 50;
    public static final int MIN_SPARE_THREADS = 4;
    public static final int WORK_WAIT_TIMEOUT = 60000;
    protected Vector pool;
    protected MonitorRunnable monitor;
    protected int maxThreads = 200;
    protected int minSpareThreads = 4;
    protected int maxSpareThreads = 50;
    protected int currentThreadCount = 0;
    protected int currentThreadsBusy = 0;
    protected boolean stopThePool = false;
    protected boolean isDaemon = true;
    static int debug = 0;
    Log loghelper = Log.getLog("tc/ThreadPool", "ThreadPool");
    static boolean logfull = true;

    public synchronized void start() {
        this.stopThePool = false;
        this.currentThreadCount = 0;
        this.currentThreadsBusy = 0;
        this.adjustLimits();
        this.openThreads(this.minSpareThreads);
        this.monitor = new MonitorRunnable(this);
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    public void setMaxSpareThreads(int maxSpareThreads) {
        this.maxSpareThreads = maxSpareThreads;
    }

    public int getMaxSpareThreads() {
        return this.maxSpareThreads;
    }

    public void setDaemon(boolean b) {
        this.isDaemon = b;
    }

    public boolean getDaemon() {
        return this.isDaemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runIt(ThreadPoolRunnable r) {
        if (null == r) {
            throw new NullPointerException();
        }
        if (0 == this.currentThreadCount || this.stopThePool) {
            throw new IllegalStateException();
        }
        ControlRunnable c = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.currentThreadsBusy == this.currentThreadCount) {
                if (this.currentThreadCount < this.maxThreads) {
                    int toOpen = this.currentThreadCount + this.minSpareThreads;
                    this.openThreads(toOpen);
                } else {
                    ThreadPool.logFull(this.loghelper, this.currentThreadCount, this.maxThreads);
                    while (this.currentThreadsBusy == this.currentThreadCount) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            this.loghelper.log("Unexpected exception", e);
                        }
                        if (0 != this.currentThreadCount && !this.stopThePool) continue;
                        throw new IllegalStateException();
                    }
                }
            }
            c = (ControlRunnable)this.pool.lastElement();
            this.pool.removeElement(c);
            ++this.currentThreadsBusy;
        }
        c.runIt(r);
    }

    public static void logFull(Log loghelper, int currentThreadCount, int maxThreads) {
        if (logfull) {
            loghelper.log("All threads are busy, waiting. Please increase maxThreads or check the servlet status" + currentThreadCount + " " + maxThreads);
            logfull = false;
        }
    }

    public synchronized void shutdown() {
        if (!this.stopThePool) {
            this.stopThePool = true;
            this.monitor.terminate();
            this.monitor = null;
            int i = 0;
            while (i < this.currentThreadCount - this.currentThreadsBusy) {
                try {
                    ((ControlRunnable)this.pool.elementAt(i)).terminate();
                }
                catch (Throwable t) {
                    this.loghelper.log("Ignored exception while shutting down thread pool", t, 1);
                }
                ++i;
            }
            this.currentThreadCount = 0;
            this.currentThreadsBusy = 0;
            this.pool = null;
            this.notifyAll();
        }
    }

    protected synchronized void checkSpareControllers() {
        if (this.stopThePool) {
            return;
        }
        if (this.currentThreadCount - this.currentThreadsBusy > this.maxSpareThreads) {
            int toFree = this.currentThreadCount - this.currentThreadsBusy - this.maxSpareThreads;
            int i = 0;
            while (i < toFree) {
                ControlRunnable c = (ControlRunnable)this.pool.firstElement();
                this.pool.removeElement(c);
                c.terminate();
                --this.currentThreadCount;
                ++i;
            }
        }
    }

    protected synchronized void returnController(ControlRunnable c) {
        if (0 == this.currentThreadCount || this.stopThePool) {
            c.terminate();
            return;
        }
        --this.currentThreadsBusy;
        this.pool.addElement(c);
        this.notify();
    }

    protected synchronized void notifyThreadEnd(ControlRunnable c) {
        --this.currentThreadsBusy;
        --this.currentThreadCount;
        this.notify();
    }

    protected void adjustLimits() {
        if (this.maxThreads <= 0) {
            this.maxThreads = 200;
        }
        if (this.maxSpareThreads >= this.maxThreads) {
            this.maxSpareThreads = this.maxThreads;
        }
        if (this.maxSpareThreads <= 0) {
            this.maxSpareThreads = 1 == this.maxThreads ? 1 : this.maxThreads / 2;
        }
        if (this.minSpareThreads > this.maxSpareThreads) {
            this.minSpareThreads = this.maxSpareThreads;
        }
        if (this.minSpareThreads <= 0) {
            this.minSpareThreads = 1 == this.maxSpareThreads ? 1 : this.maxSpareThreads / 2;
        }
    }

    protected void openThreads(int toOpen) {
        if (toOpen > this.maxThreads) {
            toOpen = this.maxThreads;
        }
        if (0 == this.currentThreadCount) {
            this.pool = new Vector(toOpen);
        }
        int i = this.currentThreadCount;
        while (i < toOpen) {
            this.pool.addElement(new ControlRunnable(this));
            ++i;
        }
        this.currentThreadCount = toOpen;
    }

    void log(String s) {
        this.loghelper.log(s);
        this.loghelper.flush();
    }

    class ControlRunnable
    implements Runnable {
        ThreadPool p;
        Thread t;
        ThreadPoolRunnable toRun = null;
        boolean shouldTerminate = false;
        boolean shouldRun = false;
        boolean noThData;
        Object[] thData = null;

        ControlRunnable(ThreadPool p) {
            this.p = p;
            this.t = new Thread(this);
            this.t.setDaemon(true);
            this.t.start();
            this.noThData = true;
            this.thData = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Object var4_5;
                    ControlRunnable controlRunnable = this;
                    synchronized (controlRunnable) {
                        if (!this.shouldRun && !this.shouldTerminate) {
                            this.wait();
                        }
                    }
                    if (this.toRun == null) {
                        if (debug > 0) {
                            this.p.log("No toRun ???");
                        }
                    }
                    if (this.shouldTerminate) {
                        if (debug <= 0) break;
                        this.p.log("Terminate");
                        break;
                    }
                    try {
                        block19: {
                            try {
                                if (this.noThData) {
                                    if (debug > 0) {
                                        this.p.log("Getting new thread data");
                                    }
                                    this.thData = this.toRun.getInitData();
                                    this.noThData = false;
                                }
                                if (!this.shouldRun) break block19;
                                this.toRun.runIt(this.thData);
                            }
                            catch (Throwable t) {
                                ThreadPool.this.loghelper.log("Caught exception executing " + this.toRun.toString() + ", terminating thread", t);
                                ThreadPool.this.loghelper.flush();
                                this.shouldTerminate = true;
                                this.shouldRun = false;
                                this.p.notifyThreadEnd(this);
                                var4_5 = null;
                                if (this.shouldRun) {
                                    this.shouldRun = false;
                                    this.p.returnController(this);
                                }
                            }
                        }
                        var4_5 = null;
                        if (this.shouldRun) {
                            this.shouldRun = false;
                            this.p.returnController(this);
                        }
                    }
                    catch (Throwable throwable) {
                        var4_5 = null;
                        if (this.shouldRun) {
                            this.shouldRun = false;
                            this.p.returnController(this);
                        }
                        throw throwable;
                    }
                    if (!this.shouldTerminate) continue;
                }
                catch (InterruptedException ie) {
                    ThreadPool.this.loghelper.log("Unexpected exception", ie);
                    ThreadPool.this.loghelper.flush();
                    continue;
                }
                break;
            }
        }

        public synchronized void runIt(ThreadPoolRunnable toRun) {
            if (toRun == null) {
                throw new NullPointerException("No Runnable");
            }
            this.toRun = toRun;
            this.shouldRun = true;
            this.notify();
        }

        public synchronized void terminate() {
            this.shouldTerminate = true;
            this.notify();
        }
    }

    class MonitorRunnable
    implements Runnable {
        ThreadPool p;
        Thread t;
        boolean shouldTerminate = false;

        MonitorRunnable(ThreadPool p) {
            this.p = p;
            this.t = new Thread(this);
            this.t.setDaemon(p.getDaemon());
            this.t.setName("MonitorRunnable");
            this.t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    MonitorRunnable monitorRunnable = this;
                    synchronized (monitorRunnable) {
                        this.wait(60000L);
                    }
                    if (this.shouldTerminate) break;
                    this.p.checkSpareControllers();
                }
                catch (Throwable t) {
                    ThreadPool.this.loghelper.log("Unexpected exception", t);
                    ThreadPool.this.loghelper.flush();
                }
            }
        }

        public synchronized void terminate() {
            this.shouldTerminate = true;
            this.notify();
        }
    }
}

