/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.MathUtil;
import java.io.Serializable;

final class BeanIdCache {
    private final BeanId[] buckets;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$container$BeanIdCache == null ? (class$com$ibm$ejs$container$BeanIdCache = BeanIdCache.class$("com.ibm.ejs.container.BeanIdCache")) : class$com$ibm$ejs$container$BeanIdCache), (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.BeanIdCache";
    static /* synthetic */ Class class$com$ibm$ejs$container$BeanIdCache;

    public BeanIdCache(int n) {
        n = MathUtil.findNextPrime((int)n);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init> (" + n + ")"));
        }
        this.buckets = new BeanId[n];
    }

    public BeanId find(BeanId beanId) {
        BeanId beanId2 = this.buckets[(beanId.hashValue & Integer.MAX_VALUE) % this.buckets.length];
        if (beanId2 == null || !beanId2.equals(beanId)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"BeanId not found in BeanId Cache");
            }
            beanId2 = beanId;
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"BeanId found in BeanId Cache");
        }
        return beanId2;
    }

    public BeanId find(EJSHome eJSHome, Serializable serializable, boolean bl) {
        int n = BeanId.computeHashValue(eJSHome.j2eeName, serializable, bl);
        BeanId beanId = this.buckets[(n & Integer.MAX_VALUE) % this.buckets.length];
        if (beanId == null || !beanId.equals(eJSHome, serializable, bl)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"BeanId not found in BeanId Cache");
            }
            beanId = new BeanId(eJSHome, serializable, bl);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"BeanId found in BeanId Cache");
        }
        return beanId;
    }

    public void add(BeanId beanId) {
        this.buckets[(beanId.hashValue & Integer.MAX_VALUE) % this.buckets.length] = beanId;
    }

    public void removeAll(EJSHome eJSHome) {
        for (int i = 0; i < this.buckets.length; ++i) {
            BeanId beanId = this.buckets[i];
            if (beanId == null || beanId.home != eJSHome) continue;
            this.buckets[i] = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

