/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.TimeoutElement;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.passivator.StatefulPassivator;
import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;

public final class StatefulBeanReaper
extends Thread
implements AlarmListener,
Dumpable {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$container$StatefulBeanReaper == null ? (class$com$ibm$ejs$container$StatefulBeanReaper = StatefulBeanReaper.class$("com.ibm.ejs.container.StatefulBeanReaper")) : class$com$ibm$ejs$container$StatefulBeanReaper), (String)"EJBCache", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.StatefulBeanReaper";
    private long ivSweepInterval;
    private FastHashtable ivStatefulBeanList;
    private static final long DEFAULT_CLEANUP_INTERVAL = 60000L;
    private static final long DEFAULT_SESSION_TIMEOUT = 300000L;
    private Activator ivActivator;
    protected boolean dumped = false;
    protected int numObjects = 0;
    protected int numAdds = 0;
    protected int numRemoves = 0;
    protected int numNullRemoves = 0;
    protected int numDeletes = 0;
    static /* synthetic */ Class class$com$ibm$ejs$container$StatefulBeanReaper;

    public StatefulBeanReaper(Activator activator, int n) {
        this(activator, n, 60000L);
    }

    public StatefulBeanReaper(Activator activator, int n, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.ivSweepInterval = l < 60000L ? 60000L : l;
        this.setDaemon(true);
        this.setName("StatefulBeanReaper");
        this.ivStatefulBeanList = new FastHashtable(n);
        this.ivActivator = activator;
        Tr.registerDumpable((TraceComponent)tc, (Dumpable)this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init> : sweep = " + this.ivSweepInterval));
        }
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run");
        }
        if (this.ivSweepInterval >= 60000L) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"StatefulBeanReaper using Alarms");
            }
            AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"run");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"StatefulBeanReaper running as background thread");
        }
        while (true) {
            try {
                while (true) {
                    StatefulBeanReaper.sleep(this.ivSweepInterval);
                    this.sweep();
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ejs.container.StatefulBeanReaper.run", (String)"185", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"STATEFUL_BEAN_REAPER_THREAD_INTERRUPTED_CNTR0014W", (Object)new Object[]{interruptedException});
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.container.StatefulBeanReaper.run", (String)"192", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"UNEXPECTED_EXCEPTION_DURING_STATEFUL_BEAN_CLEANUP_CNTR0015W", (Object)new Object[]{this, exception});
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        try {
            this.sweep();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.container.StatefulBeanReaper.alarm", (String)"226", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"UNEXPECTED_EXCEPTION_DURING_STATEFUL_BEAN_CLEANUP_CNTR0015W", (Object)new Object[]{this, exception});
        }
        finally {
            AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sweep() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("Sweep : Stateful Beans = " + this.ivStatefulBeanList.size()));
        }
        Enumeration enumeration = this.ivStatefulBeanList.elements();
        while (enumeration.hasMoreElements()) {
            TimeoutElement timeoutElement;
            boolean bl = false;
            TimeoutElement timeoutElement2 = timeoutElement = (TimeoutElement)enumeration.nextElement();
            synchronized (timeoutElement2) {
                if (this.beanTimedOut(timeoutElement)) {
                    bl = true;
                }
            }
            if (!bl) continue;
            this.deleteBean(timeoutElement.beanId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("Sweep : Stateful Beans = " + this.ivStatefulBeanList.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalSweep(StatefulPassivator statefulPassivator) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("finalSweep : Stateful Beans = " + this.ivStatefulBeanList.size()));
        }
        Enumeration enumeration = this.ivStatefulBeanList.elements();
        while (enumeration.hasMoreElements()) {
            TimeoutElement timeoutElement;
            TimeoutElement timeoutElement2 = timeoutElement = (TimeoutElement)enumeration.nextElement();
            synchronized (timeoutElement2) {
                if (timeoutElement.passivated) {
                    try {
                        if (this.remove(timeoutElement.beanId)) {
                            statefulPassivator.remove(timeoutElement.beanId);
                        }
                    }
                    catch (RemoteException remoteException) {
                        FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ejs.container.StatefulBeanReaper.finalSweep", (String)"298", (Object)this);
                        Tr.warning((TraceComponent)tc, (String)"REMOVE_FROM_PASSIVATION_STORE_FAILED_CNTR0016W", (Object)new Object[]{timeoutElement.beanId, remoteException});
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("finalSweep : Stateful Beans = " + this.ivStatefulBeanList.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beanExistsAndTimedOut(BeanId beanId) {
        TimeoutElement timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get((Object)beanId);
        if (timeoutElement == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Session bean not in Reaper: Timeout = false");
            }
            return false;
        }
        TimeoutElement timeoutElement2 = timeoutElement;
        synchronized (timeoutElement2) {
            return this.beanTimedOut(timeoutElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beanTimedOut(BeanId beanId) {
        TimeoutElement timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get((Object)beanId);
        if (timeoutElement == null) {
            return true;
        }
        TimeoutElement timeoutElement2 = timeoutElement;
        synchronized (timeoutElement2) {
            return this.beanTimedOut(timeoutElement);
        }
    }

    private boolean beanTimedOut(TimeoutElement timeoutElement) {
        if (timeoutElement.timeout > 0L && System.currentTimeMillis() - timeoutElement.lastAccessTime >= timeoutElement.timeout) {
            if (tc.isDebugEnabled()) {
                Date date = new Date(System.currentTimeMillis());
                Date date2 = new Date(timeoutElement.lastAccessTime);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Session bean timed out", (Object)("Current Time : " + date.toString() + "Last Access Time : " + date2.toString() + "Timeout : " + timeoutElement.timeout + " ms"));
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteBean(BeanId beanId) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("deleteBean " + beanId));
            }
            StatefulBeanReaper statefulBeanReaper = this;
            synchronized (statefulBeanReaper) {
                ++this.numDeletes;
            }
            try {
                this.ivActivator.timeoutBean(beanId);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.container.StatefulBeanReaper.deleteBean", (String)"367", (Object)this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"Unable to timeout session bean");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteBean");
        }
    }

    public void add(BeanId beanId) {
        this.add(beanId, 300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BeanId beanId, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("add " + beanId + ", " + l));
        }
        TimeoutElement timeoutElement = new TimeoutElement(beanId, l);
        this.ivStatefulBeanList.put((Object)beanId, (Object)timeoutElement);
        this.setLastAccessTime(beanId);
        StatefulBeanReaper statefulBeanReaper = this;
        synchronized (statefulBeanReaper) {
            ++this.numObjects;
            ++this.numAdds;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"add");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(BeanId beanId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("remove (" + beanId + ")"));
        }
        TimeoutElement timeoutElement = null;
        timeoutElement = (TimeoutElement)this.ivStatefulBeanList.remove((Object)beanId);
        StatefulBeanReaper statefulBeanReaper = this;
        synchronized (statefulBeanReaper) {
            if (timeoutElement != null) {
                --this.numObjects;
                ++this.numRemoves;
            } else {
                ++this.numNullRemoves;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("remove (" + (timeoutElement != null) + ")"));
        }
        return timeoutElement != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastAccessTime(BeanId beanId) {
        TimeoutElement timeoutElement;
        TimeoutElement timeoutElement2 = timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get((Object)beanId);
        synchronized (timeoutElement2) {
            timeoutElement.lastAccessTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastAccessTime(BeanId beanId, long l) {
        TimeoutElement timeoutElement;
        TimeoutElement timeoutElement2 = timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get((Object)beanId);
        synchronized (timeoutElement2) {
            timeoutElement.lastAccessTime = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassivated(BeanId beanId) {
        TimeoutElement timeoutElement;
        TimeoutElement timeoutElement2 = timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get((Object)beanId);
        synchronized (timeoutElement2) {
            timeoutElement.passivated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(BeanId beanId) {
        TimeoutElement timeoutElement;
        TimeoutElement timeoutElement2 = timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get((Object)beanId);
        synchronized (timeoutElement2) {
            timeoutElement.passivated = false;
        }
    }

    public synchronized Iterator getStatefulBeanIds(J2EEName j2EEName) {
        ArrayList<BeanId> arrayList = new ArrayList<BeanId>();
        Enumeration enumeration = this.ivStatefulBeanList.elements();
        while (enumeration.hasMoreElements()) {
            TimeoutElement timeoutElement = (TimeoutElement)enumeration.nextElement();
            if (!j2EEName.equals(timeoutElement.beanId.getJ2EEName()) || timeoutElement.passivated) continue;
            arrayList.add(timeoutElement.beanId);
        }
        return arrayList.iterator();
    }

    public synchronized Iterator getStatefulBeanIds() {
        ArrayList<BeanId> arrayList = new ArrayList<BeanId>();
        Enumeration enumeration = this.ivStatefulBeanList.elements();
        while (enumeration.hasMoreElements()) {
            TimeoutElement timeoutElement = (TimeoutElement)enumeration.nextElement();
            if (timeoutElement.passivated) continue;
            arrayList.add(timeoutElement.beanId);
        }
        return arrayList.iterator();
    }

    public synchronized Iterator getPassivatedStatefulBeanIds(J2EEName j2EEName) {
        ArrayList<BeanId> arrayList = new ArrayList<BeanId>();
        Enumeration enumeration = this.ivStatefulBeanList.elements();
        while (enumeration.hasMoreElements()) {
            TimeoutElement timeoutElement = (TimeoutElement)enumeration.nextElement();
            if (!j2EEName.equals(timeoutElement.beanId.getJ2EEName()) || !timeoutElement.passivated) continue;
            arrayList.add(timeoutElement.beanId);
        }
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        if (this.dumped) {
            return;
        }
        try {
            Tr.dump((TraceComponent)tc, (String)"-- StatefulBeanReaper Dump -- ", (Object)this);
            StatefulBeanReaper statefulBeanReaper = this;
            synchronized (statefulBeanReaper) {
                Tr.dump((TraceComponent)tc, (String)("Number of objects:      " + this.numObjects));
                Tr.dump((TraceComponent)tc, (String)("Number of adds:         " + this.numAdds));
                Tr.dump((TraceComponent)tc, (String)("Number of removes:      " + this.numRemoves));
                Tr.dump((TraceComponent)tc, (String)("Number of null removes: " + this.numNullRemoves));
                Tr.dump((TraceComponent)tc, (String)("Number of deletes:      " + this.numDeletes));
            }
        }
        finally {
            this.dumped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDump() {
        this.dumped = false;
        StatefulBeanReaper statefulBeanReaper = this;
        synchronized (statefulBeanReaper) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

