/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.SessionBeanStore;
import com.ibm.websphere.csi.StreamUnavailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileBeanStore
implements SessionBeanStore {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$csi$FileBeanStore == null ? (class$com$ibm$ejs$csi$FileBeanStore = FileBeanStore.class$("com.ibm.ejs.csi.FileBeanStore")) : class$com$ibm$ejs$csi$FileBeanStore), (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.csi.FileBeanStore";
    private String passivationDir;
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static /* synthetic */ Class class$com$ibm$ejs$csi$FileBeanStore;

    public FileBeanStore(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)string);
        }
        if (string != null && new File(string).isDirectory()) {
            this.passivationDir = string;
        } else {
            this.passivationDir = null;
            if (string != null) {
                Tr.warning((TraceComponent)tc, (String)"PASSIVATION_DIRECTORY_DOES_NOT_EXIST_CNTR0023W", (Object)string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public InputStream getInputStream(EJBKey eJBKey) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInputStream", (Object)eJBKey);
        }
        final String string = this.getPortableFilename(eJBKey.toString());
        final String string2 = this.passivationDir;
        GZIPInputStream gZIPInputStream = null;
        try {
            gZIPInputStream = (GZIPInputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException, IOException {
                    FileInputStream fileInputStream = new FileInputStream(new File(string2, string));
                    return new GZIPInputStream(fileInputStream);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof FileNotFoundException) {
                FFDCFilter.processException((Throwable)((FileNotFoundException)exception), (String)"com.ibm.ejs.csi.FileBeanStore.getInputStream", (String)"91", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"No file found while trying to activate passivated stateful session bean", (Object)string);
                }
                throw new StreamUnavailableException("");
            }
            if (exception instanceof IOException) {
                FFDCFilter.processException((Throwable)((IOException)exception), (String)"com.ibm.ejs.csi.FileBeanStore.getInputStream", (String)"98", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"IOEXCEPTION_READING_FILE_FOR_STATEFUL_SESSION_BEAN_CNTR0024W", (Object)new Object[]{string, this, (IOException)exception});
                throw new CSIException("IOException reading input stream for stateful session bean", (Throwable)((IOException)exception));
            }
            throw new CSIException("Unexpected exception reading input stream for stateful session bean", (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInputStream");
        }
        return gZIPInputStream;
    }

    public OutputStream getOutputStream(EJBKey eJBKey) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOutputStream ", (Object)eJBKey);
        }
        final String string = this.getPortableFilename(eJBKey.toString());
        String string2 = this.passivationDir;
        GZIPOutputStream gZIPOutputStream = null;
        try {
            gZIPOutputStream = (GZIPOutputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(FileBeanStore.this.passivationDir, string));
                    return new GZIPOutputStream(fileOutputStream);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            IOException iOException = (IOException)privilegedActionException.getException();
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ejs.csi.FileBeanStore.getOutputStream", (String)"127", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"IOEXCEPTION_WRITING_FILE_FOR_STATEFUL_SESSION_BEAN_CNTR0025W", (Object)new Object[]{string, this, iOException});
            throw new CSIException("Unable to open output stream", (Throwable)iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOutputStream");
        }
        return gZIPOutputStream;
    }

    public void remove(EJBKey eJBKey) {
        block2: {
            final String string = this.passivationDir;
            final String string2 = this.getPortableFilename(eJBKey.toString());
            final EJBKey eJBKey2 = eJBKey;
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        new File(string, string2).delete();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Bean " + eJBKey2 + " removed from the passivation store"));
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ejs.csi.FileBeanStore.remove", (String)"150", (Object)this);
                if (!tc.isEventEnabled()) break block2;
                Tr.event((TraceComponent)tc, (String)"Failed to remove session bean state", (Object)new Object[]{eJBKey, privilegedActionException});
            }
        }
    }

    private static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(hexChars[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(hexChars[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    private String getPortableFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

