/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.csi.TransactionControlImpl;
import com.ibm.ejs.csi.TxCookieImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSITransactionRequiredException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.ExceptionType;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.traceinfo.ejbcontainer.TETxLifeCycleInfo;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

abstract class TranStrategy {
    protected static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$csi$TranStrategy == null ? (class$com$ibm$ejs$csi$TranStrategy = TranStrategy.class$("com.ibm.ejs.csi.TranStrategy")) : class$com$ibm$ejs$csi$TranStrategy), (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.csi.TranStrategy";
    protected TransactionControlImpl txCtrl;
    protected LocalTransactionCurrent ltcCurrent;
    private WebSphereTransactionManager txManager = TransactionManagerFactory.getTransactionManager();
    static /* synthetic */ Class class$com$ibm$ejs$csi$TranStrategy;

    protected TranStrategy(TransactionControlImpl transactionControlImpl) {
        this.txCtrl = transactionControlImpl;
        this.ltcCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
    }

    abstract TxCookieImpl preInvoke(EJBKey var1, EJBMethodInfo var2) throws CSIException;

    void postInvoke(EJBKey eJBKey, TxCookieImpl txCookieImpl, EJBMethodInfo eJBMethodInfo) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postInvoke");
        }
        if (txCookieImpl.beginner) {
            if (this.txCtrl.getRollbackOnly()) {
                this.rollback(true, eJBKey, eJBMethodInfo);
                throw new CSITransactionRolledbackException("Transaction marked rollbackonly");
            }
            this.commit(eJBKey, eJBMethodInfo);
        } else {
            this.txCtrl.completeTxTimeout();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"postInvoke");
        }
    }

    void handleException(EJBKey eJBKey, TxCookieImpl txCookieImpl, ExceptionType exceptionType, EJBMethodInfo eJBMethodInfo) throws CSIException {
        if (exceptionType == ExceptionType.CHECKED_EXCEPTION) {
            this.postInvoke(eJBKey, txCookieImpl, eJBMethodInfo);
            return;
        }
        if (txCookieImpl.beginner) {
            this.rollback(true, eJBKey, eJBMethodInfo);
            return;
        }
        if (this.globalTxExists(false)) {
            this.txCtrl.completeTxTimeout();
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"handleException: marking client transaction rollbackOnly");
            }
            this.rollback(false, eJBKey, eJBMethodInfo);
            throw new CSITransactionRolledbackException();
        }
    }

    final void beginLocalTx(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo) throws CSIException {
        LocalTransactionCoordinator localTransactionCoordinator;
        int n = ((EJBComponentMetaData)eJBMethodInfo.getComponentMetaData()).getEJBComponentType();
        boolean bl = ((EJBComponentMetaData)eJBMethodInfo.getComponentMetaData()).getLocalTranConfigData().getValueBoundary() == 1;
        boolean bl2 = false;
        if (bl && (n == 3 || n == 4 || n == 5) && (localTransactionCoordinator = (LocalTransactionCoordinator)this.txCtrl.stickyLocalTxTable.remove((Object)eJBKey)) != null) {
            bl2 = true;
            try {
                this.resumeLocalTx(localTransactionCoordinator);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.csi.TranStrategy.beginLocalTx", (String)"200", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Local tx resume failed", (Object)throwable);
                }
                throw new CSIException("Resume local tx failed", throwable);
            }
        }
        if (!bl2) {
            try {
                this.ltcCurrent.begin(bl);
                localTransactionCoordinator = null;
                if (tc.isEventEnabled() || TETxLifeCycleInfo.isTraceEnabled()) {
                    localTransactionCoordinator = this.txCtrl.getLocalCoord();
                }
                if (tc.isEventEnabled()) {
                    if (localTransactionCoordinator != null) {
                        Tr.event((TraceComponent)tc, (String)("Began LTC cntxt: " + System.identityHashCode(localTransactionCoordinator)));
                    } else {
                        Tr.event((TraceComponent)tc, (String)"Began LTC cntxt: null Coordinator!");
                    }
                }
                if (localTransactionCoordinator != null && TETxLifeCycleInfo.isTraceEnabled()) {
                    TETxLifeCycleInfo.traceLocalTxBegin("" + System.identityHashCode(localTransactionCoordinator), "Begin Local Tx");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.csi.TranStrategy.beginLocalTx", (String)"217", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Begin local tx failed", (Object)exception);
                }
                throw new CSIException("Begin local tx failed", (Throwable)exception);
            }
        }
    }

    final void suspendLocalTx(LocalTransactionCoordinator localTransactionCoordinator) {
        if (tc.isEventEnabled()) {
            if (localTransactionCoordinator != null) {
                Tr.event((TraceComponent)tc, (String)("Suspending LTC cntxt: " + System.identityHashCode(localTransactionCoordinator)));
            } else {
                Tr.event((TraceComponent)tc, (String)"Suspending LTC cntxt: null Coordinator!");
            }
        }
        this.ltcCurrent.suspend();
        if (localTransactionCoordinator != null && TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceLocalTxSuspend("" + System.identityHashCode(localTransactionCoordinator), "Suspend Local Tx");
        }
    }

    final void resumeLocalTx(LocalTransactionCoordinator localTransactionCoordinator) throws IllegalStateException {
        if (tc.isEventEnabled()) {
            if (localTransactionCoordinator != null) {
                Tr.event((TraceComponent)tc, (String)("Resuming LTC cntxt: " + System.identityHashCode(localTransactionCoordinator)));
            } else {
                Tr.event((TraceComponent)tc, (String)"Resuming LTC cntxt: null Coordinator!");
            }
        }
        this.ltcCurrent.resume(localTransactionCoordinator);
        if (localTransactionCoordinator != null && TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceLocalTxResume("" + System.identityHashCode(localTransactionCoordinator), "Resume Local Tx");
        }
    }

    final boolean globalTxExists(boolean bl) throws CSIException {
        Transaction transaction;
        block4: {
            transaction = null;
            try {
                transaction = this.txManager.getTransaction();
            }
            catch (SystemException systemException) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)"Could not determine if there is a global tx active");
            }
        }
        if (bl && transaction != null && ((UOWCoordinator)transaction).getTxType() == 2) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Cannot proceed under a non-interoperable transaction context");
            }
            throw new CSITransactionRequiredException("Interoperable global transaction required");
        }
        return transaction != null;
    }

    final void beginGlobalTx(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo) throws CSIException {
        try {
            this.txCtrl.txService.setTransactionTimeout(this.txCtrl.txLifetime);
            this.txCtrl.txService.begin();
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Began TX cntxt: " + this.txCtrl.txService.getTransaction()));
            }
            if (TETxLifeCycleInfo.isTraceEnabled()) {
                int n;
                String string = this.txCtrl.txService.getTransaction().toString();
                string = string != null ? ((n = string.indexOf("(")) != -1 ? string.substring(n + 1, string.indexOf(")")) : ((n = string.indexOf("tid=")) != -1 ? string.substring(n + 4) : string)) : "NoTx";
                TETxLifeCycleInfo.traceGlobalTxBegin(string, "Begin Global Tx");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.csi.TranStrategy.beginGlobalTx", (String)"243", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Begin global tx failed", (Object)exception);
            }
            throw new CSIException("Begin global tx failed", (Throwable)exception);
        }
    }

    final Transaction suspendGlobalTx(int n) throws CSIException {
        Transaction transaction = this.txCtrl.suspendGlobalTx(n);
        if (TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceGlobalTxSuspend("NoTx", "Suspend Global Tx");
        }
        return transaction;
    }

    final void resumeGlobalTx(Transaction transaction, int n) throws CSIException {
        try {
            this.txCtrl.resumeGlobalTx(transaction, n);
            if (TETxLifeCycleInfo.isTraceEnabled()) {
                int n2;
                String string = this.txCtrl.txService.getTransaction().toString();
                string = string != null ? ((n2 = string.indexOf("(")) != -1 ? string.substring(n2 + 1, string.indexOf(")")) : ((n2 = string.indexOf("tid=")) != -1 ? string.substring(n2 + 4) : string)) : "NoTx";
                TETxLifeCycleInfo.traceGlobalTxResume(string, "Resume Global Tx");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.csi.TranStrategy.resumeGlobalTx", (String)"335", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Global tx resume failed", (Object)exception);
            }
            throw new CSIException("", (Throwable)exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void commit(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo) throws CSITransactionRolledbackException {
        LocalTransactionCoordinator localTransactionCoordinator = this.ltcCurrent.getLocalTranCoord();
        if (localTransactionCoordinator != null) {
            int n = ((EJBComponentMetaData)eJBMethodInfo.getComponentMetaData()).getEJBComponentType();
            if (localTransactionCoordinator.isASScoped()) {
                if (eJBMethodInfo.isHome() || n == 6) return;
                this.suspendLocalTx(localTransactionCoordinator);
                if (n == 2 || eJBMethodInfo.getMethodName().equalsIgnoreCase("remove")) return;
                this.txCtrl.stickyLocalTxTable.put((Object)eJBKey, (Object)localTransactionCoordinator);
                return;
            } else {
                try {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Completing LTC cntxt: " + System.identityHashCode(localTransactionCoordinator)));
                    }
                    localTransactionCoordinator.end(0);
                    if (localTransactionCoordinator == null || !TETxLifeCycleInfo.isTraceEnabled()) return;
                    TETxLifeCycleInfo.traceLocalTxCommit("" + System.identityHashCode(localTransactionCoordinator), "Commit Local Tx - end");
                    return;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.csi.TranStrategy.commit", (String)"277", (Object)this);
                    if (!tc.isEventEnabled()) throw new CSITransactionRolledbackException("");
                    Tr.event((TraceComponent)tc, (String)"Local tx completion failed", (Object)exception);
                    throw new CSITransactionRolledbackException("");
                }
            }
        }
        try {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Committing TX cntxt: " + this.txCtrl.txService.getTransaction()));
            }
            this.txCtrl.txService.commit();
            if (!TETxLifeCycleInfo.isTraceEnabled()) return;
            TETxLifeCycleInfo.traceGlobalTxCommit("NoTx", "Commit Global Tx");
            return;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.csi.TranStrategy.commit", (String)"294", (Object)this);
            if (!tc.isEventEnabled()) throw new CSITransactionRolledbackException("");
            Tr.event((TraceComponent)tc, (String)"Global tx commit failed", (Object)exception);
            throw new CSITransactionRolledbackException("");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void rollback(boolean bl, EJBKey eJBKey, EJBMethodInfo eJBMethodInfo) throws CSIException {
        LocalTransactionCoordinator localTransactionCoordinator = this.ltcCurrent.getLocalTranCoord();
        if (localTransactionCoordinator != null) {
            int n = ((EJBComponentMetaData)eJBMethodInfo.getComponentMetaData()).getEJBComponentType();
            if (localTransactionCoordinator.isASScoped()) {
                if (eJBMethodInfo.isHome() || n == 6) return;
                localTransactionCoordinator.setRollbackOnly();
                this.suspendLocalTx(localTransactionCoordinator);
                if (n == 2 || eJBMethodInfo.getMethodName().equalsIgnoreCase("remove")) return;
                this.txCtrl.stickyLocalTxTable.put((Object)eJBKey, (Object)localTransactionCoordinator);
                return;
            } else {
                try {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Completing LTC cntxt with rollback due to bean exception: " + System.identityHashCode(localTransactionCoordinator)));
                    }
                    localTransactionCoordinator.setRollbackOnly();
                    localTransactionCoordinator.end(1);
                    if (localTransactionCoordinator == null || !TETxLifeCycleInfo.isTraceEnabled()) return;
                    TETxLifeCycleInfo.traceLocalTxRollback("" + System.identityHashCode(localTransactionCoordinator), "Rollback Local Tx - end");
                    return;
                }
                catch (RolledbackException rolledbackException) {
                    FFDCFilter.processException((Throwable)rolledbackException, (String)"com.ibm.ejs.csi.TranStrategy.rollback", (String)"375", (Object)this);
                    return;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.csi.TranStrategy.rollback", (String)"378", (Object)this);
                    String string = "Could not complete local tx";
                    if (!tc.isEventEnabled()) throw new CSIException(string, (Throwable)exception);
                    Tr.event((TraceComponent)tc, (String)string, (Object)exception);
                    throw new CSIException(string, (Throwable)exception);
                }
            }
        }
        try {
            if (bl) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Rolling back TX cntxt due to bean exception: " + this.txCtrl.txService.getTransaction()));
                }
                this.txCtrl.txService.rollback();
                if (!TETxLifeCycleInfo.isTraceEnabled()) return;
                TETxLifeCycleInfo.traceGlobalTxRollback("NoTx", "Rollback Global Tx");
                return;
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Marking TX cntxt for rollback due to bean exception: " + this.txCtrl.txService.getTransaction()));
                }
                this.txCtrl.txService.setRollbackOnly();
            }
            return;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.csi.TranStrategy.rollback", (String)"405", (Object)this);
            String string = "Could not roll back global tx";
            if (!tc.isEventEnabled()) throw new CSIException(string, (Throwable)exception);
            Tr.event((TraceComponent)tc, (String)string, (Object)exception);
            throw new CSIException(string, (Throwable)exception);
        }
    }

    boolean isBmtActive() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

