/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.ejb.EJBObject;

public class Utils {
    private static final String rootContextPrefix = "ejsadmin/";
    private static final int UUID_LENGTH = 16;
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$sm$util$Utils == null ? (class$com$ibm$ejs$sm$util$Utils = Utils.class$("com.ibm.ejs.sm.util.Utils")) : class$com$ibm$ejs$sm$util$Utils));
    static /* synthetic */ Class class$com$ibm$ejs$sm$util$Utils;

    public static String getIdString(EJBObject eJBObject) throws RemoteException {
        return Long.toString((Long)eJBObject.getPrimaryKey());
    }

    public static String getIdString(Long l) {
        return Long.toString(l);
    }

    public static Long getId(String string) {
        return new Long(Long.parseLong(string));
    }

    public static final String relativeName(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    public static final String packageName(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(0, n);
        }
        return null;
    }

    public static Properties byteArrayToProperties(byte[] byArray) throws RemoteException {
        try {
            Properties properties = new Properties();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            properties.load(byteArrayInputStream);
            return properties;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ejs.sm.util.Utils.byteArrayToProperties", (String)"70");
            throw new RemoteException("", iOException);
        }
    }

    public static byte[] propertiesToByteArray(Properties properties) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        properties.save(byteArrayOutputStream, "");
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] serializeObject(Object object) throws RemoteException {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ejs.sm.util.Utils.serializeObject", (String)"93");
            throw new RemoteException("", iOException);
        }
    }

    public static Object deserializeObject(byte[] byArray) throws RemoteException {
        if (byArray == null) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ejs.sm.util.Utils.deserializeObject", (String)"107");
            throw new RemoteException("", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ejs.sm.util.Utils.deserializeObject", (String)"110");
            throw new RemoteException("", classNotFoundException);
        }
    }

    public static boolean intToBoolean(int n) {
        return n > 0;
    }

    public static int booleanToInt(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    public static int enumLength(Enumeration enumeration) {
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ++n;
            Object e = enumeration.nextElement();
        }
        return n;
    }

    public static String getLocalHostName() throws RemoteException {
        try {
            return (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    return Utils.getLocalHostIPAddress().getHostName();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ejs.sm.util.Utils.getLocalHostName", (String)"146");
            throw (RemoteException)privilegedActionException.getException();
        }
    }

    public static InetAddress getLocalHostIPAddress() throws RemoteException {
        try {
            return (InetAddress)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getLocalHost();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ejs.sm.util.Utils.getLocalHostIPAddress", (String)"163");
            UnknownHostException unknownHostException = (UnknownHostException)privilegedActionException.getException();
            throw new RemoteException("", unknownHostException);
        }
    }

    public static String getUuid(long l) {
        String string = Long.toHexString(l);
        if (string.length() < 16) {
            for (int i = 16 - string.length(); i > 0; --i) {
                string = string + "0";
            }
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println(new String(Utils.getUuid(1L)));
    }

    public static String replaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = null;
        int n = string2.length();
        int n2 = 0;
        while ((n2 = string.indexOf(string2)) > -1) {
            stringBuffer = new StringBuffer().append(string.substring(0, n2));
            stringBuffer.append(string3);
            stringBuffer.append(string.substring(n2 + n));
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String getRootContextPrefix() {
        return rootContextPrefix;
    }

    public static String qualifyRepositoryHomeName(String string, String string2) {
        return "ejsadmin/homes/" + string2;
    }

    public static String unqualifyRepositoryHomeName(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unqualifyRepositoryHomeName", (Object)new Object[]{string, string2});
        }
        String string3 = string2;
        String string4 = "ejsadmin/homes/";
        if (!string2.startsWith(string4)) {
            Tr.event((TraceComponent)tc, (String)"home prefix was not qualified: cannot unqualify", (Object)string2);
        } else {
            string3 = string2.substring(string4.length());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unqualifyRepositoryHomeName", (Object)string3);
        }
        return string3;
    }

    public static String defaultNodeName(String string, boolean bl) throws UnknownHostException, RemoteException {
        Object object;
        InetAddress inetAddress = null;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = null;
        if (string == null || string.equals("") || string.equalsIgnoreCase("localhost")) {
            bl3 = true;
            inetAddress = Utils.getLocalHostIPAddress();
            object = inetAddress;
            string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((InetAddress)object){
                private final /* synthetic */ InetAddress val$myIpAddress;
                {
                    this.val$myIpAddress = inetAddress;
                }

                public Object run() {
                    return this.val$myIpAddress.getHostName();
                }
            });
            if (string == null) {
                string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((InetAddress)object){
                    private final /* synthetic */ InetAddress val$myIpAddress;
                    {
                        this.val$myIpAddress = inetAddress;
                    }

                    public Object run() {
                        return this.val$myIpAddress.getHostAddress();
                    }
                });
                bl2 = true;
                Tr.event((TraceComponent)tc, (String)"IP address is used as node name", (Object)string);
            }
        }
        string2 = string;
        if (!bl3) {
            try {
                object = string2;
                inetAddress = (InetAddress)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((String)object){
                    private final /* synthetic */ String val$myName;
                    {
                        this.val$myName = string;
                    }

                    public Object run() throws UnknownHostException {
                        return InetAddress.getByName(this.val$myName);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ejs.sm.util.Utils.defaultNodeName", (String)"303");
                UnknownHostException unknownHostException = (UnknownHostException)privilegedActionException.getException();
                Tr.event((TraceComponent)tc, (String)"DNS lookup for hostName failed. ", (Object)unknownHostException);
                throw unknownHostException;
            }
            if (string2.equals(inetAddress.getHostAddress()) && (string2 = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((InetAddress)(object = inetAddress)){
                private final /* synthetic */ InetAddress val$myIpAddress;
                {
                    this.val$myIpAddress = inetAddress;
                }

                public Object run() {
                    return this.val$myIpAddress.getHostName();
                }
            })) == null) {
                string2 = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((InetAddress)object){
                    private final /* synthetic */ InetAddress val$myIpAddress;
                    {
                        this.val$myIpAddress = inetAddress;
                    }

                    public Object run() {
                        return this.val$myIpAddress.getHostAddress();
                    }
                });
                bl2 = true;
                Tr.event((TraceComponent)tc, (String)"IP address is used as node name", (Object)string2);
            }
        }
        if (bl && !bl2) {
            object = new StringTokenizer(string2, ".");
            string2 = ((StringTokenizer)object).nextToken();
        }
        if (((String)(object = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return System.getProperty("os.name").toLowerCase();
            }
        }))).indexOf("netware") != -1) {
            return string2.toLowerCase();
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

