/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.MathUtil;
import com.ibm.ejs.util.cache.Bucket;
import com.ibm.ejs.util.cache.CacheElementEnumerator;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.EvictionStrategy;
import com.ibm.ejs.util.cache.IllegalOperationException;
import com.ibm.ejs.util.cache.LimitStrategy;
import com.ibm.ejs.util.cache.NoSuchObjectException;
import com.ibm.websphere.csi.DiscardException;
import com.ibm.websphere.csi.DiscardStrategy;
import com.ibm.websphere.csi.EJBCache;
import com.ibm.websphere.csi.FaultException;
import com.ibm.websphere.csi.FaultStrategy;
import com.ibm.websphere.csi.InsufficientCacheSpaceException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Enumeration;

public final class Cache
implements EJBCache,
Dumpable {
    protected FaultStrategy faultStrategy = null;
    protected LimitStrategy limitStrategy = null;
    protected EvictionStrategy evictionStrategy = null;
    protected DiscardStrategy discardStrategy = null;
    protected String ivName;
    protected Bucket[] buckets;
    protected int numBuckets;
    protected int numObjects = 0;
    private int numEvictionAttempts = 0;
    private int numEvictions = 0;
    protected long numSweeps = 0L;
    protected boolean dumped = false;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$util$cache$Cache == null ? (class$com$ibm$ejs$util$cache$Cache = Cache.class$("com.ibm.ejs.util.cache.Cache")) : class$com$ibm$ejs$util$cache$Cache), (String)"EJBCache", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.util.cache.Cache";
    static /* synthetic */ Class class$com$ibm$ejs$util$cache$Cache;

    public Cache(String string, int n) {
        n = MathUtil.findNextPrime((int)n);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init> (" + string + "," + n + ")"));
        }
        this.ivName = string;
        this.numBuckets = n;
        this.buckets = new Bucket[n];
        for (int i = 0; i < n; ++i) {
            this.buckets[i] = new Bucket();
        }
        Tr.registerDumpable((TraceComponent)tc, (Dumpable)this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public Cache(String string, long l) {
        this(string, (int)l);
    }

    public final int getSize() {
        return this.numObjects;
    }

    public final int getConfigSize() {
        return this.numBuckets;
    }

    public String getName() {
        return this.ivName;
    }

    public final void setFaultStrategy(FaultStrategy faultStrategy) {
        this.faultStrategy = faultStrategy;
    }

    public final void setLimitStrategy(LimitStrategy limitStrategy) {
        this.limitStrategy = limitStrategy;
    }

    public final void setEvictionStrategy(EvictionStrategy evictionStrategy) {
        this.evictionStrategy = evictionStrategy;
    }

    public final void setDiscardStrategy(DiscardStrategy discardStrategy) {
        this.discardStrategy = discardStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"contains", (Object)object);
        }
        Bucket bucket = this.getBucketForKey(object);
        Element element = null;
        Bucket bucket2 = bucket;
        synchronized (bucket2) {
            element = bucket.findByKey(object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"contains", (Object)new Boolean(element != null));
        }
        return element != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object find(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"find", (Object)object);
        }
        Bucket bucket = this.getBucketForKey(object);
        Object object2 = null;
        Bucket bucket2 = bucket;
        synchronized (bucket2) {
            Element element = bucket.findByKey(object);
            if (element != null) {
                ++element.pinned;
                object2 = element.object;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"find", (Object)object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findDontPinNAdjustPinCount(Object object, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findDontPinNAdjustPinCount", (Object)(object + ", adujust pin count=" + n));
        }
        Bucket bucket = this.getBucketForKey(object);
        Object object2 = null;
        Bucket bucket2 = bucket;
        synchronized (bucket2) {
            Element element = bucket.findByKey(object);
            if (element != null) {
                element.accessed = true;
                element.sweepCount = 0;
                element.accessedSweep = this.numSweeps;
                object2 = element.object;
                element.pinned += n;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findDontPinNAdjustPinCount", object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findAndFault(Object object) throws FaultException, InsufficientCacheSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findAndFault", (Object)object);
        }
        Bucket bucket = this.getBucketForKey(object);
        Object object2 = null;
        Object object3 = bucket;
        synchronized (object3) {
            Element element = bucket.findByKey(object);
            if (element != null) {
                element.accessed = true;
                element.sweepCount = 0;
                element.accessedSweep = this.numSweeps;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findAndFault : found in cache");
                }
                return element.object;
            }
            if (this.faultStrategy == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findAndFault : not in cache : no FaultStrategy");
                }
                return null;
            }
            try {
                object2 = this.faultStrategy.faultOnKey((EJBCache)this, object);
                if (object2 != null) {
                    element = bucket.insertByKey(object, object2);
                    element.accessed = true;
                    element.sweepCount = 0;
                    element.accessedSweep = this.numSweeps;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.util.cache.Cache.findAndFault", (String)"417", (Object)this);
                throw new FaultException(exception, object);
            }
        }
        if (object2 != null) {
            object3 = this;
            synchronized (object3) {
                ++this.numObjects;
            }
        }
        this.trimCache();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findAndFault : not in cache : faulted");
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object, boolean bl) {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{object, new Boolean(bl)});
        }
        Bucket bucket = this.getBucketForKey(object);
        Object object3 = bucket;
        synchronized (object3) {
            Element element = bucket.removeByKey(object, bl);
            object2 = element != null ? element.object : null;
        }
        if (object2 != null) {
            object3 = this;
            synchronized (object3) {
                --this.numObjects;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove", (Object)object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeAndDiscard(Object object, boolean bl) throws DiscardException {
        Object object2;
        block16: {
            Cache cache;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"removeAndDiscard", (Object)new Object[]{object, new Boolean(bl)});
            }
            Bucket bucket = this.getBucketForKey(object);
            object2 = null;
            try {
                Bucket bucket2 = bucket;
                synchronized (bucket2) {
                    Element element = bucket.removeByKey(object, bl);
                    Object object3 = object2 = element != null ? element.object : null;
                    if (object2 != null && this.discardStrategy != null) {
                        try {
                            this.discardStrategy.discardObject((EJBCache)this, element.key, element.object);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.util.cache.Cache.removeAndDiscard", (String)"540", (Object)this);
                            Tr.warning((TraceComponent)tc, (String)"EXCEPTION_THROWN_BY_DISCARD_STRATEGY_CNTR0054W", (Object)new Object[]{element, exception});
                            element = null;
                            throw new DiscardException(exception, object);
                        }
                    }
                }
                Object var10_9 = null;
                if (object2 == null) break block16;
                cache = this;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (object2 != null) {
                    Cache cache2 = this;
                    synchronized (cache2) {
                        --this.numObjects;
                    }
                }
                throw throwable;
            }
            synchronized (cache) {
                --this.numObjects;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAndDiscard", (Object)object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Object object, Object object2) throws InsufficientCacheSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"insert", (Object)new Object[]{object, object2});
        }
        try {
            this.trimCache();
            Bucket bucket = this.getBucketForKey(object);
            Object object3 = bucket;
            synchronized (object3) {
                Element element = bucket.insertByKey(object, object2);
                ++element.pinned;
            }
            object3 = this;
            synchronized (object3) {
                ++this.numObjects;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"insert");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"insert");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pin(Object object) {
        Bucket bucket;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"pin", (Object)object);
        }
        Bucket bucket2 = bucket = this.getBucketForKey(object);
        synchronized (bucket2) {
            Element element = bucket.findByKey(object);
            if (element == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"pin - throw NoSuchObjectException");
                }
                throw new NoSuchObjectException(object);
            }
            ++element.pinned;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pinOnce(Object object) {
        Bucket bucket;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"pinOnce", (Object)object);
        }
        boolean bl = false;
        Bucket bucket2 = bucket = this.getBucketForKey(object);
        synchronized (bucket2) {
            Element element = bucket.findByKey(object);
            if (element != null && element.pinned == 0) {
                ++element.pinned;
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("pinOnce : " + bl));
        }
        return bl;
    }

    public void unpin(Object object) {
        this.unpin(object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpin(Object object, boolean bl) {
        Bucket bucket;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unpin", (Object)(object + ":" + bl));
        }
        Bucket bucket2 = bucket = this.getBucketForKey(object);
        synchronized (bucket2) {
            Element element = bucket.findByKey(object);
            if (element == null) {
                if (bl) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"unpin - not in cache, return");
                    }
                    return;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"unpin - throw NoSuchObjectException");
                }
                throw new NoSuchObjectException(object);
            }
            if (element.pinned < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"unpin - throw IllegalOperationException");
                }
                throw new IllegalOperationException(object, element.pinned);
            }
            --element.pinned;
            element.accessed = true;
            element.sweepCount = 0;
            element.accessedSweep = this.numSweeps;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unpin");
        }
    }

    public final Enumeration enumerateElements() {
        return new CacheElementEnumerator(this);
    }

    protected final Bucket getBucketForKey(Object object) {
        return this.buckets[(object.hashCode() & Integer.MAX_VALUE) % this.buckets.length];
    }

    protected void trimCache() throws InsufficientCacheSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"trimCache");
        }
        if (this.limitStrategy == null || this.evictionStrategy == null) {
            return;
        }
        while (this.limitStrategy.hardLimitReached(this)) {
            Object object = this.evictionStrategy.getVictim(this);
            if (object != null) {
                this.evictObject(object);
                continue;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"trimCache - throw InsufficientCacheSpaceException");
            }
            throw new InsufficientCacheSpaceException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"trimCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected boolean evictObject(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"evictObject", (Object)object);
        }
        Bucket bucket = this.getBucketForKey(object);
        Element element = null;
        Object object2 = this;
        // MONITORENTER : object2
        ++this.numEvictionAttempts;
        // MONITOREXIT : object2
        try {
            try {
                block19: {
                    block18: {
                        object2 = bucket;
                        // MONITORENTER : object2
                        element = bucket.findByKey(object);
                        if (element == null || !this.evictionStrategy.canBeDiscarded(element)) break block18;
                        element = bucket.discardByKey(object);
                        if (element != null) {
                            Cache cache = this;
                            // MONITORENTER : cache
                            --this.numObjects;
                            ++this.numEvictions;
                            // MONITOREXIT : cache
                            if (this.discardStrategy != null) {
                                try {
                                    this.discardStrategy.discardObject((EJBCache)this, element.key, element.object);
                                }
                                catch (Exception cache2) {
                                    FFDCFilter.processException((Throwable)cache2, (String)"com.ibm.ejs.util.cache.Cache.evictObject", (String)"863", (Object)this);
                                    Tr.warning((TraceComponent)tc, (String)"EXCEPTION_THROWN_BY_DISCARD_STRATEGY_CNTR0054W", (Object)new Object[]{element, cache2});
                                    element = null;
                                }
                            }
                        }
                        break block19;
                    }
                    element = null;
                }
                // MONITOREXIT : object2
            }
            catch (IllegalOperationException illegalOperationException) {
                FFDCFilter.processException((Throwable)illegalOperationException, (String)"com.ibm.ejs.util.cache.Cache.evictObject", (String)"878", (Object)this);
                element = null;
                Object var9_9 = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"evictObject", (Object)new Boolean(element != null));
                }
            }
            Object var9_8 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"evictObject", (Object)new Boolean(element != null));
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"evictObject", (Object)new Boolean(element != null));
            throw throwable;
        }
        if (element == null) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        if (this.dumped) {
            return;
        }
        try {
            Tr.dump((TraceComponent)tc, (String)"-- Cache Dump -- ", (Object)this);
            Tr.dump((TraceComponent)tc, (String)("Name of Cache: " + this.ivName));
            Tr.dump((TraceComponent)tc, (String)("Number of buckets: " + this.numBuckets));
            Cache cache = this;
            synchronized (cache) {
                Tr.dump((TraceComponent)tc, (String)("Number of objects currently in cache: " + this.numObjects));
                Tr.dump((TraceComponent)tc, (String)("Number of evictions attempted (since last dump): " + this.numEvictionAttempts));
                Tr.dump((TraceComponent)tc, (String)("Number of evictions (since last dump): " + this.numEvictions));
            }
        }
        finally {
            this.dumped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDump() {
        this.dumped = false;
        Cache cache = this;
        synchronized (cache) {
            this.numEvictionAttempts = 0;
            this.numEvictions = 0;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

