/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.jar;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.StrUtils;
import com.ibm.ejs.util.jar.ClasspathElement;
import com.ibm.ejs.util.jar.EJBDir;
import com.ibm.ejs.util.jar.EJBJar;
import com.ibm.ejs.util.jar.EJBZip;
import com.ibm.ejs.util.jar.JarClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;

public class ClasspathManager {
    private JarClassLoader cl;
    private StringBuffer cp = new StringBuffer();
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$util$jar$ClasspathManager == null ? (class$com$ibm$ejs$util$jar$ClasspathManager = ClasspathManager.class$("com.ibm.ejs.util.jar.ClasspathManager")) : class$com$ibm$ejs$util$jar$ClasspathManager));
    static /* synthetic */ Class class$com$ibm$ejs$util$jar$ClasspathManager;

    public ClasspathManager() {
        this.cl = new JarClassLoader();
    }

    public ClasspathManager(JarClassLoader jarClassLoader) {
        this.cl = jarClassLoader;
    }

    public synchronized void addComponents(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addPath: ", (Object)string);
        }
        if (string == null || string.length() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addPath");
            }
            return;
        }
        String[] stringArray = StrUtils.split((String)string, (int)File.pathSeparatorChar);
        for (int i = 0; i < stringArray.length; ++i) {
            ClasspathElement classpathElement = null;
            try {
                File file = new File(stringArray[i]);
                boolean bl = file.isFile();
                if (bl && stringArray[i].endsWith(".zip")) {
                    classpathElement = new EJBZip(stringArray[i], this.cl);
                    this.cl.addCPElement(classpathElement);
                    continue;
                }
                if (bl && stringArray[i].endsWith(".jar")) {
                    EJBJar eJBJar = new EJBJar(stringArray[i], this.cl);
                    classpathElement = eJBJar;
                    this.cl.addCPElement(classpathElement);
                    eJBJar.loadDeploymentDescriptors();
                    continue;
                }
                classpathElement = new EJBDir(stringArray[i], this.cl);
                this.cl.addCPElement(classpathElement);
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.util.jar.ClasspathManager.addComponents", (String)"63", (Object)this);
                if (classpathElement != null) {
                    this.cl.removeCPElement(classpathElement);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Got exception while processing " + stringArray[i]), (Object)throwable);
            }
        }
        if (this.cp.length() > 0) {
            this.cp.append(File.pathSeparatorChar + string);
        } else {
            this.cp.append(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addPath");
        }
    }

    public synchronized void deleteComponents() {
        this.cl.removeAllCPElement();
    }

    public synchronized EJBJar addJarFile(String string) throws IOException, ClassNotFoundException {
        EJBJar eJBJar = (EJBJar)this.cl.isClasspathElementPresent(string);
        if (eJBJar != null) {
            this.cp.append(File.pathSeparatorChar + string);
            return eJBJar;
        }
        try {
            eJBJar = new EJBJar(string, this.cl);
            this.cl.addCPElement(eJBJar);
            eJBJar.loadDeploymentDescriptors();
            if (this.cp.length() > 0) {
                this.cp.append(File.pathSeparatorChar + string);
            } else {
                this.cp.append(string);
            }
        }
        catch (ZipException zipException) {
            FFDCFilter.processException((Throwable)zipException, (String)"com.ibm.ejs.util.jar.ClasspathManager.addJarFile", (String)"106", (Object)this);
            throw new ZipException("error in opening the zip file " + string);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ejs.util.jar.ClasspathManager.addJarFile", (String)"109", (Object)this);
            this.cl.removeCPElement(eJBJar);
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ejs.util.jar.ClasspathManager.addJarFile", (String)"113", (Object)this);
            this.cl.removeCPElement(eJBJar);
            throw classNotFoundException;
        }
        return eJBJar;
    }

    public String getClasspath() {
        return this.cp.toString();
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

