/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.jar;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.PortableDeploymentDescriptor;
import com.ibm.ejs.util.jar.EJBZip;
import com.ibm.ejs.util.jar.JarClassLoader;
import com.ibm.ejs.util.jar.Manifest;
import com.ibm.ejs.util.jar.ObjectInputStream;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import javax.ejb.deployment.DeploymentDescriptor;

public class EJBJar
extends EJBZip {
    private Manifest manifest;
    private Hashtable descriptorsByHomeName = new Hashtable();
    private Vector orderedDescriptors = new Vector();
    private static final String MANIFEST_FILE_NAME = "META-INF/MANIFEST.MF";
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$util$jar$EJBJar == null ? (class$com$ibm$ejs$util$jar$EJBJar = EJBJar.class$("com.ibm.ejs.util.jar.EJBJar")) : class$com$ibm$ejs$util$jar$EJBJar));
    static /* synthetic */ Class class$com$ibm$ejs$util$jar$EJBJar;

    public EJBJar(String string) throws IOException, ClassNotFoundException {
        super(string);
        try {
            this.loadManifest();
            if (this.classLoader instanceof JarClassLoader) {
                ((JarClassLoader)this.classLoader).addCPElement(this);
            }
            this.loadDeploymentDescriptors();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ejs.util.jar.EJBJar.EJBJar", (String)"28", (Object)this);
            if (this.classLoader instanceof JarClassLoader) {
                ((JarClassLoader)this.classLoader).removeCPElement(this);
            }
            this.close();
            throw iOException;
        }
    }

    public EJBJar(String string, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        super(string, classLoader);
        try {
            this.loadManifest();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ejs.util.jar.EJBJar.EJBJar", (String)"45", (Object)this);
            this.close();
            throw iOException;
        }
    }

    public boolean isFullyDeployed() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isFullyDeployed");
        }
        Enumeration enumeration = this.getDeploymentDescriptors();
        boolean bl = true;
        while (bl && enumeration.hasMoreElements()) {
            PortableDeploymentDescriptor portableDeploymentDescriptor = (PortableDeploymentDescriptor)enumeration.nextElement();
            String string = portableDeploymentDescriptor.getEnterpriseBeanClassName();
            String string2 = portableDeploymentDescriptor.getRemoteInterfaceClassName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("remoteInterfaceName: " + string2));
            }
            String string3 = this.getPackageName(string) + "." + this.getEJSClassName(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("remoteInterfaceImplName: " + string3));
            }
            string3 = string3.replace('.', '/') + ".class";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("remoteInterfaceImplPathName: " + string3));
            }
            boolean bl2 = bl = this.getEntry(string3) != null;
            if (!bl) {
                string3 = this.getPackageName(string2) + "." + this.getEJSClassName(string2);
                string3 = string3.replace('.', '/') + ".class";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("remoteInterfaceImplPathName: " + string3));
                }
                boolean bl3 = bl = this.getEntry(string3) != null;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)(string + " is deployed: " + new Boolean(bl)));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isFullyDeployed: " + new Boolean(bl)));
        }
        return bl;
    }

    public void loadDeploymentDescriptors() throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadDeploymentDescriptors");
        }
        try {
            Enumeration enumeration = this.manifest.descriptorNames();
            if (enumeration.hasMoreElements()) {
                this.loadDeploymentDescriptors(enumeration);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ejs.util.jar.EJBJar.loadDeploymentDescriptors", (String)"116", (Object)this);
            this.close();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"loadDeploymentDescriptors");
            }
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ejs.util.jar.EJBJar.loadDeploymentDescriptors", (String)"122", (Object)this);
            this.close();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"loadDeploymentDescriptors");
            }
            throw classNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadDeploymentDescriptors");
        }
    }

    private void loadDeploymentDescriptors(Enumeration enumeration) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadDeploymentDescriptors(Enumeration)");
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Instantiating " + string));
            }
            InputStream inputStream = null;
            try {
                inputStream = this.classLoader.getResourceAsStream(string);
                if (inputStream == null) continue;
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream, this.classLoader);
                DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)objectInputStream.readObject();
                PortableDeploymentDescriptor portableDeploymentDescriptor = new PortableDeploymentDescriptor(deploymentDescriptor, this.classLoader);
                this.descriptorsByHomeName.put(deploymentDescriptor.getBeanHomeName().toString(), portableDeploymentDescriptor);
                this.orderedDescriptors.addElement(portableDeploymentDescriptor);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ejs.util.jar.EJBJar.loadDeploymentDescriptors", (String)"163", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("loadDeploymentDescriptors: Cannot instantiate deployment descriptor: " + string), (Object)classNotFoundException);
                }
                throw classNotFoundException;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ejs.util.jar.EJBJar.loadDeploymentDescriptors", (String)"169", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("loadDeploymentDescriptors: Cannot instantiate deployment descriptor: " + string), (Object)iOException);
                }
                throw iOException;
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadDeploymentDescriptors(Enumeration)");
        }
    }

    private void loadManifest() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadManifest");
        }
        InputStream inputStream = null;
        try {
            ZipEntry zipEntry = this.getEntry(MANIFEST_FILE_NAME);
            if (zipEntry == null) {
                zipEntry = this.getEntry("/META-INF/MANIFEST.MF");
            }
            if (zipEntry == null) {
                throw new EOFException("No manifest found in " + this.fileName);
            }
            inputStream = this.getInputStream(zipEntry);
            this.manifest = new Manifest(inputStream, (int)zipEntry.getSize());
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ejs.util.jar.EJBJar.loadManifest", (String)"221", (Object)this);
            Tr.uncondEvent((TraceComponent)tc, (String)"Cannot load a manifest file: {0} {1}", (Object)new Object[]{this.fileName, iOException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"loadManifest");
            }
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadManifest");
        }
    }

    private String getPackageName(String string) {
        String string2 = string.substring(0, string.lastIndexOf(46) + 1);
        return string2;
    }

    private String getEJSClassName(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        return string2;
    }

    public PortableDeploymentDescriptor getDescriptorForHome(String string) {
        return (PortableDeploymentDescriptor)this.descriptorsByHomeName.get(string);
    }

    public String toString() {
        return "EJBJar[" + this.fileName + "]";
    }

    public Enumeration getBeanHomeNames() {
        return this.descriptorsByHomeName.keys();
    }

    public Enumeration getDeploymentDescriptors() {
        return this.orderedDescriptors.elements();
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

