/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.jar;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.jar.ClasspathElement;
import com.ibm.ejs.util.jar.EJBDir;
import com.ibm.ejs.util.jar.EJBJar;
import com.ibm.ejs.util.jar.EJBZip;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JarClassLoader
extends ClassLoader {
    private Hashtable errorTrackingTable = null;
    private boolean errorTrackingEnabled = false;
    private Vector elems = new Vector();
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$util$jar$JarClassLoader == null ? (class$com$ibm$ejs$util$jar$JarClassLoader = JarClassLoader.class$("com.ibm.ejs.util.jar.JarClassLoader")) : class$com$ibm$ejs$util$jar$JarClassLoader));
    static /* synthetic */ Class class$com$ibm$ejs$util$jar$JarClassLoader;

    public void addZip(EJBZip eJBZip) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addZip", (Object)eJBZip);
        }
        this.addCPElement(eJBZip);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addZip");
        }
    }

    public void addJar(EJBJar eJBJar) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addJar", (Object)eJBJar);
        }
        this.addCPElement(eJBJar);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addJar");
        }
    }

    public void addDir(EJBDir eJBDir) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addDir", (Object)eJBDir);
        }
        this.addCPElement(eJBDir);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addDir");
        }
    }

    void addCPElement(ClasspathElement classpathElement) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addCPElement", (Object)classpathElement);
        }
        this.elems.addElement(classpathElement);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addCPElement");
        }
    }

    void removeCPElement(ClasspathElement classpathElement) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeCPElement", (Object)classpathElement);
        }
        this.elems.removeElement(classpathElement);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeCPElement");
        }
    }

    void removeAllCPElement() {
        Enumeration enumeration = this.elems.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof EJBJar) {
                try {
                    ((EJBJar)e).close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.util.jar.JarClassLoader.removeAllCPElement", (String)"71", (Object)this);
                }
                continue;
            }
            if (!(e instanceof EJBZip)) continue;
            try {
                ((EJBZip)e).close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.util.jar.JarClassLoader.removeAllCPElement", (String)"77", (Object)this);
            }
        }
        this.elems.removeAllElements();
    }

    ClasspathElement isClasspathElementPresent(String string) {
        for (int i = 0; i < this.elems.size(); ++i) {
            String string2 = ((ClasspathElement)this.elems.elementAt(i)).getName();
            if (string2.compareTo(string) != 0) continue;
            return (ClasspathElement)this.elems.elementAt(i);
        }
        return null;
    }

    protected synchronized Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findClass", (Object)new Object[]{string});
        }
        if ((clazz = this.findLoadedClass(string)) == null) {
            Object object;
            byte[] byArray = null;
            boolean bl = false;
            for (int i = 0; i < this.elems.size() && !bl; ++i) {
                try {
                    object = (ClasspathElement)this.elems.elementAt(i);
                    Tr.event((TraceComponent)tc, (String)"Looking in: ", (Object)object);
                    byArray = object.getClassBytes(string);
                    bl = byArray != null;
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.util.jar.JarClassLoader.findClass", (String)"116", (Object)this);
                }
            }
            if (byArray != null) {
                try {
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.util.jar.JarClassLoader.findClass", (String)"125", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findClass: Could not load class:", (Object)exception);
                    }
                    if (this.errorTrackingEnabled) {
                        object = Integer.toHexString(Thread.currentThread().hashCode());
                        this.errorTrackingTable.put(object, string);
                    }
                    throw new ClassNotFoundException("Could not load class : " + string + " : " + exception.toString());
                }
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findClass: Class not found");
                }
                if (this.errorTrackingEnabled) {
                    String string2 = Integer.toHexString(Thread.currentThread().hashCode());
                    this.errorTrackingTable.put(string2, string);
                }
                throw new ClassNotFoundException(string + " not found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findClass");
        }
        return clazz;
    }

    public URL getResource(String string) {
        URL uRL;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResource", (Object)string);
        }
        if ((uRL = JarClassLoader.getSystemResource(string)) == null) {
            boolean bl = false;
            for (int i = 0; i < this.elems.size() && !bl; ++i) {
                try {
                    ClasspathElement classpathElement = (ClasspathElement)this.elems.elementAt(i);
                    uRL = classpathElement.getResource(string);
                    bl = true;
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.util.jar.JarClassLoader.getResource", (String)"168", (Object)this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResource", (Object)uRL);
        }
        if (uRL == null && this.errorTrackingEnabled) {
            String string2 = Integer.toHexString(Thread.currentThread().hashCode());
            this.errorTrackingTable.put(string2, string);
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResourceAsStream", (Object)string);
        }
        if ((inputStream = JarClassLoader.getSystemResourceAsStream(string)) == null) {
            boolean bl = false;
            for (int i = 0; i < this.elems.size() && !bl; ++i) {
                try {
                    ClasspathElement classpathElement = (ClasspathElement)this.elems.elementAt(i);
                    inputStream = classpathElement.getResourceStream(string);
                    if (inputStream == null) continue;
                    bl = true;
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.util.jar.JarClassLoader.getResourceAsStream", (String)"204", (Object)this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResourceAsStream", (Object)inputStream);
        }
        if (inputStream == null && this.errorTrackingEnabled) {
            String string2 = Integer.toHexString(Thread.currentThread().hashCode());
            this.errorTrackingTable.put(string2, string);
        }
        return inputStream;
    }

    public void enabledErrorTracking() {
        this.errorTrackingEnabled = true;
        this.errorTrackingTable = new Hashtable(10);
    }

    public String getError() {
        if (!this.errorTrackingEnabled) {
            return null;
        }
        String string = Integer.toHexString(Thread.currentThread().hashCode());
        return (String)this.errorTrackingTable.get(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

