/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.opool;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.opool.DiscardStrategy;
import com.ibm.ejs.util.opool.PoolManager;
import com.ibm.websphere.pmi.PmiBean;

public class Pool {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$util$opool$Pool == null ? (class$com$ibm$ejs$util$opool$Pool = Pool.class$("com.ibm.ejs.util.opool.Pool")) : class$com$ibm$ejs$util$opool$Pool), (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    int minimum;
    int maximum;
    private Object[] elements;
    private int topOfPool;
    boolean inactive;
    DiscardStrategy discardStrategy;
    PoolManager poolMgr;
    private int maxDrainAmount;
    private PmiBean beanPerf = null;
    static /* synthetic */ Class class$com$ibm$ejs$util$opool$Pool;

    Pool(int n, int n2, DiscardStrategy discardStrategy, PoolManager poolManager, PmiBean pmiBean) {
        this.minimum = n;
        this.maximum = n2;
        this.elements = new Object[n2];
        this.topOfPool = 0;
        this.inactive = false;
        this.discardStrategy = discardStrategy;
        this.poolMgr = poolManager;
        this.beanPerf = pmiBean;
        int n3 = n2 - n;
        this.maxDrainAmount = n3 <= 0 ? 0 : (n3 <= 5 ? n3 : n3 / 5);
        if (pmiBean != null) {
            pmiBean.poolCreated(this.topOfPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get() {
        this.inactive = false;
        Object[] objectArray = this.elements;
        synchronized (this.elements) {
            Object object;
            if (this.topOfPool > 0) {
                --this.topOfPool;
                object = this.elements[this.topOfPool];
                this.elements[this.topOfPool] = null;
            } else {
                object = null;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (this.beanPerf != null) {
                this.beanPerf.objectRetrieve(this.topOfPool, object != null);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) {
        boolean bl = false;
        Object[] objectArray = this.elements;
        synchronized (this.elements) {
            if (this.topOfPool < this.maximum) {
                this.elements[this.topOfPool] = object;
                ++this.topOfPool;
            } else {
                bl = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (bl) {
                this.discardStrategy.discard(object);
            }
            if (this.beanPerf != null) {
                this.beanPerf.objectReturn(this.topOfPool, bl);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void drain() {
        int n = 0;
        Object object = null;
        while (this.inactive && this.topOfPool > this.minimum && n < this.maxDrainAmount) {
            object = null;
            Object[] objectArray = this.elements;
            // MONITORENTER : this.elements
            int n2 = this.topOfPool--;
            if (n2 > 0 && n2 > this.minimum) {
                object = this.elements[this.topOfPool];
                this.elements[this.topOfPool] = null;
                ++n;
            }
            // MONITOREXIT : objectArray
            if (object == null) continue;
            this.discardStrategy.discard(object);
        }
        if (this.beanPerf == null) return;
        this.beanPerf.poolDrained(this.topOfPool, n);
    }

    public void destroy() {
        this.poolMgr.remove(this);
        this.minimum = 0;
        this.maxDrainAmount = this.maximum;
        this.inactive = true;
        this.drain();
    }

    public void discard() {
        this.poolMgr.remove(this);
        this.minimum = 0;
        this.maximum = 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

