/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.mbean;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.StreamEvent;
import com.ibm.ejs.ras.TraceEvent;
import com.ibm.ejs.ras.TraceEventListener;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;

public class RasLoggingServiceMBean
extends RuntimeCollaborator
implements TraceEventListener {
    public static final String NOTIFICATION_LOG_FATAL = "websphere.ras.fatal";
    public static final String NOTIFICATION_LOG_ERROR = "websphere.ras.error";
    public static final String NOTIFICATION_LOG_WARNING = "websphere.ras.warning";
    public static final String NOTIFICATION_LOG_AUDIT = "websphere.ras.audit";
    public static final String NOTIFICATION_LOG_SERVICE = "websphere.ras.service";
    public static final String NOTIFICATION_LOG_INFO = "websphere.ras.info";
    private long ntfySeqNum = 0L;
    private static boolean registered = false;

    public void setObjectName(ObjectName objectName) {
        super.setObjectName(objectName);
        RasLoggingServiceMBean.registerWithRas(this);
    }

    public String getMessageFilterLevel() {
        return ManagerAdmin.getMessageFilterLevel();
    }

    public void setMessageFilterLevel(String string) {
        ManagerAdmin.setMessageFilterLevel((String)string);
    }

    public void auditEvent(MessageEvent messageEvent) {
        this.sendEvent(NOTIFICATION_LOG_AUDIT, messageEvent);
    }

    public void debugEvent(TraceEvent traceEvent) {
    }

    public void dumpEvent(TraceEvent traceEvent) {
    }

    public void errorEvent(MessageEvent messageEvent) {
        this.sendEvent(NOTIFICATION_LOG_ERROR, messageEvent);
    }

    public void eventEvent(TraceEvent traceEvent) {
    }

    public void entryEvent(TraceEvent traceEvent) {
    }

    public void exitEvent(TraceEvent traceEvent) {
    }

    public void fatalEvent(MessageEvent messageEvent) {
        this.sendEvent(NOTIFICATION_LOG_FATAL, messageEvent);
    }

    public void infoEvent(MessageEvent messageEvent) {
        this.sendEvent(NOTIFICATION_LOG_INFO, messageEvent);
    }

    public void serviceEvent(MessageEvent messageEvent) {
        this.sendEvent(NOTIFICATION_LOG_SERVICE, messageEvent);
    }

    public void systemOutEvent(StreamEvent streamEvent) {
    }

    public void systemErrEvent(StreamEvent streamEvent) {
    }

    public void uncondTraceEvent(TraceEvent traceEvent) {
    }

    public void warningEvent(MessageEvent messageEvent) {
        this.sendEvent(NOTIFICATION_LOG_WARNING, messageEvent);
    }

    private static synchronized void registerWithRas(RasLoggingServiceMBean rasLoggingServiceMBean) {
        if (registered) {
            return;
        }
        try {
            ManagerAdmin.addJmxListener((TraceEventListener)rasLoggingServiceMBean);
            registered = true;
        }
        catch (RasException rasException) {
            FFDCFilter.processException((Throwable)rasException, (String)"com.ibm.ws.management.RasLoggingServiceMBean.registerWithRas", (String)"193", (Object)((Object)rasLoggingServiceMBean));
        }
    }

    private void sendEvent(String string, MessageEvent messageEvent) {
        try {
            Notification notification = new Notification(string, this.getObjectName(), this.ntfySeqNum++);
            notification.setUserData(messageEvent);
            this.sendNotification(notification);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.RasLoggingServiceMBean.sendEvent", (String)"203", (Object)((Object)this));
        }
    }
}

