/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityL13SupportImpl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public class SecurityLogger {
    private static ORB orb = null;
    private static String serverID;
    private static String serverName;
    private static String filterString;
    private static TraceComponent tc;
    public static boolean debugTraceEnabled;
    public static boolean debugEntryEnabled;
    public static boolean traceByteArrays;
    public static boolean traceEnabled;
    private static StringBuffer msgBuffer;
    private static final long Security = 0x4000000L;
    private static final long Normal = 1L;
    private static final long Harmless = 2L;
    private static final long Warning = 4L;
    private static final long Minor = 8L;
    private static final long Critical = 16L;
    private static final long Fatal = 32L;
    private static final long FatalException = 4L;
    private static final long CriticalException = 8L;
    private static final long OtherException = 16L;

    public SecurityLogger(ORB oRB) {
        serverID = new Integer(oRB.getServerId()).toString();
        serverName = oRB.getProperty("com.ibm.CORBA.ServerName");
        if (serverName != null && !serverName.equals("")) {
            serverID = serverName;
        }
        orb = oRB;
        filterString = oRB.getProperty("com.ibm.CORBA.securityTraceFilter");
        if (filterString == null) {
            filterString = "";
        }
    }

    public static synchronized boolean debugMessage(String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(500);
        if (tc.isDebugEnabled() && SecurityLogger.filter(string)) {
            String[] stringArray = SecurityLogger.toHexAsciiFormat(byArray);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]).append(System.getProperty("line.separator")).append("        ");
            }
            SecurityLogger.debug(string, stringBuffer.toString());
        }
        return true;
    }

    public static synchronized boolean debugMessage(String string, String string2) {
        if (tc.isDebugEnabled() && SecurityLogger.filter(string)) {
            SecurityLogger.debug(string, string2);
        }
        if (debugTraceEnabled != tc.isDebugEnabled()) {
            SecurityLogger.reInitGuards();
        }
        return true;
    }

    public static synchronized void debugEntry(String string) {
        if (tc.isEntryEnabled() && SecurityLogger.filter(string)) {
            SecurityLogger.entry(string);
        }
    }

    public static synchronized void debugEntry(String string, Object[] objectArray) {
        if (tc.isEntryEnabled() && SecurityLogger.filter(string)) {
            SecurityLogger.entry(string, objectArray);
        }
    }

    public static synchronized void debugExit(String string) {
        if (tc.isEntryEnabled() && SecurityLogger.filter(string)) {
            SecurityLogger.exit(string);
        }
    }

    public static synchronized boolean logActivity(String string, int n, String string2) {
        if (tc.isDebugEnabled() && SecurityLogger.filter(string)) {
            SecurityLogger.audit(string, string2);
        }
        return true;
    }

    public static synchronized void logError(String string, String string2) {
        Tr.error((TraceComponent)tc, (String)string2);
    }

    public static synchronized void logError(String string, Object[] objectArray) {
        Tr.error((TraceComponent)tc, (String)string, (Object)objectArray);
    }

    public static synchronized void logWarning(String string, Object[] objectArray) {
        Tr.warning((TraceComponent)tc, (String)string, (Object)objectArray);
    }

    public static synchronized void logWarning(String string, String string2) {
        Tr.warning((TraceComponent)tc, (String)"security.JSAS0000E", (Object)new Object[]{string2, System.getProperty("line.separator")});
    }

    public static synchronized void logAudit(String string, String string2) {
        Tr.audit((TraceComponent)tc, (String)string2);
    }

    public static synchronized boolean logError(String string, String string2, int n) {
        Tr.error((TraceComponent)tc, (String)"security.JSAS0000E", (Object)new Object[]{string2, System.getProperty("line.separator")});
        return true;
    }

    public static synchronized boolean logException(String string, Exception exception, int n, int n2) {
        SecurityLogger.exception(string, exception);
        return true;
    }

    public static synchronized boolean traceException(String string, Exception exception, int n, int n2) {
        SecurityLogger.exception(string, exception);
        return true;
    }

    public static synchronized boolean traceException(String string, Throwable throwable, int n, int n2) {
        SecurityLogger.exception(string, throwable);
        return true;
    }

    public static synchronized boolean traceMessage(String string, String string2) {
        if (tc.isDebugEnabled() && SecurityLogger.filter(string)) {
            SecurityLogger.debug(string, string2);
        }
        return true;
    }

    private static void debug(String string, String string2) {
        msgBuffer.delete(0, msgBuffer.length());
        msgBuffer.append("[").append(string).append("], [ServerID: ").append(serverID).append("]").append(System.getProperty("line.separator")).append("        ").append(string2).append(System.getProperty("line.separator"));
        Tr.debug((TraceComponent)tc, (String)msgBuffer.toString());
    }

    private static void entry(String string) {
        msgBuffer.delete(0, msgBuffer.length());
        msgBuffer.append("[").append(string).append("], [ServerID: ").append(serverID).append("]").append(System.getProperty("line.separator"));
        Tr.entry((TraceComponent)tc, (String)msgBuffer.toString());
    }

    private static void entry(String string, Object[] objectArray) {
        msgBuffer.delete(0, msgBuffer.length());
        msgBuffer.append("[").append(string).append("], [ServerID: ").append(serverID).append("]").append(System.getProperty("line.separator"));
        Tr.entry((TraceComponent)tc, (String)msgBuffer.toString(), (Object)objectArray);
    }

    private static void exit(String string) {
        msgBuffer.delete(0, msgBuffer.length());
        msgBuffer.append("[").append(string).append("], [ServerID: ").append(serverID).append("]").append(System.getProperty("line.separator"));
        Tr.exit((TraceComponent)tc, (String)msgBuffer.toString());
    }

    private static void exception(String string, Throwable throwable) {
        msgBuffer.delete(0, msgBuffer.length());
        msgBuffer.append("[").append(string).append("], [ServerID: ").append(serverID).append("]").append(System.getProperty("line.separator"));
        Tr.debug((TraceComponent)tc, (String)msgBuffer.toString(), (Object)throwable);
    }

    private static void audit(String string, String string2) {
        msgBuffer.delete(0, msgBuffer.length());
        msgBuffer.append("[").append(string).append("], [ServerID: ").append(serverID).append("]").append(System.getProperty("line.separator")).append("        ").append(string2).append(System.getProperty("line.separator"));
        Tr.debug((TraceComponent)tc, (String)msgBuffer.toString());
    }

    private static String clean(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.startsWith("\"") && string2.endsWith("\"") || string2.startsWith("'") && string2.endsWith("'")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    public static String[] toHexAsciiFormat(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = (byArray.length - 1) / 16 + 1;
        String[] stringArray = new String[n];
        String string = null;
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            int n2;
            string = new String("0000" + Integer.toHexString(i * 16));
            string2 = string.substring(string.length() - 4) + ": ";
            for (n2 = 0; n2 < 16; ++n2) {
                if (i * 16 + n2 < byArray.length) {
                    string = new String("00" + Integer.toHexString(byArray[i * 16 + n2]));
                    string2 = string2 + string.substring(string.length() - 2) + " ";
                    continue;
                }
                string2 = string2 + "   ";
            }
            string2 = string2 + "  [";
            for (n2 = 0; n2 < 16; ++n2) {
                if (i * 16 + n2 < byArray.length) {
                    if (Character.isISOControl((char)byArray[i * 16 + n2])) {
                        string2 = string2 + ".";
                        continue;
                    }
                    string2 = string2 + (char)byArray[i * 16 + n2];
                    continue;
                }
                string2 = string2 + " ";
            }
            stringArray[i] = string2 = string2 + "]";
        }
        return stringArray;
    }

    private static String getMethodName(String string) {
        int n = string.lastIndexOf(".");
        return string.substring(n + 1);
    }

    private static boolean filter(String string) {
        if (filterString.equals("")) {
            return true;
        }
        if (string != null) {
            int n = string.lastIndexOf(".");
            String string2 = string.substring(0, n);
            return string2 != null && filterString.indexOf(string2) != -1;
        }
        return false;
    }

    private static void reInitGuards() {
        debugTraceEnabled = tc.isDebugEnabled();
        debugEntryEnabled = tc.isEntryEnabled();
        traceByteArrays = tc.isDebugEnabled();
        traceEnabled = tc.isDebugEnabled();
    }

    static {
        filterString = "";
        tc = Tr.register((String)"SASRas", null, (String)"com.ibm.ISecurityL13SupportImpl.sec");
        debugTraceEnabled = tc.isDebugEnabled();
        debugEntryEnabled = tc.isEntryEnabled();
        traceByteArrays = tc.isDebugEnabled();
        traceEnabled = tc.isDebugEnabled();
        msgBuffer = new StringBuffer(500);
    }
}

