/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.IExtendedSecurity.InvalidAdditionalCriteria;
import com.ibm.IExtendedSecurity.MechanismTypeNotRegistered;
import com.ibm.IExtendedSecurity.PrincipalSecurityInfo;
import com.ibm.IExtendedSecurity.RealmNotRegistered;
import com.ibm.IExtendedSecurity.UnknownMapping;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityUIDGenerator;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsPackage.CredentialsNotSet;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.AuthenticationTarget;
import com.ibm.ISecurityUtilityImpl.CredentialsHelper;
import com.ibm.ISecurityUtilityImpl.KeyFile;
import com.ibm.ISecurityUtilityImpl.KeyFileEntry;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SecurityAttributeList;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.security.auth.AuthPermission;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.Security.Attribute;
import org.omg.Security.AttributeType;
import org.omg.Security.AuthenticationStatus;
import org.omg.Security.CommunicationDirection;
import org.omg.Security.DuplicateAttributeType;
import org.omg.Security.DuplicateSecurityFeature;
import org.omg.Security.ExtensibleFamily;
import org.omg.Security.InvalidAttributeType;
import org.omg.Security.InvalidAttributeTypeReason;
import org.omg.Security.InvalidCommDirection;
import org.omg.Security.InvalidEnumTypeReason;
import org.omg.Security.InvalidSecurityFeature;
import org.omg.Security.OpaqueHolder;
import org.omg.Security.SecurityFeature;
import org.omg.Security.SecurityFeatureValue;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.CredentialsHolder;
import org.omg.SecurityLevel2.InvalidCredential;
import org.omg.SecurityLevel2.LoginFailed;

public abstract class CredentialsImpl
extends com.ibm.IExtendedSecurityImpl.CredentialsImpl
implements Runnable {
    protected static final short ibm_family_definer = 8;
    protected static final short ibm_family = 2;
    protected static final short omg_family_definer = 0;
    protected static final short omg_family = 1;
    protected static final int omg_attribute_count = 5;
    protected static final int ibm_attribute_count = 1;
    protected static final int max_attribute_count = 6;
    protected static final int max_feature_count = 10;
    protected static final IntHolder expiry_time_now = new IntHolder(0);
    protected boolean _isForwardable = true;
    protected String _Oid = null;
    protected String _Public = null;
    protected String _UniqueSecurityName = null;
    protected String _AccessId = null;
    protected String _PrimaryGroupId = null;
    protected String[] _GroupIds = null;
    protected String[] _Roles = null;
    protected String _HostName = null;
    protected byte[] _CredentialToken = null;
    protected String _IdentityType = null;
    protected byte[] _IdentityValue = null;
    protected long _expiration = 1L;
    protected long _cache_expiration = 1L;
    protected boolean _credsExpired = false;
    protected boolean _credsInvalid = false;
    protected boolean _credsRejected = false;
    protected boolean _credsUnauthenticated = false;
    protected boolean _credsIsDummy = false;
    protected boolean _credsIsServer = false;
    protected String _uniqueID = null;
    protected java.lang.Object _object = null;
    protected CredentialsImpl _mappedCreds = null;
    protected int _mappedCredType = 0;
    protected String _mappedCredTypeString = "unknown";
    protected String _mappedCredRealmString = "";
    protected int _authTargetType = 0;
    protected String _authTargetTypeString = "unknown";
    protected String _authTargetRealmString = "";
    protected static int _configAuthTargetType = 0;
    protected static String _configAuthTargetTypeString = "unknown";
    protected static boolean _atSecurityEnabled = false;
    protected static boolean _baSecurityEnabled = false;
    protected static boolean[] _securityEnabled = new boolean[]{false};
    protected static boolean[] _refreshServerCred = new boolean[]{false};
    protected VaultImpl _vault = null;
    protected ORB _orb = null;
    protected SecurityConfiguration _config = null;
    protected CurrentImpl _current = null;
    protected Hashtable _table = new Hashtable(32);
    protected WSCredential _wsCred = null;
    private static final AuthPermission APP_UPDATE_PERMISSION = new AuthPermission("wssecurity.applicationUpdateCredential");

    protected CredentialsImpl() {
    }

    protected CredentialsImpl(VaultImpl vaultImpl) {
        if (vaultImpl == null) {
            String string = "CredentialsImpl.constructor(vault)";
            String string2 = "security.JSAS0010E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            this.invalidate();
            return;
        }
        this._vault = vaultImpl;
        this._orb = this._vault.getORB();
        CredentialsImpl credentialsImpl = this;
        this._config = credentialsImpl._vault.getSecurityConfiguration();
        this._current = this.current();
        long l = this._config.getrequestCredsExpiration();
        this._cache_expiration = System.currentTimeMillis() + this._config.getsecurityCacheTimeout() * 1000L;
        this._expiration = l == 0L ? 0L : new Date().getTime() + l;
        if (_configAuthTargetType == 0) {
            _configAuthTargetType = this._config.getauthenticationTarget();
            _configAuthTargetTypeString = (String)AuthenticationTarget.strings.get(new Integer(_configAuthTargetType));
        }
    }

    public Credentials copy() {
        throw new NO_IMPLEMENT();
    }

    protected Credentials copy(CredentialsImpl credentialsImpl) {
        String string = "CredentialsImpl.copy";
        String string2 = null;
        if (this._credsUnauthenticated && SecurityLogger.debugTraceEnabled) {
            string2 = "Copying unauthenticated credentials.";
            SecurityLogger.debugMessage(string, string2);
        }
        if (this._credsInvalid) {
            string2 = "security.JSAS0435E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            credentialsImpl.invalidate();
            return credentialsImpl;
        }
        credentialsImpl._isForwardable = this._isForwardable;
        credentialsImpl._Oid = this._Oid;
        credentialsImpl._Public = this._Public;
        credentialsImpl._UniqueSecurityName = this._UniqueSecurityName;
        credentialsImpl._AccessId = this._AccessId;
        credentialsImpl._PrimaryGroupId = this._PrimaryGroupId;
        credentialsImpl._GroupIds = this._GroupIds;
        credentialsImpl._Roles = this._Roles;
        credentialsImpl._HostName = this._HostName;
        credentialsImpl._CredentialToken = this._CredentialToken;
        credentialsImpl._expiration = this._expiration;
        credentialsImpl._credsExpired = this._credsExpired;
        credentialsImpl._credsInvalid = this._credsInvalid;
        credentialsImpl._credsRejected = this._credsRejected;
        credentialsImpl._credsUnauthenticated = this._credsUnauthenticated;
        credentialsImpl._credsIsDummy = this._credsIsDummy;
        credentialsImpl._credsIsServer = this._credsIsServer;
        credentialsImpl._uniqueID = this._uniqueID;
        credentialsImpl._mappedCreds = this._mappedCreds;
        credentialsImpl._mappedCredType = this._mappedCredType;
        credentialsImpl._mappedCredTypeString = this._mappedCredTypeString;
        credentialsImpl._mappedCredRealmString = this._mappedCredRealmString;
        credentialsImpl._authTargetType = this._authTargetType;
        credentialsImpl._authTargetTypeString = this._authTargetTypeString;
        credentialsImpl._authTargetRealmString = this._authTargetRealmString;
        credentialsImpl._IdentityType = this._IdentityType;
        credentialsImpl._IdentityValue = this._IdentityValue;
        return credentialsImpl;
    }

    public Credentials copyUnique() {
        CredentialsImpl credentialsImpl = (CredentialsImpl)this.copy();
        return credentialsImpl;
    }

    protected CurrentImpl current() {
        return this._vault.getCurrent();
    }

    public void destroy() {
        String string = "CredentialsImpl.destroy";
        String string2 = null;
        this.invalidate();
        CurrentImpl currentImpl = this._vault.getCurrent();
        try {
            this._vault.delete_default_credentials((Credentials)this);
            this._vault.deleteEstablishedCredentials((Credentials)this);
            if (currentImpl != null) {
                currentImpl.removeCredFromThreadTable((Credentials)this);
            }
        }
        catch (InvalidCredential invalidCredential) {
            FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.destroy", (String)"547", (java.lang.Object)this);
            string2 = "security.JSAS0435E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string, invalidCredential});
        }
    }

    protected void enableSecurity(int n) {
        if (this._credsUnauthenticated) {
            if (SecurityLogger.debugTraceEnabled) {
                String string = "CredentialsImpl.enableSecurity";
                String string2 = "Cannot enable security with an unauthenticated cred.";
                SecurityLogger.debugMessage(string, string2);
            }
            return;
        }
        this._vault.enableSecurityForCredentials(n);
    }

    public Attribute[] get_attributes(AttributeType[] attributeTypeArray) throws InvalidAttributeType, DuplicateAttributeType {
        String string = "CredentialsImpl.get_attributes";
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        short s = -1;
        short s2 = -1;
        try {
            if (!this.is_valid(expiry_time_now)) {
                string2 = "security.JSAS0435E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                return null;
            }
        }
        catch (InvalidCredential invalidCredential) {
            FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.get_attributes", (String)"622", (java.lang.Object)this);
            string2 = "security.JSAS0435E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string, invalidCredential});
        }
        if (attributeTypeArray == null) {
            string2 = "security.JSAS0350E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            return null;
        }
        int n = attributeTypeArray.length;
        Attribute[] attributeArray = new Attribute[n];
        for (int i = 0; i < n; ++i) {
            if (attributeTypeArray[i] == null || attributeTypeArray[i].attribute_family == null) {
                string2 = "security.JSAS0350E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                throw new InvalidAttributeType(InvalidAttributeTypeReason.InvalidType, attributeTypeArray[i]);
            }
            if (attributeTypeArray[i].attribute_family.family_definer == 0 && attributeTypeArray[i].attribute_family.family == 1) {
                s = 0;
                s2 = 1;
            } else if (attributeTypeArray[i].attribute_family.family_definer == 8 && attributeTypeArray[i].attribute_family.family == 2) {
                s = 8;
                s2 = 2;
            } else {
                string2 = "security.JSAS0350E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                throw new InvalidAttributeType(InvalidAttributeTypeReason.InvalidType, attributeTypeArray[i]);
            }
            attributeArray[i] = new Attribute();
            attributeArray[i].attribute_type = new AttributeType();
            attributeArray[i].attribute_type.attribute_family = new ExtensibleFamily(s, s2);
            if (s == 0) {
                switch (attributeTypeArray[i].attribute_type) {
                    case 1: {
                        if (bl) {
                            bl7 = true;
                            break;
                        }
                        bl = true;
                        attributeArray[i].attribute_type.attribute_type = 1;
                        attributeArray[i].value = StringBytesConversion.getConvertedBytes(this._Public);
                        break;
                    }
                    case 2: {
                        if (bl2) {
                            bl7 = true;
                            break;
                        }
                        bl2 = true;
                        attributeArray[i].attribute_type.attribute_type = 2;
                        attributeArray[i].value = StringBytesConversion.getConvertedBytes(this._AccessId);
                        break;
                    }
                    case 3: {
                        if (bl3) {
                            bl7 = true;
                            break;
                        }
                        bl3 = true;
                        attributeArray[i].attribute_type.attribute_type = 3;
                        attributeArray[i].value = StringBytesConversion.getConvertedBytes(this._PrimaryGroupId);
                        break;
                    }
                    case 4: {
                        if (bl4) {
                            bl7 = true;
                            break;
                        }
                        bl4 = true;
                        attributeArray[i].attribute_type.attribute_type = 4;
                        attributeArray[i].value = SecurityAttributeList.getAttributeByteArray(this._GroupIds);
                        break;
                    }
                    case 5: {
                        if (bl5) {
                            bl7 = true;
                            break;
                        }
                        bl5 = true;
                        attributeArray[i].attribute_type.attribute_type = 5;
                        attributeArray[i].value = SecurityAttributeList.getAttributeByteArray(this._Roles);
                        break;
                    }
                    default: {
                        bl8 = true;
                        break;
                    }
                }
            } else {
                switch (attributeTypeArray[i].attribute_type) {
                    case 2: {
                        if (bl6) {
                            bl7 = true;
                            break;
                        }
                        bl6 = true;
                        attributeArray[i].attribute_type.attribute_type = 2;
                        attributeArray[i].value = StringBytesConversion.getConvertedBytes(this._HostName);
                        break;
                    }
                    default: {
                        bl8 = true;
                    }
                }
            }
            if (bl8) {
                string2 = "security.JSAS0350E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                throw new InvalidAttributeType(InvalidAttributeTypeReason.InvalidType, attributeTypeArray[i]);
            }
            if (!bl7) continue;
            string2 = "security.JSAS0350E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            throw new DuplicateAttributeType(attributeTypeArray[i]);
        }
        return attributeArray;
    }

    public void get_credential_token(StringHolder stringHolder, OpaqueHolder opaqueHolder) throws CredentialsNotSet {
        throw new NO_IMPLEMENT();
    }

    protected void get_credential_token(StringHolder stringHolder, OpaqueHolder opaqueHolder, CredentialsNotSet credentialsNotSet) throws CredentialsNotSet {
        String string = "CredentialsImpl.get_credential_token";
        String string2 = null;
        if (this._credsUnauthenticated) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Credentials are unauthenticated. No token is available.";
                SecurityLogger.debugMessage(string, string2);
            }
            stringHolder.value = this._Public;
            opaqueHolder.value = this._CredentialToken;
            return;
        }
        try {
            if (!this.is_valid(expiry_time_now)) {
                string2 = "security.JSAS0435E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                stringHolder.value = null;
                opaqueHolder.value = null;
                throw credentialsNotSet;
            }
        }
        catch (InvalidCredential invalidCredential) {
            FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.get_credential_token", (String)"849", (java.lang.Object)this);
            string2 = "security.JSAS0435E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
        }
        stringHolder.value = this._Public;
        opaqueHolder.value = this._CredentialToken;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public void setExpiration(long l) {
        this._expiration = l;
    }

    public WSCredential getWSCredential() {
        return this._wsCred;
    }

    public void setWSCredential(WSCredential wSCredential) {
        this._wsCred = wSCredential;
    }

    public Credentials get_mapped_credentials(String string, String string2, Any any) throws MechanismTypeNotRegistered, RealmNotRegistered, InvalidAdditionalCriteria, UnknownMapping {
        throw new NO_IMPLEMENT();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Credentials get_mapped_credentials(String string, String string2, Any any, boolean bl, boolean bl2, boolean bl3) throws MechanismTypeNotRegistered, RealmNotRegistered, InvalidAdditionalCriteria, UnknownMapping {
        KeyFileEntry keyFileEntry;
        LoginHelperImpl loginHelperImpl;
        String string3 = "CredentialsImpl.get_mapped_credentials";
        String string4 = null;
        if (this._credsUnauthenticated) {
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "No mapped credentials are available for unauthenticated credentials.";
                SecurityLogger.debugMessage(string3, string4);
            }
            this._mappedCreds = null;
            return null;
        }
        try {
            if (!this.is_valid(expiry_time_now)) {
                string4 = "security.JSAS0435E";
                SecurityLogger.logError(string4, new java.lang.Object[]{string3});
                this._mappedCreds = null;
                return null;
            }
        }
        catch (InvalidCredential invalidCredential) {
            FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.get_mapped_credentials", (String)"930", (java.lang.Object)this);
            string4 = "security.JSAS0435E";
            SecurityLogger.logError(string4, new java.lang.Object[]{string3, invalidCredential});
        }
        int n = 0;
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.length() == 0) {
            n = _configAuthTargetType;
            string = _configAuthTargetTypeString;
        } else if (string.equalsIgnoreCase("basicauth")) {
            n = 4;
            string = "basicauth";
        } else if (string.equalsIgnoreCase("localos")) {
            n = 2;
            string = "localos";
        } else if (string.equalsIgnoreCase("ltpa")) {
            n = 1;
            string = "ltpa";
        } else if (string.equalsIgnoreCase("custom")) {
            n = 8;
            string = "custom";
        } else if (string.equalsIgnoreCase("kerberos")) {
            n = 6;
            string = "kerberos";
        } else {
            if (!string.equalsIgnoreCase("unknown")) {
                string4 = "security.JSAS0473E";
                SecurityLogger.logError(string4, new java.lang.Object[]{string3});
                throw new MechanismTypeNotRegistered();
            }
            n = 0;
            string = "unknown";
        }
        if (SecurityLogger.debugTraceEnabled) {
            string4 = "Authentication type is " + string + ".";
            SecurityLogger.debugMessage(string3, string4);
        }
        String string5 = null;
        String string6 = null;
        String string7 = null;
        if (string2 == null) {
            string5 = this._authTargetRealmString;
            string6 = "";
            string7 = "NULL";
        } else if ((string2 = string2.trim()).length() == 0) {
            string5 = this._authTargetRealmString;
            string6 = "";
            string7 = "\"\"";
        } else {
            string5 = string2;
            string6 = string2;
            string7 = string2;
        }
        if (n == this._authTargetType && this.realmsMatch(string6, this._authTargetRealmString)) {
            if (!SecurityLogger.debugTraceEnabled) return this;
            string4 = "Realm and mechanism type match the request.";
            SecurityLogger.debugMessage(string3, string4);
            return this;
        }
        if (this._mappedCreds != null && n == this._mappedCredType && this.realmsMatch(string6, this._mappedCredRealmString)) {
            try {
                if (this._mappedCreds.is_valid(expiry_time_now)) {
                    if (!SecurityLogger.debugTraceEnabled) return this._mappedCreds;
                    string4 = "Returning mapped creds.";
                    SecurityLogger.debugMessage(string3, string4);
                    return this._mappedCreds;
                }
            }
            catch (InvalidCredential invalidCredential) {
                FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.get_mapped_credentials", (String)"1057", (java.lang.Object)this);
                string4 = "security.JSAS0435E";
                SecurityLogger.logError(string4, new java.lang.Object[]{string3, invalidCredential});
            }
            this._mappedCreds = null;
        }
        String string8 = RealmSecurityName.getSecurityName(this._Public);
        CredentialsImpl credentialsImpl = null;
        if (bl) {
            credentialsImpl = (CredentialsImpl)this._vault.getEstablishedCreds(string8, string5, string);
        }
        if (credentialsImpl != null) {
            try {
                if (credentialsImpl.is_valid(expiry_time_now)) {
                    this._mappedCreds = credentialsImpl;
                    this._mappedCredType = n;
                    this._mappedCredTypeString = string;
                    this._mappedCredRealmString = string5;
                    if (!SecurityLogger.debugTraceEnabled) return credentialsImpl;
                    string4 = "Returning mapped creds from established creds list.";
                    SecurityLogger.debugMessage(string3, string4);
                    return credentialsImpl;
                }
            }
            catch (InvalidCredential invalidCredential) {
                FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.get_mapped_credentials", (String)"1093", (java.lang.Object)this);
                string4 = "security.JSAS0435E";
                SecurityLogger.logError(string4, new java.lang.Object[]{string3, invalidCredential});
            }
        }
        if (SecurityLogger.debugTraceEnabled) {
            string4 = "Valid mapped credentials do not exist, attempting to form new " + string + " credentials for " + string7 + "/" + string8 + ".";
            SecurityLogger.debugMessage(string3, string4);
        }
        if ((loginHelperImpl = (LoginHelperImpl)this.current().login_helper()) == null) {
            string4 = "security.JSAS0020E";
            SecurityLogger.logError(string4, new java.lang.Object[]{string3});
            return null;
        }
        java.lang.Object var16_19 = null;
        OpaqueHolder opaqueHolder = null;
        int n2 = n;
        String string9 = null;
        boolean bl4 = false;
        if (any != null) {
            try {
                bl4 = any.extract_long() == -18;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.get_mapped_credentials", (String)"1137", (java.lang.Object)this);
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "Invalid additional criteria.";
                    SecurityLogger.debugMessage(string3, string4);
                }
                bl4 = false;
            }
        }
        if (bl4) {
            if (!this.isServer()) {
                if (!SecurityLogger.debugTraceEnabled) return null;
                string4 = "No multi-realm mapping will be performed for a client credential.";
                SecurityLogger.debugMessage(string3, string4);
                return null;
            }
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Using key file to map server credential for realm: " + string2;
                SecurityLogger.debugMessage(string3, string4);
            }
            try {
                if (this._config.getkeyFileName() != null && this._config.getkeyFileName().length() > 0) {
                    KeyFile keyFile = loginHelperImpl.getKeyFileObject();
                    keyFileEntry = keyFile.find(string2, string8);
                    if (keyFileEntry == null) {
                        string4 = "security.JSAS0480E";
                        SecurityLogger.logError(string4, new java.lang.Object[]{string3});
                        return null;
                    }
                } else {
                    string4 = "security.JSAS0480E";
                    SecurityLogger.logError(string4, new java.lang.Object[]{string3});
                    return null;
                }
                string8 = keyFileEntry.getUserid();
                string9 = keyFileEntry.getPassword();
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                FFDCFilter.processException((Throwable)bAD_OPERATION, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.get_mapped_credentials", (String)"1193", (java.lang.Object)this);
                string4 = "security.JSAS0480E";
                SecurityLogger.logError(string4, new java.lang.Object[]{string3, bAD_OPERATION});
                return null;
            }
        } else {
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "_authTargetType: " + this._authTargetType + ", mechanism_type: " + n;
                SecurityLogger.debugMessage(string3, string4);
            }
            if (this._authTargetType == 4) {
                string9 = StringBytesConversion.getConvertedString(this._CredentialToken);
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "Got password from credential: " + SecurityConfiguration.mask(string9);
                    SecurityLogger.debugMessage(string3, string4);
                }
            }
        }
        try {
            int n3 = 2;
            if (this._config.getProtocol().equals("ibm")) {
                n3 = 1;
            }
            keyFileEntry = this._vault.getMechanismFactory().getPrincipalAuthenticator(this._config.getauthenticationTarget(), n3);
            int n4 = 0;
            Attribute[] attributeArray = null;
            CredentialsHolder credentialsHolder = new CredentialsHolder();
            OpaqueHolder opaqueHolder2 = new OpaqueHolder();
            opaqueHolder = new OpaqueHolder();
            AuthenticationStatus authenticationStatus = null;
            try {
                authenticationStatus = keyFileEntry.authenticate(n4, string8, StringBytesConversion.getConvertedBytes(string9), attributeArray, credentialsHolder, opaqueHolder2, opaqueHolder);
            }
            catch (LoginFailed loginFailed) {
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "LoginFailed exception occurred in principal authenticator.";
                    SecurityLogger.debugMessage(string3, string4);
                    SecurityLogger.logException(string3, (Exception)((java.lang.Object)loginFailed), 0, 0);
                }
                FFDCFilter.processException((Throwable)loginFailed, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.get_mapped_credentials", (String)"1292", (java.lang.Object)this);
            }
            catch (Exception exception) {
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "Generic exception occurred in principal authenticator.";
                    SecurityLogger.debugMessage(string3, string4);
                    SecurityLogger.logException(string3, exception, 0, 0);
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.get_mapped_credentials", (String)"1297", (java.lang.Object)this);
            }
            if (authenticationStatus == AuthenticationStatus.SecAuthSuccess) {
                credentialsImpl = credentialsHolder.value;
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "Authentication success";
                    SecurityLogger.debugMessage(string3, string4);
                }
            } else {
                credentialsImpl = null;
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "Authentication Failed";
                    SecurityLogger.debugMessage(string3, string4);
                }
            }
            if (bl3 && var16_19.value != null) {
                try {
                    this._current.set_invocation_credentials(var16_19.value);
                }
                catch (InvalidCredential invalidCredential) {
                    FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.get_mapped_credentials", (String)"1276", (java.lang.Object)this);
                    string4 = "security.JSAS0054E";
                    SecurityLogger.logError(string4, new java.lang.Object[]{string3, invalidCredential});
                    credentialsImpl = null;
                }
            }
            if (bl2 && credentialsImpl != null && credentialsImpl instanceof com.ibm.ISecurityLocalObjectBasicAuthImpl.CredentialsImpl) {
                try {
                    this._vault.add_default_credentials((Credentials)credentialsImpl);
                }
                catch (InvalidCredential invalidCredential) {
                    FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.get_mapped_credentials", (String)"1293", (java.lang.Object)this);
                    if (SecurityLogger.debugTraceEnabled) {
                        string4 = "Error adding credentials to default credentials list. Reason: " + invalidCredential.toString();
                        SecurityLogger.debugMessage(string3, string4);
                        SecurityLogger.traceException(string3, (Exception)((java.lang.Object)invalidCredential), 0, 0);
                    }
                    credentialsImpl = null;
                }
            }
            if (credentialsImpl != null) {
                try {
                    this._vault.addEstablishedCredentials((Credentials)credentialsImpl);
                }
                catch (InvalidCredential invalidCredential) {
                    FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.get_mapped_credentials", (String)"1310", (java.lang.Object)this);
                    if (SecurityLogger.debugTraceEnabled) {
                        string4 = "Error adding credentials to established credentials list. Reason: " + invalidCredential.toString();
                        SecurityLogger.debugMessage(string3, string4);
                        SecurityLogger.traceException(string3, (Exception)((java.lang.Object)invalidCredential), 0, 0);
                    }
                    credentialsImpl = null;
                }
            }
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Login successful for user: " + string8 + ", Mechanism OID: " + credentialsImpl.getOID();
                SecurityLogger.debugMessage(string3, string4);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.get_mapped_credentials", (String)"1395", (java.lang.Object)this);
            string4 = "security.JSAS0240E";
            SecurityLogger.logError(string4, new java.lang.Object[]{string3, exception});
            credentialsImpl = null;
        }
        if (credentialsImpl != null) {
            this._mappedCreds = credentialsImpl;
            this._mappedCredType = this._mappedCreds._authTargetType;
            this._mappedCredTypeString = this._mappedCreds._authTargetTypeString;
            this._mappedCredRealmString = RealmSecurityName.getRealm(this._mappedCreds._Public);
            return credentialsImpl;
        }
        string4 = "security.JSAS0240E";
        SecurityLogger.logError(string4, new java.lang.Object[]{string3});
        return credentialsImpl;
    }

    public Credentials get_mapped_creds(String string, String string2, Any any, boolean bl, boolean bl2, boolean bl3) throws LoginFailed, MechanismTypeNotRegistered, RealmNotRegistered, InvalidAdditionalCriteria, UnknownMapping {
        Credentials credentials = this.get_mapped_credentials(string, string2, any, bl, bl2, bl3);
        if (credentials == null) {
            throw new LoginFailed();
        }
        return credentials;
    }

    public PrincipalSecurityInfo get_mapped_security_info(String string, String string2, Any any) throws MechanismTypeNotRegistered, RealmNotRegistered, InvalidAdditionalCriteria {
        throw new NO_IMPLEMENT();
    }

    public SecurityFeatureValue[] get_security_features(CommunicationDirection communicationDirection) throws InvalidCommDirection {
        String string = "CredentialsImpl.get_security_features";
        String string2 = null;
        if (this._credsUnauthenticated) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "No security features defined for unauthenticated credentials.";
                SecurityLogger.debugMessage(string, string2);
            }
            return null;
        }
        if (communicationDirection.value() != 0) {
            string2 = "security.JSAS0340E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            throw new InvalidCommDirection(InvalidEnumTypeReason.NotSupported, communicationDirection);
        }
        try {
            if (!this.is_valid(expiry_time_now)) {
                string2 = "security.JSAS0435E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                return null;
            }
        }
        catch (InvalidCredential invalidCredential) {
            FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.get_security_features", (String)"1438", (java.lang.Object)this);
            string2 = "security.JSAS0435E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string, invalidCredential});
        }
        SecurityFeatureValue[] securityFeatureValueArray = new SecurityFeatureValue[]{new SecurityFeatureValue(SecurityFeature.SecNoDelegation, false), new SecurityFeatureValue(SecurityFeature.SecSimpleDelegation, true), new SecurityFeatureValue(SecurityFeature.SecCompositeDelegation, false), new SecurityFeatureValue(SecurityFeature.SecNoProtection, false), new SecurityFeatureValue(SecurityFeature.SecIntegrity, this._config.claimMessageIntegrityRequired()), new SecurityFeatureValue(SecurityFeature.SecConfidentiality, this._config.claimMessageConfidentialityRequired()), new SecurityFeatureValue(SecurityFeature.SecIntegrityAndConfidentiality, this._config.claimMessageIntegrityRequired() && this._config.claimMessageConfidentialityRequired()), new SecurityFeatureValue(SecurityFeature.SecDetectReplay, this._config.claimMessageReplayDetectionRequired()), new SecurityFeatureValue(SecurityFeature.SecDetectMisordering, this._config.claimMessageOutOfSequenceDetectionRequired()), new SecurityFeatureValue(SecurityFeature.SecEstablishTrustInTarget, this._config.claimServerAuthenticationRequired())};
        return securityFeatureValueArray;
    }

    protected static int getCredentialTypeInt(Credentials credentials) {
        if (credentials == null) {
            return 0;
        }
        if (credentials instanceof com.ibm.ISecurityLocalObjectBasicAuthImpl.CredentialsImpl) {
            return 4;
        }
        if (credentials instanceof com.ibm.ISecurityLocalObjectLocalOSImpl.CredentialsImpl) {
            return 2;
        }
        if (credentials instanceof com.ibm.ISecurityLocalObjectLTPAImpl.CredentialsImpl) {
            return 1;
        }
        if (credentials instanceof com.ibm.ISecurityLocalObjectTokenBaseImpl.CredentialsImpl) {
            return ((com.ibm.ISecurityLocalObjectTokenBaseImpl.CredentialsImpl)credentials).getAuthType();
        }
        return 0;
    }

    protected static String getCredentialTypeString(Credentials credentials) {
        if (credentials == null) {
            return "unknown";
        }
        if (credentials instanceof com.ibm.ISecurityLocalObjectBasicAuthImpl.CredentialsImpl) {
            return "basicauth";
        }
        if (credentials instanceof com.ibm.ISecurityLocalObjectLocalOSImpl.CredentialsImpl) {
            return "localos";
        }
        if (credentials instanceof com.ibm.ISecurityLocalObjectLTPAImpl.CredentialsImpl) {
            return "ltpa";
        }
        if (credentials instanceof com.ibm.ISecurityLocalObjectTokenBaseImpl.CredentialsImpl) {
            return ((com.ibm.ISecurityLocalObjectTokenBaseImpl.CredentialsImpl)credentials).getAuthTypeString();
        }
        return "unknown";
    }

    public String getUniqueID() throws InvalidCredential {
        String string = "CredentialsImpl.getUniqueID";
        String string2 = null;
        if (this._credsUnauthenticated) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "No unique id for unauthenticated credentials.";
                SecurityLogger.debugMessage(string, string2);
            }
            return null;
        }
        try {
            if (!this.is_valid(expiry_time_now)) {
                string2 = "security.JSAS0435E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                throw new InvalidCredential();
            }
        }
        catch (InvalidCredential invalidCredential) {
            FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.getUniqueID", (String)"1548", (java.lang.Object)this);
            string2 = "security.JSAS0435E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string, invalidCredential});
        }
        if (this._uniqueID == null || this._uniqueID.length() == 0) {
            this._uniqueID = SecurityUIDGenerator.createUID();
        }
        return this._uniqueID;
    }

    public String getIdentityType() throws InvalidCredential {
        String string = "CredentialsImpl.getIdentityType";
        String string2 = null;
        if (this._credsUnauthenticated) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "No unique id for unauthenticated credentials.";
                SecurityLogger.debugMessage(string, string2);
            }
            return null;
        }
        try {
            if (!this.is_valid(expiry_time_now)) {
                string2 = "security.JSAS0435E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                throw new InvalidCredential();
            }
        }
        catch (InvalidCredential invalidCredential) {
            FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.getIdentityType", (String)"1592", (java.lang.Object)this);
            string2 = "security.JSAS0435E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string, invalidCredential});
        }
        return this._IdentityType;
    }

    public byte[] getIdentityValue() throws InvalidCredential {
        String string = "CredentialsImpl.getIdentityValue";
        String string2 = null;
        if (this._credsUnauthenticated) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "No unique id for unauthenticated credentials.";
                SecurityLogger.debugMessage(string, string2);
            }
            return null;
        }
        try {
            if (!this.is_valid(expiry_time_now)) {
                string2 = "security.JSAS0435E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                throw new InvalidCredential();
            }
        }
        catch (InvalidCredential invalidCredential) {
            FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.getIdentityValue", (String)"1635", (java.lang.Object)this);
            string2 = "security.JSAS0435E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string, invalidCredential});
        }
        return this._IdentityValue;
    }

    public void initialize(String string, byte[] byArray, byte[] byArray2, byte[] byArray3, String string2, String string3) throws InvalidAttributeType, DuplicateAttributeType, InvalidCredential {
        String string4 = "";
        String string5 = "CredentialsImpl.constructor";
        short s = 0;
        short s2 = 1;
        Attribute[] attributeArray = new Attribute[6];
        for (int i = 0; i < 6; ++i) {
            if (i == 5) {
                s = 8;
                s2 = 2;
            }
            attributeArray[i] = new Attribute();
            attributeArray[i].attribute_type = new AttributeType();
            attributeArray[i].attribute_type.attribute_family = new ExtensibleFamily(s, s2);
        }
        attributeArray[0].attribute_type.attribute_type = 1;
        attributeArray[0].value = StringBytesConversion.getConvertedBytes(string);
        attributeArray[1].attribute_type.attribute_type = 2;
        attributeArray[1].value = byArray;
        attributeArray[2].attribute_type.attribute_type = 3;
        attributeArray[2].value = byArray2;
        attributeArray[3].attribute_type.attribute_type = 4;
        attributeArray[3].value = byArray3;
        attributeArray[4].attribute_type.attribute_type = 5;
        attributeArray[4].value = StringBytesConversion.getConvertedBytes(string2);
        attributeArray[5].attribute_type.attribute_type = 2;
        attributeArray[5].value = StringBytesConversion.getConvertedBytes(string3);
        try {
            this.set_attributes(attributeArray);
        }
        catch (InvalidAttributeType invalidAttributeType) {
            FFDCFilter.processException((Throwable)invalidAttributeType, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.initialize", (String)"1703", (java.lang.Object)this);
            string4 = "security.JSAS0310E";
            SecurityLogger.logError(string4, new java.lang.Object[]{string5, invalidAttributeType});
            throw invalidAttributeType;
        }
        catch (DuplicateAttributeType duplicateAttributeType) {
            FFDCFilter.processException((Throwable)duplicateAttributeType, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.initialize", (String)"1710", (java.lang.Object)this);
            string4 = "security.JSAS0355E";
            SecurityLogger.logError(string4, new java.lang.Object[]{string5, duplicateAttributeType});
            throw duplicateAttributeType;
        }
        try {
            this._vault.addEstablishedCredentials((Credentials)this);
        }
        catch (InvalidCredential invalidCredential) {
            FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.initialize", (String)"1723", (java.lang.Object)this);
            SecurityLogger.logException(string5, (Exception)((java.lang.Object)invalidCredential), 0, 0);
            throw invalidCredential;
        }
        this.setUniqueID(string);
    }

    public void invalidate() {
        String string = "CredentialsImpl.invalidate";
        String string2 = null;
        int n = CredentialsImpl.getCredentialTypeInt((Credentials)this);
        if (VaultImpl.isServerCred(n, (Credentials)this)) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Attempted to invalidate server credentials.";
                SecurityLogger.debugMessage(string, string2);
            }
            return;
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Invalidated client credentials.";
            SecurityLogger.debugMessage(string, string2);
        }
        this._Public = null;
        this._UniqueSecurityName = null;
        this._AccessId = null;
        this._PrimaryGroupId = null;
        this._GroupIds = null;
        this._Roles = null;
        this._HostName = null;
        this._CredentialToken = null;
        this._expiration = 1L;
        this._credsExpired = true;
        this._credsInvalid = true;
        this._credsIsDummy = false;
        this._credsIsServer = false;
        this._uniqueID = null;
        this._mappedCreds = null;
        this._mappedCredType = 0;
        this._mappedCredTypeString = "unknown";
        this._mappedCredRealmString = "";
        this._authTargetType = 0;
        this._authTargetTypeString = "unknown";
        this._authTargetRealmString = "";
    }

    protected void invalidateByExpiration() {
        if (this._credsExpired) {
            return;
        }
        if (SecurityLogger.debugTraceEnabled) {
            String string = null;
            string = this._Public == null ? "NULL" : (this._Public.length() == 0 ? "\"\"" : this._Public);
            String string2 = "CredentialsImpl.invalidateByExpiration";
            String string3 = "The " + CredentialsImpl.getCredentialTypeString((Credentials)this) + " credentials for " + string + " expired.";
            SecurityLogger.debugMessage(string2, string3);
        }
        this._expiration = 1L;
        this._credsExpired = true;
    }

    protected void invalidateByRejection() {
        if (this._credsRejected) {
            return;
        }
        if (SecurityLogger.debugTraceEnabled) {
            String string = null;
            string = this._Public == null ? "NULL" : (this._Public.length() == 0 ? "\"\"" : this._Public);
            String string2 = "CredentialsImpl.invalidateByRejection";
            String string3 = "The " + CredentialsImpl.getCredentialTypeString((Credentials)this) + " credentials for " + string + " failed authentication.";
            SecurityLogger.debugMessage(string2, string3);
        }
        this.invalidate();
        this._credsRejected = true;
    }

    public boolean is_cache_expiration_valid(IntHolder intHolder) {
        String string = "CredentialsImpl.is_valid";
        String string2 = null;
        long l = intHolder.value;
        if (l < 0L) {
            string2 = "security.JSAS0475E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            return false;
        }
        long l2 = new Date().getTime();
        long l3 = this._cache_expiration - l2;
        if (l < l3) {
            return true;
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Current time: " + l2 + ", credential expiration: " + this._expiration + ", time remaining: " + l3 + ".";
            SecurityLogger.debugMessage(string, string2);
        }
        int n = CredentialsImpl.getCredentialTypeInt((Credentials)this);
        String string3 = CredentialsImpl.getCredentialTypeString((Credentials)this);
        CredentialsImpl credentialsImpl = VaultImpl.getServerCred(n);
        if (credentialsImpl == null) {
            string2 = "security.JSAS0494E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string, string3});
            return true;
        }
        return VaultImpl.isServerCred(n, (Credentials)this);
    }

    public boolean is_valid(IntHolder intHolder) throws InvalidCredential {
        WSCredential wSCredential;
        String string = "CredentialsImpl.is_valid";
        String string2 = null;
        long l = intHolder.value;
        if (l < 0L) {
            string2 = "security.JSAS0475E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            return false;
        }
        if (this._credsInvalid) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Client credentials are invalid.  is_valid returning false.";
                SecurityLogger.debugMessage(string, string2);
            }
            return false;
        }
        this._cache_expiration = System.currentTimeMillis() + this._config.getsecurityCacheTimeout() * 1000L;
        if (this._expiration == 0L) {
            return true;
        }
        long l2 = new Date().getTime();
        long l3 = this._expiration - l2;
        if (l < l3) {
            return true;
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Current time: " + l2 + ", credential expiration: " + this._expiration + ", time remaining: " + l3 + ".";
            SecurityLogger.debugMessage(string, string2);
        }
        int n = CredentialsImpl.getCredentialTypeInt((Credentials)this);
        String string3 = CredentialsImpl.getCredentialTypeString((Credentials)this);
        CredentialsImpl credentialsImpl = VaultImpl.getServerCred(n);
        if (credentialsImpl == null) {
            string2 = "security.JSAS0494E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string, string3});
            return true;
        }
        if (!VaultImpl.isServerCred(n, (Credentials)this)) {
            if (l3 <= 0L) {
                this.invalidateByExpiration();
            }
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Client credentials are expired.  is_valid returning false.";
                SecurityLogger.debugMessage(string, string2);
            }
            return false;
        }
        if (credentialsImpl._expiration < l2 + l) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Refreshing server's credentials.";
                SecurityLogger.debugMessage(string, string2);
            }
            this.refreshServerCred(credentialsImpl);
        } else if (SecurityLogger.debugTraceEnabled) {
            string2 = "Not refreshing server's credentials.";
            SecurityLogger.debugMessage(string, string2);
        }
        this._CredentialToken = credentialsImpl._CredentialToken;
        this._credsExpired = credentialsImpl._credsExpired;
        this._expiration = credentialsImpl._expiration;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Updated the server's " + string3 + " credentials, new expiration == " + this._expiration;
            SecurityLogger.debugMessage(string, string2);
        }
        if ((wSCredential = credentialsImpl.getWSCredential()) != null && (!wSCredential.isCurrent() || wSCredential.isDestroyed())) {
            credentialsImpl.setWSCredential(null);
        }
        if ((wSCredential = this.getWSCredential()) != null && (!wSCredential.isCurrent() || wSCredential.isDestroyed())) {
            this.setWSCredential(null);
        }
        return true;
    }

    public String getOID() {
        return this._Oid;
    }

    public void setOID(String string) {
        this._Oid = string;
    }

    public java.lang.Object getObject() {
        return this._object;
    }

    public void setObject(java.lang.Object object) {
        this._object = object;
    }

    public java.lang.Object get(String string) {
        return this._table.get(string);
    }

    public java.lang.Object set(String string, java.lang.Object object) {
        SecurityManager securityManager;
        if (this._table.get(string) != null && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(APP_UPDATE_PERMISSION);
        }
        return this._table.put(string, object);
    }

    public String[] getRoles() {
        return this._Roles;
    }

    public void setRoles(String[] stringArray) {
        this._Roles = stringArray;
    }

    public String[] getGroupIds() {
        return this._GroupIds;
    }

    public void setGroupIds(String[] stringArray) {
        this._GroupIds = stringArray;
    }

    public String getPrimaryGroupId() {
        return this._PrimaryGroupId;
    }

    public void setPrimaryGroupId(String string) {
        this._PrimaryGroupId = string;
    }

    public String getAccessId() {
        return this._AccessId;
    }

    public void setAccessId(String string) {
        this._AccessId = string;
    }

    public String getPublic() {
        return this._Public;
    }

    public void setPublic(String string) {
        this._Public = string;
    }

    public String getUniqueSecurityName() {
        return this._UniqueSecurityName;
    }

    public void setUniqueSecurityName(String string) {
        this._UniqueSecurityName = string;
    }

    public String getHostName() {
        return this._HostName;
    }

    public void setHostName(String string) {
        this._HostName = string;
    }

    public Hashtable getTable() {
        return (Hashtable)this._table.clone();
    }

    public void setTable(Hashtable hashtable) {
        this._table = (Hashtable)hashtable.clone();
    }

    public boolean isDummy() {
        return this._credsIsDummy;
    }

    public boolean isEquivalent(CredentialsImpl credentialsImpl) {
        return !this._credsInvalid && credentialsImpl != null && !credentialsImpl._credsInvalid && this.getClass().getName().equals(credentialsImpl.getClass().getName()) && this._Public.equals(credentialsImpl._Public) && this._AccessId.equals(credentialsImpl._AccessId) && this._HostName.equals(credentialsImpl._HostName);
    }

    public boolean equals(Object object) {
        return this.isEquivalent((CredentialsImpl)object);
    }

    public int hashCode() {
        String string = null;
        String string2 = CredentialsHelper.getAccessID(this);
        if (this instanceof com.ibm.ISecurityLocalObjectBasicAuthImpl.CredentialsImpl && (string = StringBytesConversion.getConvertedString(this._CredentialToken)) != null && string.length() > 0) {
            string2 = string2 + string;
        }
        return string2.hashCode();
    }

    public boolean isForwardable() {
        return this._isForwardable;
    }

    public void setForwardable(boolean bl) {
        this._isForwardable = bl;
    }

    public boolean isForwardable(String string) {
        return false;
    }

    public boolean isForwardable(String string, String string2) {
        return false;
    }

    public boolean isForwardable(String string, boolean bl) {
        boolean bl2;
        String string2 = "CredentialsImpl.isForwardable";
        String string3 = null;
        if (this._credsUnauthenticated) {
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "Unauthenticated credentials are not forwardable.";
                SecurityLogger.debugMessage(string2, string3);
            }
            return false;
        }
        try {
            if (!this.is_valid(expiry_time_now)) {
                string3 = "security.JSAS0435E";
                SecurityLogger.logError(string3, new java.lang.Object[]{string2});
                return false;
            }
        }
        catch (InvalidCredential invalidCredential) {
            FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.isForwardable", (String)"2036", (java.lang.Object)this);
            string3 = "security.JSAS0435E";
            SecurityLogger.logError(string3, new java.lang.Object[]{string2, invalidCredential});
        }
        String string4 = RealmSecurityName.getRealm(this._Public);
        String string5 = RealmSecurityName.getRealm(string, null);
        String string6 = "<default>";
        boolean bl3 = bl2 = string4.length() == 0 || string4.equalsIgnoreCase(string6) || string4.equalsIgnoreCase(string5) || bl && string5.length() == 0;
        if (!bl2) {
            String string7;
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "Target realm does not match current realm, target realm: " + string5 + ", current realm: " + string4 + ".";
                SecurityLogger.debugMessage(string2, string3);
            }
            if ((string7 = this._config.getSupportedTargetRealms()) != null && !string7.equals("")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string7, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = stringTokenizer.nextToken();
                    if (!string8.equalsIgnoreCase(string5)) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        return bl2;
    }

    protected boolean isInvalidByExpiration() {
        return !this._credsInvalid && this._credsExpired;
    }

    protected boolean isInvalidByRejection() {
        return this._credsRejected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSecurityEnabled(int n) {
        boolean[] blArray = _securityEnabled;
        synchronized (_securityEnabled) {
            if (!_securityEnabled[0]) {
                CredentialsImpl._securityEnabled[0] = VaultImpl.isSecurityEnabled(n);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return _securityEnabled[0];
        }
    }

    public boolean isServer() {
        return this._credsIsServer;
    }

    public boolean isUnauthenticated() {
        return this._credsUnauthenticated;
    }

    protected void markAsDummy() {
        this._credsIsDummy = true;
    }

    protected void markAsServer() {
        if (this._config.getauthenticationTarget() != 4) {
            this._credsIsServer = true;
        }
    }

    public final void markAsUnauthenticated() {
        this._credsUnauthenticated = true;
    }

    protected boolean realmsMatch(String string, String string2) {
        if (string == null || string2 == null) {
            return true;
        }
        if (string.length() == 0 || string2.length() == 0) {
            return true;
        }
        if (string.equals("localHost") || string2.equals("localHost")) {
            return true;
        }
        if (string.equals("client-side-operation") || string2.equals("client-side-operation")) {
            return true;
        }
        return string.equals(string2);
    }

    public boolean refresh() throws InvalidCredential {
        String string = "CredentialsImpl.refresh";
        String string2 = null;
        if (this._credsUnauthenticated) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Cannot refresh unauthenticated credentials.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new InvalidCredential();
        }
        if (this._credsInvalid) {
            string2 = "security.JSAS0435E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            throw new InvalidCredential();
        }
        return false;
    }

    protected boolean refresh(int n) throws InvalidCredential {
        String string = "CredentialsImpl.refresh";
        String string2 = null;
        if (this._credsUnauthenticated) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Cannot refresh unauthenticated credential.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new InvalidCredential();
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "The credential trying to refresh is serverCred: " + VaultImpl.isServerCred(n, (Credentials)this);
            SecurityLogger.debugMessage(string, string2);
        }
        if (this._credsInvalid) {
            if (!VaultImpl.isServerCred(n, (Credentials)this)) {
                string2 = "security.JSAS0435E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                throw new InvalidCredential();
            }
        }
        this._mappedCreds = null;
        LoginHelperImpl loginHelperImpl = (LoginHelperImpl)this.current().login_helper();
        if (loginHelperImpl == null) {
            string2 = "security.JSAS0020E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            return false;
        }
        CredentialsImpl credentialsImpl = null;
        try {
            String string3 = this._Public;
            String string4 = RealmSecurityName.getSecurityName(string3);
            String string5 = RealmSecurityName.getRealm(string3);
            String string6 = null;
            CredentialsHolder credentialsHolder = null;
            OpaqueHolder opaqueHolder = null;
            boolean bl = false;
            boolean bl2 = false;
            credentialsImpl = (CredentialsImpl)loginHelperImpl.request_login_controlled(string4, string5, string6, credentialsHolder, opaqueHolder, bl, n, bl2);
        }
        catch (LoginFailed loginFailed) {
            FFDCFilter.processException((Throwable)loginFailed, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.refresh", (String)"2287", (java.lang.Object)this);
            string2 = "security.JSAS0240E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string, loginFailed});
            credentialsImpl = null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.refresh", (String)"2294", (java.lang.Object)this);
            string2 = "security.JSAS0240E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string, exception});
            credentialsImpl = null;
        }
        if (credentialsImpl == null) {
            string2 = "security.JSAS0240E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            return false;
        }
        boolean bl = this.isEquivalent(credentialsImpl);
        if (bl) {
            this._CredentialToken = credentialsImpl._CredentialToken;
            this._credsExpired = credentialsImpl._credsExpired;
            this._expiration = credentialsImpl._expiration;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshServerCred(CredentialsImpl credentialsImpl) {
        String string = "CredentialsImpl.refreshServerCred";
        String string2 = null;
        String string3 = CredentialsImpl.getCredentialTypeString((Credentials)credentialsImpl);
        long l = new Date().getTime() + this._config.getMinimumRequestCredsExpiration() * 1000L;
        boolean bl = false;
        boolean[] blArray = _refreshServerCred;
        synchronized (_refreshServerCred) {
            if (!_refreshServerCred[0]) {
                CredentialsImpl._refreshServerCred[0] = true;
                bl = true;
            }
            // ** MonitorExit[var8_7] (shouldn't be in output)
            if (bl) {
                boolean bl2 = false;
                try {
                    bl2 = credentialsImpl.refresh(CredentialsImpl.getCredentialTypeInt((Credentials)credentialsImpl));
                }
                catch (InvalidCredential invalidCredential) {
                    FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.refreshServerCred", (String)"2363", (java.lang.Object)this);
                    string2 = "security.JSAS0435E";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string, invalidCredential});
                    bl2 = false;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.refreshServerCred", (String)"2370", (java.lang.Object)this);
                    string2 = "security.JSAS0435E";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string, exception});
                    bl2 = false;
                }
                if (!bl2) {
                    credentialsImpl._credsExpired = false;
                    credentialsImpl._expiration = l;
                    string2 = "security.JSAS1474W";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string});
                } else if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Refreshed the server's " + string3 + " credentials ... new expiration == " + this._expiration;
                    SecurityLogger.debugMessage(string, string2);
                }
                if (this != credentialsImpl) {
                    this._CredentialToken = credentialsImpl._CredentialToken;
                    this._credsExpired = credentialsImpl._credsExpired;
                    this._expiration = credentialsImpl._expiration;
                }
                boolean[] blArray2 = _refreshServerCred;
                synchronized (_refreshServerCred) {
                    CredentialsImpl._refreshServerCred[0] = false;
                    // ** MonitorExit[var9_12] (shouldn't be in output)
                }
            }
            this._credsExpired = false;
            this._expiration = l;
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Reset the server's " + string3 + " credentials ... new expiration == " + this._expiration;
                SecurityLogger.debugMessage(string, string2);
            }
            return;
        }
    }

    public void run() {
        if (this._expiration != 0L) {
            String string = "CredentialsImpl.run";
            String string2 = null;
            String string3 = CredentialsImpl.getCredentialTypeString((Credentials)this);
            String string4 = this._Public;
            if (string4 == null || string4.length() == 0) {
                string2 = "security.JSAS0495E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                throw new INTERNAL();
            }
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "The server's " + string3 + " credentials are valid ... realm/name == " + string4 + ".";
                SecurityLogger.debugMessage(string, string2);
            }
            long l = this._config.getsecurityCacheTimeout() * 800L;
            long l2 = this._expiration - new Date().getTime();
            long l3 = l2 - (long)this._orb.getRequestTimeout();
            long l4 = this._config.getMinimumRequestCredsExpiration() * 800L;
            long l5 = l2 * 800L / 1000L;
            if (l4 < l) {
                l4 = l;
            }
            if (l4 > l3) {
                l5 = l3 * 800L / 1000L;
                string2 = "security.JSAS0496E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string, string3});
            } else if (l5 < l4) {
                l5 = l4;
            } else if (l5 > l3) {
                l5 = l3;
            }
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Refresh_timeout == " + l5 + ".";
                SecurityLogger.debugMessage(string, string2);
            }
            while (true) {
                try {
                    Thread.sleep(l5);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl.run", (String)"2500", (java.lang.Object)this);
                    string2 = "security.JSAS0479E";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string, exception});
                }
                this.refreshServerCred(this);
            }
        }
    }

    public void set_attributes(Attribute[] attributeArray) throws InvalidAttributeType, DuplicateAttributeType {
        String string = "CredentialsImpl.set_attributes";
        String string2 = null;
        if (this._credsUnauthenticated) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Cannot modify attributes for unauthenticated credentials.";
                SecurityLogger.debugMessage(string, string2);
            }
            return;
        }
        if (this._credsInvalid) {
            string2 = "security.JSAS0435E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            return;
        }
        if (attributeArray == null) {
            string2 = "security.JSAS0360E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = attributeArray.length;
        block10: for (int i = 0; i < n4; ++i) {
            if (attributeArray[i] == null) {
                string2 = "security.JSAS0380E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                bl8 = true;
                n3 = i;
                continue;
            }
            if (attributeArray[i].attribute_type == null || attributeArray[i].attribute_type.attribute_family == null) {
                string2 = "security.JSAS0370E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                bl8 = true;
                n3 = i;
                continue;
            }
            if (attributeArray[i].attribute_type.attribute_family.family_definer == 0 && attributeArray[i].attribute_type.attribute_family.family == 1) {
                n = 0;
                n2 = 1;
            } else if (attributeArray[i].attribute_type.attribute_family.family_definer == 8 && attributeArray[i].attribute_type.attribute_family.family == 2) {
                n = 8;
                n2 = 2;
            } else {
                string2 = "security.JSAS0350E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                bl8 = true;
                n3 = i;
                continue;
            }
            if (n == 0) {
                switch (attributeArray[i].attribute_type.attribute_type) {
                    case 1: {
                        String string3;
                        if (bl) {
                            bl7 = true;
                            n3 = i;
                            break;
                        }
                        bl = true;
                        this._Public = string3 = RealmSecurityName.getRealmSecurityName(StringBytesConversion.getConvertedString(attributeArray[i].value));
                        this._authTargetRealmString = RealmSecurityName.getRealm(string3);
                        break;
                    }
                    case 2: {
                        if (bl2) {
                            bl7 = true;
                            n3 = i;
                            break;
                        }
                        bl2 = true;
                        this._AccessId = StringBytesConversion.getConvertedString(attributeArray[i].value);
                        break;
                    }
                    case 3: {
                        if (bl3) {
                            bl7 = true;
                            n3 = i;
                            break;
                        }
                        bl3 = true;
                        this._PrimaryGroupId = StringBytesConversion.getConvertedString(attributeArray[i].value);
                        break;
                    }
                    case 4: {
                        if (bl4) {
                            bl7 = true;
                            n3 = i;
                            break;
                        }
                        bl4 = true;
                        this._GroupIds = SecurityAttributeList.getAttributeStringArray(attributeArray[i].value);
                        break;
                    }
                    case 5: {
                        if (bl5) {
                            bl7 = true;
                            n3 = i;
                            break;
                        }
                        bl5 = true;
                        this._Roles = SecurityAttributeList.getAttributeStringArray(attributeArray[i].value);
                        break;
                    }
                    default: {
                        bl8 = true;
                        n3 = i;
                        break;
                    }
                }
                continue;
            }
            switch (attributeArray[i].attribute_type.attribute_type) {
                case 2: {
                    if (bl6) {
                        bl7 = true;
                        n3 = i;
                        continue block10;
                    }
                    bl6 = true;
                    this._HostName = StringBytesConversion.getConvertedString(attributeArray[i].value);
                    continue block10;
                }
                default: {
                    bl8 = true;
                    n3 = i;
                }
            }
        }
        if (bl8) {
            string2 = "security.JSAS0350E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            throw new InvalidAttributeType(InvalidAttributeTypeReason.InvalidType, attributeArray[n3].attribute_type);
        }
        if (bl7) {
            string2 = "security.JSAS0350E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            throw new DuplicateAttributeType(attributeArray[n3].attribute_type);
        }
    }

    public void set_credential_token(String string, byte[] byArray, long l) throws CredentialsNotSet {
        throw new NO_IMPLEMENT();
    }

    protected void set_credential_token(String string, byte[] byArray, long l, CredentialsNotSet credentialsNotSet) throws CredentialsNotSet {
        String string2;
        String string3 = "CredentialsImpl.set_credential_token";
        String string4 = null;
        if (this._credsUnauthenticated) {
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Cannot modify credential token of unauthenticated credentials.";
                SecurityLogger.debugMessage(string3, string4);
            }
            throw credentialsNotSet;
        }
        if (this._credsInvalid) {
            string4 = "security.JSAS0435E";
            SecurityLogger.logError(string4, new java.lang.Object[]{string3});
            throw credentialsNotSet;
        }
        this._Public = string2 = RealmSecurityName.getRealmSecurityName(string);
        this._authTargetRealmString = RealmSecurityName.getRealm(string2);
        this._CredentialToken = byArray;
        if (l > new Date().getTime()) {
            this._credsExpired = false;
        }
        this._expiration = l;
        this._mappedCreds = null;
    }

    public void set_security_features(CommunicationDirection communicationDirection, SecurityFeatureValue[] securityFeatureValueArray) throws InvalidCommDirection, InvalidSecurityFeature, DuplicateSecurityFeature {
        throw new NO_IMPLEMENT();
    }

    public void setUniqueID(String string) {
        String string2 = "CredentialsImpl.setUniqueID";
        String string3 = null;
        if (this._credsUnauthenticated) {
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "No unique ID will be set for unauthenticated credentials.";
                SecurityLogger.debugMessage(string2, string3);
            }
            return;
        }
        if (this._credsInvalid) {
            string3 = "security.JSAS0435E";
            SecurityLogger.logError(string3, new java.lang.Object[]{string2});
            return;
        }
        this._uniqueID = string;
    }

    public void setAttributForIdentityAssertion(String string, byte[] byArray) {
        String string2 = "CredentialsImpl.setAttributeForIdentityAssertion";
        String string3 = null;
        if (this._credsUnauthenticated) {
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "No unique ID will be set for unauthenticated credentials.";
                SecurityLogger.debugMessage(string2, string3);
            }
            return;
        }
        if (this._credsInvalid) {
            string3 = "security.JSAS0435E";
            SecurityLogger.logError(string3, new java.lang.Object[]{string2});
            return;
        }
        this._IdentityType = string;
        this._IdentityValue = byArray;
    }

    public WSCredential mapCorbaToWS() {
        throw new NO_IMPLEMENT();
    }

    public Credentials mapWSToCorba(WSCredential wSCredential) {
        throw new NO_IMPLEMENT();
    }
}

