/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityL13SupportImpl.LoginPanel;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.PrincipalAuthenticatorImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.AuthenticationTarget;
import com.ibm.ISecurityUtilityImpl.CredentialsHelper;
import com.ibm.ISecurityUtilityImpl.KeyFile;
import com.ibm.ISecurityUtilityImpl.KeyFileEntry;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.SecurityServer;
import com.ibm.ISecurityUtilityImpl.SourceLocation;
import com.ibm.ISecurityUtilityImpl.StdinLoginPrompt;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Permission;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.swing.JFrame;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_MEMORY;
import org.omg.Security.Attribute;
import org.omg.Security.AuthenticationStatus;
import org.omg.Security.CredentialType;
import org.omg.Security.InvalidCredentialType;
import org.omg.Security.OpaqueHolder;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.CredentialsHolder;
import org.omg.SecurityLevel2.InvalidCredential;
import org.omg.SecurityLevel2.LoginFailed;
import org.omg.SecurityLevel2.LoginFailedReason;

public class LoginHelperImpl
extends com.ibm.IExtendedSecurityImpl.LoginHelperImpl {
    private VaultImpl _vault = null;
    private ORB _orb = null;
    private SecurityConfiguration _secConfig = null;
    private static KeyFile _keyFile = null;
    private int _loginSource = 7;
    private int _loginTimeout = 300;
    private static int stdinRetry = 0;
    private String r_name = null;
    private String s_name = null;
    private String p_name = null;
    private String p_word = null;
    private byte[] a_data = null;
    private int result = 0;
    private static final WebSphereRuntimePermission perm = new WebSphereRuntimePermission("SecOwnCredentials");

    protected LoginHelperImpl() {
    }

    public LoginHelperImpl(ORB oRB, SecurityConfiguration securityConfiguration) {
        String string = "LoginHelperImpl.LoginHelperImpl";
        if (oRB != null) {
            this._vault = VaultImpl.getInstance();
            this._orb = oRB;
            this._secConfig = securityConfiguration;
            this._loginSource = this._secConfig.getloginSource();
            this._loginTimeout = this._secConfig.getloginTimeout();
            try {
                _keyFile = this.getKeyFileObject();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.LoginHelperImpl", (String)"171", (Object)((Object)this));
                SecurityLogger.traceException(string, exception, 0, 0);
            }
        }
    }

    private CurrentImpl current() {
        return this._vault.getCurrent();
    }

    private void getEnvironmentLogin() {
    }

    private String getHostName() {
        String string = null;
        try {
            string = this._orb.getLocalHost();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.getHostName", (String)"243", (Object)((Object)this));
            string = null;
        }
        if (string == null || string.length() == 0) {
            string = "localHost";
        }
        return string;
    }

    private void getKeyFileLogin() {
        KeyFileEntry keyFileEntry;
        String string = "LoginHelperImpl.getKeyFileLogin";
        String string2 = null;
        if (this.p_name == null) {
            this.p_name = this._secConfig.getprincipalName();
            this.p_name = RealmSecurityName.getRealmSecurityName(this.p_name);
            this.s_name = RealmSecurityName.getSecurityName(this.p_name);
            this.r_name = RealmSecurityName.getRealm(this.p_name);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Getting login information from key-file for " + this.p_name;
            SecurityLogger.debugMessage(string, string2);
        }
        if (_keyFile == null) {
            _keyFile = new KeyFile(this._secConfig.getkeyFileName());
        }
        if ((keyFileEntry = _keyFile.find(this.r_name, this.s_name)) != null) {
            this.p_name = keyFileEntry.getUserid();
            this.p_word = keyFileEntry.getPassword();
            this.p_name = RealmSecurityName.getRealmSecurityName(this.r_name, this.p_name);
            this.s_name = RealmSecurityName.getSecurityName(this.p_name);
            this.r_name = RealmSecurityName.getRealm(this.p_name);
        } else {
            this.p_word = null;
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0454A", "JSAS0454A: The indicated entry was not found in the key file.");
            SecurityLogger.logActivity(string, 0, string2);
        }
    }

    public KeyFile getKeyFileObject() {
        String string = "LoginHelperImpl.getKeyFileObject";
        String string2 = null;
        String string3 = this._secConfig.getkeyFileName();
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Getting an authentication key file object.";
            SecurityLogger.debugMessage(string, string2);
        }
        if (_keyFile == null) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Authentication key file is: " + string3;
                SecurityLogger.debugMessage(string, string2);
            }
            _keyFile = new KeyFile(string3);
        }
        if (!_keyFile.isEmpty()) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Returning authentication key file object is initialized.";
                SecurityLogger.debugMessage(string, string2);
            }
        } else if (SecurityLogger.debugTraceEnabled) {
            string2 = "Returning authentication key file object is empty.";
            SecurityLogger.debugMessage(string, string2);
        }
        return _keyFile;
    }

    private void getPropertiesLogin() {
        this.p_name = this._secConfig.getloginUserid();
        this.p_word = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return LoginHelperImpl.this._secConfig.getloginPassword();
            }
        });
        this.p_name = RealmSecurityName.getRealmSecurityName(this.p_name);
        this.s_name = RealmSecurityName.getSecurityName(this.p_name);
    }

    private void getStdInLogin() {
        String[] stringArray = null;
        try {
            if (stdinRetry < 1) {
                Object object;
                if (this.r_name.length() > 0) {
                    object = SecurityMessages.getMsgOrUseDefault("RealmName", "Realm (Cell) Name");
                    System.out.println((String)object + ": " + this.r_name);
                }
                if ((stringArray = new StdinLoginPrompt().getUidAndPassword()) != null) {
                    this.p_word = stringArray[1];
                    this.p_name = RealmSecurityName.getRealmSecurityName(stringArray[0]);
                    this.s_name = RealmSecurityName.getSecurityName(stringArray[0]);
                    if (this.r_name.length() == 0) {
                        object = new BufferedReader(new InputStreamReader(System.in));
                        String string = SecurityMessages.getMsgOrUseDefault("RealmName", "Realm (Cell) Name");
                        System.out.print(string + ": ");
                        this.r_name = ((BufferedReader)object).readLine().trim();
                        if (this.r_name.length() == 0) {
                            this.r_name = this.getHostName();
                        }
                        this.p_name = RealmSecurityName.getRealmSecurityName(this.r_name, this.s_name);
                    }
                    stdinRetry = 0;
                } else {
                    ++stdinRetry;
                    this.r_name = null;
                    this.s_name = null;
                    this.p_name = null;
                    this.p_word = null;
                }
            } else {
                stdinRetry = 0;
                this.r_name = null;
                this.s_name = null;
                this.p_name = null;
                this.p_word = null;
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.getStdInLogin", (String)"452", (Object)((Object)this));
            System.out.println("unable to get system input stream");
        }
    }

    private synchronized boolean getPromptLogin() {
        boolean bl = false;
        boolean bl2 = false;
        LoginPanel loginPanel = null;
        JFrame jFrame = null;
        while (!bl) {
            jFrame = new JFrame();
            loginPanel = new LoginPanel(this.s_name, this.r_name, this.p_word, this._loginTimeout, jFrame);
            this.result = loginPanel.showPanel();
            if (this.result == 2) {
                String string = loginPanel.getId();
                if (string != null && string.length() > 0) {
                    this.s_name = new String(string.trim());
                    if (this.s_name != null && this.s_name.length() > 0) {
                        String string2 = loginPanel.getCell();
                        this.r_name = string2 != null && string2.length() > 0 ? new String(string2.trim()) : "";
                        this.p_name = RealmSecurityName.getRealmSecurityName(this.r_name, this.s_name);
                        String string3 = loginPanel.getPassword();
                        this.p_word = string3 != null && string3.length() > 0 ? new String(string3) : "";
                        loginPanel.dispose();
                        loginPanel = null;
                        bl = true;
                    } else {
                        this.r_name = "";
                        this.p_name = "";
                        this.p_word = "";
                    }
                } else {
                    this.s_name = "";
                    this.r_name = "";
                    this.p_name = "";
                    this.p_word = "";
                }
                if (!bl) {
                    loginPanel.dispose();
                    loginPanel = null;
                    bl = true;
                }
            } else {
                bl2 = true;
                loginPanel.dispose();
                loginPanel = null;
                this.r_name = null;
                this.s_name = null;
                this.p_name = null;
                this.p_word = null;
                bl = true;
            }
            if (jFrame == null) continue;
            jFrame.dispose();
            jFrame = null;
        }
        return !bl2;
    }

    public synchronized Credentials request_login(int n, byte[] byArray) throws LoginFailed {
        String string = "LoginHelperImpl.request_login";
        String string2 = null;
        if (n == 262144) {
            n = 1;
        }
        String string3 = (String)AuthenticationTarget.strings.get(new Integer(n));
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Logging in by validating the " + string3 + " credential token.";
            SecurityLogger.debugMessage(string, string2);
        }
        switch (n) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                string2 = "security.JSAS0051E";
                SecurityLogger.logError(string2, new Object[]{string});
                throw new LoginFailed();
            }
        }
        if (byArray == null || byArray.length == 0) {
            string2 = "security.JSAS0052E";
            SecurityLogger.logError(string2, new Object[]{string});
            throw new LoginFailed();
        }
        CurrentImpl currentImpl = this.current();
        if (currentImpl == null) {
            string2 = "security.JSAS0030E";
            SecurityLogger.logError(string2, new Object[]{string});
            throw new LoginFailed();
        }
        try {
            currentImpl.setServerCredBeforeClientSideOperation(n, byArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login", (String)"693", (Object)((Object)this));
            string2 = "Unable to set the server credentials before a client-side operation.";
            SecurityLogger.debugMessage(string, string2);
            throw new LoginFailed();
        }
        String string4 = null;
        String string5 = null;
        String string6 = null;
        CredentialsHolder credentialsHolder = null;
        OpaqueHolder opaqueHolder = null;
        boolean bl = true;
        boolean bl2 = true;
        Credentials credentials = null;
        try {
            credentials = this.request_login_controlled(string4, string5, string6, byArray, credentialsHolder, opaqueHolder, bl, n, bl2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login", (String)"716", (Object)((Object)this));
            credentials = null;
        }
        try {
            currentImpl.resetServerCredAfterClientSideOperation();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login", (String)"729", (Object)((Object)this));
            string2 = "Unable to reset the server credentials after a client-side operation.";
            SecurityLogger.debugMessage(string, string2);
            throw new LoginFailed();
        }
        if (credentials == null) {
            string2 = "security.JSAS0053E";
            SecurityLogger.logError(string2, new Object[]{string});
            throw new LoginFailed();
        }
        return credentials;
    }

    public synchronized Credentials request_login(String string, String string2, String string3, CredentialsHolder credentialsHolder, OpaqueHolder opaqueHolder) throws LoginFailed {
        String string4 = "LoginHelperImpl.request_login";
        String string5 = null;
        if (string != null) {
            string = string.trim();
        }
        if (string3 != null) {
            string3 = string3.trim();
        }
        if (string == null || string.equals("") || string3 == null || string3.equals("")) {
            if (SecurityLogger.debugTraceEnabled) {
                string5 = "Security name and/or password not specified.  Login Failed.";
                SecurityLogger.debugMessage(string4, string5);
            }
            throw new LoginFailed();
        }
        if (SecurityLogger.debugTraceEnabled) {
            string5 = "Logging in:  Security Name " + string + " Realm Name " + string2;
            SecurityLogger.debugMessage(string4, string5);
        }
        boolean bl = false;
        return this.request_login_controlled(string, string2, string3, credentialsHolder, opaqueHolder, bl);
    }

    public synchronized Credentials request_login_controlled(String string, String string2, String string3, CredentialsHolder credentialsHolder, OpaqueHolder opaqueHolder, boolean bl) throws LoginFailed {
        int n = 0;
        return this.request_login_controlled(string, string2, string3, credentialsHolder, opaqueHolder, bl, n);
    }

    public synchronized Credentials request_login_controlled(String string, String string2, String string3, CredentialsHolder credentialsHolder, OpaqueHolder opaqueHolder, boolean bl, int n) throws LoginFailed {
        boolean bl2 = true;
        return this.request_login_controlled(string, string2, string3, credentialsHolder, opaqueHolder, bl, n, bl2);
    }

    public synchronized Credentials request_login_controlled(String string, String string2, String string3, CredentialsHolder credentialsHolder, OpaqueHolder opaqueHolder, boolean bl, boolean bl2) throws LoginFailed {
        int n = 0;
        return this.request_login_controlled(string, string2, string3, credentialsHolder, opaqueHolder, bl, n, bl2);
    }

    public synchronized Credentials request_login_controlled(String string, String string2, String string3, CredentialsHolder credentialsHolder, OpaqueHolder opaqueHolder, boolean bl, int n, boolean bl2) throws LoginFailed {
        byte[] byArray = null;
        return this.request_login_controlled(string, string2, string3, byArray, credentialsHolder, opaqueHolder, bl, n, bl2);
    }

    /*
     * Loose catch block
     */
    public synchronized Credentials request_login_controlled(String string, String string2, String string3, byte[] byArray, CredentialsHolder credentialsHolder, OpaqueHolder opaqueHolder, boolean bl, int n, boolean bl2) throws LoginFailed {
        Object object;
        String string4;
        String string5;
        block79: {
            String string6;
            Object object2;
            string5 = "LoginHelperImpl.request_login_controlled";
            string4 = null;
            if (string != null) {
                string = string.trim();
            }
            if (string3 != null) {
                string3 = string3.trim();
            }
            if ((string == null || string.equals("") || string3 == null || string3.equals("")) && (object = System.getSecurityManager()) != null) {
                string4 = "Performing Java 2 Security Permission Check ...Expecting : " + perm.toString();
                SecurityLogger.debugMessage(string5, string4);
                ((SecurityManager)object).checkPermission((Permission)perm);
            }
            if (this._orb == null) {
                string4 = "security.JSAS0025E";
                SecurityLogger.logError(string4, new Object[]{string5});
                this._orb = GlobalORBFactory.globalORB();
                if (this._orb == null) {
                    string4 = "security.JSAS0025E";
                    SecurityLogger.logError(string4, new Object[]{string5});
                    throw new INTERNAL("There is no ORB reference");
                }
            }
            object = this.current();
            ContextManager contextManager = ContextManagerFactory.getInstance();
            if (object == null) {
                string4 = "security.JSAS0030E";
                SecurityLogger.logError(string4, new Object[]{string5});
                throw new LoginFailed();
            }
            PrincipalAuthenticatorImpl principalAuthenticatorImpl = (PrincipalAuthenticatorImpl)((CurrentImpl)((Object)object)).principal_authenticator(n);
            if (principalAuthenticatorImpl == null) {
                string4 = "security.JSAS0180E";
                SecurityLogger.logError(string4, new Object[]{string5});
                throw new LoginFailed();
            }
            int n2 = 0;
            if (bl) {
                n2 |= 0x10000;
            }
            this.r_name = null;
            this.s_name = null;
            this.p_name = null;
            this.p_word = null;
            this.a_data = null;
            if (byArray == null) {
                if (string != null) {
                    this.s_name = new String(string.trim());
                    if (this.s_name == null) {
                        throw new NO_MEMORY();
                    }
                }
                if (string2 != null) {
                    this.r_name = new String(string2.trim());
                    if (this.r_name == null) {
                        throw new NO_MEMORY();
                    }
                }
                if (string3 != null) {
                    this.p_word = new String(string3);
                    if (this.p_word == null) {
                        throw new NO_MEMORY();
                    }
                }
                if (this.s_name == null && this.p_word == null) {
                    object2 = this._orb.getProperty("com.ibm.CORBA.BVTestPrincipalName");
                    if (object2 != null && ((String)object2).length() > 0) {
                        this.s_name = new String(RealmSecurityName.getSecurityName((String)object2));
                        if (this.s_name == null) {
                            throw new NO_MEMORY();
                        }
                        this.r_name = new String(RealmSecurityName.getRealm((String)object2));
                        if (this.r_name == null) {
                            throw new NO_MEMORY();
                        }
                    }
                    if ((string6 = this._orb.getProperty("com.ibm.CORBA.BVTestPassword")) != null && string6.length() > 0) {
                        this.p_word = new String(string6);
                        if (this.p_word == null) {
                            throw new NO_MEMORY();
                        }
                    }
                }
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "s_name: " + this.s_name + ", p_word: " + SecurityConfiguration.mask(this.p_word) + ", r_name: " + this.r_name;
                    SecurityLogger.debugMessage(string5, string4);
                }
                if (this.s_name == null || this.s_name.length() == 0 || this.p_word == null || this.p_word.length() == 0) {
                    switch (this._loginSource) {
                        case 4: {
                            this.getEnvironmentLogin();
                            break;
                        }
                        case 3: {
                            this.getKeyFileLogin();
                            break;
                        }
                        case 1: {
                            try {
                                boolean bl3 = this.getPromptLogin();
                                if (bl3 && (this.s_name == null || this.s_name.length() == 0 || this.p_word == null || this.p_word.length() == 0)) {
                                    throw new LoginFailed();
                                }
                                break;
                            }
                            catch (LoginFailed loginFailed) {
                                throw loginFailed;
                            }
                            catch (Throwable throwable) {
                                if (SecurityLogger.debugTraceEnabled) {
                                    string4 = "Error occurred with GUI prompt, logging in with console prompt.";
                                    SecurityLogger.debugMessage(string5, string4);
                                }
                                this.getStdInLogin();
                                break;
                            }
                        }
                        case 5: {
                            this.getPropertiesLogin();
                            break;
                        }
                        case 6: {
                            this.getStdInLogin();
                            break;
                        }
                        case 7: {
                            if (this.s_name != null && this.s_name.length() != 0 && this.p_word != null && this.p_word.length() != 0) break;
                            return this.current().get_unauthenticated_credential();
                        }
                    }
                }
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "Login source is " + SourceLocation.strings.get(new Integer(this._loginSource)) + ".";
                    SecurityLogger.debugMessage(string5, string4);
                }
                this.p_name = RealmSecurityName.getRealmSecurityName(this.r_name, this.s_name);
                this.a_data = StringBytesConversion.getConvertedBytes(this.p_word);
            } else {
                this.a_data = byArray;
                n2 |= 0x40000;
            }
            if (this.result == 3) {
                if (credentialsHolder == null && (credentialsHolder = new CredentialsHolder()) == null) {
                    throw new NO_MEMORY();
                }
                credentialsHolder.value = ((CurrentImpl)((Object)object)).get_unauthenticated_credential();
                object2 = (CredentialsImpl)credentialsHolder.value;
                ((CredentialsImpl)object2).invalidateByRejection();
                return object2;
            }
            if (this.a_data == null || this.a_data.length == 0) {
                string4 = SecurityMessages.getMsgOrUseDefault("JSAS0455A", "JSAS0455A: Unable to login principal, invalid authentication information.");
                SecurityLogger.logActivity(string5, 0, string4);
                throw new LoginFailed();
            }
            if (credentialsHolder == null && (credentialsHolder = new CredentialsHolder()) == null) {
                throw new NO_MEMORY();
            }
            if (opaqueHolder == null && (opaqueHolder = new OpaqueHolder()) == null) {
                throw new NO_MEMORY();
            }
            object2 = new OpaqueHolder();
            if (object2 == null) {
                throw new NO_MEMORY();
            }
            string6 = null;
            AuthenticationStatus authenticationStatus = AuthenticationStatus.SecAuthFailure;
            try {
                authenticationStatus = byArray == null ? principalAuthenticatorImpl.authenticate(n2, this.p_name, this.a_data, (Attribute[])string6, credentialsHolder, (OpaqueHolder)object2, opaqueHolder) : principalAuthenticatorImpl.validate(n2, this.p_name, this.a_data, (Attribute[])string6, credentialsHolder, (OpaqueHolder)object2, opaqueHolder);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1161", (Object)((Object)this));
                if (SecurityLogger.traceEnabled) {
                    SecurityLogger.traceException(string5, exception, 0, 0);
                }
                authenticationStatus = AuthenticationStatus.SecAuthFailure;
            }
            if (authenticationStatus == AuthenticationStatus.SecAuthFailure) {
                string4 = "security.JSAS0240E";
                SecurityLogger.logError(string4, new Object[]{string5});
                throw new LoginFailed();
            }
            if (this._secConfig.validateBasicAuth() && credentialsHolder.value != null && credentialsHolder.value instanceof com.ibm.ISecurityLocalObjectBasicAuthImpl.CredentialsImpl) {
                Credentials credentials;
                block77: {
                    credentials = null;
                    try {
                        credentials = this.current().get_credentials(CredentialType.SecInvocationCredentials, false, null);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1197", (Object)((Object)this));
                        SecurityLogger.logException(string5, exception, 0, 0);
                    }
                    try {
                        ((CurrentImpl)((Object)object)).set_credentials(CredentialType.SecInvocationCredentials, ((CurrentImpl)((Object)object)).get_unauthenticated_credential());
                    }
                    catch (InvalidCredential invalidCredential) {
                        FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1207", (Object)((Object)this));
                        SecurityLogger.logException(string5, (Exception)((Object)invalidCredential), 0, 0);
                    }
                    catch (InvalidCredentialType invalidCredentialType) {
                        FFDCFilter.processException((Throwable)invalidCredentialType, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1212", (Object)((Object)this));
                        SecurityLogger.logException(string5, (Exception)((Object)invalidCredentialType), 0, 0);
                    }
                    BasicAuthData basicAuthData = new BasicAuthData(this.s_name, this.p_word, this.r_name);
                    SecurityServer securityServer = this._vault.getSecurityServer();
                    boolean bl4 = false;
                    String string7 = "";
                    if (SecurityLogger.debugTraceEnabled) {
                        string4 = "Calling authenticate for user: " + basicAuthData.getUserid();
                        SecurityLogger.debugMessage(string5, string4);
                    }
                    try {
                        bl4 = securityServer.simple_authenticate(basicAuthData);
                    }
                    catch (WSLoginFailedException wSLoginFailedException) {
                        FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1199", (Object)((Object)this));
                        if (SecurityLogger.debugTraceEnabled) {
                            string4 = "An exception occurred in simple_authenticate.";
                            SecurityLogger.debugMessage(string5, string4);
                            SecurityLogger.traceException(string5, wSLoginFailedException, 0, 0);
                        }
                        string7 = wSLoginFailedException.getMessage();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1210", (Object)((Object)this));
                        if (SecurityLogger.debugTraceEnabled) {
                            string4 = "An exception occurred in simple_authenticate.";
                            SecurityLogger.debugMessage(string5, string4);
                            SecurityLogger.traceException(string5, exception, 0, 0);
                        }
                        string7 = exception.getMessage();
                    }
                    if (!bl4) {
                        string4 = "Credential is null, BasicAuth creds did not authenticate, reason: " + string7;
                        SecurityLogger.debugMessage(string5, string4);
                        throw new LoginFailed(LoginFailedReason.from_int((int)1), string7);
                    }
                    try {
                        this._vault.add_default_credentials(credentialsHolder.value);
                        if (!contextManager.processIsServer()) {
                            WSCredential wSCredential = CredentialsHelper.mapCorbaToWS((CredentialsImpl)credentialsHolder.value);
                            Subject subject = SubjectHelper.createSubjectFromWSCredential(wSCredential);
                            this._vault.set_default_subject(subject);
                        }
                    }
                    catch (InvalidCredential invalidCredential) {
                        FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1211", (Object)((Object)this));
                        if (!SecurityLogger.debugTraceEnabled) break block77;
                        string4 = "Error adding credentials to default credentials list. Reason: " + invalidCredential.toString();
                        SecurityLogger.debugMessage(string5, string4);
                        SecurityLogger.traceException(string5, (Exception)((Object)invalidCredential), 0, 0);
                    }
                }
                Object var27_39 = null;
                try {
                    ((CurrentImpl)((Object)object)).set_credentials(CredentialType.SecInvocationCredentials, credentials);
                }
                catch (InvalidCredential invalidCredential) {
                    FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1272", (Object)((Object)this));
                    SecurityLogger.logException(string5, (Exception)((Object)invalidCredential), 0, 0);
                }
                catch (InvalidCredentialType invalidCredentialType) {
                    FFDCFilter.processException((Throwable)invalidCredentialType, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1277", (Object)((Object)this));
                    SecurityLogger.logException(string5, (Exception)((Object)invalidCredentialType), 0, 0);
                }
                break block79;
                {
                    catch (LoginFailed loginFailed) {
                        throw loginFailed;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1223", (Object)((Object)this));
                        string4 = "Exception occurred authenticating BasicAuth creds. Reason: " + exception.toString();
                        SecurityLogger.debugMessage(string5, string4);
                        SecurityLogger.logException(string5, exception, 0, 0);
                        throw new LoginFailed(LoginFailedReason.from_int((int)1), exception.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var27_40 = null;
                    try {
                        ((CurrentImpl)((Object)object)).set_credentials(CredentialType.SecInvocationCredentials, credentials);
                    }
                    catch (InvalidCredential invalidCredential) {
                        FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1272", (Object)((Object)this));
                        SecurityLogger.logException(string5, (Exception)((Object)invalidCredential), 0, 0);
                    }
                    catch (InvalidCredentialType invalidCredentialType) {
                        FFDCFilter.processException((Throwable)invalidCredentialType, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1277", (Object)((Object)this));
                        SecurityLogger.logException(string5, (Exception)((Object)invalidCredentialType), 0, 0);
                    }
                    throw throwable;
                }
            }
        }
        if (bl2) {
            try {
                ((CurrentImpl)((Object)object)).set_invocation_credentials(credentialsHolder.value);
            }
            catch (InvalidCredential invalidCredential) {
                FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1294", (Object)((Object)this));
                string4 = "security.JSAS0054E";
                SecurityLogger.logError(string4, new Object[]{string5, invalidCredential});
                throw new LoginFailed();
            }
        }
        return credentialsHolder.value;
    }

    public synchronized Subject request_login_controlled(String string, String string2, String string3, byte[] byArray, boolean bl) throws WSLoginFailedException {
        Object object;
        String string4 = "LoginHelperImpl.request_login_controlled";
        String string5 = null;
        if (string != null) {
            string = string.trim();
        }
        if (string3 != null) {
            string3 = string3.trim();
        }
        if ((string == null || string.equals("") || string3 == null || string3.equals("")) && (object = System.getSecurityManager()) != null) {
            string5 = "Performing Java 2 Security Permission Check ...Expecting : " + perm.toString();
            SecurityLogger.debugMessage(string4, string5);
            ((SecurityManager)object).checkPermission((Permission)perm);
        }
        object = null;
        WSCredential wSCredential = null;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        this.r_name = null;
        this.s_name = null;
        this.p_name = null;
        this.p_word = null;
        this.a_data = null;
        if (byArray == null) {
            if (string != null) {
                this.s_name = new String(string.trim());
                if (this.s_name == null) {
                    throw new NO_MEMORY();
                }
            }
            if (string2 != null) {
                this.r_name = new String(string2.trim());
                if (this.r_name == null) {
                    throw new NO_MEMORY();
                }
            }
            if (string3 != null) {
                this.p_word = new String(string3);
                if (this.p_word == null) {
                    throw new NO_MEMORY();
                }
            }
            if (this.s_name == null && this.p_word == null) {
                String string6;
                String string7 = this._orb.getProperty("com.ibm.CORBA.BVTestPrincipalName");
                if (string7 != null && string7.length() > 0) {
                    this.s_name = new String(RealmSecurityName.getSecurityName(string7));
                    if (this.s_name == null) {
                        throw new NO_MEMORY();
                    }
                    this.r_name = new String(RealmSecurityName.getRealm(string7));
                    if (this.r_name == null) {
                        throw new NO_MEMORY();
                    }
                }
                if ((string6 = this._orb.getProperty("com.ibm.CORBA.BVTestPassword")) != null && string6.length() > 0) {
                    this.p_word = new String(string6);
                    if (this.p_word == null) {
                        throw new NO_MEMORY();
                    }
                }
            }
            if (SecurityLogger.debugTraceEnabled) {
                string5 = "s_name: " + this.s_name + ", p_word: " + SecurityConfiguration.mask(this.p_word) + ", r_name: " + this.r_name;
                SecurityLogger.debugMessage(string4, string5);
            }
            if (this.s_name == null || this.s_name.length() == 0 || this.p_word == null || this.p_word.length() == 0) {
                switch (this._loginSource) {
                    case 4: {
                        this.getEnvironmentLogin();
                        break;
                    }
                    case 3: {
                        this.getKeyFileLogin();
                        break;
                    }
                    case 1: {
                        try {
                            boolean bl2 = this.getPromptLogin();
                            if (bl2 && (this.s_name == null || this.s_name.length() == 0 || this.p_word == null || this.p_word.length() == 0)) {
                                throw new WSLoginFailedException("username and/or password is null");
                            }
                            break;
                        }
                        catch (WSLoginFailedException wSLoginFailedException) {
                            throw wSLoginFailedException;
                        }
                        catch (Throwable throwable) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string5 = "Error occurred with GUI prompt, logging in with console prompt.";
                                SecurityLogger.debugMessage(string4, string5);
                            }
                            this.getStdInLogin();
                            break;
                        }
                    }
                    case 5: {
                        this.getPropertiesLogin();
                        break;
                    }
                    case 6: {
                        this.getStdInLogin();
                        break;
                    }
                    case 7: {
                        if (this.s_name != null && this.s_name.length() != 0 && this.p_word != null && this.p_word.length() != 0) break;
                        return SubjectHelper.createUnauthenticatedSubject();
                    }
                }
            }
            if (SecurityLogger.debugTraceEnabled) {
                string5 = "Login source is " + SourceLocation.strings.get(new Integer(this._loginSource)) + ".";
                SecurityLogger.debugMessage(string4, string5);
            }
            this.p_name = RealmSecurityName.getRealmSecurityName(this.r_name, this.s_name);
            this.a_data = StringBytesConversion.getConvertedBytes(this.p_word);
        } else {
            this.a_data = byArray;
        }
        if (this.result == 3) {
            return SubjectHelper.createUnauthenticatedSubject();
        }
        if (this.a_data == null || this.a_data.length == 0) {
            string5 = SecurityMessages.getMsgOrUseDefault("JSAS0455A", "JSAS0455A: Unable to login principal, invalid authentication information.");
            SecurityLogger.logActivity(string4, 0, string5);
            throw new WSLoginFailedException(string5);
        }
        this.current().setAllowUnauthCredForAuthenticate(true);
        try {
            if (byArray == null) {
                object = contextManager.login(this.r_name, this.s_name, this.p_word);
                wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)object);
            } else {
                object = contextManager.login(this.r_name, this.a_data);
                wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)object);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1161", (Object)((Object)this));
            if (SecurityLogger.traceEnabled) {
                SecurityLogger.traceException(string4, exception, 0, 0);
            }
            object = null;
            if (exception instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)exception;
            }
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
        finally {
            this.current().setAllowUnauthCredForAuthenticate(false);
        }
        if (object == null) {
            string5 = "security.JSAS0240E";
            SecurityLogger.logError(string5, new Object[]{string4});
            string5 = SecurityMessages.getMsgOrUseDefault("JSAS0240E", "JSAS0240E: Login failed.  Verify the userid/password is correct.  Check the properties file to ensure the login source is valid.  If this error occurs on the server, check the server properties to ensure the principalName has a valid realm and userid.");
            throw new WSLoginFailedException(string5);
        }
        if (bl) {
            try {
                contextManager.setInvocationSubject((Subject)object);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", (String)"1294", (Object)((Object)this));
                string5 = "security.JSAS0054E";
                SecurityLogger.logError(string5, new Object[]{string4, exception});
                if (exception instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)exception;
                }
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        }
        if (!contextManager.processIsServer()) {
            this._vault.set_default_subject((Subject)object);
        }
        return object;
    }
}

