/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBasicAuthImpl;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.IExtendedSecurityReplaceablePriv.SessionEntry;
import com.ibm.IExtendedSecurityReplaceablePriv.SessionEntryHolder;
import com.ibm.IExtendedSecurityReplaceablePriv.VaultPackage.SessionDoesNotExist;
import com.ibm.IExtendedSecurityReplaceablePriv._OrbRequestHolder;
import com.ibm.IExtendedSecurityReplaceablePrivImpl.OrbRequestHolderImpl;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.RequestHolder;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectBasicAuthImpl.CredentialsImpl;
import com.ibm.ISecurityLocalObjectBasicAuthImpl.CredentialsPackage.CredentialsNotSet;
import com.ibm.ISecurityLocalObjectBasicAuthImpl.PrincipalAuthenticatorImpl;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.StringHolder;
import org.omg.IOP.ServiceContext;
import org.omg.Security.AssociationStatus;
import org.omg.Security.Attribute;
import org.omg.Security.AuthenticationStatus;
import org.omg.Security.DuplicateAttributeType;
import org.omg.Security.InvalidAttributeType;
import org.omg.Security.InvalidAuthnMethod;
import org.omg.Security.OpaqueHolder;
import org.omg.Security.QOP;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.CredentialsHolder;
import org.omg.SecurityLevel2.InvalidCredential;
import org.omg.SecurityLevel2.LoginFailed;

public class SecurityContextImpl
extends com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl {
    protected SecurityContextImpl() {
    }

    public SecurityContextImpl(VaultImpl vaultImpl, String string) {
        super(vaultImpl, string);
        this._mechanismType = "1.1";
    }

    public SecurityContextImpl(VaultImpl vaultImpl, String string, String string2) {
        super(vaultImpl, string);
        this._mechanismType = "5.6";
    }

    public AssociationStatus continue_security_context(byte[] byArray, OpaqueHolder opaqueHolder) {
        String string = "SecurityContextImpl.continue_security_context";
        String string2 = null;
        try {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "SecurityContext continued with vault " + this._vault + " on ORB " + this._orb + ".";
                SecurityLogger.debugMessage(string, string2);
            }
            SessionEntryHolder sessionEntryHolder = new SessionEntryHolder();
            try {
                this._vault.get_session(this._sessionHandle, sessionEntryHolder);
            }
            catch (SessionDoesNotExist sessionDoesNotExist) {
                FFDCFilter.processException((Throwable)sessionDoesNotExist, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.continue_security_context", (String)"200", (Object)((Object)this));
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Security Session does not exist.";
                    SecurityLogger.debugMessage(string, string2);
                }
                return AssociationStatus.SecAssocFailure;
            }
            SessionEntry sessionEntry = sessionEntryHolder.value;
            if (sessionEntry.entry_state == AssociationStatus.SecAssocSuccess) {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Security Association Success.";
                    SecurityLogger.debugMessage(string, string2);
                }
                return AssociationStatus.SecAssocSuccess;
            }
            if (sessionEntry.entry_state == AssociationStatus.SecAssocContinue) {
                sessionEntry.entry_state = AssociationStatus.SecAssocSuccess;
                try {
                    this._vault.update_session(this._sessionHandle, sessionEntry);
                }
                catch (SessionDoesNotExist sessionDoesNotExist) {
                    FFDCFilter.processException((Throwable)sessionDoesNotExist, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.continue_security_context", (String)"234", (Object)((Object)this));
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Security Session does not exist.";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    return AssociationStatus.SecAssocFailure;
                }
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Updated sessionEntry in SessionTable, Security Association Success.";
                    SecurityLogger.debugMessage(string, string2);
                }
                return AssociationStatus.SecAssocSuccess;
            }
            return AssociationStatus.SecAssocFailure;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.continue_security_context", (String)"261", (Object)((Object)this));
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0208E", "JSAS0208E: Internal error: system exception.  Take down all the error information and contact support for more assistance.");
            SecurityLogger.debugMessage(string, string2);
            if (SecurityLogger.traceEnabled) {
                SecurityLogger.traceException(string, throwable, 0, 0);
            }
            throw new INTERNAL("Unexpected Java Exception: " + throwable.toString());
        }
    }

    public void initialize(Credentials[] credentialsArray, byte[] byArray, byte[] byArray2, OpaqueHolder opaqueHolder) {
        String string = "SecurityContextImpl.initialize";
        String string2 = null;
        try {
            com.ibm.ISecurityLocalObjectBaseL13Impl.PrincipalAuthenticatorImpl principalAuthenticatorImpl;
            String string3;
            block35: {
                SecurityConfiguration securityConfiguration;
                block34: {
                    string3 = null;
                    principalAuthenticatorImpl = null;
                    SecurityContextImpl securityContextImpl = this;
                    securityConfiguration = securityContextImpl._vault.getSecurityConfiguration();
                    if (!securityConfiguration.SSLTypeIClientAssociationEnabled()) break block34;
                    switch (securityConfiguration.getauthenticationTarget()) {
                        case 4: {
                            string3 = "1.1";
                            principalAuthenticatorImpl = new PrincipalAuthenticatorImpl(this._vault);
                            break block35;
                        }
                        case 3: {
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "DCE security mechanism not supported.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                            this._contextState = 4;
                            this._principalAuthFailReason = (byte)101;
                            throw new NO_IMPLEMENT();
                        }
                        case 1: {
                            string3 = "1.1.1";
                            principalAuthenticatorImpl = new com.ibm.ISecurityLocalObjectLTPAImpl.PrincipalAuthenticatorImpl(this._vault);
                            break block35;
                        }
                        case 2: {
                            string3 = "1.1.2";
                            principalAuthenticatorImpl = new com.ibm.ISecurityLocalObjectLocalOSImpl.PrincipalAuthenticatorImpl(this._vault);
                            break block35;
                        }
                        default: {
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Invalid security mechanism.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                            this._contextState = 4;
                            this._principalAuthFailReason = (byte)12;
                            throw new BAD_PARAM();
                        }
                    }
                }
                switch (securityConfiguration.getauthenticationTarget()) {
                    case 4: {
                        string3 = "5.6";
                        principalAuthenticatorImpl = new PrincipalAuthenticatorImpl(this._vault);
                        break;
                    }
                    case 3: {
                        if (SecurityLogger.debugTraceEnabled) {
                            string2 = "DCE security mechanism not supported.";
                            SecurityLogger.debugMessage(string, string2);
                        }
                        this._contextState = 4;
                        this._principalAuthFailReason = (byte)101;
                        throw new NO_IMPLEMENT();
                    }
                    case 1: {
                        string3 = "5.3";
                        principalAuthenticatorImpl = new com.ibm.ISecurityLocalObjectLTPAImpl.PrincipalAuthenticatorImpl(this._vault);
                        break;
                    }
                    case 2: {
                        string3 = "5.4";
                        principalAuthenticatorImpl = new com.ibm.ISecurityLocalObjectLocalOSImpl.PrincipalAuthenticatorImpl(this._vault);
                        break;
                    }
                    default: {
                        if (SecurityLogger.debugTraceEnabled) {
                            string2 = "Invalid security mechanism.";
                            SecurityLogger.debugMessage(string, string2);
                        }
                        this._contextState = 4;
                        this._principalAuthFailReason = (byte)12;
                        throw new BAD_PARAM();
                    }
                }
            }
            int n = 0;
            Attribute[] attributeArray = null;
            CredentialsHolder credentialsHolder = new CredentialsHolder();
            OpaqueHolder opaqueHolder2 = new OpaqueHolder();
            OpaqueHolder opaqueHolder3 = new OpaqueHolder();
            CDRInputStream cDRInputStream = ORB.createCDRInputStream((ORB)this._orb, (byte[])byArray2, (int)byArray2.length);
            String string4 = null;
            try {
                string4 = cDRInputStream.read_string();
            }
            catch (MARSHAL mARSHAL) {
                FFDCFilter.processException((Throwable)mARSHAL, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.initialize", (String)"429", (Object)((Object)this));
                string2 = "security.JSAS0027E";
                SecurityLogger.logError(string2, new Object[]{string, mARSHAL});
                throw mARSHAL;
            }
            if (string4 == null || string4.length() < 1) {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Security name == NULL.";
                    SecurityLogger.debugMessage(string, string2);
                }
                this._contextState = 4;
                this._principalAuthFailReason = 1;
                return;
            }
            int n2 = cDRInputStream.read_ulong();
            byte[] byArray3 = new byte[n2];
            if (n2 > 0) {
                cDRInputStream.read_octet_array(byArray3, 0, n2);
            }
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Security name == " + string4 + ", authentication data == " + SecurityConfiguration.mask(StringBytesConversion.getConvertedString(byArray3)) + ".";
                SecurityLogger.debugMessage(string, string2);
            }
            AuthenticationStatus authenticationStatus = null;
            try {
                authenticationStatus = principalAuthenticatorImpl.authenticate(n, string4, byArray3, attributeArray, credentialsHolder, opaqueHolder2, opaqueHolder3);
            }
            catch (LoginFailed loginFailed) {
                FFDCFilter.processException((Throwable)loginFailed, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.initialize", (String)"477", (Object)((Object)this));
            }
            catch (InvalidAuthnMethod invalidAuthnMethod) {
                FFDCFilter.processException((Throwable)invalidAuthnMethod, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.initialize", (String)"482", (Object)((Object)this));
            }
            catch (InvalidAttributeType invalidAttributeType) {
                FFDCFilter.processException((Throwable)invalidAttributeType, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.initialize", (String)"487", (Object)((Object)this));
            }
            catch (DuplicateAttributeType duplicateAttributeType) {
                FFDCFilter.processException((Throwable)duplicateAttributeType, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.initialize", (String)"492", (Object)((Object)this));
            }
            if (authenticationStatus == AuthenticationStatus.SecAuthSuccess) {
                this._contextState = 3;
                this._principalAuthFailReason = (byte)100;
                this._clientCreds = credentialsHolder.value;
                this._targetCreds = credentialsArray[0];
                this._mechanismType = string3;
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Authentication success";
                    SecurityLogger.debugMessage(string, string2);
                }
            } else {
                this._contextState = 4;
                this._principalAuthFailReason = opaqueHolder3.value[0];
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Authentication Failed";
                    SecurityLogger.debugMessage(string, string2);
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.initialize", (String)"570", (Object)((Object)this));
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0208E", "JSAS0208E: Internal error: system exception.  Take down all the error information and contact support for more assistance.");
            SecurityLogger.debugMessage(string, string2);
            if (SecurityLogger.traceEnabled) {
                SecurityLogger.traceException(string, throwable, 0, 0);
            }
            throw new INTERNAL("Unexpected Java Exception: " + throwable.toString());
        }
    }

    public synchronized boolean preprotect_message(_OrbRequestHolder _OrbRequestHolder2, QOP qOP, OpaqueHolder opaqueHolder, OpaqueHolder opaqueHolder2) {
        String string = "SecurityContextImpl.preprotect_message";
        String string2 = null;
        try {
            byte[] byArray;
            block82: {
                DataOutputStream dataOutputStream;
                Object object;
                boolean bl;
                int n;
                int n2;
                byte[] byArray2;
                String string3;
                CDROutputStream cDROutputStream;
                byte[] byArray3;
                SessionEntry sessionEntry;
                RequestHolder requestHolder;
                block81: {
                    StringHolder stringHolder = new StringHolder();
                    OpaqueHolder opaqueHolder3 = new OpaqueHolder();
                    OrbRequestHolderImpl orbRequestHolderImpl = null;
                    orbRequestHolderImpl = (OrbRequestHolderImpl)_OrbRequestHolder2;
                    requestHolder = orbRequestHolderImpl.getRequestHolder();
                    SessionEntryHolder sessionEntryHolder = new SessionEntryHolder();
                    try {
                        this._vault.get_session(this._sessionHandle, sessionEntryHolder);
                    }
                    catch (SessionDoesNotExist sessionDoesNotExist) {
                        FFDCFilter.processException((Throwable)sessionDoesNotExist, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.preprotect_message", (String)"636", (Object)((Object)this));
                        if (SecurityLogger.debugTraceEnabled) {
                            string2 = "Session does not exist.";
                            SecurityLogger.debugMessage(string, string2);
                        }
                        return false;
                    }
                    sessionEntry = sessionEntryHolder.value;
                    if (sessionEntry.connection_type != 0) {
                        string2 = "security.JSAS0320E";
                        SecurityLogger.logError(string2, new Object[]{string});
                        opaqueHolder.value = null;
                        opaqueHolder2.value = null;
                        return false;
                    }
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Connection type found in session entry valid, SSL_connection";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    byArray3 = null;
                    cDROutputStream = ORB.createCDROutputStream(null);
                    cDROutputStream.putEndian();
                    try {
                        cDROutputStream.write_string(VaultConstants.SSL_MECH_TYPE);
                    }
                    catch (DATA_CONVERSION dATA_CONVERSION) {
                        FFDCFilter.processException((Throwable)dATA_CONVERSION, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.preprotect_message", (String)"677", (Object)((Object)this));
                        string2 = "security.JSAS0027E";
                        SecurityLogger.logError(string2, new Object[]{string, dATA_CONVERSION});
                        throw dATA_CONVERSION;
                    }
                    string3 = null;
                    byArray2 = null;
                    n2 = 0;
                    n = 0;
                    bl = true;
                    if (sessionEntry.entry_state == AssociationStatus.SecAssocContinue) {
                        if (sessionEntry.client_seq_num != 0) {
                            sessionEntry.client_seq_num = 0;
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Sequence number and session state mismatch, reseting the sequence number.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                        } else if (SecurityLogger.debugTraceEnabled) {
                            string2 = "Sequence number and sesson state match.  The client_seq_num is " + sessionEntry.client_seq_num;
                            SecurityLogger.debugMessage(string, string2);
                        }
                        object = null;
                        n = sessionEntry.client_seq_num++;
                        if (sessionEntry.client_credentials instanceof CredentialsImpl) {
                            object = (CredentialsImpl)sessionEntry.client_credentials;
                            try {
                                ((CredentialsImpl)object).get_credential_token(stringHolder, opaqueHolder3);
                                string3 = stringHolder.value;
                                byArray2 = opaqueHolder3.value;
                            }
                            catch (CredentialsNotSet credentialsNotSet) {
                                FFDCFilter.processException((Throwable)((Object)credentialsNotSet), (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.preprotect_message", (String)"741", (Object)((Object)this));
                                string2 = "security.JSAS0130E";
                                SecurityLogger.logError(string2, new Object[]{string, credentialsNotSet});
                            }
                        } else {
                            string2 = "security.JSAS0110E";
                            SecurityLogger.logError(string2, new Object[]{string});
                        }
                        dataOutputStream = new IntHolder(0);
                        try {
                            if ((sessionEntry.qop & 0x40) != 0 && object != null && ((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)object).is_valid((IntHolder)dataOutputStream)) {
                                if (SecurityLogger.debugTraceEnabled) {
                                    string2 = "Setting message type to ASSOC_MUTUAL_AUTHN.";
                                    SecurityLogger.debugMessage(string, string2);
                                }
                                n2 = 2;
                                break block81;
                            }
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Setting message type to ASSOC_TARGET_AUTHN, credentials == null or are invalid, entry.qop == " + sessionEntry.qop + ".";
                                SecurityLogger.debugMessage(string, string2);
                            }
                            n2 = 0;
                        }
                        catch (InvalidCredential invalidCredential) {
                            FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.preprotect_message", (String)"785", (Object)((Object)this));
                            if (SecurityLogger.traceEnabled) {
                                SecurityLogger.traceException(string, (Exception)((Object)invalidCredential), 0, 0);
                            }
                            n2 = 0;
                        }
                    } else if (sessionEntry.entry_state == AssociationStatus.SecAssocSuccess) {
                        if (sessionEntry.client_seq_num == 0) {
                            n2 = 4;
                            n = sessionEntry.target_seq_num++;
                            bl = false;
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Setting message type to ASSOC_ACCEPT.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                        } else {
                            n2 = 6;
                            n = sessionEntry.client_seq_num++;
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Setting message type to ASSOC_COMPLETE.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                        }
                    } else if (sessionEntry.entry_state == AssociationStatus.SecAssocFailure) {
                        if (sessionEntry.client_seq_num == 0) {
                            n2 = 5;
                            n = sessionEntry.target_seq_num++;
                            bl = false;
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Setting message type to ASSOC_REJECT.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                        } else {
                            n2 = 0;
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Session state set to SecAssocFailure, setting message type to ASSOC_TARGET_AUTHN.";
                                SecurityLogger.debugMessage(string, string2);
                            }
                        }
                    } else if (SecurityLogger.debugTraceEnabled) {
                        string2 = "entry.entry_state unknown";
                        SecurityLogger.debugMessage(string, string2);
                    }
                }
                cDROutputStream.write_octet((byte)n2);
                cDROutputStream.write_octet((byte)3);
                cDROutputStream.write_octet((byte)1);
                cDROutputStream.write_ulong(n);
                object = new ByteArrayOutputStream();
                dataOutputStream = new DataOutputStream((OutputStream)object);
                try {
                    dataOutputStream.writeBytes(sessionEntry.session_id);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.preprotect_message", (String)"887", (Object)((Object)this));
                    throw new INTERNAL("Java IOException writing the session id.");
                }
                byArray = ((ByteArrayOutputStream)object).toByteArray();
                cDROutputStream.write_ulong(byArray.length);
                cDROutputStream.write_octet_array(byArray, 0, byArray.length);
                try {
                    cDROutputStream.write_string(sessionEntry.target_host_name);
                }
                catch (DATA_CONVERSION dATA_CONVERSION) {
                    FFDCFilter.processException((Throwable)dATA_CONVERSION, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.preprotect_message", (String)"902", (Object)((Object)this));
                    string2 = "security.JSAS0027E";
                    SecurityLogger.logError(string2, new Object[]{string, dATA_CONVERSION});
                    throw dATA_CONVERSION;
                }
                if (n2 == 2) {
                    if (string3 == null) {
                        string3 = new String("");
                    }
                    try {
                        cDROutputStream.write_string(string3);
                    }
                    catch (DATA_CONVERSION dATA_CONVERSION) {
                        FFDCFilter.processException((Throwable)dATA_CONVERSION, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.preprotect_message", (String)"920", (Object)((Object)this));
                        string2 = "security.JSAS0027E";
                        SecurityLogger.logError(string2, new Object[]{string, dATA_CONVERSION});
                        throw dATA_CONVERSION;
                    }
                    String string4 = null;
                    string4 = byArray2 == null ? new String("") : StringBytesConversion.getConvertedString(byArray2);
                    try {
                        cDROutputStream.write_string(string4);
                    }
                    catch (DATA_CONVERSION dATA_CONVERSION) {
                        FFDCFilter.processException((Throwable)dATA_CONVERSION, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.preprotect_message", (String)"956", (Object)((Object)this));
                        string2 = "security.JSAS0027E";
                        SecurityLogger.logError(string2, new Object[]{string, dATA_CONVERSION});
                        throw dATA_CONVERSION;
                    }
                }
                if (n2 == 4) {
                    cDROutputStream.write_ulong(0);
                } else if (n2 == 5) {
                    byte by = 0;
                    switch (this._principalAuthFailReason) {
                        case 100: {
                            string2 = "Secure association was rejected, but the failure reason wasn't established.";
                            SecurityLogger.debugMessage(string, string2);
                            throw new INTERNAL(string2);
                        }
                        case 0: {
                            by = 7;
                            break;
                        }
                        case 5: {
                            by = 11;
                            break;
                        }
                        case 6: {
                            by = 13;
                            break;
                        }
                        case 1: {
                            by = 17;
                            break;
                        }
                        case 4: {
                            by = 22;
                            break;
                        }
                        case 9: {
                            by = 9;
                            break;
                        }
                        case 14: {
                            by = 10;
                            break;
                        }
                        case 17: {
                            by = 12;
                            break;
                        }
                        case 16: {
                            by = 14;
                            break;
                        }
                        case 7: {
                            by = 15;
                            break;
                        }
                        case 13: {
                            by = 18;
                            break;
                        }
                        case 10: {
                            by = 8;
                            break;
                        }
                        case 12: {
                            by = 16;
                            break;
                        }
                        case 101: {
                            by = 19;
                            break;
                        }
                        case 8: {
                            by = 20;
                            break;
                        }
                        case 3: {
                            by = 21;
                            break;
                        }
                        case 11: {
                            by = 23;
                            break;
                        }
                        default: {
                            string2 = "Secure association was rejected, but an undefined reason was reported.";
                            SecurityLogger.debugMessage(string, string2);
                            throw new INTERNAL(string2);
                        }
                    }
                    cDROutputStream.write_octet(by);
                } else if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Association message type unknown";
                    SecurityLogger.debugMessage(string, string2);
                }
                try {
                    this._vault.update_session(this._sessionHandle, sessionEntry);
                }
                catch (SessionDoesNotExist sessionDoesNotExist) {
                    FFDCFilter.processException((Throwable)sessionDoesNotExist, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.preprotect_message", (String)"1061", (Object)((Object)this));
                    string2 = "security.JSAS0060W";
                    SecurityLogger.logWarning(string2, new Object[]{string, sessionDoesNotExist});
                    return false;
                }
                byArray3 = cDROutputStream.toByteArray();
                try {
                    if (((com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl)sessionEntry.security_context).getSecServiceID() == 1229081868) {
                        ServiceContext serviceContext = new ServiceContext(1229081868, byArray3);
                        this.add_service_context(requestHolder, serviceContext, 1229081868, bl);
                        break block82;
                    }
                    if (((com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl)sessionEntry.security_context).getSecServiceID() == -2004318072) {
                        ServiceContext serviceContext = new ServiceContext(-2004318072, byArray3);
                        this.add_service_context(requestHolder, serviceContext, -2004318072, bl);
                        break block82;
                    }
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Cannot read the service context id from SecurityContext. Unable to build security context.";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    return false;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.preprotect_message", (String)"1196", (Object)((Object)this));
                    string2 = "security.JSAS0060W";
                    SecurityLogger.logError(string2, new Object[]{string, exception});
                    return false;
                }
            }
            opaqueHolder2.value = byArray;
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl.preprotect_message", (String)"1208", (Object)((Object)this));
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0208E", "JSAS0208E: Internal error: system exception.  Take down all the error information and contact support for more assistance.");
            SecurityLogger.debugMessage(string, string2);
            if (SecurityLogger.traceEnabled) {
                SecurityLogger.traceException(string, throwable, 0, 0);
            }
            throw new INTERNAL("Unexpected Java Exception: " + throwable.toString());
        }
    }
}

