/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectTokenBaseImpl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.websphere.security.auth.WSSecurityContextResult;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import javax.security.auth.Subject;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.Security.OpaqueHolder;
import org.omg.SecurityLevel2.CredentialsHolder;

public final class WSSecurityContextLTPAImpl
implements WSSecurityContext {
    private GSSFactory _gFactory = new GSSFactory("oid:2.23.130.1.1.1");
    private ORB _orb = null;
    private VaultImpl vault = VaultImpl.getInstance();
    private SecurityConfiguration secConfig = null;
    private MechanismFactory mechFactory = null;

    public WSSecurityContextLTPAImpl() {
        if (this.vault == null) {
            throw new INTERNAL("Vault is NULL.", 1229066420, CompletionStatus.COMPLETED_NO);
        }
        this._orb = this.vault.getORB();
        WSSecurityContextLTPAImpl wSSecurityContextLTPAImpl = this;
        this.secConfig = wSSecurityContextLTPAImpl.vault.getSecurityConfiguration();
        this.mechFactory = this.vault.getMechanismFactory();
    }

    public byte[] initSecContext(WSCredential wSCredential, String string, String string2) throws WSSecurityContextException {
        Subject subject = SubjectHelper.createSubjectFromWSCredential(wSCredential);
        return this.initSecContext(subject, string, string2);
    }

    public byte[] initSecContext(Subject subject, String string, String string2) throws WSSecurityContextException {
        String string3 = "";
        String string4 = "WSSecurityContextImpl.initSecContext";
        CSIUtil cSIUtil = new CSIUtil();
        OpaqueHolder opaqueHolder = new OpaqueHolder();
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        if (wSCredential != null) {
            try {
                opaqueHolder.value = wSCredential.getCredentialToken();
                byte[] byArray = null;
                if (wSCredential.getOID().compareTo("oid:2.23.130.1.1.1") == 0) {
                    if (SecurityLogger.traceEnabled) {
                        string3 = "Encountered GSSUP credential. Calling GSSUP.initSecContext()";
                        SecurityLogger.traceMessage(string4, string3);
                    }
                    WSSecurityContextImpl wSSecurityContextImpl = new WSSecurityContextImpl();
                    byArray = wSSecurityContextImpl.initSecContext(subject, string, string2);
                } else {
                    byArray = cSIUtil.create_gss_initial_context_token(wSCredential.getOID(), opaqueHolder);
                }
                if (SecurityLogger.traceEnabled) {
                    string3 = "Forming client_authentication_token in initSecContext using: username = " + wSCredential.getSecurityName() + ", server = " + string + ", realm = " + string2;
                    SecurityLogger.traceMessage(string4, string3);
                }
                return byArray;
            }
            catch (WSSecurityContextException wSSecurityContextException) {
                FFDCFilter.processException((Throwable)wSSecurityContextException, (String)"com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextLTPAImpl.initSecContext", (String)"138", (Object)this);
                string3 = "Error creating client_auth_token in initSecContext, reason: " + wSSecurityContextException.toString();
                SecurityLogger.logActivity(string4, 0, string3);
                throw wSSecurityContextException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextLTPAImpl.initSecContext", (String)"147", (Object)this);
                string3 = "Exception getting attributes from WSCredential.";
                SecurityLogger.logActivity(string4, 0, string3);
                return null;
            }
        }
        string3 = SecurityMessages.getMsgOrUseDefault("JSAS0020W", "JSAS0020W: Unable to get credentials.");
        if (SecurityLogger.traceEnabled) {
            SecurityLogger.traceMessage(string4, string3);
        }
        int n = 7;
        int n2 = 0;
        throw new WSSecurityContextException(n, n2, string4 + ": " + string3);
    }

    public WSSecurityContextResult acceptSecContext(byte[] byArray) throws WSSecurityContextException {
        Object object;
        String string = "";
        String string2 = "WSSecurityContextImpl.acceptSecContext";
        Object var4_4 = null;
        boolean bl = false;
        CSIUtil cSIUtil = new CSIUtil();
        Object var7_7 = null;
        CredentialsHolder credentialsHolder = new CredentialsHolder();
        OpaqueHolder opaqueHolder = new OpaqueHolder();
        OpaqueHolder opaqueHolder2 = new OpaqueHolder();
        OpaqueHolder opaqueHolder3 = new OpaqueHolder();
        byte[] byArray2 = new byte[]{100};
        Object var13_13 = null;
        try {
            object = GSSFactory.getMechOIDFromGSSToken(byArray);
            if (object == null) {
                WSSecurityContextImpl wSSecurityContextImpl = new WSSecurityContextImpl();
                return wSSecurityContextImpl.acceptSecContext(byArray);
            }
            cSIUtil.parse_gss_initial_context_token(byArray, opaqueHolder3);
        }
        catch (WSSecurityContextException wSSecurityContextException) {
            FFDCFilter.processException((Throwable)wSSecurityContextException, (String)"com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextLTPAImpl.acceptSecContext", (String)"181", (Object)this);
            string = "Error parsing client_auth_token in acceptSecContext, reason: " + wSSecurityContextException.toString();
            SecurityLogger.debugMessage(string2, string);
            throw wSSecurityContextException;
        }
        catch (GSSEncodeDecodeException gSSEncodeDecodeException) {
            FFDCFilter.processException((Throwable)gSSEncodeDecodeException, (String)"com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextLTPAImpl.acceptSecContext", (String)"214", (Object)this);
            string = "Error parsing client_auth_token in acceptSecContext, reason: " + gSSEncodeDecodeException.toString();
            SecurityLogger.debugMessage(string2, string);
            int n = 18;
            int n2 = 0;
            throw new WSSecurityContextException(n, n2, string);
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            FFDCFilter.processException((Throwable)bAD_OPERATION, (String)"com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextLTPAImpl.acceptSecContext", (String)"228", (Object)this);
            string = "Corba BAD_OPERATION exception occurred, reason: " + bAD_OPERATION.getMessage();
            SecurityLogger.debugMessage(string2, string);
            SecurityLogger.logException(string2, (Exception)((Object)bAD_OPERATION), 0, 0);
            int n = 14;
            int n3 = 0;
            throw new WSSecurityContextException(n, n3, string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextLTPAImpl.acceptSecContext", (String)"238", (Object)this);
            string = "Java exception occurred.";
            SecurityLogger.logException(string2, exception, 0, 0);
            int n = 13;
            int n4 = 0;
            throw new WSSecurityContextException(n, n4, string);
        }
        object = null;
        if (opaqueHolder3.value != null) {
            try {
                object = ContextManagerFactory.getInstance().login(RealmSecurityName.getRealm(this.secConfig.getprincipalName()), opaqueHolder3.value, this.secConfig.getRMIInboundLoginConfig(), null, null, null);
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "WSLoginFailedException occurred in acceptSecContext: " + wSLoginFailedException.getMessage();
                    SecurityLogger.debugMessage(string2, string);
                    SecurityLogger.logException(string2, wSLoginFailedException, 0, 0);
                }
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.acceptSecContext", (String)"309", (Object)this);
                throw new WSSecurityContextException(0, 0, wSLoginFailedException.getMessage(), wSLoginFailedException);
            }
            catch (Exception exception) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Exception occurred in acceptSecContext: " + exception.getMessage();
                    SecurityLogger.debugMessage(string2, string);
                    SecurityLogger.logException(string2, exception, 0, 0);
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.acceptSecContext", (String)"321", (Object)this);
                throw new WSSecurityContextException(0, 0, exception.getMessage(), exception);
            }
        } else {
            string = "Failed to parse the gss initial context token.";
            if (SecurityLogger.traceEnabled) {
                SecurityLogger.traceMessage(string2, string);
            }
            int n = 18;
            int n5 = 0;
            throw new WSSecurityContextException(n, n5, string);
        }
        if (object != null) {
            return new WSSecurityContextResult(null, (Subject)object);
        }
        int n = 4;
        int n6 = 0;
        string = "Validation failed in acceptSecContext, reason: Major[" + n + "], Minor[" + n6 + "], Message[" + "Subject is null, Token is probably expired." + "]";
        if (SecurityLogger.traceEnabled) {
            SecurityLogger.traceMessage(string2, string);
        }
        throw new WSSecurityContextException(n, n6, string);
    }

    public void completeSecContext(byte[] byArray) {
    }

    public void dispose() {
    }
}

