/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.SystemException;

public class ConfigURLProperties
extends Properties {
    private static TraceComponent tc = Tr.register((String)"SASRas", null, (String)"com.ibm.ISecurityL13SupportImpl.sec");
    protected Hashtable specifiers;
    public ORB _orb = null;
    private static ConfigURLProperties configURLProps = null;
    private static boolean securityEnabled = false;
    private static boolean serverSecurityEnabled = true;
    private static String securityProtocol = "ibm";

    public static ConfigURLProperties getInstance() {
        if (configURLProps == null) {
            configURLProps = new ConfigURLProperties();
        }
        return configURLProps;
    }

    public void init(String string, ORB oRB) {
        String string2;
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ConfigURLProperties.init", (Object)new Object[]{string});
        }
        this._orb = oRB;
        configURLProps = this;
        this.specifiers = new Hashtable();
        if (string != null) {
            this.loadPropertiesFile(string);
        }
        if ((string3 = this.getProperty("com.ibm.CORBA.securityEnabled")) != null && (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("yes"))) {
            securityEnabled = true;
        }
        serverSecurityEnabled = (string2 = this.getProperty("com.ibm.CORBA.serverSecurityEnabled")) == null ? securityEnabled : string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes");
        String string4 = this.getProperty("com.ibm.CSI.protocol");
        if (string4 != null) {
            if (string4.equalsIgnoreCase("csi")) {
                string4 = "csiv2";
            }
            if (string4.equalsIgnoreCase("sas")) {
                string4 = "ibm";
            }
            securityProtocol = string4.equalsIgnoreCase("ibm") ? "ibm" : (string4.equalsIgnoreCase("csiv2") ? "csiv2" : (string4.equalsIgnoreCase("both") ? "both" : "csiv2"));
        } else {
            securityProtocol = "csiv2";
        }
        this.dumpProperties();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ConfigURLProperties.init");
        }
    }

    protected void loadPropertiesFile(String string) throws SystemException {
        String string2;
        block17: {
            string2 = "ConfigURLProperties.loadPropertiesFile";
            String string3 = "";
            final String string4 = string;
            String string5 = "";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)string2, (Object)new Object[]{string4});
            }
            if (string4 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)string2);
                }
                return;
            }
            try {
                try {
                    AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            InputStream inputStream = null;
                            try {
                                URL uRL = new URL(string4);
                                inputStream = uRL.openStream();
                                ConfigURLProperties.this.load(inputStream);
                            }
                            catch (Exception exception) {
                                throw exception;
                            }
                            finally {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            return null;
                        }
                    });
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)string2);
                    }
                    return;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ISecurityUtilityImpl.ConfigURLProperties.loadPropertiesFile", (String)"174", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"security.JSAS0631E", (Object)new Object[]{string2, string, privilegedActionException});
                    string5 = this.validateURL(string);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.ConfigURLProperties.loadPropertiesFile", (String)"182", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"security.JSAS0631E", (Object)new Object[]{string2, string, exception});
                string5 = this.validateURL(string);
            }
            final String string6 = string5;
            Tr.debug((TraceComponent)tc, (String)("Retry URL = " + string6));
            try {
                try {
                    AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            InputStream inputStream = null;
                            try {
                                URL uRL = new URL(string6);
                                inputStream = uRL.openStream();
                                ConfigURLProperties.this.load(inputStream);
                            }
                            catch (Exception exception) {
                                throw exception;
                            }
                            finally {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ISecurityUtilityImpl.ConfigURLProperties.loadPropertiesFile", (String)"207", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.JSAS0629E", (Object)new Object[]{string2, string6, privilegedActionException});
                    throw privilegedActionException.getException();
                }
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ISecurityUtilityImpl.ConfigURLProperties.loadPropertiesFile", (String)"215", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.JSAS1478W");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)string2);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ISecurityUtilityImpl.ConfigURLProperties.loadPropertiesFile", (String)"221", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.JSAS1478W");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)string2);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.ConfigURLProperties.loadPropertiesFile", (String)"227", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.JSAS1478W");
                if (!tc.isEntryEnabled()) break block17;
                Tr.exit((TraceComponent)tc, (String)string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)string2);
        }
    }

    String validateURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Existing propertiesURL: " + string));
        }
        int n = 0;
        for (int i = string.indexOf(58, 0) + 1; i < string.length(); ++i) {
            if (string.charAt(i) == '/' || string.charAt(i) == '\\') continue;
            n = i;
            break;
        }
        stringBuffer.append("file:/");
        stringBuffer.append(string.substring(n));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("New propertiesURL: " + stringBuffer.toString()));
        }
        return stringBuffer.toString();
    }

    public String getProperty(String string) {
        String string2 = string;
        String string3 = this._orb.getProperty(string);
        if (string3 == null || string3.equals("")) {
            string3 = System.getProperty(string2);
        }
        if (string3 == null || string3.equals("")) {
            string3 = super.getProperty(string);
        }
        return string3;
    }

    public static boolean isSecurityEnabled() {
        return securityEnabled;
    }

    public static boolean isServerSecurityEnabled() {
        return serverSecurityEnabled;
    }

    public static String getSecurityProtocol() {
        return securityProtocol;
    }

    public void dumpProperties() {
        if (this.size() > 0) {
            Tr.debug((TraceComponent)tc, (String)"Printing ConfigURLProperties...");
            Enumeration<?> enumeration = this.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = this.getProperty(string);
                if (string.endsWith("Password")) {
                    String string3 = "ConfigURLProperties.dumpProperties";
                    String string4 = "";
                    try {
                        PasswordUtil.decode((String)string2);
                    }
                    catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                        string2 = SecurityConfiguration.mask(string2);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.ConfigURLProperties.dumpProperties", (String)"365", (Object)this);
                        string4 = "security.JSAS0486E";
                        SecurityLogger.logError(string4, new Object[]{string3, exception});
                    }
                }
                Tr.debug((TraceComponent)tc, (String)(string + " = " + string2));
            }
        }
    }
}

