/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import java.util.Vector;

public class SecurityAttributeList {
    private static final byte[] emptyByteArray = new byte[0];
    private static final String[] emptyStringArray = new String[0];

    private SecurityAttributeList() {
    }

    public static byte[] getAttributeByteArray(String[] stringArray) {
        int n = 2;
        int n2 = 0;
        int n3 = stringArray.length > 65535 ? 65535 : stringArray.length;
        Vector<byte[]> vector = new Vector<byte[]>(n3);
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = new byte[2];
        if (stringArray.length > 65535) {
            SecurityLogger.debugMessage("SecurityAttributeList.getAttibuteByteArray", "64K or more strings to convert.  Converting first 64K-1 strings.");
        }
        if (stringArray != null) {
            if (n3 == 0) {
                byArray = emptyByteArray;
            } else {
                int n4;
                for (n4 = 0; n4 < n3; ++n4) {
                    byte[] byArray5 = StringBytesConversion.getConvertedBytes(stringArray[n4]);
                    if (byArray5.length > 65535) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Group name exceeded 64K in size. First 20 characters are: ");
                        stringBuffer.append(stringArray[n4].substring(20));
                        byArray5 = StringBytesConversion.getConvertedBytes(stringBuffer.toString());
                        SecurityLogger.debugMessage("SecurityAttributeList.getAttibuteByteArray", stringBuffer.toString());
                    }
                    vector.addElement(byArray5);
                    n += 2 + byArray5.length;
                }
                byArray = new byte[n];
                n2 = SecurityAttributeList.arrayInsert(SecurityAttributeList.intToBytePair(n3, byArray4), byArray, n2);
                for (n4 = 0; n4 < n3; ++n4) {
                    byArray2 = (byte[])vector.elementAt(n4);
                    byArray3 = SecurityAttributeList.intToBytePair(byArray2.length, byArray4);
                    n2 = SecurityAttributeList.arrayInsert(byArray3, byArray, n2);
                    n2 = SecurityAttributeList.arrayInsert(byArray2, byArray, n2);
                }
            }
        }
        return byArray;
    }

    public static String[] getAttributeStringArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String[] stringArray = null;
        if (byArray != null) {
            if (byArray.length == 0) {
                stringArray = emptyStringArray;
            } else {
                int n = 0;
                int n2 = SecurityAttributeList.bytePairToInt(SecurityAttributeList.getSubArray(byArray, n, 2));
                n += 2;
                stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    int n3 = SecurityAttributeList.bytePairToInt(SecurityAttributeList.getSubArray(byArray, n, 2));
                    byte[] byArray2 = SecurityAttributeList.getSubArray(byArray, n += 2, n3);
                    n += n3;
                    stringArray[i] = StringBytesConversion.getConvertedString(byArray2);
                }
            }
        }
        return stringArray;
    }

    private static int bytePairToInt(byte[] byArray) {
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    private static byte[] intToBytePair(int n, byte[] byArray) {
        byArray[0] = (byte)((n & 0xFF00) >> 8);
        byArray[1] = (byte)(n & 0xFF);
        return byArray;
    }

    private static int arrayInsert(byte[] byArray, byte[] byArray2, int n) {
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        return n + byArray.length;
    }

    private static byte[] getSubArray(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    private static String getFormattedStringArrayDump(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("Num Strings ");
        stringBuffer.append(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("\n[");
            stringBuffer.append(i);
            stringBuffer.append("] ");
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }
}

