/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.ws.ffdc.FFDCFilter;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public final class WSSecurityContextFactory {
    private VaultImpl vault = null;
    private SecurityConfiguration sConfig = null;
    private String configuredOID = null;

    public static WSSecurityContextFactory getInstance() {
        return new WSSecurityContextFactory();
    }

    public WSSecurityContext createContext(String string) {
        String string2 = "";
        String string3 = "WSSecurityContextFactory.createContext";
        if (this.verifyOid(string)) {
            if (OID.compareOIDs(string, this.sConfig.getWSSecurityContextActiveOID())) {
                try {
                    Class<?> clazz = Class.forName(this.sConfig.getWSSecurityContextActiveClass());
                    Object obj = clazz.newInstance();
                    WSSecurityContext wSSecurityContext = null;
                    wSSecurityContext = (WSSecurityContext)obj;
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Instantiating WSSecurityContext instance: " + this.sConfig.getWSSecurityContextActiveClass();
                        SecurityLogger.debugMessage(string3, string2);
                    }
                    return wSSecurityContext;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.WSSecurityContextFactory.createContext", (String)"76", (Object)this);
                    string2 = "security.JSAS0624E";
                    SecurityLogger.logError(string2, new Object[]{string3, this.sConfig.getWSSecurityContextActiveClass(), exception.toString(), exception});
                    return null;
                }
            }
            if (OID.compareOIDs(string, "oid:2.23.130.1.1.1")) {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Instantiating GSSUP WSSecurityContext instance: com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl";
                    SecurityLogger.debugMessage(string3, string2);
                }
                return new WSSecurityContextImpl();
            }
            string2 = "JSAS0625E: Cannot instantiate WSSecurityContext instance for OID: " + string;
            SecurityLogger.debugMessage(string3, string2);
            return null;
        }
        return null;
    }

    private WSSecurityContextFactory() {
        String string = "";
        String string2 = "WSSecurityContextFactory.constructor";
        this.vault = VaultImpl.getInstance();
        if (this.vault == null) {
            string = "security.JSAS0010E";
            SecurityLogger.logError(string, new Object[]{string2});
            throw new INTERNAL(string2 + ": " + "JSAS0010E: Null reference to the vault.", 1229066420, CompletionStatus.COMPLETED_NO);
        }
        WSSecurityContextFactory wSSecurityContextFactory = this;
        this.sConfig = wSSecurityContextFactory.vault.getSecurityConfiguration();
        this.configuredOID = this.vault.getAuthenticationTarget().authTargetToOid(this.sConfig.getauthenticationTarget());
    }

    private boolean verifyOid(String string) {
        String string2 = "";
        String string3 = "WSSecurityContextFactory.verifyOid";
        if (OID.compareOIDs(string, "oid:2.23.130.1.1.1")) {
            return true;
        }
        if (OID.compareOIDs(string, this.configuredOID)) {
            return true;
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "security.JSAS0626E";
            SecurityLogger.logError(string2, new Object[]{string3, string, this.configuredOID});
        }
        return false;
    }
}

