/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth.callback;

import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSLoginHelperImpl;
import com.ibm.ws.security.common.auth.util.WSStdinLoginPrompt;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class WSStdinCallbackHandlerImpl
implements CallbackHandler {
    private static final String realmNamePrompt = SecurityMessages.getMsgOrUseDefault("RealmName", "Realm (Cell) Name");
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static int stdinRetry = 0;
    private String userName = "";
    private String password = "";
    private String realmName = "";
    private String userNamePrompt = "";
    private String passwordPrompt = "";
    private boolean passwordEcho = false;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$websphere$security$auth$callback$WSStdinCallbackHandlerImpl == null ? (class$com$ibm$websphere$security$auth$callback$WSStdinCallbackHandlerImpl = WSStdinCallbackHandlerImpl.class$("com.ibm.websphere.security.auth.callback.WSStdinCallbackHandlerImpl")) : class$com$ibm$websphere$security$auth$callback$WSStdinCallbackHandlerImpl), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$websphere$security$auth$callback$WSStdinCallbackHandlerImpl;

    public WSStdinCallbackHandlerImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WSStdinCallbackHandlerImpl()");
        }
        this.realmName = WSLoginHelperImpl.getDefaultRealmName();
        if (this.realmName == null || this.realmName.length() == 0) {
            this.realmName = "<default>";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Realm Name: " + this.realmName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSStdinCallbackHandlerImpl()");
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        Object object;
        int n;
        int n2 = 0;
        if (callbackArray == null || (n2 = callbackArray.length) == 0) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handle(callbacks)");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(callbackArray[i].getClass().getName());
                if (i >= n2 - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
            Tr.entry((TraceComponent)tc, (String)("handle(callbacks = \"" + stringBuffer.toString() + "\")"));
        }
        for (n = 0; n < n2; ++n) {
            Callback callback = callbackArray[n];
            if (callback instanceof NameCallback) {
                this.userNamePrompt = ((NameCallback)callback).getPrompt();
                this.userName = ((NameCallback)callback).getDefaultName();
                continue;
            }
            if (callback instanceof PasswordCallback) {
                this.passwordPrompt = ((PasswordCallback)callback).getPrompt();
                this.passwordEcho = ((PasswordCallback)callback).isEchoOn();
                continue;
            }
            if (!(callback instanceof WSRealmNameCallbackImpl)) continue;
            this.realmName = ((WSRealmNameCallbackImpl)callback).getRealmName();
            if (this.realmName != null && !this.realmName.equals("")) continue;
            this.realmName = ((WSRealmNameCallbackImpl)callback).getDefaultRealmName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Realm Name: " + this.realmName));
        }
        String[] stringArray = null;
        try {
            if (stdinRetry < 1) {
                System.out.print(realmNamePrompt + ": " + this.realmName + NEW_LINE);
                System.out.flush();
                object = new WSStdinLoginPrompt(this.userNamePrompt, this.passwordPrompt);
                stringArray = ((WSStdinLoginPrompt)object).getUidAndPassword();
                if (stringArray != null) {
                    this.password = stringArray[1];
                    this.userName = RealmSecurityName.getSecurityName(stringArray[0]);
                    stdinRetry = 0;
                } else {
                    ++stdinRetry;
                    this.userName = null;
                    this.password = null;
                }
            } else {
                stdinRetry = 0;
                this.userName = null;
                this.password = null;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.security.auth.callback.WSStdinCallbackHandlerImpl.handle", (String)"197", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.jaas.SystemInputError", (Object)new Object[]{exception});
        }
        for (n = 0; n < n2; ++n) {
            object = callbackArray[n];
            if (object instanceof NameCallback) {
                ((NameCallback)object).setName(this.userName);
                continue;
            }
            if (object instanceof PasswordCallback) {
                ((PasswordCallback)object).setPassword(this.password == null ? new char[]{} : this.password.toCharArray());
                continue;
            }
            if (object instanceof WSRealmNameCallbackImpl || object instanceof WSCredTokenCallbackImpl) continue;
            throw new UnsupportedCallbackException((Callback)object, "Unsupported callback");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handle(callbacks)");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

