/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.PrincipalAuthenticatorImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectBasicAuthImpl.CredentialsImpl;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.CredentialsHelper;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.SecurityServer;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.JaasLoginHelper;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.omg.SecurityLevel2.Credentials;

public class ContextManagerImpl
implements ContextManager {
    private boolean serverSecurityEnabled = true;
    private static boolean enableSyncOSThread = false;
    private String regionUserid = "";
    private String DefaultSAFRealm = "";
    private static final String DEFAULT_REALM = "<default>";
    private static final String EMPTY = "";
    private String SECURITY_REALM = "";
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final WebSphereRuntimePermission GET_SERVER_CRED_PERM = new WebSphereRuntimePermission("ContextManager.getServerCredential");
    private CurrentImpl current = null;
    private Credentials[] creds = null;
    private ORB theORB = null;
    private SecurityServer securityServer = null;
    private WSCredential serverBACred = null;
    private WSCredential serverTokenCred = null;
    private Subject serverSubject = null;
    private VaultImpl vault = null;
    private SecurityConfiguration secConfig = null;
    private SecurityCache cache = null;
    private static ServerCredSigner scs = null;
    private JaasLoginHelper jaasLoginHelper = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$auth$ContextManagerImpl == null ? (class$com$ibm$ws$security$auth$ContextManagerImpl = ContextManagerImpl.class$("com.ibm.ws.security.auth.ContextManagerImpl")) : class$com$ibm$ws$security$auth$ContextManagerImpl), null, (String)"com.ibm.ejs.resources.security");
    private static final String FACTORY_CLASS = "com.ibm.ws.security.auth.AuthCache";
    private Class _authCacheClass = null;
    private Method _authCacheGetInstanceMethod = null;
    private static final String SECURITY_SERVER_IMPL_CLASS = "com.ibm.ws.security.server.SecurityServerImpl";
    private Class _securityServerImplClass = null;
    private Method _getRegistryMethod = null;
    private static final String SECURITY_SERVER_FACTORY_CLASS = "com.ibm.ws.security.server.SecurityServerFactory";
    private Class _securityServerFactoryClass = null;
    private Method _getSecurityServerCreateMethod = null;
    private Object _registryObject = null;
    private WSCredentialTokenMapperInterface wsCredTokenMapper = null;
    private static String URL_HANDLER_PROP = "java.protocol.handler.pkgs";
    private static final String PKGNAME_DELIMITER = "|";
    static /* synthetic */ Class class$com$ibm$ws$security$auth$ContextManagerImpl;
    static /* synthetic */ Class class$com$ibm$websphere$security$cred$WSCredential;
    static /* synthetic */ Class class$com$ibm$ws$security$server$SecurityServer;
    static /* synthetic */ Class class$java$lang$String;

    public ContextManagerImpl() throws WSSecurityException {
        this.init();
    }

    private void init() throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                Method method;
                this.vault = VaultImpl.getInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"init(): VaultImpl instance: ", (Object)this.vault);
                }
                if (this.vault != null) {
                    scs = ServerCredSigner.getInstance();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"init(): Server cred signer instance: ", (Object)scs);
                    }
                    ContextManagerImpl contextManagerImpl = this;
                    this.secConfig = contextManagerImpl.vault.getSecurityConfiguration();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"init(): Security configuration instance: ", (Object)this.secConfig);
                    }
                    this.current = this.vault.getCurrent();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"init(): CurrentImpl instance: ", (Object)((Object)this.current));
                    }
                    this.theORB = this.vault.getORB();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"init(): ORB instance: ", (Object)this.theORB);
                    }
                } else {
                    throw new WSSecurityException("Vault is null during ContextManager initialization");
                }
                if (this.secConfig == null) {
                    throw new WSSecurityException("Security Configuration is null");
                }
                if (this.getCurrent() == null) {
                    throw new WSSecurityException("Security Current is null");
                }
                if (this.secConfig.processIsServer() && (method = this.getAuthCacheGetInstanceMethod()) != null) {
                    this.cache = (SecurityCache)method.invoke(null, null);
                }
            }
            catch (WSSecurityException wSSecurityException) {
                throw wSSecurityException;
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException.getTargetException(), (String)((class$com$ibm$ws$security$auth$ContextManagerImpl == null ? (class$com$ibm$ws$security$auth$ContextManagerImpl = ContextManagerImpl.class$("com.ibm.ws.security.auth.ContextManagerImpl")) : class$com$ibm$ws$security$auth$ContextManagerImpl).getName() + ".init()"), (String)"215", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed in getting AuthCache, reflection call failed", (Object)invocationTargetException.getTargetException());
                }
                throw new WSSecurityException(invocationTargetException.getMessage(), invocationTargetException);
            }
            catch (Exception exception) {
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public void initialize(Object object) throws WSSecurityException {
        if (this.creds != null || !this.isCellSecurityEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        if (object == null) {
            throw new WSSecurityException("Excepting Boolean, but null is passed in");
        }
        if (!(object instanceof Boolean)) {
            throw new WSSecurityException("Excepting Boolean, but " + object.getClass().getName() + " is passed in");
        }
        boolean bl = (Boolean)object;
        try {
            Method method;
            PrincipalAuthenticatorImpl.enableSecurity(bl);
            this.serverBACred = this.createBasicAuthCredential(this.getDefaultRealm(), this.secConfig.getloginUserid(), this.secConfig.getloginPassword());
            Credentials credentials = CredentialsHelper.mapWSToCorba(this.serverBACred);
            this.creds = new Credentials[]{credentials};
            if (credentials instanceof CredentialsImpl) {
                credentials = ((CredentialsImpl)credentials).get_mapped_credentials(null, EMPTY, null);
            }
            if ((method = this.getSecurityServerCreateMethod()) != null) {
                method.invoke(null, null);
            }
            Subject subject = this.getServerSubject();
            this.serverTokenCred = SubjectHelper.getWSCredentialFromSubject(subject);
            this.setOwnSubject(subject);
            this.setCallerSubject(subject);
            this.setInvocationSubject(subject);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.enable", (String)"193");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)EMPTY, (Object)exception);
            }
            this.current = null;
            throw new WSSecurityException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public boolean processIsServer() {
        if (this.isCellSecurityEnabled() && this.secConfig != null) {
            return this.secConfig.processIsServer();
        }
        return false;
    }

    public String getSecurityServerHost() {
        if (this.isCellSecurityEnabled() && this.secConfig != null) {
            return this.secConfig.getSecurityServerHost();
        }
        return EMPTY;
    }

    public String getSecurityServerPort() {
        if (this.isCellSecurityEnabled() && this.secConfig != null) {
            return this.secConfig.getSecurityServerPort();
        }
        return EMPTY;
    }

    public String getSpecificSecurityServerHost() {
        if (this.isCellSecurityEnabled() && this.getCurrent() != null) {
            return this.getCurrent().getAllHosts();
        }
        return EMPTY;
    }

    public String getSpecificSecurityServerPort() {
        if (this.isCellSecurityEnabled() && this.getCurrent() != null) {
            return this.getCurrent().getAllPorts();
        }
        return EMPTY;
    }

    public String getProperty(String string) {
        if (this.theORB != null) {
            return this.theORB.getProperty(string);
        }
        return null;
    }

    public String getProperty(String string, String string2) {
        if (this.theORB != null) {
            String string3 = this.theORB.getProperty(string);
            if (string3 == null || string3.length() == 0) {
                string3 = string2;
            }
            return string3;
        }
        return null;
    }

    public PropagationToken setPropagationToken(String string, PropagationToken propagationToken) throws WSSecurityException {
        if (string == null || propagationToken == null) {
            throw new WSSecurityException("Invalid null parameters.");
        }
        if (this.getCurrent() != null) {
            return this.getCurrent().setPropagationToken(string, propagationToken);
        }
        return null;
    }

    public PropagationToken getPropagationToken(String string) throws WSSecurityException {
        if (string == null) {
            throw new WSSecurityException("Invalid null parameters.");
        }
        if (this.getCurrent() != null) {
            return this.getCurrent().getPropagationToken(string);
        }
        return null;
    }

    public Map getPropagationTokens() {
        if (this.getCurrent() != null) {
            return this.getCurrent().getPropagationTokens();
        }
        return null;
    }

    public PropagationToken createPropagationToken(Subject subject) throws WSSecurityException {
        WSCredentialTokenMapperInterface wSCredentialTokenMapperInterface = null;
        try {
            wSCredentialTokenMapperInterface = this.getWSCredTokenMapper();
            if (wSCredentialTokenMapperInterface != null && subject != null) {
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                return wSCredentialTokenMapperInterface.createPropagationTokenFromWSCredential(wSCredential);
            }
            if (wSCredentialTokenMapperInterface != null && subject == null) {
                return wSCredentialTokenMapperInterface.createPropagationTokenBeforeAuthenticatedCallerSet();
            }
            throw new WSSecurityException("Could not instantiate WSCredTokenMapper.");
        }
        catch (WSSecurityException wSSecurityException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WSSecurityException creating propagation token.");
            }
            throw wSSecurityException;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception creating propagation token.");
            }
            throw new WSSecurityException(exception.getMessage(), exception);
        }
    }

    public Subject getUnauthenticatedSubject() throws WSSecurityException {
        return SubjectHelper.createSubjectFromWSCredential(this.getUnauthenticatedCredential());
    }

    public Subject createUnauthenticatedSubject() throws WSSecurityException {
        return SubjectHelper.createUnauthenticatedSubject();
    }

    public String getUnauthenticatedString() {
        return "UNAUTHENTICATED";
    }

    public WSCredential getUnauthenticatedCredential() throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            Credentials credentials = this.getCurrent().get_unauthenticated_credential();
            if (credentials instanceof com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl) {
                return CredentialsHelper.mapCorbaToWS((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)credentials);
            }
            throw new WSSecurityException("CORBA credentials is not an instance com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl");
        }
        return null;
    }

    public List getRealms() {
        List list = null;
        try {
            list = this.getSecurityServer().getRealms();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getRealms", (String)"491", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception during getRealms(): ", (Object)new Object[]{exception});
            }
            list = null;
        }
        return list;
    }

    public UserRegistry getRegistry(String string) {
        UserRegistry userRegistry = null;
        try {
            userRegistry = this.getSecurityServer().getRegistry(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getRegistry", (String)"510", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception during getRegistry(): ", (Object)new Object[]{exception});
            }
            userRegistry = null;
        }
        return userRegistry;
    }

    public String getDefaultRealm() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultRealmName()");
        }
        if (this.isCellSecurityEnabled()) {
            if (this.SECURITY_REALM == null || this.SECURITY_REALM.length() == 0) {
                String string = this.getProperty("com.ibm.CORBA.principalName");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Security name = " + string));
                }
                this.SECURITY_REALM = RealmSecurityName.getRealm(string);
                if (this.SECURITY_REALM == null || this.SECURITY_REALM.length() == 0) {
                    this.SECURITY_REALM = DEFAULT_REALM;
                }
            } else if (this.SECURITY_REALM != null && this.SECURITY_REALM.equals(DEFAULT_REALM) && this.secConfig != null && this.secConfig.processIsServer()) {
                String string = this.getProperty("com.ibm.CORBA.principalName");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Security name = " + string));
                }
                this.SECURITY_REALM = RealmSecurityName.getRealm(string);
                if (this.SECURITY_REALM == null || this.SECURITY_REALM.length() == 0) {
                    this.SECURITY_REALM = DEFAULT_REALM;
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security is disabled, default realm name will be returned");
            }
            this.SECURITY_REALM = DEFAULT_REALM;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getDefaultRealmName() -> " + this.SECURITY_REALM));
        }
        return this.SECURITY_REALM;
    }

    public boolean isServerSubject(Subject subject) throws WSSecurityException {
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        return scs.isServerCred(wSCredential);
    }

    public boolean isWSSubject(Subject subject) throws WSSecurityException {
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        return scs.isWSCred(wSCredential);
    }

    public boolean isServerCred(WSCredential wSCredential) throws WSSecurityException {
        return scs.isServerCred(wSCredential);
    }

    public boolean isWSCred(WSCredential wSCredential) throws WSSecurityException {
        return scs.isWSCred(wSCredential);
    }

    public Subject login(WSCredential wSCredential) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login(credential)");
        }
        if (this.isCellSecurityEnabled() && wSCredential != null) {
            this.checkAuthRetryForThread();
            try {
                if (wSCredential.isBasicAuth()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"authenticating userid/password credential.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"login(credential)");
                    }
                    return this.login(wSCredential.getRealmName(), wSCredential.getSecurityName(), StringBytesConversion.getConvertedString(wSCredential.getCredentialToken()));
                }
                if (wSCredential.isCurrent()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"login(credential)");
                    }
                    return SubjectHelper.createSubjectFromWSCredential(wSCredential);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Credential is not current.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(credential)");
                }
                throw new WSLoginFailedException("Credential is not current.");
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.ContextManagerImpl.login", (String)"638", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WSLoginFailedException occurred.", (Object)new Object[]{wSLoginFailedException});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(credential)");
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.login", (String)"645", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"authenticate failed: ", (Object)this.dump(exception));
                }
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(credential)");
                }
                throw wSLoginFailedException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(credential)");
        }
        return null;
    }

    public Subject login(String string, String string2) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("login(realm, user) -> login(" + string + ", " + string2 + ")"));
        }
        Subject subject = this.login(string, string2, null, null, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(realm, user)");
        }
        return subject;
    }

    public Subject login(String string, String string2, String string3, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) throws WSLoginFailedException {
        return this.login(string, string2, string3, httpServletRequest, httpServletResponse, map, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Subject login(String string, String string2, String string3, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, Subject subject) throws WSLoginFailedException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("login(realm, user, auth_mech) -> login(" + string + ", " + string2 + ", " + string3 + ")"));
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + MAP_CREDENTIAL.toString()));
            }
            securityManager.checkPermission((Permission)MAP_CREDENTIAL);
        }
        if (this.isCellSecurityEnabled()) {
            if (this.secConfig == null || !this.secConfig.processIsServer()) {
                return null;
            }
            this.checkAuthRetryForThread();
            Subject subject2 = null;
            Object object = null;
            try {
                block37: {
                    if (subject != null) {
                        object = this.getWSCredTokenMapper().getCacheKeyFromHashtable(subject);
                        if (object != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Looking for Subject using cacheKey (" + object + ") from hashtable."));
                            }
                            subject2 = object instanceof byte[] ? this.cache.getSubject((byte[])object) : this.cache.getSubject(object);
                        }
                        if (subject2 != null && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Found Subject using TAI cacheKey.");
                        }
                    }
                    ArrayList arrayList = null;
                    if (subject2 == null && (this.secConfig.isRMIInboundPropagationEnabled() || this.secConfig.isRMIOutboundPropagationEnabled() || this.secConfig.isWebInboundPropagationEnabled())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Looking for opaque token in thread before doing Subject lookup.");
                        }
                        arrayList = (ArrayList)this.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup());
                    }
                    if (subject2 == null && arrayList == null && !this.getWSCredTokenMapper().subjectContainsLoginHashtable(subject)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Looking for Subject using realm:user.");
                        }
                        subject2 = this.cache.getSubject(string, string2);
                    }
                    if (subject2 != null) {
                        try {
                            WSCredential wSCredential = (WSCredential)subject2.getPublicCredentials(class$com$ibm$websphere$security$cred$WSCredential == null ? (class$com$ibm$websphere$security$cred$WSCredential = ContextManagerImpl.class$("com.ibm.websphere.security.cred.WSCredential")) : class$com$ibm$websphere$security$cred$WSCredential).iterator().next();
                            if (wSCredential != null) {
                                boolean bl = wSCredential.isDestroyed();
                                boolean bl2 = wSCredential.isForwardable();
                                long l = wSCredential.getExpiration() - System.currentTimeMillis() - this.cache.getCushion();
                                if (tc.isDebugEnabled()) {
                                    if (bl2) {
                                        Tr.debug((TraceComponent)tc, (String)("login(realm, user, password, . . .): time remaining = " + l + " millis"));
                                    } else {
                                        Tr.debug((TraceComponent)tc, (String)"login(realm, user, password, . . .): time remaining = no expiration");
                                    }
                                }
                                if (bl || bl2 && l <= 0L) {
                                    this.cache.removeEntry(string, string2);
                                    subject2 = null;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Credential has expired or is destroyed, logging in again.");
                                    }
                                    break block37;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"login(realm, user,  . . .)");
                                }
                                return subject2;
                            }
                            subject2 = null;
                        }
                        catch (CredentialDestroyedException credentialDestroyedException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Credential is destroyed.", (Object)new Object[]{credentialDestroyedException});
                            }
                            subject2 = null;
                        }
                        catch (CredentialExpiredException credentialExpiredException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Credential has expired.", (Object)new Object[]{credentialExpiredException});
                            }
                            subject2 = null;
                        }
                    }
                }
                if (subject2 == null) {
                    subject2 = string3 == null ? this.getJaasLoginHelper().jaas_login(string, string2, null, subject) : (httpServletRequest == null ? this.getJaasLoginHelper().jaas_login(string, string2, null, string3, subject) : this.getJaasLoginHelper().jaas_login(string, string2, null, string3, httpServletRequest, httpServletResponse, map, subject));
                    if (this.secConfig.isWebInboundPropagationEnabled() && string3 != null && string3.equals(this.secConfig.getWebInboundLoginConfig())) {
                        this.processSubjectForPropagationAfterLogin(subject2);
                    }
                    this.cache.insert(subject2);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, . . .)");
                }
                return subject2;
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.ContextManagerImpl.login", (String)"820", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + wSLoginFailedException));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, . . .)");
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.login", (String)"827", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + this.dump(exception)));
                }
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, . . .)");
                }
                throw wSLoginFailedException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(realm, user, . . .)");
        }
        return null;
    }

    public Subject login(String string, String string2, String string3) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("login(realm, user, password) -> login(" + string + ", " + string2 + ", " + SecurityConfiguration.mask(string3) + ")"));
        }
        Subject subject = this.login(string, string2, string3, null, null, null, (Map)null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(realm, user, password)");
        }
        return subject;
    }

    public Subject login(String string, String string2, String string3, String string4, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) throws WSLoginFailedException {
        return this.login(string, string2, string3, string4, httpServletRequest, httpServletResponse, map, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Subject login(final String string, final String string2, final String string3, String string4, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("login(realm, user, password) -> login(" + string + ", " + string2 + ", " + SecurityConfiguration.mask(string3) + ", " + string4 + ")"));
        }
        if (string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            throw new WSLoginFailedException("Username and/or password is null.");
        }
        if (this.isCellSecurityEnabled()) {
            if (this.secConfig == null) {
                return null;
            }
            this.checkAuthRetryForThread();
            try {
                Subject subject2;
                block42: {
                    if (!this.secConfig.processIsServer()) {
                        WSCredential wSCredential = this.createBasicAuthCredential(string, string2, string3);
                        if (!this.secConfig.validateBasicAuth()) {
                            return SubjectHelper.createSubjectFromWSCredential(wSCredential);
                        }
                        try {
                            Boolean bl = (Boolean)this.runAsSpecified(SubjectHelper.createUnauthenticatedSubject(), new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    boolean bl = ContextManagerImpl.this.getSecurityServer().simple_authenticate(new BasicAuthData(string2, string3, string));
                                    return new Boolean(bl);
                                }
                            });
                            if (bl.booleanValue()) {
                                if (!this.getCurrent().getServerSecurityEnabled()) {
                                    wSCredential = null;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, password)");
                                }
                                return SubjectHelper.createSubjectFromWSCredential(wSCredential);
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"login(realm, user, password)");
                            }
                            throw new WSLoginFailedException("Failed to authenticate " + wSCredential.getRealmSecurityName());
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            Exception exception = privilegedActionException.getException();
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.login", (String)"906", (Object)this);
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"login(realm, user, password)");
                            }
                            if (exception instanceof WSLoginFailedException) {
                                throw exception;
                            }
                            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                            throw wSLoginFailedException;
                        }
                    }
                    subject2 = null;
                    ArrayList arrayList = null;
                    if (this.secConfig.isRMIInboundPropagationEnabled() || this.secConfig.isRMIOutboundPropagationEnabled() || this.secConfig.isWebInboundPropagationEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Looking for opaque token on the thread before Subject cache lookup.");
                        }
                        arrayList = (ArrayList)this.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup());
                    }
                    if (arrayList == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Looking for subject from cache using token as lookup.");
                        }
                        subject2 = this.cache.getSubject(string, string2, string3);
                    }
                    if (subject2 != null) {
                        try {
                            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject2);
                            if (wSCredential != null) {
                                boolean bl = wSCredential.isDestroyed();
                                boolean bl2 = wSCredential.isForwardable();
                                long l = wSCredential.getExpiration() - System.currentTimeMillis() - this.cache.getCushion();
                                if (tc.isDebugEnabled()) {
                                    if (bl2) {
                                        Tr.debug((TraceComponent)tc, (String)("login(realm, user, password): time remaining = " + l + " millis"));
                                    } else {
                                        Tr.debug((TraceComponent)tc, (String)"login(realm, user, password): time remaining = no expiration");
                                    }
                                }
                                if (bl || bl2 && l <= 0L) {
                                    this.cache.removeEntry(string, string2);
                                    subject2 = null;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Credential has expired or is destroyed, logging in again.");
                                    }
                                    break block42;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, password, auth_mech, . . .)");
                                }
                                return subject2;
                            }
                            subject2 = null;
                        }
                        catch (CredentialDestroyedException credentialDestroyedException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Credential is destroyed.", (Object)new Object[]{credentialDestroyedException});
                            }
                            subject2 = null;
                        }
                        catch (CredentialExpiredException credentialExpiredException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Credential has expired.", (Object)new Object[]{credentialExpiredException});
                            }
                            subject2 = null;
                        }
                    }
                }
                if (subject2 == null) {
                    subject2 = string4 == null ? this.getJaasLoginHelper().jaas_login(string, string2, string3, subject) : (httpServletRequest == null ? this.getJaasLoginHelper().jaas_login(string, string2, string3, string4, subject) : this.getJaasLoginHelper().jaas_login(string, string2, string3, string4, httpServletRequest, httpServletResponse, map, subject));
                    if (this.secConfig.isWebInboundPropagationEnabled() && string4 != null && string4.equals(this.secConfig.getWebInboundLoginConfig())) {
                        this.processSubjectForPropagationAfterLogin(subject2);
                    }
                    this.cache.insert(subject2, string3);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, password, auth_mech, . . .)");
                }
                return subject2;
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.ContextManagerImpl.login", (String)"1024", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + wSLoginFailedException));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, password, auth_mech, . . .)");
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.login", (String)"1034", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + this.dump(exception)));
                }
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, password, auth_mech, . . .)");
                }
                throw wSLoginFailedException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(realm, user, password, auth_mech, . . .)");
        }
        return null;
    }

    public Subject login(String string, byte[] byArray) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login(realm, token, auth_mech)");
        }
        Subject subject = this.login(string, byArray, null, null, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(realm, token, auth_mech)");
        }
        return subject;
    }

    public Subject login(String string, byte[] byArray, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) throws WSLoginFailedException {
        return this.login(string, byArray, string2, httpServletRequest, httpServletResponse, map, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Subject login(String string, byte[] byArray, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("login(realm, token, auth_mech, . . .) -> (" + string + ", token, " + string2 + ", . . .)"));
        }
        if (this.isCellSecurityEnabled() && byArray != null && byArray.length != 0) {
            if (this.secConfig == null || !this.secConfig.processIsServer()) {
                return null;
            }
            this.checkAuthRetryForThread();
            try {
                if (this.secConfig.processIsServer()) {
                    Subject subject2;
                    block35: {
                        ArrayList arrayList = null;
                        subject2 = null;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Web inbound login config: " + this.secConfig.getWebInboundLoginConfig()));
                        }
                        if (this.secConfig.isRMIInboundPropagationEnabled() || this.secConfig.isRMIOutboundPropagationEnabled() || this.secConfig.isWebInboundPropagationEnabled()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Looking for opaque token on the thread before Subject cache lookup.");
                            }
                            arrayList = (ArrayList)this.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup());
                        }
                        if (arrayList == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Looking for subject from cache using token as lookup.");
                            }
                            subject2 = this.cache.getSubject(byArray);
                        }
                        if (this.secConfig.isWebInboundPropagationEnabled() && string2 != null && string2.equals(this.secConfig.getWebInboundLoginConfig())) {
                            this.getOpaqueTokenFromCacheOrOriginatingServer(byArray);
                            subject2 = string2 == null ? this.getJaasLoginHelper().jaas_login(byArray, subject) : (httpServletRequest == null ? this.getJaasLoginHelper().jaas_login(byArray, string2, subject) : this.getJaasLoginHelper().jaas_login(byArray, string2, httpServletRequest, httpServletResponse, map, subject));
                            if (subject2 != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Adding propagation login Subject to cache.");
                                }
                                this.cache.insert(subject2);
                            }
                        }
                        if (subject2 != null) {
                            try {
                                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject2);
                                if (wSCredential != null) {
                                    boolean bl = wSCredential.isDestroyed();
                                    long l = wSCredential.getExpiration() - System.currentTimeMillis();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("login(token): time remaining = " + l + " millis"));
                                    }
                                    if (bl || l <= 0L) {
                                        String string3 = wSCredential.getRealmName();
                                        String string4 = wSCredential.getSecurityName();
                                        this.cache.removeEntry(string3, string4);
                                        subject2 = null;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Credential has expired or is destroyed, logging in again.");
                                        }
                                        break block35;
                                    }
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit((TraceComponent)tc, (String)"login(realm, token, auth_mech, . . .)");
                                    }
                                    return subject2;
                                }
                                subject2 = null;
                            }
                            catch (CredentialDestroyedException credentialDestroyedException) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Credential is destroyed.", (Object)new Object[]{credentialDestroyedException});
                                }
                                subject2 = null;
                            }
                            catch (CredentialExpiredException credentialExpiredException) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Credential has expired.", (Object)new Object[]{credentialExpiredException});
                                }
                                subject2 = null;
                            }
                        }
                    }
                    if (subject2 == null && (subject2 = string2 == null ? this.getJaasLoginHelper().jaas_login(byArray, subject) : (httpServletRequest == null ? this.getJaasLoginHelper().jaas_login(byArray, string2, subject) : this.getJaasLoginHelper().jaas_login(byArray, string2, httpServletRequest, httpServletResponse, map, subject))) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Adding new Subject to cache.");
                        }
                        this.cache.insert(subject2);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"login(realm, token, auth_mech, . . .)");
                    }
                    return subject2;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, token, auth_mech, . . .)");
                }
                throw new WSLoginFailedException("Token can not be validated on a pure client or authentication target is basic authen");
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.ContextManagerImpl.login", (String)"1209", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + wSLoginFailedException));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, token, auth_mech, . . .)");
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.login", (String)"1216", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + this.dump(exception)));
                }
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, token, auth_mech, . . .)");
                }
                throw wSLoginFailedException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(realm, token, auth_mech, . . .)");
        }
        return null;
    }

    private void processSubjectForPropagationAfterLogin(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processSubjectForPropagationAfterLogin");
        }
        try {
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            if (wSCredential.isForwardable()) {
                SingleSignonToken singleSignonToken;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Adding opaque token for accessID \"" + wSCredential.getAccessId() + "\" to the distributed cache."));
                }
                if ((singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject)) != null) {
                    ByteArray byteArray = new ByteArray(singleSignonToken.getBytes());
                    byte[] byArray = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromSubject(subject);
                    long l = System.currentTimeMillis();
                    long l2 = wSCredential.getExpiration();
                    long l3 = l2 - l;
                    if (l3 > 0L) {
                        int n = (int)(l3 / 1000L);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("timeToLive in seconds: " + n));
                        }
                        this.putDistributedObject(byteArray, byArray, n);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WSCredential is not forwardable, not adding to distributed cache.");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception adding opaque authz token to distributed cache.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.processSubjectForPropagationAfterLogin", (String)"1271", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processSubjectForPropagationAfterLogin");
        }
    }

    private void getOpaqueTokenFromCacheOrOriginatingServer(byte[] byArray) {
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getOpaqueTokenFromCacheOrOriginatingServer");
            }
            Object var2_2 = null;
            try {
                Cloneable cloneable;
                ByteArray byteArray;
                byte[] byArray2;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting distributed object from DynaCache.");
                }
                if ((byArray2 = (byte[])this.getDistributedObject(byteArray = new ByteArray(byArray))) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Not found in DynaCache, getting distributed object using MBean.");
                    }
                    cloneable = this.getWSCredTokenMapper().validateLTPAToken(byArray);
                    String[] stringArray = cloneable.getAttributes("process.serverName");
                    String[] stringArray2 = cloneable.getAttributes("java.naming.provider.url");
                    String[] stringArray3 = cloneable.getAttributes("type");
                    String[] stringArray4 = cloneable.getAttributes("host");
                    String[] stringArray5 = cloneable.getAttributes("port");
                    if (this.secConfig.getWebPropagationTransport().equals("IIOP") && stringArray2 != null) {
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        hashtable.put("java.naming.provider.url", stringArray2[0]);
                        hashtable.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                        byArray2 = this.getOpaqueTokenFromCorbaObject(byteArray, hashtable);
                    } else if (byteArray != null && stringArray3 != null && stringArray4 != null && stringArray5 != null && stringArray != null && stringArray[0] != null) {
                        Properties properties = new Properties();
                        properties.setProperty("type", stringArray3[0]);
                        properties.setProperty("host", stringArray4[0]);
                        properties.setProperty("port", stringArray5[0]);
                        byArray2 = this.getOpaqueTokenFromMBean(byteArray, stringArray[0], properties);
                    }
                }
                if (byArray2 == null) break block18;
                cloneable = null;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Getting token holder list from opaque token.");
                    }
                    if ((cloneable = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(byArray2)) != null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"Token holder list has been set on the thread.");
                        }
                        this.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), cloneable);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Failed to get token holder list.");
                    }
                }
                catch (WSSecurityException wSSecurityException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Failed to get token holder list.", (Object)new Object[]{wSSecurityException});
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getSubjectFromDynaCacheOrOriginatingServer", (String)"1352", (Object)this);
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug((TraceComponent)tc, (String)"Exception getting opaque token from originating server.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubjectFromDynaCacheOrOriginatingServer");
        }
    }

    private byte[] getOpaqueTokenFromMBean(final ByteArray byteArray, final String string, final Properties properties) {
        byte[] byArray;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getOpaqueTokenFromMBean", (Object)new Object[]{string, properties});
            }
            byArray = null;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        return ContextManagerImpl.this.getWSCredTokenMapper().getOpaqueTokenFromMBean(byteArray, string, properties);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromMBean", (String)"1381", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception getting opaque token from originating server.");
                        }
                        return null;
                    }
                }
            };
            try {
                byArray = (byte[])this.runAsSystem(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromMBean", (String)"1396", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Exception getting opaque token from originating server.", (Object)new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOpaqueTokenFromMBean");
        }
        return byArray;
    }

    private byte[] getOpaqueTokenFromCorbaObject(final ByteArray byteArray, final Hashtable hashtable) {
        byte[] byArray;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getOpaqueTokenFromCorbaObject", (Object)new Object[]{hashtable});
            }
            byArray = null;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    block4: {
                        try {
                            TokenHolder tokenHolder;
                            com.ibm.ws.security.server.SecurityServer securityServer;
                            InitialContext initialContext = new InitialContext(hashtable);
                            Object object = initialContext.lookup("SecurityServer");
                            if (object != null && (securityServer = (com.ibm.ws.security.server.SecurityServer)PortableRemoteObject.narrow((Object)object, (Class)(class$com$ibm$ws$security$server$SecurityServer == null ? (class$com$ibm$ws$security$server$SecurityServer = ContextManagerImpl.class$("com.ibm.ws.security.server.SecurityServer")) : class$com$ibm$ws$security$server$SecurityServer))) != null && (tokenHolder = securityServer.getOpaqueToken(byteArray)) != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Returning byte[] from getOpaqueTokenFromCorbaObject.");
                                }
                                return tokenHolder.getBytes();
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromCorbaObject", (String)"1444", (Object)this);
                            if (!tc.isDebugEnabled()) break block4;
                            Tr.debug((TraceComponent)tc, (String)"Exception getting opaque token from originating server.", (Object)new Object[]{exception});
                        }
                    }
                    return null;
                }
            };
            try {
                byArray = (byte[])this.runAsSpecified(this.getUnauthenticatedSubject(), privilegedExceptionAction);
            }
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromCorbaObject", (String)"1459", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception getting opaque token from originating server.", (Object)new Object[]{wSSecurityException});
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromCorbaObject", (String)"1464", (Object)this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"Exception getting opaque token from originating server.", (Object)new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOpaqueTokenFromCorbaObject");
        }
        return byArray;
    }

    public Subject login(String string, Object object, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login(auth_mech, protocolPolicy, invocation_subject)");
        }
        if (this.isCellSecurityEnabled() && object != null && subject != null) {
            if (this.secConfig == null || !this.secConfig.processIsServer()) {
                return null;
            }
            try {
                Subject subject2 = this.getJaasLoginHelper().jaas_login(string, object, subject);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(auth_mech, protocolPolicy, invocation_subject)");
                }
                return subject2;
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.ContextManagerImpl.login", (String)"1495", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + wSLoginFailedException));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(auth_mech, protocolPolicy, invocation_subject)");
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.login", (String)"1502", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + this.dump(exception)));
                }
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(auth_mech, protocolPolicy, invocation_subject)");
                }
                throw wSLoginFailedException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(auth_mech, protocolPolicy, invocation_subject)");
        }
        return null;
    }

    public WSCredential createBasicAuthCredential(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            return new WSCredentialImpl(this.getDefaultRealm(), string2, string3);
        }
        return new WSCredentialImpl(string, string2, string3);
    }

    public WSCredential authenticate(WSCredential wSCredential) throws AuthenticationFailedException {
        if (wSCredential == null) {
            Tr.debug((TraceComponent)tc, (String)"Credential passed in is null.");
            return null;
        }
        try {
            Subject subject = this.login(wSCredential);
            return SubjectHelper.getWSCredentialFromSubject(subject);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.ContextManagerImpl.authenticate", (String)"1541", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authenticate failed: " + this.dump(wSLoginFailedException)));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(wSLoginFailedException.getMessage());
            authenticationFailedException.addException(wSLoginFailedException);
            throw authenticationFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.authenticate", (String)"1552", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authenticate failed: " + this.dump(exception)));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(exception.getMessage());
            authenticationFailedException.addException(exception);
            throw authenticationFailedException;
        }
    }

    public WSCredential authenticate(String string, String string2, String string3) throws AuthenticationFailedException {
        try {
            Subject subject = this.login(string, string2, string3);
            return SubjectHelper.getWSCredentialFromSubject(subject);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.ContextManagerImpl.authenticate", (String)"1572", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authenticate failed: " + this.dump(wSLoginFailedException)));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(wSLoginFailedException.getMessage());
            authenticationFailedException.addException(wSLoginFailedException);
            throw authenticationFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.authenticate", (String)"1583", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authenticate failed: " + this.dump(exception)));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(exception.getMessage());
            authenticationFailedException.addException(exception);
            throw authenticationFailedException;
        }
    }

    public WSCredential authenticate(String string, byte[] byArray) throws AuthenticationFailedException {
        try {
            Subject subject = this.login(string, byArray);
            return SubjectHelper.getWSCredentialFromSubject(subject);
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, (String)"com.ibm.ws.security.auth.ContextManagerImpl.authenticate", (String)"1603", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authenticate failed: " + this.dump(loginException)));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(loginException.getMessage());
            authenticationFailedException.addException(loginException);
            throw authenticationFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.authenticate", (String)"1614", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authenticate failed: " + this.dump(exception)));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(exception.getMessage());
            authenticationFailedException.addException(exception);
            throw authenticationFailedException;
        }
    }

    public synchronized Subject getServerSubject() throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            block22: {
                if (this.secConfig == null || !this.secConfig.processIsServer()) {
                    return null;
                }
                if (this.getRegistryObject() == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"BOOTSTRAP MODE: Returning unauthenticated server subject.");
                    }
                    return this.getUnauthenticatedSubject();
                }
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                        Tr.debug((TraceComponent)tc, (String)("Expecting : " + GET_SERVER_CRED_PERM.toString()));
                    }
                    securityManager.checkPermission((Permission)GET_SERVER_CRED_PERM);
                }
                if (this.serverTokenCred != null && !this.serverTokenCred.isDestroyed()) {
                    long l = 0L;
                    try {
                        long l2 = this.serverTokenCred.getExpiration();
                        if (l2 == -1L || l2 == 0L) {
                            return this.serverSubject;
                        }
                        long l3 = System.currentTimeMillis();
                        l = l2 - (l3 + this.getReqTimeout());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Server cred time remaining = " + l));
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getServerCredential", (String)"1673");
                        Tr.error((TraceComponent)tc, (String)"security.SecurityContext.getActualCreds", (Object)new Object[]{exception});
                        throw new WSSecurityException(exception.getMessage(), exception);
                    }
                    if (l > 0L) {
                        return this.serverSubject;
                    }
                    try {
                        this.cache.removeEntry(this.getDefaultRealm(), this.secConfig.getloginUserid());
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getServerCredential", (String)"1691");
                    }
                }
                try {
                    Subject subject = this.login(this.getDefaultRealm(), this.secConfig.getloginUserid(), this.secConfig.getloginPassword());
                    this.cache.insert(subject, this.secConfig.getloginPassword());
                    WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                    if (this.serverTokenCred != null) {
                        if (wSCredential == null || wSCredential.isBasicAuth()) break block22;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Updating server Subject with new wsCred token, auth token and authz token.");
                        }
                        ((WSCredentialImpl)this.serverTokenCred).refreshCred(wSCredential);
                        try {
                            final Subject subject2 = this.serverSubject;
                            final WSCredential wSCredential2 = wSCredential;
                            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                public Object run() throws WSLoginFailedException, WSSecurityException {
                                    AuthorizationToken authorizationToken = ContextManagerImpl.this.getWSCredTokenMapper().createAuthzTokenFromWSCredential(wSCredential2);
                                    AuthenticationToken authenticationToken = ContextManagerImpl.this.getWSCredTokenMapper().createAuthTokenFromWSCredential(wSCredential2);
                                    Iterator<Object> iterator = subject2.getPrivateCredentials().iterator();
                                    while (iterator.hasNext()) {
                                        Object object = iterator.next();
                                        if (object instanceof AuthorizationToken) {
                                            ((AbstractTokenImpl)object).setToken(((AbstractTokenImpl)((Object)authorizationToken)).getToken());
                                            continue;
                                        }
                                        if (!(object instanceof AuthenticationToken)) continue;
                                        ((AbstractTokenImpl)object).setToken(((AbstractTokenImpl)((Object)authenticationToken)).getToken());
                                    }
                                    return null;
                                }
                            });
                            break block22;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.auth.ContextManagerImpl.getServerSubject", (String)"1746", (Object)this);
                            this.setRootException(privilegedActionException.getException());
                            throw new WSSecurityException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                        }
                    }
                    this.serverTokenCred = wSCredential;
                    this.serverSubject = subject;
                    this.serverSubject.setReadOnly();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getServerCredential", (String)"109");
                    Tr.error((TraceComponent)tc, (String)"security.SecurityContext.getActualCreds", (Object)new Object[]{exception});
                    throw new WSSecurityException(exception.getMessage(), exception);
                }
            }
            if (this.serverTokenCred == null) {
                if (this.secConfig != null && this.secConfig.processIsServer()) {
                    Tr.error((TraceComponent)tc, (String)"security.authn.error.owncred");
                    throw new WSSecurityException("Authentication Failed");
                }
                return null;
            }
            ((WSCredentialImpl)this.serverTokenCred).markServerCred(scs.getEncryptedServerSigner());
            return this.serverSubject;
        }
        return null;
    }

    public synchronized WSCredential getServerCredential() throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            if (this.secConfig == null || !this.secConfig.processIsServer()) {
                return null;
            }
            Subject subject = this.getServerSubject();
            return SubjectHelper.getWSCredentialFromSubject(subject);
        }
        return null;
    }

    public Subject pushInvocationSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                Subject subject2 = this.getInvocationSubject();
                this.setInvocationSubject(subject);
                return subject2;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.pushInvocationSubject", (String)"1812", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        return null;
    }

    public void popInvocationSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                this.setInvocationSubject(subject);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.popInvocationSubject", (String)"1830", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public Subject pushReceivedSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                Subject subject2 = this.getCallerSubject();
                this.setCallerSubject(subject);
                return subject2;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerImpl.pushReceivedSubject", (String)"1848", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        return null;
    }

    public void popReceivedSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                this.setCallerSubject(subject);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerImpl.popReceivedSubject", (String)"1866", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public void clearRootException() {
        this.setRootException(null);
    }

    public void setRootException(Throwable throwable) {
        Throwable throwable2;
        if (this.getCurrent() != null && (throwable2 = this.getCurrent().getRootException()) == null) {
            this.getCurrent().setRootException(throwable);
        }
    }

    public Throwable getRootException() {
        if (this.getCurrent() != null) {
            return this.getCurrent().getRootException();
        }
        return null;
    }

    public Subject getCallerSubject() throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                return this.getCurrent().get_caller_subject();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getCallerSubject", (String)"1916", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCallerSubject(): CurrentImpl is null");
        }
        return null;
    }

    public void setCallerSubject(Subject subject) throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                this.getCurrent().set_caller_subject(subject);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.setCallerSubject", (String)"1937", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public Subject getInvocationSubject() throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                return this.getCurrent().get_invocation_subject();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getInvocationSubject", (String)"1953", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getInvocationSubject(): CurrentImpl is null");
        }
        return null;
    }

    public void setInvocationSubject(Subject subject) throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                this.getCurrent().set_invocation_subject(subject);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.setInvocationSubject", (String)"1974", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public void addWSSubjectToCache(Subject subject) throws WSSecurityException {
        if (subject != null && this.processIsServer() && this.isWSSubject(subject)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding WSSubject to cache.");
            }
            this.cache.insert(subject);
        }
    }

    public Subject getOwnSubject() throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                return this.getCurrent().get_own_subject();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getOwnSubject", (String)"1998", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getOwnSubject(): CurrentImpl is null");
        }
        return null;
    }

    public void setOwnSubject(Subject subject) throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                this.getCurrent().set_own_subject(subject);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.setOwnSubject", (String)"2019", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public WSCredential[] getCallerCredentials() throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                return this.getCurrent().get_ws_received_credentials();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getCallerCredentials", (String)"2036", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        return null;
    }

    public void setCallerCredentials(WSCredential[] wSCredentialArray) throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                this.getCurrent().set_ws_received_credentials(wSCredentialArray);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.setCallerCredentials", (String)"2054", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public WSCredential getInvocationCredential() throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                return this.getCurrent().get_ws_invocation_credentials();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getInvocationCredential", (String)"2070", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getInvocationCredential(): CurrentImpl is null");
        }
        return null;
    }

    public void setInvocationCredential(WSCredential wSCredential) throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                this.getCurrent().set_ws_invocation_credentials(wSCredential);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.setInvocationCredential", (String)"2091", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public WSCredential pushInvocationCredential(WSCredential wSCredential) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                WSCredential wSCredential2 = this.getInvocationCredential();
                this.setInvocationCredential(wSCredential);
                return wSCredential2;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.pushInvocationCredential", (String)"2109", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        return null;
    }

    public void popInvocationCredential(WSCredential wSCredential) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                this.setInvocationCredential(wSCredential);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.popInvocationCredential", (String)"2126", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    private void checkAuthRetryForThread() {
        Boolean bl = (Boolean)this.get("wssecurity.disableauthretry");
        if (bl != null && bl.booleanValue()) {
            this.getCurrent().setAuthRetryForJAAS(false);
        }
    }

    public Object get(String string) {
        if (this.isCellSecurityEnabled()) {
            return this.getCurrent().getProperty(string);
        }
        return null;
    }

    public Object put(String string, Object object) {
        if (this.isCellSecurityEnabled()) {
            return this.getCurrent().setProperty(string, object);
        }
        return null;
    }

    public boolean contains(String string) {
        if (this.isCellSecurityEnabled()) {
            return this.getCurrent().containsProperty(string);
        }
        return false;
    }

    public Object runAsSystem(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return this.runAs(null, privilegedExceptionAction, "System");
    }

    public Object runAsReceivedClient(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return this.runAs(null, privilegedExceptionAction, "ReceivedClient");
    }

    public Object runAsClient(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return this.runAs(null, privilegedExceptionAction, "Client");
    }

    public Object runAsSpecified(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return this.runAs(subject, privilegedExceptionAction, "Specified");
    }

    public Object runAsSpecified(WSCredential wSCredential, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return this.runAs(SubjectHelper.createSubjectFromWSCredential(wSCredential), privilegedExceptionAction, "Specified");
    }

    private Object runAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, String string) throws PrivilegedActionException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("runAs(" + string + ")"));
        }
        String string2 = EMPTY;
        String string3 = "ContextManager.runAs";
        Subject subject2 = null;
        Subject subject3 = null;
        Object var8_8 = null;
        if (ConfigURLProperties.isSecurityEnabled()) {
            try {
                Subject subject4;
                Subject subject5 = null;
                if (string.equals("System")) {
                    subject5 = this.getServerSubject();
                    if (subject5 != null) {
                        subject3 = this.pushReceivedSubject(subject5);
                    }
                } else if (string.equals("Client")) {
                    subject4 = this.getCallerSubject();
                    subject5 = subject4 != null ? subject4 : this.getInvocationSubject();
                } else if (string.equals("ReceivedClient")) {
                    subject4 = this.getCallerSubject();
                    if (subject4 != null) {
                        subject5 = subject4;
                    }
                } else if (string.equals("Specified")) {
                    subject5 = subject;
                }
                subject2 = this.pushInvocationSubject(subject5);
            }
            catch (Exception exception) {
                try {
                    if (subject2 != null) {
                        this.popInvocationSubject(subject2);
                        subject2 = null;
                    }
                    if (subject3 != null) {
                        this.popReceivedSubject(subject3);
                        subject3 = null;
                    }
                }
                catch (Exception exception2) {
                    try {
                        if (subject3 != null) {
                            this.popReceivedSubject(subject3);
                            subject3 = null;
                        }
                    }
                    catch (Exception exception3) {
                        FFDCFilter.processException((Throwable)exception3, (String)"com.ibm.ws.security.core.ContextManagerImpl.runAs", (String)"2291", (Object)this);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)("runAs(" + string + ") -> Exception occurred."), (Object)new Object[]{exception3});
                        }
                        throw new PrivilegedActionException(exception3);
                    }
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerImpl.runAs", (String)"2296", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("runAs(" + string + ") -> Exception occurred."), (Object)new Object[]{exception});
                }
                throw new PrivilegedActionException(exception);
            }
        }
        try {
            var8_8 = privilegedExceptionAction.run();
        }
        catch (Exception exception) {
            if (ConfigURLProperties.isSecurityEnabled()) {
                try {
                    if (subject2 != null) {
                        this.popInvocationSubject(subject2);
                        subject2 = null;
                    }
                    if (subject3 != null) {
                        this.popReceivedSubject(subject3);
                        subject3 = null;
                    }
                }
                catch (Exception exception4) {
                    try {
                        if (subject3 != null) {
                            this.popReceivedSubject(subject3);
                            subject3 = null;
                        }
                    }
                    catch (Exception exception5) {
                        FFDCFilter.processException((Throwable)exception5, (String)"com.ibm.ws.security.core.ContextManagerImpl.runAs", (String)"2340", (Object)this);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)("runAs(" + string + ") -> Exception occurred."), (Object)new Object[]{exception5});
                        }
                        throw new PrivilegedActionException(exception5);
                    }
                }
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerImpl.runAs", (String)"2347", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("runAs(" + string + ") -> Exception occurred."), (Object)new Object[]{exception});
            }
            throw new PrivilegedActionException(exception);
        }
        if (ConfigURLProperties.isSecurityEnabled()) {
            try {
                this.popInvocationSubject(subject2);
                if (subject3 != null) {
                    this.popReceivedSubject(subject3);
                    subject3 = null;
                }
            }
            catch (Exception exception) {
                try {
                    if (subject2 != null) {
                        this.popInvocationSubject(subject2);
                        subject2 = null;
                    }
                    if (subject3 != null) {
                        this.popReceivedSubject(subject3);
                        subject3 = null;
                    }
                }
                catch (Exception exception6) {
                    FFDCFilter.processException((Throwable)exception6, (String)"com.ibm.ws.security.core.ContextManagerImpl.runAs", (String)"2384", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("runAs(" + string + ") -> Exception occurred."), (Object)new Object[]{exception6});
                    }
                    throw new PrivilegedActionException(exception6);
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerImpl.runAs", (String)"2389", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("runAs(" + string + ") -> Exception occurred."), (Object)new Object[]{exception});
                }
                throw new PrivilegedActionException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("runAs(" + string + ")"));
        }
        return var8_8;
    }

    public WSPrincipal createPrincipal(WSCredential wSCredential) throws WSSecurityException {
        return SubjectHelper.createPrincipal(wSCredential);
    }

    public void initializeSystemContext() throws WSSecurityException {
        if (this.getCurrent() != null) {
            this.getCurrent().initialize_requestor_context(this.creds);
        }
    }

    public void initializeCallerContext(Subject subject) throws WSSecurityException {
        if (this.getCurrent() != null) {
            this.getCurrent().initialize_requestor_context(subject);
        }
    }

    public void initializeCallerContext(WSCredential[] wSCredentialArray) throws WSSecurityException {
        if (this.getCurrent() != null) {
            this.getCurrent().initialize_ws_requestor_context(wSCredentialArray);
        }
    }

    public void clearCallerContext() throws WSSecurityException {
        if (this.getCurrent() != null) {
            this.getCurrent().clear_ws_requestor_context();
        }
    }

    public boolean isCellSecurityEnabled() {
        return ConfigURLProperties.isSecurityEnabled();
    }

    public boolean isServerSecurityEnabled() {
        if (this.getCurrent() != null) {
            return this.getCurrent().isSecurityEnabled() && this.getCurrent().isSSLSecurityTagExported();
        }
        return false;
    }

    public String getClientUniqueIDForOutboundRequests(Subject subject) {
        WSCredentialTokenMapperInterface wSCredentialTokenMapperInterface = null;
        try {
            wSCredentialTokenMapperInterface = this.getWSCredTokenMapper();
            if (wSCredentialTokenMapperInterface != null && subject != null) {
                return wSCredentialTokenMapperInterface.createUniqueIDFromAllTokens(subject);
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getClientUniqueIDForOutboundRequests", (String)"2469");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught exception.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    public boolean getServerSecurityEnabled() {
        return this.serverSecurityEnabled;
    }

    public void setServerSecurityEnabled(boolean bl) {
        this.serverSecurityEnabled = bl;
    }

    public void setPlatformHelper(PlatformHelper platformHelper) {
        PlatformHelperFactory.setPlatformHelper((PlatformHelper)platformHelper);
    }

    public PlatformHelper getPlatformHelper() {
        return PlatformHelperFactory.getPlatformHelper();
    }

    public long getReqTimeout() {
        long l = this.theORB.getRequestTimeout() - 5000;
        return l;
    }

    public boolean isSynctoThreadEnabled() {
        return enableSyncOSThread;
    }

    public String getRegionId() {
        return this.regionUserid;
    }

    public String getDefaultSAFRealm() {
        return this.DefaultSAFRealm;
    }

    private String dump(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private SecurityServer getSecurityServer() throws AuthenticationFailedException {
        if (this.securityServer == null) {
            try {
                this.securityServer = this.vault.getSecurityServer();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getSecurityServer", (String)"2550");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)EMPTY, (Object)exception);
                }
                this.securityServer = null;
                throw new AuthenticationFailedException(exception.getMessage());
            }
        }
        return this.securityServer;
    }

    private JaasLoginHelper getJaasLoginHelper() throws WSSecurityException {
        if (this.jaasLoginHelper == null) {
            try {
                this.jaasLoginHelper = new JaasLoginHelper(this.secConfig.getAuthMechAuthAlias());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"JaasLoginHelper()");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManager.getJaasLoginHelper", (String)"2571");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)EMPTY, (Object)exception);
                }
                this.jaasLoginHelper = null;
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        return this.jaasLoginHelper;
    }

    private CurrentImpl getCurrent() {
        block3: {
            if (this.current == null) {
                try {
                    this.init();
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.auth.ContextManager.getCurrent", (String)"1736");
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"Error initializing security.", (Object)new Object[]{wSSecurityException});
                }
            }
        }
        return this.current;
    }

    private Object getDistributedObject(Object object) {
        try {
            return this.getWSCredTokenMapper().getDistributedObject(object);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManager.getDistributedObject", (String)"2629");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error getting distributed object.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    private Object putDistributedObject(Object object, Object object2, int n) {
        try {
            return this.getWSCredTokenMapper().putDistributedObject(object, object2, n);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManager.getDistributedObject", (String)"2673");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error setting distributed object.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    private Object putDistributedObject(Object object, Object object2, int n, int n2, int n3, Object[] objectArray) {
        try {
            return this.getWSCredTokenMapper().putDistributedObject(object, object2, n, n2, n3, objectArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManager.getDistributedObject", (String)"2722");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error setting distributed object.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    private Class getAuthCacheClass() {
        if (this._authCacheClass == null) {
            Class<?> clazz = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz = classLoader != null ? classLoader.loadClass(FACTORY_CLASS) : Class.forName(FACTORY_CLASS);
                this._authCacheClass = clazz;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(class$com$ibm$ws$security$auth$ContextManagerImpl == null ? (class$com$ibm$ws$security$auth$ContextManagerImpl = ContextManagerImpl.class$("com.ibm.ws.security.auth.ContextManagerImpl")) : class$com$ibm$ws$security$auth$ContextManagerImpl).getName(), (String)"2767");
                throw new UndeclaredThrowableException(exception);
            }
        }
        return this._authCacheClass;
    }

    private Method getAuthCacheGetInstanceMethod() {
        Class clazz;
        if (this._authCacheGetInstanceMethod == null && (clazz = this.getAuthCacheClass()) != null) {
            try {
                this._authCacheGetInstanceMethod = clazz.getMethod("getInstance", null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(class$com$ibm$ws$security$auth$ContextManagerImpl == null ? (class$com$ibm$ws$security$auth$ContextManagerImpl = ContextManagerImpl.class$("com.ibm.ws.security.auth.ContextManagerImpl")) : class$com$ibm$ws$security$auth$ContextManagerImpl).getName(), (String)"1813");
                throw new UndeclaredThrowableException(exception);
            }
        }
        return this._authCacheGetInstanceMethod;
    }

    private Class getSecurityServerImplClass() {
        if (this._securityServerImplClass == null) {
            Class<?> clazz = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz = classLoader != null ? classLoader.loadClass(SECURITY_SERVER_IMPL_CLASS) : Class.forName(SECURITY_SERVER_IMPL_CLASS);
                this._securityServerImplClass = clazz;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(class$com$ibm$ws$security$auth$ContextManagerImpl == null ? (class$com$ibm$ws$security$auth$ContextManagerImpl = ContextManagerImpl.class$("com.ibm.ws.security.auth.ContextManagerImpl")) : class$com$ibm$ws$security$auth$ContextManagerImpl).getName(), (String)"2820");
                throw new UndeclaredThrowableException(exception);
            }
        }
        return this._securityServerImplClass;
    }

    private Method getRegistryMethod() {
        Class clazz;
        if (this._getRegistryMethod == null && (clazz = this.getSecurityServerImplClass()) != null) {
            try {
                this._getRegistryMethod = clazz.getMethod("getRegistryImpl", class$java$lang$String == null ? (class$java$lang$String = ContextManagerImpl.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(class$com$ibm$ws$security$auth$ContextManagerImpl == null ? (class$com$ibm$ws$security$auth$ContextManagerImpl = ContextManagerImpl.class$("com.ibm.ws.security.auth.ContextManagerImpl")) : class$com$ibm$ws$security$auth$ContextManagerImpl).getName(), (String)"2841");
                throw new UndeclaredThrowableException(exception);
            }
        }
        return this._getRegistryMethod;
    }

    private Class getSecurityServerFactoryClass() {
        if (this._securityServerFactoryClass == null) {
            Class<?> clazz = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz = classLoader != null ? classLoader.loadClass(SECURITY_SERVER_FACTORY_CLASS) : Class.forName(SECURITY_SERVER_FACTORY_CLASS);
                this._securityServerFactoryClass = clazz;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(class$com$ibm$ws$security$auth$ContextManagerImpl == null ? (class$com$ibm$ws$security$auth$ContextManagerImpl = ContextManagerImpl.class$("com.ibm.ws.security.auth.ContextManagerImpl")) : class$com$ibm$ws$security$auth$ContextManagerImpl).getName(), (String)"2872");
                throw new UndeclaredThrowableException(exception);
            }
        }
        return this._securityServerFactoryClass;
    }

    private Method getSecurityServerCreateMethod() {
        Class clazz;
        if (this._getSecurityServerCreateMethod == null && (clazz = this.getSecurityServerFactoryClass()) != null) {
            try {
                this._getSecurityServerCreateMethod = clazz.getMethod("create", null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(class$com$ibm$ws$security$auth$ContextManagerImpl == null ? (class$com$ibm$ws$security$auth$ContextManagerImpl = ContextManagerImpl.class$("com.ibm.ws.security.auth.ContextManagerImpl")) : class$com$ibm$ws$security$auth$ContextManagerImpl).getName(), (String)"2893");
                throw new UndeclaredThrowableException(exception);
            }
        }
        return this._getSecurityServerCreateMethod;
    }

    private Object getRegistryObject() {
        Method method;
        if (this._registryObject == null && (method = this.getRegistryMethod()) != null) {
            try {
                this._registryObject = method.invoke(null, this.getDefaultRealm());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getRegistryObject", (String)"2917");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception getting registry instance during bootstrap check.", (Object)exception);
                }
                return null;
            }
        }
        if (this._registryObject == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Returning null registryObject, still in BOOTSTRAP mode.");
        }
        return this._registryObject;
    }

    public WSCredentialTokenMapperInterface getWSCredTokenMapper() throws WSSecurityException {
        if (this.wsCredTokenMapper == null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object obj = clazz.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Got instance of WSCredTokenMapper.");
                }
                this.wsCredTokenMapper = (WSCredentialTokenMapperInterface)obj;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.auth.ContextManagerImpl.getWSCredTokenMapper", (String)"2943", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The following exception occurred in UserMappingImpl when loading the custom implementation: ", (Object)new Object[]{throwable});
                }
                throw new WSSecurityException(throwable.getMessage(), throwable);
            }
        }
        return this.wsCredTokenMapper;
    }

    public static synchronized void registerPackage(String string) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = System.getProperty(URL_HANDLER_PROP);
        if (string2 != null) {
            object = new StringTokenizer(string2, PKGNAME_DELIMITER);
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
        }
        if (arrayList.contains(string)) {
            return;
        }
        arrayList.add(string);
        object = new StringBuffer();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            ((StringBuffer)object).append(string3);
            if (!iterator.hasNext()) continue;
            ((StringBuffer)object).append('|');
        }
        System.setProperty(URL_HANDLER_PROP, ((StringBuffer)object).toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

